/*
 * Decompiled with CFR 0.152.
 */
package win.demistorm.stormiespiders.client;

import java.util.WeakHashMap;
import net.minecraft.class_10042;
import net.minecraft.class_1309;
import net.minecraft.class_2350;
import net.minecraft.class_4587;
import net.minecraft.class_7833;
import org.joml.Quaternionfc;
import win.demistorm.stormiespiders.common.entity.mob.IClimberEntity;
import win.demistorm.stormiespiders.common.entity.mob.Orientation;

public class ClientEventHandlers {
    private static final WeakHashMap<class_10042, ClimberRenderData> renderStateDataMap = new WeakHashMap();

    public static void storeClimberDataForRenderState(class_10042 renderState, class_1309 entity, IClimberEntity climber, float partialTicks) {
        Orientation renderOrientation = climber.calculateOrientation(partialTicks);
        climber.setRenderOrientation(renderOrientation);
        float verticalOffset = climber.getVerticalOffset(partialTicks);
        renderStateDataMap.put(renderState, new ClimberRenderData(climber, partialTicks, renderOrientation, verticalOffset, climber.getOrientation()));
    }

    public static void onPreRenderLivingFromState(class_10042 renderState, class_4587 matrixStack) {
        ClimberRenderData data = renderStateDataMap.get(renderState);
        if (data != null) {
            matrixStack.method_22903();
            ClientEventHandlers.applyClimberTransformPre(data, matrixStack);
        }
    }

    public static void onPostRenderLivingFromState(class_10042 renderState, class_4587 matrixStack) {
        ClimberRenderData data = renderStateDataMap.get(renderState);
        if (data != null) {
            ClientEventHandlers.applyClimberTransformPost(data, matrixStack);
            matrixStack.method_22909();
            renderStateDataMap.remove(renderState);
        }
    }

    private static void applyClimberTransformPre(ClimberRenderData data, class_4587 matrixStack) {
        IClimberEntity climber = data.climber;
        Orientation renderOrientation = data.renderOrientation;
        float verticalOffset = data.verticalOffset;
        float partialTicks = data.partialTicks;
        float x = climber.getAttachmentOffset(class_2350.class_2351.field_11048, partialTicks) - (float)renderOrientation.normal.field_1352 * verticalOffset;
        float y = climber.getAttachmentOffset(class_2350.class_2351.field_11052, partialTicks) - (float)renderOrientation.normal.field_1351 * verticalOffset;
        float z = climber.getAttachmentOffset(class_2350.class_2351.field_11051, partialTicks) - (float)renderOrientation.normal.field_1350 * verticalOffset;
        matrixStack.method_46416(x, y, z);
        matrixStack.method_22907((Quaternionfc)class_7833.field_40716.rotationDegrees(renderOrientation.yaw));
        matrixStack.method_22907((Quaternionfc)class_7833.field_40714.rotationDegrees(renderOrientation.pitch));
        matrixStack.method_22907((Quaternionfc)class_7833.field_40716.rotationDegrees(Math.signum(0.5f - renderOrientation.componentY - renderOrientation.componentZ - renderOrientation.componentX) * renderOrientation.yaw));
    }

    private static void applyClimberTransformPost(ClimberRenderData data, class_4587 matrixStack) {
        Orientation orientation = data.currentOrientation;
        Orientation renderOrientation = data.renderOrientation;
        if (renderOrientation != null) {
            float verticalOffset = data.verticalOffset;
            float partialTicks = data.partialTicks;
            IClimberEntity climber = data.climber;
            float x = climber.getAttachmentOffset(class_2350.class_2351.field_11048, partialTicks) - (float)renderOrientation.normal.field_1352 * verticalOffset;
            float y = climber.getAttachmentOffset(class_2350.class_2351.field_11052, partialTicks) - (float)renderOrientation.normal.field_1351 * verticalOffset;
            float z = climber.getAttachmentOffset(class_2350.class_2351.field_11051, partialTicks) - (float)renderOrientation.normal.field_1350 * verticalOffset;
            matrixStack.method_22907((Quaternionfc)class_7833.field_40716.rotationDegrees(-Math.signum(0.5f - orientation.componentY - orientation.componentZ - orientation.componentX) * renderOrientation.yaw));
            matrixStack.method_22907((Quaternionfc)class_7833.field_40714.rotationDegrees(-renderOrientation.pitch));
            matrixStack.method_22907((Quaternionfc)class_7833.field_40716.rotationDegrees(-renderOrientation.yaw));
            matrixStack.method_46416(-x, -y, -z);
        }
    }

    private static class ClimberRenderData {
        final IClimberEntity climber;
        final float partialTicks;
        final Orientation renderOrientation;
        final float verticalOffset;
        final Orientation currentOrientation;

        ClimberRenderData(IClimberEntity climber, float partialTicks, Orientation renderOrientation, float verticalOffset, Orientation currentOrientation) {
            this.climber = climber;
            this.partialTicks = partialTicks;
            this.renderOrientation = renderOrientation;
            this.verticalOffset = verticalOffset;
            this.currentOrientation = currentOrientation;
        }
    }
}

