/*
 * Decompiled with CFR 0.152.
 */
package win.demistorm.stormiespiders.client;

import java.util.HashMap;
import java.util.Map;
import net.minecraft.class_10042;
import net.minecraft.class_1309;
import net.minecraft.class_2350;
import net.minecraft.class_4587;
import net.minecraft.class_4597;
import net.minecraft.class_7833;
import win.demistorm.stormiespiders.common.entity.mob.IClimberEntity;
import win.demistorm.stormiespiders.common.entity.mob.Orientation;

public class ClientEventHandlers {
    private static final Map<Integer, ClimberRenderData> climberDataCache = new HashMap<Integer, ClimberRenderData>();

    public static void onPreRenderLiving(class_1309 entity, float partialTicks, class_4587 matrixStack) {
        if (entity instanceof IClimberEntity) {
            IClimberEntity climber = (IClimberEntity)entity;
            Orientation orientation = climber.getOrientation();
            Orientation renderOrientation = climber.calculateOrientation(partialTicks);
            climber.setRenderOrientation(renderOrientation);
            float verticalOffset = climber.getVerticalOffset(partialTicks);
            float x = climber.getAttachmentOffset(class_2350.class_2351.field_11048, partialTicks) - (float)renderOrientation.normal.field_1352 * verticalOffset;
            float y = climber.getAttachmentOffset(class_2350.class_2351.field_11052, partialTicks) - (float)renderOrientation.normal.field_1351 * verticalOffset;
            float z = climber.getAttachmentOffset(class_2350.class_2351.field_11051, partialTicks) - (float)renderOrientation.normal.field_1350 * verticalOffset;
            matrixStack.method_46416(x, y, z);
            matrixStack.method_22907(class_7833.field_40716.rotationDegrees(renderOrientation.yaw));
            matrixStack.method_22907(class_7833.field_40714.rotationDegrees(renderOrientation.pitch));
            matrixStack.method_22907(class_7833.field_40716.rotationDegrees(Math.signum(0.5f - orientation.componentY - orientation.componentZ - orientation.componentX) * renderOrientation.yaw));
        }
    }

    public static void onPostRenderLiving(class_1309 entity, float partialTicks, class_4587 matrixStack, class_4597 bufferIn) {
        if (entity instanceof IClimberEntity) {
            IClimberEntity climber = (IClimberEntity)entity;
            Orientation orientation = climber.getOrientation();
            Orientation renderOrientation = climber.getRenderOrientation();
            if (renderOrientation != null) {
                float verticalOffset = climber.getVerticalOffset(partialTicks);
                float x = climber.getAttachmentOffset(class_2350.class_2351.field_11048, partialTicks) - (float)renderOrientation.normal.field_1352 * verticalOffset;
                float y = climber.getAttachmentOffset(class_2350.class_2351.field_11052, partialTicks) - (float)renderOrientation.normal.field_1351 * verticalOffset;
                float z = climber.getAttachmentOffset(class_2350.class_2351.field_11051, partialTicks) - (float)renderOrientation.normal.field_1350 * verticalOffset;
                matrixStack.method_22907(class_7833.field_40716.rotationDegrees(-Math.signum(0.5f - orientation.componentY - orientation.componentZ - orientation.componentX) * renderOrientation.yaw));
                matrixStack.method_22907(class_7833.field_40714.rotationDegrees(-renderOrientation.pitch));
                matrixStack.method_22907(class_7833.field_40716.rotationDegrees(-renderOrientation.yaw));
                matrixStack.method_46416(-x, -y, -z);
            }
        }
    }

    public static void storeClimberData(class_1309 entity, IClimberEntity climber, float partialTicks) {
        Orientation renderOrientation = climber.calculateOrientation(partialTicks);
        float verticalOffset = climber.getVerticalOffset(partialTicks);
        int entityId = entity.method_5628();
        climberDataCache.put(entityId, new ClimberRenderData(climber, partialTicks, renderOrientation, verticalOffset));
    }

    public static void onPreRenderLivingFromState(class_10042 renderState, class_4587 matrixStack) {
        ClimberRenderData data = ClientEventHandlers.findClimberDataForRenderState(renderState);
        if (data != null) {
            ClientEventHandlers.applyClimberTransformPre(data, matrixStack);
        }
    }

    public static void onPostRenderLivingFromState(class_10042 renderState, class_4587 matrixStack, class_4597 bufferIn) {
        ClimberRenderData data = ClientEventHandlers.findClimberDataForRenderState(renderState);
        if (data != null) {
            ClientEventHandlers.applyClimberTransformPost(data, matrixStack);
        }
        if (Math.random() < 0.01) {
            climberDataCache.clear();
        }
    }

    private static ClimberRenderData findClimberDataForRenderState(class_10042 renderState) {
        return climberDataCache.values().stream().findFirst().orElse(null);
    }

    private static void applyClimberTransformPre(ClimberRenderData data, class_4587 matrixStack) {
        IClimberEntity climber = data.climber;
        Orientation renderOrientation = data.renderOrientation;
        float verticalOffset = data.verticalOffset;
        float x = climber.getAttachmentOffset(class_2350.class_2351.field_11048, data.partialTicks) - (float)renderOrientation.normal.field_1352 * verticalOffset;
        float y = climber.getAttachmentOffset(class_2350.class_2351.field_11052, data.partialTicks) - (float)renderOrientation.normal.field_1351 * verticalOffset;
        float z = climber.getAttachmentOffset(class_2350.class_2351.field_11051, data.partialTicks) - (float)renderOrientation.normal.field_1350 * verticalOffset;
        matrixStack.method_46416(x, y, z);
        matrixStack.method_22907(class_7833.field_40716.rotationDegrees(renderOrientation.yaw));
        matrixStack.method_22907(class_7833.field_40714.rotationDegrees(renderOrientation.pitch));
        matrixStack.method_22907(class_7833.field_40716.rotationDegrees(Math.signum(0.5f - renderOrientation.componentY - renderOrientation.componentZ - renderOrientation.componentX) * renderOrientation.yaw));
    }

    private static void applyClimberTransformPost(ClimberRenderData data, class_4587 matrixStack) {
        IClimberEntity climber = data.climber;
        Orientation orientation = climber.getOrientation();
        Orientation renderOrientation = data.renderOrientation;
        if (renderOrientation != null) {
            float verticalOffset = data.verticalOffset;
            float x = climber.getAttachmentOffset(class_2350.class_2351.field_11048, data.partialTicks) - (float)renderOrientation.normal.field_1352 * verticalOffset;
            float y = climber.getAttachmentOffset(class_2350.class_2351.field_11052, data.partialTicks) - (float)renderOrientation.normal.field_1351 * verticalOffset;
            float z = climber.getAttachmentOffset(class_2350.class_2351.field_11051, data.partialTicks) - (float)renderOrientation.normal.field_1350 * verticalOffset;
            matrixStack.method_22907(class_7833.field_40716.rotationDegrees(-Math.signum(0.5f - orientation.componentY - orientation.componentZ - orientation.componentX) * renderOrientation.yaw));
            matrixStack.method_22907(class_7833.field_40714.rotationDegrees(-renderOrientation.pitch));
            matrixStack.method_22907(class_7833.field_40716.rotationDegrees(-renderOrientation.yaw));
            matrixStack.method_46416(-x, -y, -z);
        }
    }

    private static class ClimberRenderData {
        final IClimberEntity climber;
        final float partialTicks;
        final Orientation renderOrientation;
        final float verticalOffset;

        ClimberRenderData(IClimberEntity climber, float partialTicks, Orientation renderOrientation, float verticalOffset) {
            this.climber = climber;
            this.partialTicks = partialTicks;
            this.renderOrientation = renderOrientation;
            this.verticalOffset = verticalOffset;
        }
    }
}

