/*
 * Decompiled with CFR 0.152.
 */
package win.demistorm.stormiespiders.common;

import it.unimi.dsi.fastutil.floats.FloatArrays;
import java.util.List;
import java.util.function.Consumer;
import net.minecraft.class_238;
import net.minecraft.class_243;
import net.minecraft.class_259;
import net.minecraft.class_3532;
import org.apache.commons.lang3.tuple.Pair;
import org.jetbrains.annotations.Nullable;

public class CollisionSmoothingUtil {
    private static float invSqrt(float x) {
        float xhalf = 0.5f * x;
        int i = Float.floatToIntBits(x);
        i = 1597463007 - (i >> 1);
        x = Float.intBitsToFloat(i);
        x *= 1.5f - xhalf * x * x;
        return x;
    }

    private static float sampleSdf(float[] erx, float[] ery, float[] erz, float[] ecx, float[] ecy, float[] ecz, int count, float px, float py, float pz, float pnx, float pny, float pnz, float x, float y, float z, float smoothingRange, float invSmoothingRange) {
        float sdfDst = 0.0f;
        float planeDst = pnx * (x - px) + pny * (y - py) + pnz * (z - pz);
        for (int i = 0; i < count; ++i) {
            float rsx = x - ecx[i];
            float rsy = y - ecy[i];
            float rsz = z - ecz[i];
            float prx = rsx * erx[i];
            float pry = rsy * ery[i];
            float prz = rsz * erz[i];
            float k1 = CollisionSmoothingUtil.invSqrt(prx * prx + pry * pry + prz * prz);
            float ellipsoidDst = class_3532.method_15355((float)(rsx * rsx + rsy * rsy + rsz * rsz)) * (1.0f - 1.0f * k1);
            float h = class_3532.method_15363((float)(0.5f - 0.5f * (ellipsoidDst + planeDst) * invSmoothingRange), (float)0.0f, (float)1.0f);
            ellipsoidDst = ellipsoidDst + (-planeDst - ellipsoidDst) * h + smoothingRange * h * (1.0f - h);
            if (i == 0) {
                sdfDst = ellipsoidDst;
                continue;
            }
            h = class_3532.method_15363((float)(0.5f + 0.5f * (ellipsoidDst - sdfDst) * invSmoothingRange), (float)0.0f, (float)1.0f);
            sdfDst = ellipsoidDst + (sdfDst - ellipsoidDst) * h - smoothingRange * h * (1.0f - h);
        }
        float h = class_3532.method_15363((float)(0.5f - 0.5f * (sdfDst + planeDst) * invSmoothingRange), (float)0.0f, (float)1.0f);
        sdfDst = sdfDst + (-planeDst - sdfDst) * h + smoothingRange * h * (1.0f - h);
        return sdfDst;
    }

    @Nullable
    public static Pair<class_243, class_243> findClosestPoint(Consumer<class_259.class_260> consumer, class_243 pp, class_243 pn, float smoothingRange, float boxScale, float dx, int iters, float threshold, class_243 p) {
        BoxConsumer boxConsumer = new BoxConsumer(p, boxScale);
        consumer.accept(boxConsumer);
        if (boxConsumer.size == 0) {
            return null;
        }
        return CollisionSmoothingUtil.findClosestPoint(boxConsumer.erx, boxConsumer.ery, boxConsumer.erz, boxConsumer.ecx, boxConsumer.ecy, boxConsumer.ecz, boxConsumer.size, pp, pn, smoothingRange, boxScale, dx, iters, threshold, p);
    }

    @Nullable
    public static Pair<class_243, class_243> findClosestPoint(List<class_238> boxes, class_243 pp, class_243 pn, float smoothingRange, float boxScale, float dx, int iters, float threshold, class_243 p) {
        if (boxes.isEmpty()) {
            return null;
        }
        float[] erx = new float[boxes.size()];
        float[] ery = new float[boxes.size()];
        float[] erz = new float[boxes.size()];
        float[] ecx = new float[boxes.size()];
        float[] ecy = new float[boxes.size()];
        float[] ecz = new float[boxes.size()];
        int i = 0;
        for (class_238 box : boxes) {
            erx[i] = 1.0f / ((float)(box.field_1320 - box.field_1323) / 2.0f * boxScale);
            ery[i] = 1.0f / ((float)(box.field_1325 - box.field_1322) / 2.0f * boxScale);
            erz[i] = 1.0f / ((float)(box.field_1324 - box.field_1321) / 2.0f * boxScale);
            ecx[i] = (float)((box.field_1323 + box.field_1320) / 2.0 - p.field_1352);
            ecy[i] = (float)((box.field_1322 + box.field_1325) / 2.0 - p.field_1351);
            ecz[i] = (float)((box.field_1321 + box.field_1324) / 2.0 - p.field_1350);
            ++i;
        }
        return CollisionSmoothingUtil.findClosestPoint(erx, ery, erz, ecx, ecy, ecz, boxes.size(), pp, pn, smoothingRange, boxScale, dx, iters, threshold, p);
    }

    @Nullable
    private static Pair<class_243, class_243> findClosestPoint(float[] erx, float[] ery, float[] erz, float[] ecx, float[] ecy, float[] ecz, int count, class_243 pp, class_243 pn, float smoothingRange, float boxScale, float dx, int iters, float threshold, class_243 p) {
        float halfThreshold = threshold * 0.5f;
        float plx = (float)(pp.field_1352 - p.field_1352);
        float ply = (float)(pp.field_1351 - p.field_1351);
        float plz = (float)(pp.field_1350 - p.field_1350);
        float pnx = (float)pn.field_1352;
        float pny = (float)pn.field_1351;
        float pnz = (float)pn.field_1350;
        float px = 0.0f;
        float py = 0.0f;
        float pz = 0.0f;
        float invSmoothingRange = 1.0f / smoothingRange;
        for (int j = 0; j < iters; ++j) {
            float m;
            float dst = CollisionSmoothingUtil.sampleSdf(erx, ery, erz, ecx, ecy, ecz, count, plx, ply, plz, pnx, pny, pnz, px, py, pz, smoothingRange, invSmoothingRange);
            float fx1 = CollisionSmoothingUtil.sampleSdf(erx, ery, erz, ecx, ecy, ecz, count, plx, ply, plz, pnx, pny, pnz, px + dx, py, pz, smoothingRange, invSmoothingRange);
            float fy1 = CollisionSmoothingUtil.sampleSdf(erx, ery, erz, ecx, ecy, ecz, count, plx, ply, plz, pnx, pny, pnz, px, py + dx, pz, smoothingRange, invSmoothingRange);
            float fz1 = CollisionSmoothingUtil.sampleSdf(erx, ery, erz, ecx, ecy, ecz, count, plx, ply, plz, pnx, pny, pnz, px, py, pz + dx, smoothingRange, invSmoothingRange);
            float gx = dst - fx1;
            float gy = dst - fy1;
            float gz = dst - fz1;
            if (Float.isNaN(gx *= (m = CollisionSmoothingUtil.invSqrt(gx * gx + gy * gy + gz * gz))) || Float.isNaN(gy *= m) || Float.isNaN(gz *= m) || Double.isNaN(px) || Double.isNaN(py) || Double.isNaN(pz)) {
                return null;
            }
            float absDst = Math.abs(dst);
            float step = absDst >= halfThreshold ? dst : Math.signum(dst) * halfThreshold;
            px += gx * step;
            py += gy * step;
            pz += gz * step;
            if (!(absDst < threshold)) continue;
            return Pair.of((Object)new class_243(p.field_1352 + (double)px, p.field_1351 + (double)py, p.field_1350 + (double)pz), (Object)new class_243((double)(-gx), (double)(-gy), (double)(-gz)).method_1029());
        }
        return null;
    }

    private static class BoxConsumer
    implements class_259.class_260 {
        private int capacity = 16;
        private int size = 0;
        private float[] erx = new float[this.capacity];
        private float[] ery = new float[this.capacity];
        private float[] erz = new float[this.capacity];
        private float[] ecx = new float[this.capacity];
        private float[] ecy = new float[this.capacity];
        private float[] ecz = new float[this.capacity];
        private final class_243 p;
        private final float boxScale;

        private BoxConsumer(class_243 p, float boxScale) {
            this.p = p;
            this.boxScale = boxScale;
        }

        public void consume(double minX, double minY, double minZ, double maxX, double maxY, double maxZ) {
            if (this.size == this.capacity) {
                this.capacity = (int)Math.max(Math.min((long)this.capacity + (long)(this.capacity >> 1), 0x7FFFFFF7L), (long)this.capacity);
                this.erx = FloatArrays.forceCapacity((float[])this.erx, (int)this.capacity, (int)this.size);
                this.ery = FloatArrays.forceCapacity((float[])this.ery, (int)this.capacity, (int)this.size);
                this.erz = FloatArrays.forceCapacity((float[])this.erz, (int)this.capacity, (int)this.size);
                this.ecx = FloatArrays.forceCapacity((float[])this.ecx, (int)this.capacity, (int)this.size);
                this.ecy = FloatArrays.forceCapacity((float[])this.ecy, (int)this.capacity, (int)this.size);
                this.ecz = FloatArrays.forceCapacity((float[])this.ecz, (int)this.capacity, (int)this.size);
            }
            this.erx[this.size] = 1.0f / ((float)(maxX - minX) / 2.0f * this.boxScale);
            this.ery[this.size] = 1.0f / ((float)(maxY - minY) / 2.0f * this.boxScale);
            this.erz[this.size] = 1.0f / ((float)(maxZ - minZ) / 2.0f * this.boxScale);
            this.ecx[this.size] = (float)((minX + maxX) / 2.0 - this.p.field_1352);
            this.ecy[this.size] = (float)((minY + maxY) / 2.0 - this.p.field_1351);
            this.ecz[this.size] = (float)((minZ + maxZ) / 2.0 - this.p.field_1350);
            ++this.size;
        }
    }
}

