/*
 * Decompiled with CFR 0.152.
 */
package win.demistorm.stormiespiders.mixin;

import java.lang.invoke.MethodHandles;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import net.minecraft.class_1294;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1308;
import net.minecraft.class_1313;
import net.minecraft.class_1314;
import net.minecraft.class_1322;
import net.minecraft.class_1324;
import net.minecraft.class_1408;
import net.minecraft.class_1628;
import net.minecraft.class_1922;
import net.minecraft.class_1937;
import net.minecraft.class_1941;
import net.minecraft.class_2183;
import net.minecraft.class_2338;
import net.minecraft.class_2349;
import net.minecraft.class_2350;
import net.minecraft.class_2379;
import net.minecraft.class_238;
import net.minecraft.class_2382;
import net.minecraft.class_243;
import net.minecraft.class_2487;
import net.minecraft.class_2586;
import net.minecraft.class_259;
import net.minecraft.class_265;
import net.minecraft.class_2680;
import net.minecraft.class_2784;
import net.minecraft.class_2940;
import net.minecraft.class_2941;
import net.minecraft.class_2943;
import net.minecraft.class_2945;
import net.minecraft.class_2960;
import net.minecraft.class_3218;
import net.minecraft.class_3481;
import net.minecraft.class_3532;
import net.minecraft.class_3610;
import net.minecraft.class_3898;
import net.minecraft.class_5134;
import net.minecraft.class_9;
import org.apache.commons.lang3.tuple.Pair;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.Redirect;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;
import win.demistorm.stormiespiders.common.CollisionSmoothingUtil;
import win.demistorm.stormiespiders.common.Matrix4f;
import win.demistorm.stormiespiders.common.entity.mob.IClimberEntity;
import win.demistorm.stormiespiders.common.entity.mob.IEntityMovementHook;
import win.demistorm.stormiespiders.common.entity.mob.IEntityReadWriteHook;
import win.demistorm.stormiespiders.common.entity.mob.ILivingEntityDataManagerHook;
import win.demistorm.stormiespiders.common.entity.mob.ILivingEntityJumpHook;
import win.demistorm.stormiespiders.common.entity.mob.ILivingEntityLookAtHook;
import win.demistorm.stormiespiders.common.entity.mob.ILivingEntityRotationHook;
import win.demistorm.stormiespiders.common.entity.mob.ILivingEntityTravelHook;
import win.demistorm.stormiespiders.common.entity.mob.IMobEntityLivingTickHook;
import win.demistorm.stormiespiders.common.entity.mob.IMobEntityTickHook;
import win.demistorm.stormiespiders.common.entity.mob.Orientation;
import win.demistorm.stormiespiders.common.entity.movement.BetterSpiderPathNavigator;
import win.demistorm.stormiespiders.common.entity.movement.ClimberJumpController;
import win.demistorm.stormiespiders.common.entity.movement.ClimberLookController;
import win.demistorm.stormiespiders.common.entity.movement.ClimberMoveController;
import win.demistorm.stormiespiders.config.Config;

@Mixin(value={class_1628.class})
public abstract class ClimberEntityMixin
extends class_1314
implements IClimberEntity,
IMobEntityLivingTickHook,
ILivingEntityLookAtHook,
IMobEntityTickHook,
ILivingEntityRotationHook,
ILivingEntityDataManagerHook,
ILivingEntityTravelHook,
IEntityMovementHook,
IEntityReadWriteHook,
ILivingEntityJumpHook {
    private static final UUID SLOW_FALLING_ID = UUID.fromString("A5B6CF2A-2F7C-31EF-9022-7C3E7D5E6ABA");
    private static final class_1322 SLOW_FALLING = new class_1322(class_2960.method_60655((String)"stormiespiders", (String)"slow_falling"), -0.07, class_1322.class_1323.field_6328);
    private static final class_2940<class_2379> ROTATION_BODY;
    private static final class_2940<class_2379> ROTATION_HEAD;
    private double prevAttachmentOffsetX;
    private double prevAttachmentOffsetY;
    private double prevAttachmentOffsetZ;
    private double attachmentOffsetX;
    private double attachmentOffsetY;
    private double attachmentOffsetZ;
    private class_243 attachmentNormal = new class_243(0.0, 1.0, 0.0);
    private class_243 prevAttachmentNormal = new class_243(0.0, 1.0, 0.0);
    private float prevOrientationYawDelta;
    private float orientationYawDelta;
    private double lastAttachmentOffsetX;
    private double lastAttachmentOffsetY;
    private double lastAttachmentOffsetZ;
    private class_243 lastAttachmentOrientationNormal = new class_243(0.0, 1.0, 0.0);
    private int attachedTicks = 5;
    private class_243 attachedSides = new class_243(0.0, 0.0, 0.0);
    private class_243 prevAttachedSides = new class_243(0.0, 0.0, 0.0);
    private boolean canClimbInWater = false;
    private boolean canClimbInLava = false;
    private boolean isTravelingInFluid = false;
    private float collisionsInclusionRange = 2.0f;
    private float collisionsSmoothingRange = 1.25f;
    private Orientation orientation;
    private Pair<class_2350, class_243> groundDirection = Pair.of((Object)class_2350.field_11033, (Object)new class_243(0.0, -1.0, 0.0));
    private Orientation renderOrientation;
    private float nextStepDistance;
    private float nextFlap;
    private class_243 preWalkingPosition;
    private double preMoveY;
    private class_243 jumpDir;
    private boolean isJumping = false;

    private ClimberEntityMixin(class_1299<? extends class_1314> type, class_1937 worldIn) {
        super(type, worldIn);
    }

    @Inject(method={"<init>*"}, at={@At(value="RETURN")})
    private void onConstructed(CallbackInfo ci) {
        this.orientation = this.calculateOrientation(1.0f);
        this.groundDirection = this.getGroundDirection();
        this.field_6207 = new ClimberMoveController<ClimberEntityMixin>(this);
        this.field_6206 = new ClimberLookController<ClimberEntityMixin>(this);
        this.field_6204 = new ClimberJumpController<ClimberEntityMixin>(this);
    }

    @Inject(method={"createNavigation"}, at={@At(value="HEAD")}, cancellable=true)
    private void onCreateNavigator(class_1937 world, CallbackInfoReturnable<class_1408> ci) {
        BetterSpiderPathNavigator<ClimberEntityMixin> navigate = new BetterSpiderPathNavigator<ClimberEntityMixin>(this, world, false);
        navigate.method_6354(true);
        ci.setReturnValue(navigate);
    }

    @Redirect(method={"defineSynchedData"}, at=@At(value="INVOKE", target="Lnet/minecraft/network/syncher/SynchedEntityData$Builder;define(Lnet/minecraft/network/syncher/EntityDataAccessor;Ljava/lang/Object;)Lnet/minecraft/network/syncher/SynchedEntityData$Builder;", ordinal=0))
    public <T> class_2945.class_9222 onDefineData(class_2945.class_9222 builder, class_2940<T> accessor, T value) {
        class_2945.class_9222 result = builder.method_56912(accessor, value);
        builder.method_56912(ROTATION_BODY, (Object)new class_2379(0.0f, 0.0f, 0.0f));
        builder.method_56912(ROTATION_HEAD, (Object)new class_2379(0.0f, 0.0f, 0.0f));
        return result;
    }

    @Override
    public void onWrite(class_2487 nbt) {
        nbt.method_10549("stormiespiders.AttachmentNormalX", this.attachmentNormal.field_1352);
        nbt.method_10549("stormiespiders.AttachmentNormalY", this.attachmentNormal.field_1351);
        nbt.method_10549("stormiespiders.AttachmentNormalZ", this.attachmentNormal.field_1350);
        nbt.method_10569("stormiespiders.AttachedTicks", this.attachedTicks);
    }

    @Override
    public void onRead(class_2487 nbt) {
        this.prevAttachmentNormal = this.attachmentNormal = new class_243(nbt.method_10574("stormiespiders.AttachmentNormalX"), nbt.method_10574("stormiespiders.AttachmentNormalY"), nbt.method_10574("stormiespiders.AttachmentNormalZ"));
        this.attachedTicks = nbt.method_10550("stormiespiders.AttachedTicks");
        this.orientation = this.calculateOrientation(1.0f);
    }

    @Override
    public boolean canClimbInWater() {
        return this.canClimbInWater;
    }

    @Override
    public void setCanClimbInWater(boolean value) {
        this.canClimbInWater = value;
    }

    @Override
    public boolean canClimbInLava() {
        return this.canClimbInLava;
    }

    @Override
    public void setCanClimbInLava(boolean value) {
        this.canClimbInLava = value;
    }

    @Override
    public float getCollisionsInclusionRange() {
        return this.collisionsInclusionRange;
    }

    @Override
    public void setCollisionsInclusionRange(float range) {
        this.collisionsInclusionRange = range;
    }

    @Override
    public float getCollisionsSmoothingRange() {
        return this.collisionsSmoothingRange;
    }

    @Override
    public void setCollisionsSmoothingRange(float range) {
        this.collisionsSmoothingRange = range;
    }

    @Override
    public float getBridgePathingMalus(class_1308 entity, class_2338 pos, class_9 fallPathPoint) {
        return -1.0f;
    }

    @Override
    public void onPathingObstructed(class_2350 facing) {
    }

    public int method_5850() {
        return 0;
    }

    @Override
    public float getMovementSpeed() {
        class_1324 attribute = this.method_5996(class_5134.field_23719);
        return attribute != null ? (float)attribute.method_6194() : 1.0f;
    }

    private static double calculateXOffset(class_238 aabb, class_238 other, double offsetX) {
        if (other.field_1325 > aabb.field_1322 && other.field_1322 < aabb.field_1325 && other.field_1324 > aabb.field_1321 && other.field_1321 < aabb.field_1324) {
            double dx;
            if (offsetX > 0.0 && other.field_1320 <= aabb.field_1323) {
                double dx2 = aabb.field_1323 - other.field_1320;
                if (dx2 < offsetX) {
                    offsetX = dx2;
                }
            } else if (offsetX < 0.0 && other.field_1323 >= aabb.field_1320 && (dx = aabb.field_1320 - other.field_1323) > offsetX) {
                offsetX = dx;
            }
            return offsetX;
        }
        return offsetX;
    }

    private static double calculateYOffset(class_238 aabb, class_238 other, double offsetY) {
        if (other.field_1320 > aabb.field_1323 && other.field_1323 < aabb.field_1320 && other.field_1324 > aabb.field_1321 && other.field_1321 < aabb.field_1324) {
            double dy;
            if (offsetY > 0.0 && other.field_1325 <= aabb.field_1322) {
                double dy2 = aabb.field_1322 - other.field_1325;
                if (dy2 < offsetY) {
                    offsetY = dy2;
                }
            } else if (offsetY < 0.0 && other.field_1322 >= aabb.field_1325 && (dy = aabb.field_1325 - other.field_1322) > offsetY) {
                offsetY = dy;
            }
            return offsetY;
        }
        return offsetY;
    }

    private static double calculateZOffset(class_238 aabb, class_238 other, double offsetZ) {
        if (other.field_1320 > aabb.field_1323 && other.field_1323 < aabb.field_1320 && other.field_1325 > aabb.field_1322 && other.field_1322 < aabb.field_1325) {
            double dz;
            if (offsetZ > 0.0 && other.field_1324 <= aabb.field_1321) {
                double dz2 = aabb.field_1321 - other.field_1324;
                if (dz2 < offsetZ) {
                    offsetZ = dz2;
                }
            } else if (offsetZ < 0.0 && other.field_1321 >= aabb.field_1324 && (dz = aabb.field_1324 - other.field_1321) > offsetZ) {
                offsetZ = dz;
            }
            return offsetZ;
        }
        return offsetZ;
    }

    private void updateWalkingSide() {
        Object avoidPathingFacing = null;
        class_238 entityBox = this.method_5829();
        double closestFacingDst = Double.MAX_VALUE;
        class_2350 closestFacing = null;
        class_243 weighting = new class_243(0.0, 0.0, 0.0);
        float stickingDistance = this.field_6250 != 0.0f ? 1.5f : 0.1f;
        for (class_2350 facing : class_2350.values()) {
            if (avoidPathingFacing == facing) continue;
            List<class_238> collisionBoxes = this.getCollisionBoxes(entityBox.method_1014((double)0.2f).method_1012((double)((float)facing.method_10148() * stickingDistance), (double)((float)facing.method_10164() * stickingDistance), (double)((float)facing.method_10165() * stickingDistance)));
            double closestDst = Double.MAX_VALUE;
            for (class_238 collisionBox : collisionBoxes) {
                switch (facing) {
                    case field_11034: 
                    case field_11039: {
                        closestDst = Math.min(closestDst, Math.abs(ClimberEntityMixin.calculateXOffset(entityBox, collisionBox, (float)(-facing.method_10148()) * stickingDistance)));
                        break;
                    }
                    case field_11036: 
                    case field_11033: {
                        closestDst = Math.min(closestDst, Math.abs(ClimberEntityMixin.calculateYOffset(entityBox, collisionBox, (float)(-facing.method_10164()) * stickingDistance)));
                        break;
                    }
                    case field_11043: 
                    case field_11035: {
                        closestDst = Math.min(closestDst, Math.abs(ClimberEntityMixin.calculateZOffset(entityBox, collisionBox, (float)(-facing.method_10165()) * stickingDistance)));
                    }
                }
            }
            if (closestDst < closestFacingDst) {
                closestFacingDst = closestDst;
                closestFacing = facing;
            }
            if (!(closestDst < Double.MAX_VALUE)) continue;
            weighting = weighting.method_1019(new class_243((double)facing.method_10148(), (double)facing.method_10164(), (double)facing.method_10165()).method_1021(1.0 - Math.min(closestDst, (double)stickingDistance) / (double)stickingDistance));
        }
        this.groundDirection = closestFacing == null ? Pair.of((Object)class_2350.field_11033, (Object)new class_243(0.0, -1.0, 0.0)) : Pair.of(closestFacing, (Object)weighting.method_1029().method_1031(0.0, (double)-0.001f, 0.0).method_1029());
    }

    @Override
    public Pair<class_2350, class_243> getGroundDirection() {
        return this.groundDirection;
    }

    @Override
    public class_2350 getGroundSide() {
        return (class_2350)this.groundDirection.getKey();
    }

    @Override
    public Orientation getOrientation() {
        return this.orientation;
    }

    @Override
    public void setRenderOrientation(Orientation orientation) {
        this.renderOrientation = orientation;
    }

    @Override
    public Orientation getRenderOrientation() {
        return this.renderOrientation;
    }

    @Override
    public float getAttachmentOffset(class_2350.class_2351 axis, float partialTicks) {
        switch (axis) {
            default: {
                return (float)(this.prevAttachmentOffsetX + (this.attachmentOffsetX - this.prevAttachmentOffsetX) * (double)partialTicks);
            }
            case field_11052: {
                return (float)(this.prevAttachmentOffsetY + (this.attachmentOffsetY - this.prevAttachmentOffsetY) * (double)partialTicks);
            }
            case field_11051: 
        }
        return (float)(this.prevAttachmentOffsetZ + (this.attachmentOffsetZ - this.prevAttachmentOffsetZ) * (double)partialTicks);
    }

    @Override
    public class_243 onLookAt(class_2183.class_2184 anchor, class_243 vec) {
        class_243 dir = vec.method_1020(this.method_19538());
        dir = this.getOrientation().getLocal(dir);
        return dir;
    }

    @Override
    public void onTick() {
        class_3898.class_3208 entityTracker;
        if (!this.method_37908().field_9236 && this.method_37908() instanceof class_3218 && (entityTracker = (class_3898.class_3208)((class_3218)this.method_37908()).method_14178().field_17254.field_18242.get(this.method_5628())) != null && entityTracker.field_18246.field_14040 % entityTracker.field_18246.field_14037 == 0) {
            Orientation orientation = this.getOrientation();
            class_243 look = orientation.getGlobal(this.method_36454(), this.method_36455());
            this.field_6011.method_12778(ROTATION_BODY, (Object)new class_2379((float)look.field_1352, (float)look.field_1351, (float)look.field_1350));
            look = orientation.getGlobal(this.field_6241, 0.0f);
            this.field_6011.method_12778(ROTATION_HEAD, (Object)new class_2379((float)look.field_1352, (float)look.field_1351, (float)look.field_1350));
        }
    }

    @Override
    public void onLivingTick() {
        this.updateWalkingSide();
    }

    public boolean method_6101() {
        return true;
    }

    @Override
    public float getVerticalOffset(float partialTicks) {
        return 0.075f;
    }

    private void forEachCollisonBox(class_238 aabb, class_259.class_260 action) {
        int minChunkX = class_3532.method_15357((double)(aabb.field_1323 - 1.0E-7)) - 1 >> 4;
        int maxChunkX = class_3532.method_15357((double)(aabb.field_1320 + 1.0E-7)) + 1 >> 4;
        int minChunkZ = class_3532.method_15357((double)(aabb.field_1321 - 1.0E-7)) - 1 >> 4;
        int maxChunkZ = class_3532.method_15357((double)(aabb.field_1324 + 1.0E-7)) + 1 >> 4;
        int width = maxChunkX - minChunkX + 1;
        int depth = maxChunkZ - minChunkZ + 1;
        class_1922[] blockReaderCache = new class_1922[width * depth];
        class_1937 collisionReader = this.method_37908();
        for (int cx = minChunkX; cx <= maxChunkX; ++cx) {
            for (int cz = minChunkZ; cz <= maxChunkZ; ++cz) {
                blockReaderCache[cx - minChunkX + (cz - minChunkZ) * width] = collisionReader.method_22338(cx, cz);
            }
        }
        class_1941 cachedCollisionReader = new class_1941(){
            final /* synthetic */ class_1941 val$collisionReader;
            final /* synthetic */ class_1922[] val$blockReaderCache;
            final /* synthetic */ int val$minChunkX;
            final /* synthetic */ int val$minChunkZ;
            final /* synthetic */ int val$width;
            {
                this.val$collisionReader = class_19412;
                this.val$blockReaderCache = class_1922Array;
                this.val$minChunkX = n;
                this.val$minChunkZ = n2;
                this.val$width = n3;
            }

            public int method_31605() {
                return ClimberEntityMixin.this.method_37908().method_31605();
            }

            public int method_31607() {
                return ClimberEntityMixin.this.method_37908().method_31607();
            }

            public class_2586 method_8321(class_2338 pos) {
                return this.val$collisionReader.method_8321(pos);
            }

            public class_2680 method_8320(class_2338 pos) {
                return this.val$collisionReader.method_8320(pos);
            }

            public class_3610 method_8316(class_2338 pos) {
                return this.val$collisionReader.method_8316(pos);
            }

            public class_2784 method_8621() {
                return this.val$collisionReader.method_8621();
            }

            public List<class_265> method_20743(class_1297 entity, class_238 aabb) {
                return this.val$collisionReader.method_20743(entity, aabb);
            }

            public class_1922 method_22338(int chunkX, int chunkZ) {
                return this.val$blockReaderCache[chunkX - this.val$minChunkX + (chunkZ - this.val$minChunkZ) * this.val$width];
            }
        };
        Iterable shapes = cachedCollisionReader.method_20812((class_1297)this, aabb);
        shapes.forEach(shape -> shape.method_1089(action));
    }

    private List<class_238> getCollisionBoxes(class_238 aabb) {
        ArrayList<class_238> boxes = new ArrayList<class_238>();
        this.forEachCollisonBox(aabb, (minX, minY, minZ, maxX, maxY, maxZ) -> boxes.add(new class_238(minX, minY, minZ, maxX, maxY, maxZ)));
        return boxes;
    }

    @Override
    public boolean canClimbOnBlock(class_2680 state, class_2338 pos) {
        return !Config.COMMON.preventClimbingInRain() || !this.method_37908().method_8419() || !this.method_37908().method_8520(pos);
    }

    @Override
    public boolean canAttachToSide(class_2350 side) {
        return this.isJumping || !Config.COMMON.preventClimbingInRain() || side.method_10166() == class_2350.class_2351.field_11052 || !this.method_37908().method_8520(new class_2338((int)this.method_23317(), (int)(this.method_23318() + (double)(this.method_17682() * 0.5f)), (int)this.method_23321()));
    }

    @Override
    public float getBlockSlipperiness(class_2338 pos) {
        class_2680 offsetState = this.method_37908().method_8320(pos);
        return offsetState.method_26204().method_9499() * 0.91f;
    }

    private void updateOffsetsAndOrientation() {
        class_243 direction = this.getOrientation().getGlobal(this.method_36454(), this.method_36455());
        boolean isAttached = false;
        double baseStickingOffsetX = 0.0;
        double baseStickingOffsetY = this.getVerticalOffset(1.0f);
        double baseStickingOffsetZ = 0.0;
        class_243 baseOrientationNormal = new class_243(0.0, 1.0, 0.0);
        if (Config.COMMON.preventClimbingInRain() && this.method_37908().method_8419() && this.method_37908().method_8520(new class_2338((int)this.method_23317(), (int)(this.method_23318() + (double)(this.method_17682() * 0.5f)), (int)this.method_23321()))) {
            isAttached = false;
        } else if (!this.isTravelingInFluid && this.method_24828() && this.method_5854() == null) {
            class_243 p = this.method_19538();
            class_243 s = p.method_1031(0.0, (double)(this.method_17682() * 0.5f), 0.0);
            class_238 inclusionBox = new class_238(s.field_1352, s.field_1351, s.field_1350, s.field_1352, s.field_1351, s.field_1350).method_1014((double)this.collisionsInclusionRange);
            Pair<class_243, class_243> attachmentPoint = CollisionSmoothingUtil.findClosestPoint(consumer -> this.forEachCollisonBox(inclusionBox, (class_259.class_260)consumer), s, this.attachmentNormal.method_1021(-1.0), this.collisionsSmoothingRange, 1.0f, 0.001f, 20, 0.05f, s);
            class_238 entityBox = this.method_5829();
            if (attachmentPoint != null) {
                double dz;
                double dy;
                class_243 attachmentPos = (class_243)attachmentPoint.getLeft();
                double dx = Math.max(entityBox.field_1323 - attachmentPos.field_1352, attachmentPos.field_1352 - entityBox.field_1320);
                if (Math.max(dx, Math.max(dy = Math.max(entityBox.field_1322 - attachmentPos.field_1351, attachmentPos.field_1351 - entityBox.field_1325), dz = Math.max(entityBox.field_1321 - attachmentPos.field_1350, attachmentPos.field_1350 - entityBox.field_1324))) < 0.5) {
                    isAttached = true;
                    this.lastAttachmentOffsetX = class_3532.method_15350((double)(attachmentPos.field_1352 - p.field_1352), (double)(-this.method_17681() / 2.0f), (double)(this.method_17681() / 2.0f));
                    this.lastAttachmentOffsetY = class_3532.method_15350((double)(attachmentPos.field_1351 - p.field_1351), (double)0.0, (double)this.method_17682());
                    this.lastAttachmentOffsetZ = class_3532.method_15350((double)(attachmentPos.field_1350 - p.field_1350), (double)(-this.method_17681() / 2.0f), (double)(this.method_17681() / 2.0f));
                    this.lastAttachmentOrientationNormal = (class_243)attachmentPoint.getRight();
                }
            }
        }
        this.prevAttachmentOffsetX = this.attachmentOffsetX;
        this.prevAttachmentOffsetY = this.attachmentOffsetY;
        this.prevAttachmentOffsetZ = this.attachmentOffsetZ;
        this.prevAttachmentNormal = this.attachmentNormal;
        float attachmentBlend = (float)this.attachedTicks * 0.2f;
        this.attachmentOffsetX = baseStickingOffsetX + (this.lastAttachmentOffsetX - baseStickingOffsetX) * (double)attachmentBlend;
        this.attachmentOffsetY = baseStickingOffsetY + (this.lastAttachmentOffsetY - baseStickingOffsetY) * (double)attachmentBlend;
        this.attachmentOffsetZ = baseStickingOffsetZ + (this.lastAttachmentOffsetZ - baseStickingOffsetZ) * (double)attachmentBlend;
        this.attachmentNormal = baseOrientationNormal.method_1019(this.lastAttachmentOrientationNormal.method_1020(baseOrientationNormal).method_1021((double)attachmentBlend)).method_1029();
        this.attachedTicks = !isAttached ? Math.max(0, this.attachedTicks - 1) : Math.min(5, this.attachedTicks + 1);
        this.orientation = this.calculateOrientation(1.0f);
        Pair<Float, Float> newRotations = this.getOrientation().getLocalRotation(direction);
        float yawDelta = ((Float)newRotations.getLeft()).floatValue() - this.method_36454();
        float pitchDelta = ((Float)newRotations.getRight()).floatValue() - this.method_36455();
        this.prevOrientationYawDelta = this.orientationYawDelta;
        this.orientationYawDelta = yawDelta;
        this.field_6031 = class_3532.method_15393((float)(this.field_6031 + yawDelta));
        this.field_5982 = this.wrapAngleInRange(this.field_5982, this.field_6031);
        this.field_6284 = class_3532.method_15338((double)(this.field_6284 + (double)yawDelta));
        this.field_6283 = class_3532.method_15393((float)(this.field_6283 + yawDelta));
        this.field_6220 = this.wrapAngleInRange(this.field_6220, this.field_6283);
        this.field_6241 = class_3532.method_15393((float)(this.field_6241 + yawDelta));
        this.field_6259 = this.wrapAngleInRange(this.field_6259, this.field_6241);
        this.field_45123 = class_3532.method_15338((double)(this.field_45123 + (double)yawDelta));
        this.field_5965 = class_3532.method_15393((float)(this.field_5965 + pitchDelta));
        this.field_6004 = this.wrapAngleInRange(this.field_6004, this.field_5965);
        this.field_6221 = class_3532.method_15338((double)(this.field_6221 + (double)pitchDelta));
    }

    private float wrapAngleInRange(float angle, float target) {
        while (target - angle < -180.0f) {
            angle -= 360.0f;
        }
        while (target - angle >= 180.0f) {
            angle += 360.0f;
        }
        return angle;
    }

    @Override
    public Orientation calculateOrientation(float partialTicks) {
        class_243 attachmentNormal = this.prevAttachmentNormal.method_1019(this.attachmentNormal.method_1020(this.prevAttachmentNormal).method_1021((double)partialTicks));
        class_243 localZ = new class_243(0.0, 0.0, 1.0);
        class_243 localY = new class_243(0.0, 1.0, 0.0);
        class_243 localX = new class_243(1.0, 0.0, 0.0);
        float componentZ = (float)localZ.method_1026(attachmentNormal);
        float componentX = (float)localX.method_1026(attachmentNormal);
        float yaw = (float)Math.toDegrees(class_3532.method_15349((double)componentX, (double)componentZ));
        localZ = new class_243(Math.sin(Math.toRadians(yaw)), 0.0, Math.cos(Math.toRadians(yaw)));
        localY = new class_243(0.0, 1.0, 0.0);
        localX = new class_243(Math.sin(Math.toRadians(yaw - 90.0f)), 0.0, Math.cos(Math.toRadians(yaw - 90.0f)));
        componentZ = (float)localZ.method_1026(attachmentNormal);
        float componentY = (float)localY.method_1026(attachmentNormal);
        componentX = (float)localX.method_1026(attachmentNormal);
        float pitch = (float)Math.toDegrees(class_3532.method_15349((double)class_3532.method_15355((float)(componentX * componentX + componentZ * componentZ)), (double)componentY));
        Matrix4f m = new Matrix4f();
        m.multiply(new Matrix4f((float)Math.toRadians(yaw), 0.0f, 1.0f, 0.0f));
        m.multiply(new Matrix4f((float)Math.toRadians(pitch), 1.0f, 0.0f, 0.0f));
        m.multiply(new Matrix4f((float)Math.toRadians(Math.signum(0.5f - componentY - componentZ - componentX) * yaw), 0.0f, 1.0f, 0.0f));
        localZ = m.multiply(new class_243(0.0, 0.0, -1.0));
        localY = m.multiply(new class_243(0.0, 1.0, 0.0));
        localX = m.multiply(new class_243(1.0, 0.0, 0.0));
        return new Orientation(attachmentNormal, localZ, localY, localX, componentZ, componentY, componentX, yaw, pitch);
    }

    @Override
    public float getTargetYaw(double x, double y, double z, float yaw, float pitch, int posRotationIncrements) {
        return (float)this.field_6284;
    }

    @Override
    public float getTargetPitch(double x, double y, double z, float yaw, float pitch, int posRotationIncrements) {
        return (float)this.field_6221;
    }

    @Override
    public float getTargetHeadYaw(float yaw, int rotationIncrements) {
        return (float)this.field_45123;
    }

    @Override
    public void onNotifyDataManagerChange(class_2940<?> key) {
        if (ROTATION_BODY.equals(key)) {
            class_2379 rotation = (class_2379)this.field_6011.method_12789(ROTATION_BODY);
            class_243 look = new class_243((double)rotation.method_10256(), (double)rotation.method_10257(), (double)rotation.method_10258());
            Pair<Float, Float> rotations = this.getOrientation().getLocalRotation(look);
            this.field_6284 = ((Float)rotations.getLeft()).floatValue();
            this.field_6221 = ((Float)rotations.getRight()).floatValue();
        } else if (ROTATION_HEAD.equals(key)) {
            class_2379 rotation = (class_2379)this.field_6011.method_12789(ROTATION_HEAD);
            class_243 look = new class_243((double)rotation.method_10256(), (double)rotation.method_10257(), (double)rotation.method_10258());
            Pair<Float, Float> rotations = this.getOrientation().getLocalRotation(look);
            this.field_45123 = ((Float)rotations.getLeft()).floatValue();
            this.field_6265 = 3;
        }
    }

    private double getClimberGravity() {
        boolean isFalling;
        if (this.method_5740()) {
            return 0.0;
        }
        double gravity = 0.08;
        boolean bl = isFalling = this.method_18798().field_1351 <= 0.0;
        if (isFalling && this.method_6059(class_1294.field_5906)) {
            gravity = 0.1;
        }
        return gravity;
    }

    private class_243 getStickingForce(Pair<class_2350, class_243> walkingSide) {
        double uprightness = Math.max(this.attachmentNormal.field_1351, 0.0);
        double gravity = this.getClimberGravity();
        double stickingForce = gravity * uprightness + 0.08 * (1.0 - uprightness);
        return ((class_243)walkingSide.getRight()).method_1021(stickingForce);
    }

    @Override
    public void setJumpDirection(class_243 dir) {
        this.jumpDir = dir != null ? dir.method_1029() : null;
    }

    @Override
    public void method_6100(boolean jumping) {
        this.isJumping = jumping;
    }

    @Override
    public boolean onJump() {
        this.isJumping = true;
        if (this.jumpDir != null) {
            float jumpStrength = this.method_6106();
            if (this.method_6059(class_1294.field_5913)) {
                jumpStrength += 0.1f * (float)(this.method_6112(class_1294.field_5913).method_5578() + 1);
            }
            class_243 motion = this.method_18798();
            class_243 orthogonalMotion = this.jumpDir.method_1021(this.jumpDir.method_1026(motion));
            class_243 tangentialMotion = motion.method_1020(orthogonalMotion);
            this.method_18800(tangentialMotion.field_1352 + this.jumpDir.field_1352 * (double)jumpStrength, tangentialMotion.field_1351 + this.jumpDir.field_1351 * (double)jumpStrength, tangentialMotion.field_1350 + this.jumpDir.field_1350 * (double)jumpStrength);
            if (this.method_5624()) {
                class_243 boost = this.getOrientation().getGlobal(this.field_6031, 0.0f).method_1021((double)0.2f);
                this.method_18799(this.method_18798().method_1019(boost));
            }
            this.field_6007 = true;
            return true;
        }
        return false;
    }

    @Override
    public boolean onTravel(class_243 relative, boolean pre) {
        if (pre) {
            boolean canTravel = this.method_6034() || this.method_5787();
            this.isTravelingInFluid = false;
            class_3610 fluidState = this.method_37908().method_8316(this.method_24515());
            if (!this.canClimbInWater && this.method_5799() && this.method_29920() && !this.method_26319(fluidState)) {
                this.isTravelingInFluid = true;
                if (canTravel) {
                    return false;
                }
            } else if (!this.canClimbInLava && this.method_5771() && this.method_29920() && !this.method_26319(fluidState)) {
                this.isTravelingInFluid = true;
                if (canTravel) {
                    return false;
                }
            } else if (canTravel) {
                this.travelOnGround(relative);
            }
            if (!canTravel) {
                this.method_29242(true);
            }
            this.updateOffsetsAndOrientation();
            return true;
        }
        this.updateOffsetsAndOrientation();
        return false;
    }

    private float getRelevantMoveFactor(float slipperiness) {
        return this.method_24828() ? this.method_6029() * (0.16277136f / (slipperiness * slipperiness * slipperiness)) : this.method_49484();
    }

    private void travelOnGround(class_243 relative) {
        boolean detachedZ;
        boolean isFalling;
        Orientation orientation = this.getOrientation();
        class_243 forwardVector = orientation.getGlobal(this.field_6031, 0.0f);
        class_243 strafeVector = orientation.getGlobal(this.field_6031 + 90.0f, 0.0f);
        class_243 upVector = orientation.getGlobal(this.field_6031, -90.0f);
        Pair<class_2350, class_243> groundDirection = this.getGroundDirection();
        class_243 stickingForce = this.getStickingForce(groundDirection);
        boolean bl = isFalling = this.method_18798().field_1351 <= 0.0;
        if (isFalling && this.method_6059(class_1294.field_5906)) {
            this.field_6017 = 0.0f;
        }
        float forward = (float)relative.field_1350;
        float strafe = (float)relative.field_1352;
        if (forward != 0.0f || strafe != 0.0f) {
            float f;
            float slipperiness = 0.91f;
            if (this.method_24828()) {
                class_2338 offsetPos = new class_2338((class_2382)this.method_24515()).method_10093((class_2350)groundDirection.getLeft());
                slipperiness = this.getBlockSlipperiness(offsetPos);
            }
            if ((f = forward * forward + strafe * strafe) >= 1.0E-4f) {
                boolean isInnerCorner;
                f = Math.max(class_3532.method_15355((float)f), 1.0f);
                f = this.getRelevantMoveFactor(slipperiness) / f;
                class_243 movementOffset = new class_243(forwardVector.field_1352 * (double)(forward *= f) + strafeVector.field_1352 * (double)(strafe *= f), forwardVector.field_1351 * (double)forward + strafeVector.field_1351 * (double)strafe, forwardVector.field_1350 * (double)forward + strafeVector.field_1350 * (double)strafe);
                double px = this.method_23317();
                double py = this.method_23318();
                double pz = this.method_23321();
                class_243 motion = this.method_18798();
                class_238 aabb = this.method_5829();
                this.method_5784(class_1313.field_6308, movementOffset);
                class_243 movementDir = new class_243(this.method_23317() - px, this.method_23318() - py, this.method_23321() - pz).method_1029();
                this.method_5857(aabb);
                this.setLocationFromBoundingbox();
                this.method_18799(motion);
                class_243 probeVector = new class_243(Math.abs(movementDir.field_1352) < 0.001 ? -Math.signum(upVector.field_1352) : 0.0, Math.abs(movementDir.field_1351) < 0.001 ? -Math.signum(upVector.field_1351) : 0.0, Math.abs(movementDir.field_1350) < 0.001 ? -Math.signum(upVector.field_1350) : 0.0).method_1029().method_1021(1.0E-4);
                this.method_5784(class_1313.field_6308, probeVector);
                class_243 collisionNormal = new class_243(Math.abs(this.method_23317() - px - probeVector.field_1352) > 1.0E-6 ? Math.signum(-probeVector.field_1352) : 0.0, Math.abs(this.method_23318() - py - probeVector.field_1351) > 1.0E-6 ? Math.signum(-probeVector.field_1351) : 0.0, Math.abs(this.method_23321() - pz - probeVector.field_1350) > 1.0E-6 ? Math.signum(-probeVector.field_1350) : 0.0).method_1029();
                this.method_5857(aabb);
                this.setLocationFromBoundingbox();
                this.method_18799(motion);
                class_243 surfaceMovementDir = movementDir.method_1020(collisionNormal.method_1021(collisionNormal.method_1026(movementDir))).method_1029();
                boolean bl2 = isInnerCorner = Math.abs(collisionNormal.field_1352) + Math.abs(collisionNormal.field_1351) + Math.abs(collisionNormal.field_1350) > (double)1.0001f;
                if (!isInnerCorner) {
                    movementDir = surfaceMovementDir;
                }
                stickingForce = stickingForce.method_1020(surfaceMovementDir.method_1021(surfaceMovementDir.method_1029().method_1026(stickingForce)));
                float moveSpeed = class_3532.method_15355((float)(forward * forward + strafe * strafe));
                this.method_18799(this.method_18798().method_1019(movementDir.method_1021((double)moveSpeed)));
            }
        }
        this.method_18799(this.method_18798().method_1019(stickingForce));
        double px = this.method_23317();
        double py = this.method_23318();
        double pz = this.method_23321();
        class_243 motion = this.method_18798();
        this.method_5784(class_1313.field_6308, motion);
        this.prevAttachedSides = this.attachedSides;
        this.attachedSides = new class_243(Math.abs(this.method_23317() - px - motion.field_1352) > 0.001 ? -Math.signum(motion.field_1352) : 0.0, Math.abs(this.method_23318() - py - motion.field_1351) > 0.001 ? -Math.signum(motion.field_1351) : 0.0, Math.abs(this.method_23321() - pz - motion.field_1350) > 0.001 ? -Math.signum(motion.field_1350) : 0.0);
        float slipperiness = 0.91f;
        if (this.method_24828()) {
            this.field_6017 = 0.0f;
            class_2338 offsetPos = new class_2338((class_2382)this.method_24515()).method_10093((class_2350)groundDirection.getLeft());
            slipperiness = this.getBlockSlipperiness(offsetPos);
        }
        motion = this.method_18798();
        class_243 orthogonalMotion = upVector.method_1021(upVector.method_1026(motion));
        class_243 tangentialMotion = motion.method_1020(orthogonalMotion);
        this.method_18800(tangentialMotion.field_1352 * (double)slipperiness + orthogonalMotion.field_1352 * (double)0.98f, tangentialMotion.field_1351 * (double)slipperiness + orthogonalMotion.field_1351 * (double)0.98f, tangentialMotion.field_1350 * (double)slipperiness + orthogonalMotion.field_1350 * (double)0.98f);
        boolean detachedX = this.attachedSides.field_1352 != this.prevAttachedSides.field_1352 && Math.abs(this.attachedSides.field_1352) < 0.001;
        boolean detachedY = this.attachedSides.field_1351 != this.prevAttachedSides.field_1351 && Math.abs(this.attachedSides.field_1351) < 0.001;
        boolean bl3 = detachedZ = this.attachedSides.field_1350 != this.prevAttachedSides.field_1350 && Math.abs(this.attachedSides.field_1350) < 0.001;
        if (detachedX || detachedY || detachedZ) {
            float stepHeight = this.method_49476();
            boolean prevOnGround = this.method_24828();
            boolean prevCollidedHorizontally = this.field_5976;
            boolean prevCollidedVertically = this.field_5992;
            this.method_5784(class_1313.field_6308, new class_243(detachedX ? -this.prevAttachedSides.field_1352 * 0.25 : 0.0, detachedY ? -this.prevAttachedSides.field_1351 * 0.25 : 0.0, detachedZ ? -this.prevAttachedSides.field_1350 * 0.25 : 0.0));
            class_243 axis = this.prevAttachedSides.method_1029();
            class_243 attachVector = upVector.method_1021(-1.0);
            attachVector = attachVector.method_1020(axis.method_1021(axis.method_1026(attachVector)));
            attachVector = Math.abs(attachVector.field_1352) > Math.abs(attachVector.field_1351) && Math.abs(attachVector.field_1352) > Math.abs(attachVector.field_1350) ? new class_243(Math.signum(attachVector.field_1352), 0.0, 0.0) : (Math.abs(attachVector.field_1351) > Math.abs(attachVector.field_1350) ? new class_243(0.0, Math.signum(attachVector.field_1351), 0.0) : new class_243(0.0, 0.0, Math.signum(attachVector.field_1350)));
            double attachDst = motion.method_1033() + (double)0.1f;
            class_238 aabb = this.method_5829();
            motion = this.method_18798();
            for (int i = 0; i < 2 && !this.method_24828(); ++i) {
                this.method_5784(class_1313.field_6308, attachVector.method_1021(attachDst));
            }
            if (!this.method_24828()) {
                this.method_5857(aabb);
                this.setLocationFromBoundingbox();
                this.method_18799(motion);
                this.method_24830(prevOnGround);
                this.field_5976 = prevCollidedHorizontally;
                this.field_5992 = prevCollidedVertically;
            } else {
                this.method_18799(class_243.field_1353);
            }
        }
        this.method_29242(true);
    }

    @Override
    public boolean onMove(class_1313 type, class_243 pos, boolean pre) {
        if (pre) {
            this.preWalkingPosition = this.method_19538();
            this.preMoveY = this.method_23318();
        } else {
            if (Math.abs(this.method_23318() - this.preMoveY - pos.field_1351) > 1.0E-6) {
                this.method_18799(this.method_18798().method_18805(1.0, 0.0, 1.0));
            }
            this.method_24830(this.field_5976 || this.field_5992);
        }
        return false;
    }

    @Override
    public class_2338 getAdjustedOnPosition(class_2338 onPosition) {
        float verticalOffset = this.getVerticalOffset(1.0f);
        int x = class_3532.method_15357((double)(this.method_23317() + this.attachmentOffsetX - (double)((float)this.attachmentNormal.field_1352 * (verticalOffset + 0.2f))));
        int y = class_3532.method_15357((double)(this.method_23318() + this.attachmentOffsetY - (double)((float)this.attachmentNormal.field_1351 * (verticalOffset + 0.2f))));
        int z = class_3532.method_15357((double)(this.method_23321() + this.attachmentOffsetZ - (double)((float)this.attachmentNormal.field_1350 * (verticalOffset + 0.2f))));
        class_2338 pos = new class_2338(x, y, z);
        if (this.method_37908().method_22347(pos) && this.attachmentNormal.field_1351 < 0.0) {
            class_2338 posDown = pos.method_10074();
            class_2680 stateDown = this.method_37908().method_8320(posDown);
            if (stateDown.method_26164(class_3481.field_16584) || stateDown.method_26164(class_3481.field_15504) || stateDown.method_26204() instanceof class_2349) {
                return posDown;
            }
        }
        return pos;
    }

    @Override
    public boolean getAdjustedCanTriggerWalking(boolean canTriggerWalking) {
        if (this.preWalkingPosition != null && this.canClimberTriggerWalking() && !this.method_5765()) {
            class_243 moved = this.method_19538().method_1020(this.preWalkingPosition);
            this.preWalkingPosition = null;
            class_2338 pos = this.method_23312();
            class_2680 state = this.method_37908().method_8320(pos);
            double dx = moved.field_1352;
            double dy = moved.field_1351;
            double dz = moved.field_1350;
            class_243 tangentialMovement = moved.method_1020(this.attachmentNormal.method_1021(this.attachmentNormal.method_1026(moved)));
            this.field_5994 = (float)((double)this.field_5994 + Math.sqrt(dx * dx + dy * dy + dz * dz) * 0.6);
            if (this.field_5994 > this.nextStepDistance && !state.method_26215()) {
                this.nextStepDistance = this.method_5867();
                if (this.method_5799()) {
                    ClimberEntityMixin controller = this.method_5782() && this.method_5642() != null ? this.method_5642() : this;
                    float multiplier = controller == this ? 0.35f : 0.4f;
                    class_243 motion = controller.method_18798();
                    float swimStrength = (float)Math.sqrt(motion.field_1352 * motion.field_1352 * (double)0.2f + motion.field_1351 * motion.field_1351 + motion.field_1350 * motion.field_1350 * (double)0.2f) * multiplier;
                    if (swimStrength > 1.0f) {
                        swimStrength = 1.0f;
                    }
                    this.method_5734(swimStrength);
                } else {
                    this.method_5712(pos, state);
                }
            } else if (state.method_26215()) {
                this.method_33573();
            }
        }
        return false;
    }

    @Override
    public boolean canClimberTriggerWalking() {
        return true;
    }

    public void setLocationFromBoundingbox() {
        class_238 axisalignedbb = this.method_5829();
        this.method_23327((axisalignedbb.field_1323 + axisalignedbb.field_1320) / 2.0, axisalignedbb.field_1322, (axisalignedbb.field_1321 + axisalignedbb.field_1324) / 2.0);
    }

    static {
        Class<?> cls = MethodHandles.lookup().lookupClass();
        ROTATION_BODY = class_2945.method_12791(cls, (class_2941)class_2943.field_13316);
        ROTATION_HEAD = class_2945.method_12791(cls, (class_2941)class_2943.field_13316);
    }
}

