/*
 * Decompiled with CFR 0.152.
 */
package win.demistorm.stormiespiders.client;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Axis;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.entity.state.LivingEntityRenderState;
import net.minecraft.core.Direction;
import net.minecraft.world.entity.LivingEntity;
import org.joml.Quaternionfc;
import win.demistorm.stormiespiders.common.entity.mob.IClimberEntity;
import win.demistorm.stormiespiders.common.entity.mob.Orientation;

public class ClientEventHandlers {
    private static final Map<Integer, ClimberRenderData> climberDataCache = new ConcurrentHashMap<Integer, ClimberRenderData>();
    private static int currentRenderingEntityId = -1;

    public static void storeClimberData(LivingEntity entity, IClimberEntity climber, float partialTicks) {
        Orientation renderOrientation = climber.calculateOrientation(partialTicks);
        climber.setRenderOrientation(renderOrientation);
        float verticalOffset = climber.getVerticalOffset(partialTicks);
        int entityId = entity.getId();
        climberDataCache.put(entityId, new ClimberRenderData(climber, partialTicks, renderOrientation, verticalOffset, climber.getOrientation()));
        currentRenderingEntityId = entityId;
    }

    public static void onPreRenderLivingFromState(LivingEntityRenderState renderState, PoseStack matrixStack) {
        ClimberRenderData data = climberDataCache.get(currentRenderingEntityId);
        if (data != null) {
            ClientEventHandlers.applyClimberTransformPre(data, matrixStack);
        }
    }

    public static void onPostRenderLivingFromState(LivingEntityRenderState renderState, PoseStack matrixStack, MultiBufferSource bufferIn) {
        ClimberRenderData data = climberDataCache.get(currentRenderingEntityId);
        if (data != null) {
            ClientEventHandlers.applyClimberTransformPost(data, matrixStack);
            climberDataCache.remove(currentRenderingEntityId);
        }
        currentRenderingEntityId = -1;
    }

    private static void applyClimberTransformPre(ClimberRenderData data, PoseStack matrixStack) {
        IClimberEntity climber = data.climber;
        Orientation renderOrientation = data.renderOrientation;
        float verticalOffset = data.verticalOffset;
        float partialTicks = data.partialTicks;
        float x = climber.getAttachmentOffset(Direction.Axis.X, partialTicks) - (float)renderOrientation.normal.x * verticalOffset;
        float y = climber.getAttachmentOffset(Direction.Axis.Y, partialTicks) - (float)renderOrientation.normal.y * verticalOffset;
        float z = climber.getAttachmentOffset(Direction.Axis.Z, partialTicks) - (float)renderOrientation.normal.z * verticalOffset;
        matrixStack.translate(x, y, z);
        matrixStack.mulPose((Quaternionfc)Axis.YP.rotationDegrees(renderOrientation.yaw));
        matrixStack.mulPose((Quaternionfc)Axis.XP.rotationDegrees(renderOrientation.pitch));
        matrixStack.mulPose((Quaternionfc)Axis.YP.rotationDegrees(Math.signum(0.5f - renderOrientation.componentY - renderOrientation.componentZ - renderOrientation.componentX) * renderOrientation.yaw));
    }

    private static void applyClimberTransformPost(ClimberRenderData data, PoseStack matrixStack) {
        Orientation orientation = data.currentOrientation;
        Orientation renderOrientation = data.renderOrientation;
        if (renderOrientation != null) {
            float verticalOffset = data.verticalOffset;
            float partialTicks = data.partialTicks;
            IClimberEntity climber = data.climber;
            float x = climber.getAttachmentOffset(Direction.Axis.X, partialTicks) - (float)renderOrientation.normal.x * verticalOffset;
            float y = climber.getAttachmentOffset(Direction.Axis.Y, partialTicks) - (float)renderOrientation.normal.y * verticalOffset;
            float z = climber.getAttachmentOffset(Direction.Axis.Z, partialTicks) - (float)renderOrientation.normal.z * verticalOffset;
            matrixStack.mulPose((Quaternionfc)Axis.YP.rotationDegrees(-Math.signum(0.5f - orientation.componentY - orientation.componentZ - orientation.componentX) * renderOrientation.yaw));
            matrixStack.mulPose((Quaternionfc)Axis.XP.rotationDegrees(-renderOrientation.pitch));
            matrixStack.mulPose((Quaternionfc)Axis.YP.rotationDegrees(-renderOrientation.yaw));
            matrixStack.translate(-x, -y, -z);
        }
    }

    private static class ClimberRenderData {
        final IClimberEntity climber;
        final float partialTicks;
        final Orientation renderOrientation;
        final float verticalOffset;
        final Orientation currentOrientation;

        ClimberRenderData(IClimberEntity climber, float partialTicks, Orientation renderOrientation, float verticalOffset, Orientation currentOrientation) {
            this.climber = climber;
            this.partialTicks = partialTicks;
            this.renderOrientation = renderOrientation;
            this.verticalOffset = verticalOffset;
            this.currentOrientation = currentOrientation;
        }
    }
}

