/*
 * Decompiled with CFR 0.152.
 */
package win.demistorm.stormiespiders.common.entity.movement;

import it.unimi.dsi.fastutil.longs.Long2LongMap;
import it.unimi.dsi.fastutil.longs.Long2LongOpenHashMap;
import it.unimi.dsi.fastutil.longs.Long2ObjectMap;
import it.unimi.dsi.fastutil.longs.Long2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.objects.Object2BooleanMap;
import it.unimi.dsi.fastutil.objects.Object2BooleanOpenHashMap;
import java.util.EnumSet;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.CollisionGetter;
import net.minecraft.world.level.PathNavigationRegion;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.level.pathfinder.Node;
import net.minecraft.world.level.pathfinder.PathComputationType;
import net.minecraft.world.level.pathfinder.PathType;
import net.minecraft.world.level.pathfinder.PathfindingContext;
import net.minecraft.world.level.pathfinder.WalkNodeEvaluator;
import net.minecraft.world.phys.AABB;
import org.jetbrains.annotations.Nullable;
import win.demistorm.stormiespiders.common.entity.movement.DirectionalPathPoint;
import win.demistorm.stormiespiders.common.entity.movement.IAdvancedPathFindingEntity;
import win.demistorm.stormiespiders.commonInit;

public class AdvancedWalkNodeProcessor
extends WalkNodeEvaluator {
    protected static final PathType[] PATH_NODE_TYPES = PathType.values();
    protected static final Direction[] DIRECTIONS = Direction.values();
    protected static final Vec3i PX = new Vec3i(1, 0, 0);
    protected static final Vec3i NX = new Vec3i(-1, 0, 0);
    protected static final Vec3i PY = new Vec3i(0, 1, 0);
    protected static final Vec3i NY = new Vec3i(0, -1, 0);
    protected static final Vec3i PZ = new Vec3i(0, 0, 1);
    protected static final Vec3i NZ = new Vec3i(0, 0, -1);
    protected static final Vec3i PXPY = new Vec3i(1, 1, 0);
    protected static final Vec3i NXPY = new Vec3i(-1, 1, 0);
    protected static final Vec3i PXNY = new Vec3i(1, -1, 0);
    protected static final Vec3i NXNY = new Vec3i(-1, -1, 0);
    protected static final Vec3i PXPZ = new Vec3i(1, 0, 1);
    protected static final Vec3i NXPZ = new Vec3i(-1, 0, 1);
    protected static final Vec3i PXNZ = new Vec3i(1, 0, -1);
    protected static final Vec3i NXNZ = new Vec3i(-1, 0, -1);
    protected static final Vec3i PYPZ = new Vec3i(0, 1, 1);
    protected static final Vec3i NYPZ = new Vec3i(0, -1, 1);
    protected static final Vec3i PYNZ = new Vec3i(0, 1, -1);
    protected static final Vec3i NYNZ = new Vec3i(0, -1, -1);
    protected IAdvancedPathFindingEntity advancedPathFindingEntity;
    protected boolean startFromGround = true;
    protected boolean checkObstructions;
    protected int pathingSizeOffsetX;
    protected int pathingSizeOffsetY;
    protected int pathingSizeOffsetZ;
    protected EnumSet<Direction> pathableFacings = EnumSet.of(Direction.DOWN);
    protected Direction[] pathableFacingsArray;
    private final Long2LongMap pathNodeTypeCache = new Long2LongOpenHashMap();
    private final Long2ObjectMap<PathType> rawPathNodeTypeCache = new Long2ObjectOpenHashMap();
    private BlockGetter cachedLevel;
    private final Object2BooleanMap<AABB> aabbCollisionCache = new Object2BooleanOpenHashMap();
    protected boolean alwaysAllowDiagonals = true;

    public void setStartPathOnGround(boolean startFromGround) {
        this.startFromGround = startFromGround;
    }

    public void setCheckObstructions(boolean checkObstructions) {
        this.checkObstructions = checkObstructions;
    }

    public void setCanPathWalls(boolean canPathWalls) {
        if (canPathWalls) {
            this.pathableFacings.add(Direction.NORTH);
            this.pathableFacings.add(Direction.EAST);
            this.pathableFacings.add(Direction.SOUTH);
            this.pathableFacings.add(Direction.WEST);
        } else {
            this.pathableFacings.remove(Direction.NORTH);
            this.pathableFacings.remove(Direction.EAST);
            this.pathableFacings.remove(Direction.SOUTH);
            this.pathableFacings.remove(Direction.WEST);
        }
    }

    public void setCanPathCeiling(boolean canPathCeiling) {
        if (canPathCeiling) {
            this.pathableFacings.add(Direction.UP);
        } else {
            this.pathableFacings.remove(Direction.UP);
        }
    }

    public void prepare(PathNavigationRegion sourceIn, Mob mob) {
        super.prepare(sourceIn, mob);
        this.cachedLevel = sourceIn;
        if (!(mob instanceof IAdvancedPathFindingEntity)) {
            throw new IllegalArgumentException("Only mobs that extend " + IAdvancedPathFindingEntity.class.getSimpleName() + " are supported. Received: " + mob.getClass().getName());
        }
        this.advancedPathFindingEntity = (IAdvancedPathFindingEntity)mob;
        this.pathingSizeOffsetX = Math.max(1, Mth.floor((float)(this.mob.getBbWidth() / 2.0f + 1.0f)));
        this.pathingSizeOffsetY = Math.max(1, Mth.floor((float)(this.mob.getBbHeight() + 1.0f)));
        this.pathingSizeOffsetZ = Math.max(1, Mth.floor((float)(this.mob.getBbWidth() / 2.0f + 1.0f)));
        this.pathableFacingsArray = this.pathableFacings.toArray(new Direction[0]);
    }

    public void done() {
        super.done();
        this.pathNodeTypeCache.clear();
        this.rawPathNodeTypeCache.clear();
        this.aabbCollisionCache.clear();
        this.advancedPathFindingEntity.pathFinderCleanup();
    }

    private boolean checkAabbCollision(AABB aabb) {
        return this.aabbCollisionCache.computeIfAbsent((Object)aabb, p_237237_2_ -> !this.mob.level().noCollision((Entity)this.mob, aabb));
    }

    public Node getStart() {
        BlockPos initialStartPos;
        int by;
        BlockPos.MutableBlockPos checkPos;
        double z;
        double x;
        block12: {
            x = this.mob.getX();
            double y = this.mob.getY();
            z = this.mob.getZ();
            checkPos = new BlockPos.MutableBlockPos();
            by = Mth.floor((double)y);
            BlockState state = this.cachedLevel.getBlockState((BlockPos)checkPos.set(x, (double)by, z));
            if (!this.mob.canStandOnFluid(state.getFluidState())) {
                if (this.canFloat() && this.mob.isInWater()) {
                    while (true) {
                        if (state.getBlock() != Blocks.WATER && state.getFluidState() != Fluids.WATER.getSource(false)) {
                            --by;
                            break block12;
                        }
                        state = this.cachedLevel.getBlockState((BlockPos)checkPos.set(x, (double)(++by), z));
                    }
                }
                if (this.mob.onGround() || !this.startFromGround) {
                    by = Mth.floor((double)(y + Math.min(0.5, Math.max((double)(this.mob.getBbHeight() - 0.1f), 0.0))));
                } else {
                    BlockPos blockpos = this.mob.blockPosition();
                    while ((this.cachedLevel.getBlockState(blockpos).isAir() || this.cachedLevel.getBlockState(blockpos).isPathfindable(PathComputationType.LAND)) && blockpos.getY() > 0) {
                        blockpos = blockpos.below();
                    }
                    by = blockpos.above().getY();
                }
            } else {
                while (this.mob.canStandOnFluid(state.getFluidState())) {
                    state = this.cachedLevel.getBlockState((BlockPos)checkPos.set(x, (double)(++by), z));
                }
                --by;
            }
        }
        BlockPos startPos = initialStartPos = commonInit.blockPos(x, by, z);
        long packed = this.removeNonStartingSides(this.getDirectionalPathNodeTypeCached(this.mob, startPos.getX(), startPos.getY(), startPos.getZ()));
        DirectionalPathPoint startPathPoint = this.openPoint(startPos.getX(), startPos.getY(), startPos.getZ(), packed, false);
        startPathPoint.type = AdvancedWalkNodeProcessor.unpackNodeType(packed);
        startPathPoint.costMalus = this.mob.getPathfindingMalus(startPathPoint.type);
        startPos = this.findSuitableStartingPosition(startPos, startPathPoint);
        if (!initialStartPos.equals((Object)startPos)) {
            packed = this.removeNonStartingSides(this.getDirectionalPathNodeTypeCached(this.mob, startPos.getX(), startPos.getY(), startPos.getZ()));
            startPathPoint = this.openPoint(startPos.getX(), startPos.getY(), startPos.getZ(), packed, false);
            startPathPoint.type = AdvancedWalkNodeProcessor.unpackNodeType(packed);
            startPathPoint.costMalus = this.mob.getPathfindingMalus(startPathPoint.type);
        }
        if (this.mob.getPathfindingMalus(startPathPoint.type) < 0.0f) {
            AABB aabb = this.mob.getBoundingBox();
            if (this.isSafeStartingPosition((BlockPos)checkPos.set(aabb.minX, (double)by, aabb.minZ)) || this.isSafeStartingPosition((BlockPos)checkPos.set(aabb.minX, (double)by, aabb.maxZ)) || this.isSafeStartingPosition((BlockPos)checkPos.set(aabb.maxX, (double)by, aabb.minZ)) || this.isSafeStartingPosition((BlockPos)checkPos.set(aabb.maxX, (double)by, aabb.maxZ))) {
                packed = this.removeNonStartingSides(this.getDirectionalPathNodeTypeCached(this.mob, checkPos.getX(), checkPos.getY(), checkPos.getZ()));
                startPathPoint = this.openPoint(checkPos.getX(), checkPos.getY(), checkPos.getZ(), packed, false);
                startPathPoint.type = AdvancedWalkNodeProcessor.unpackNodeType(packed);
                startPathPoint.costMalus = this.mob.getPathfindingMalus(startPathPoint.type);
            }
        }
        return startPathPoint;
    }

    private long removeNonStartingSides(long packed) {
        long newPacked = packed & 0xFFFFFFFF00000000L;
        for (Direction side : DIRECTIONS) {
            if (!AdvancedWalkNodeProcessor.unpackDirection(side, packed) || !this.isValidStartingSide(side)) continue;
            newPacked = AdvancedWalkNodeProcessor.packDirection(side, newPacked);
        }
        return newPacked;
    }

    protected boolean isValidStartingSide(Direction side) {
        Direction groundSide = this.advancedPathFindingEntity.getGroundSide();
        return side == groundSide || side.getAxis() != groundSide.getAxis();
    }

    protected BlockPos findSuitableStartingPosition(BlockPos pos, DirectionalPathPoint startPathPoint) {
        if (startPathPoint.getPathableSides().length == 0) {
            Direction avoidedOffset = this.advancedPathFindingEntity.getGroundSide().getOpposite();
            for (int xo = -1; xo <= 1; ++xo) {
                for (int yo = -1; yo <= 1; ++yo) {
                    for (int zo = -1; zo <= 1; ++zo) {
                        BlockPos offsetPos;
                        long packed;
                        PathType nodeType;
                        if (xo == avoidedOffset.getStepX() || yo == avoidedOffset.getStepY() || zo == avoidedOffset.getStepZ() || (nodeType = AdvancedWalkNodeProcessor.unpackNodeType(packed = this.getDirectionalPathNodeTypeCached(this.mob, (offsetPos = pos.offset(xo, yo, zo)).getX(), offsetPos.getY(), offsetPos.getZ()))) != PathType.WALKABLE || !AdvancedWalkNodeProcessor.unpackDirection(packed)) continue;
                        return offsetPos;
                    }
                }
            }
        }
        return pos;
    }

    private boolean isSafeStartingPosition(BlockPos pos) {
        PathType pathnodetype = AdvancedWalkNodeProcessor.unpackNodeType(this.getDirectionalPathNodeTypeCached(this.mob, pos.getX(), pos.getY(), pos.getZ()));
        return this.mob.getPathfindingMalus(pathnodetype) >= 0.0f;
    }

    private boolean allowDiagonalPathOptions(Node[] options) {
        return this.alwaysAllowDiagonals || options == null || options.length == 0 || (options[0] == null || options[0].type == PathType.OPEN || options[0].costMalus != 0.0f) && (options.length <= 1 || options[1] == null || options[1].type == PathType.OPEN || options[1].costMalus != 0.0f);
    }

    public int getNeighbors(Node[] pathOptions, Node currentPointIn) {
        int k;
        int k2;
        boolean foundDiagonal;
        boolean is3DPathing;
        int k3;
        DirectionalPathPoint currentPoint = currentPointIn instanceof DirectionalPathPoint ? (DirectionalPathPoint)currentPointIn : new DirectionalPathPoint(currentPointIn);
        int openedNodeCount = 0;
        int stepHeight = 0;
        PathType nodeTypeAbove = AdvancedWalkNodeProcessor.unpackNodeType(this.getDirectionalPathNodeTypeCached(this.mob, currentPoint.x, currentPoint.y + 1, currentPoint.z));
        if (this.mob.getPathfindingMalus(nodeTypeAbove) >= 0.0f) {
            stepHeight = Mth.floor((float)Math.max(1.0f, this.mob.maxUpStep()));
        }
        double height = (double)currentPoint.y - AdvancedWalkNodeProcessor.getFloorLevel((BlockGetter)this.cachedLevel, (BlockPos)new BlockPos(currentPoint.x, currentPoint.y, currentPoint.z));
        Node[] pathsPZ = this.getSafePoints(currentPoint.x, currentPoint.y, currentPoint.z + 1, stepHeight, height, PZ, this.checkObstructions);
        Node[] pathsNX = this.getSafePoints(currentPoint.x - 1, currentPoint.y, currentPoint.z, stepHeight, height, NX, this.checkObstructions);
        Node[] pathsPX = this.getSafePoints(currentPoint.x + 1, currentPoint.y, currentPoint.z, stepHeight, height, PX, this.checkObstructions);
        Node[] pathsNZ = this.getSafePoints(currentPoint.x, currentPoint.y, currentPoint.z - 1, stepHeight, height, NZ, this.checkObstructions);
        for (k3 = 0; k3 < pathsPZ.length; ++k3) {
            if (!this.isSuitablePoint(pathsPZ[k3], currentPoint, this.checkObstructions)) continue;
            pathOptions[openedNodeCount++] = pathsPZ[k3];
        }
        for (k3 = 0; k3 < pathsNX.length; ++k3) {
            if (!this.isSuitablePoint(pathsNX[k3], currentPoint, this.checkObstructions)) continue;
            pathOptions[openedNodeCount++] = pathsNX[k3];
        }
        for (k3 = 0; k3 < pathsPX.length; ++k3) {
            if (!this.isSuitablePoint(pathsPX[k3], currentPoint, this.checkObstructions)) continue;
            pathOptions[openedNodeCount++] = pathsPX[k3];
        }
        for (k3 = 0; k3 < pathsNZ.length; ++k3) {
            if (!this.isSuitablePoint(pathsNZ[k3], currentPoint, this.checkObstructions)) continue;
            pathOptions[openedNodeCount++] = pathsNZ[k3];
        }
        Node[] pathsNY = null;
        if (this.checkObstructions || this.pathableFacings.size() > 1) {
            pathsNY = this.getSafePoints(currentPoint.x, currentPoint.y - 1, currentPoint.z, stepHeight, height, NY, this.checkObstructions);
            for (int k4 = 0; k4 < pathsNY.length; ++k4) {
                if (!this.isSuitablePoint(pathsNY[k4], currentPoint, this.checkObstructions)) continue;
                pathOptions[openedNodeCount++] = pathsNY[k4];
            }
        }
        Node[] pathsPY = null;
        if (this.pathableFacings.size() > 1) {
            pathsPY = this.getSafePoints(currentPoint.x, currentPoint.y + 1, currentPoint.z, stepHeight, height, PY, this.checkObstructions);
            for (int k5 = 0; k5 < pathsPY.length; ++k5) {
                if (!this.isSuitablePoint(pathsPY[k5], currentPoint, this.checkObstructions)) continue;
                pathOptions[openedNodeCount++] = pathsPY[k5];
            }
        }
        boolean allowDiagonalNZ = this.allowDiagonalPathOptions(pathsNZ);
        boolean allowDiagonalPZ = this.allowDiagonalPathOptions(pathsPZ);
        boolean allowDiagonalPX = this.allowDiagonalPathOptions(pathsPX);
        boolean allowDiagonalNX = this.allowDiagonalPathOptions(pathsNX);
        boolean fitsThroughPoles = this.mob.getBbWidth() < 0.5f;
        boolean bl = is3DPathing = this.pathableFacings.size() >= 3;
        if (allowDiagonalNZ && allowDiagonalNX) {
            DirectionalPathPoint[] pathsNXNZ = this.getSafePoints(currentPoint.x - this.entityWidth, currentPoint.y, currentPoint.z - 1, stepHeight, height, NXNZ, this.checkObstructions);
            foundDiagonal = false;
            for (k2 = 0; k2 < pathsNXNZ.length; ++k2) {
                if (!this.isSuitablePoint((DirectionalPathPoint[])pathsNX, currentPoint.x - 1, currentPoint.y, currentPoint.z, (DirectionalPathPoint[])pathsNZ, currentPoint.x, currentPoint.y, currentPoint.z - 1, pathsNXNZ[k2], currentPoint, this.checkObstructions, fitsThroughPoles, is3DPathing)) continue;
                pathOptions[openedNodeCount++] = pathsNXNZ[k2];
                foundDiagonal = true;
            }
            if (!(foundDiagonal || this.entityWidth == 1 && this.entityDepth == 1)) {
                pathsNXNZ = this.getSafePoints(currentPoint.x - 1, currentPoint.y, currentPoint.z - this.entityDepth, stepHeight, height, NXNZ, this.checkObstructions);
                for (k2 = 0; k2 < pathsNXNZ.length; ++k2) {
                    if (!this.isSuitablePoint((DirectionalPathPoint[])pathsNX, currentPoint.x - 1, currentPoint.y, currentPoint.z, (DirectionalPathPoint[])pathsNZ, currentPoint.x, currentPoint.y, currentPoint.z - 1, pathsNXNZ[k2], currentPoint, this.checkObstructions, fitsThroughPoles, is3DPathing)) continue;
                    pathOptions[openedNodeCount++] = pathsNXNZ[k2];
                }
            }
        }
        if (allowDiagonalNZ && allowDiagonalPX) {
            DirectionalPathPoint[] pathsPXNZ = this.getSafePoints(currentPoint.x + 1, currentPoint.y, currentPoint.z - 1, stepHeight, height, PXNZ, this.checkObstructions);
            for (k = 0; k < pathsPXNZ.length; ++k) {
                if (!this.isSuitablePoint((DirectionalPathPoint[])pathsPX, currentPoint.x + 1, currentPoint.y, currentPoint.z, (DirectionalPathPoint[])pathsNZ, currentPoint.x, currentPoint.y, currentPoint.z - 1, pathsPXNZ[k], currentPoint, this.checkObstructions, fitsThroughPoles, is3DPathing)) continue;
                pathOptions[openedNodeCount++] = pathsPXNZ[k];
            }
        }
        if (allowDiagonalPZ && allowDiagonalNX) {
            DirectionalPathPoint[] pathsNXPZ = this.getSafePoints(currentPoint.x - 1, currentPoint.y, currentPoint.z + 1, stepHeight, height, NXPZ, this.checkObstructions);
            for (k = 0; k < pathsNXPZ.length; ++k) {
                if (!this.isSuitablePoint((DirectionalPathPoint[])pathsNX, currentPoint.x - 1, currentPoint.y, currentPoint.z, (DirectionalPathPoint[])pathsPZ, currentPoint.x, currentPoint.y, currentPoint.z + 1, pathsNXPZ[k], currentPoint, this.checkObstructions, fitsThroughPoles, is3DPathing)) continue;
                pathOptions[openedNodeCount++] = pathsNXPZ[k];
            }
        }
        if (allowDiagonalPZ && allowDiagonalPX) {
            DirectionalPathPoint[] pathsPXPZ = this.getSafePoints(currentPoint.x + this.entityWidth, currentPoint.y, currentPoint.z + 1, stepHeight, height, PXPZ, this.checkObstructions);
            foundDiagonal = false;
            for (k2 = 0; k2 < pathsPXPZ.length; ++k2) {
                if (!this.isSuitablePoint((DirectionalPathPoint[])pathsPX, currentPoint.x + 1, currentPoint.y, currentPoint.z, (DirectionalPathPoint[])pathsPZ, currentPoint.x, currentPoint.y, currentPoint.z + 1, pathsPXPZ[k2], currentPoint, this.checkObstructions, fitsThroughPoles, is3DPathing)) continue;
                pathOptions[openedNodeCount++] = pathsPXPZ[k2];
                foundDiagonal = true;
            }
            if (!(foundDiagonal || this.entityWidth == 1 && this.entityDepth == 1)) {
                pathsPXPZ = this.getSafePoints(currentPoint.x + 1, currentPoint.y, currentPoint.z + this.entityDepth, stepHeight, height, PXPZ, this.checkObstructions);
                for (k2 = 0; k2 < pathsPXPZ.length; ++k2) {
                    if (!this.isSuitablePoint((DirectionalPathPoint[])pathsPX, currentPoint.x + 1, currentPoint.y, currentPoint.z, (DirectionalPathPoint[])pathsPZ, currentPoint.x, currentPoint.y, currentPoint.z + 1, pathsPXPZ[k2], currentPoint, this.checkObstructions, fitsThroughPoles, is3DPathing)) continue;
                    pathOptions[openedNodeCount++] = pathsPXPZ[k2];
                }
            }
        }
        if (this.pathableFacings.size() > 1) {
            int k6;
            int k7;
            boolean foundDiagonal2;
            boolean allowDiagonalPY = this.allowDiagonalPathOptions(pathsPY);
            boolean allowDiagonalNY = this.allowDiagonalPathOptions(pathsNY);
            if (allowDiagonalNY && allowDiagonalNX) {
                DirectionalPathPoint[] pathsNYNX = this.getSafePoints(currentPoint.x - this.entityWidth, currentPoint.y - 1, currentPoint.z, stepHeight, height, NXNY, this.checkObstructions);
                foundDiagonal2 = false;
                for (k7 = 0; k7 < pathsNYNX.length; ++k7) {
                    if (!this.isSuitablePoint((DirectionalPathPoint[])pathsNY, currentPoint.x, currentPoint.y - 1, currentPoint.z, (DirectionalPathPoint[])pathsNX, currentPoint.x - 1, currentPoint.y, currentPoint.z, pathsNYNX[k7], currentPoint, this.checkObstructions, fitsThroughPoles, is3DPathing)) continue;
                    pathOptions[openedNodeCount++] = pathsNYNX[k7];
                    foundDiagonal2 = true;
                }
                if (!(foundDiagonal2 || this.entityWidth == 1 && this.entityHeight == 1)) {
                    pathsNYNX = this.getSafePoints(currentPoint.x - 1, currentPoint.y - this.entityHeight, currentPoint.z, stepHeight, height, NXNY, this.checkObstructions);
                    for (k7 = 0; k7 < pathsNYNX.length; ++k7) {
                        if (!this.isSuitablePoint((DirectionalPathPoint[])pathsNY, currentPoint.x, currentPoint.y - 1, currentPoint.z, (DirectionalPathPoint[])pathsNX, currentPoint.x - 1, currentPoint.y, currentPoint.z, pathsNYNX[k7], currentPoint, this.checkObstructions, fitsThroughPoles, is3DPathing)) continue;
                        pathOptions[openedNodeCount++] = pathsNYNX[k7];
                    }
                }
            }
            if (allowDiagonalNY && allowDiagonalPX) {
                DirectionalPathPoint[] pathsNYPX = this.getSafePoints(currentPoint.x + 1, currentPoint.y - 1, currentPoint.z, stepHeight, height, PXNY, this.checkObstructions);
                for (k6 = 0; k6 < pathsNYPX.length; ++k6) {
                    if (!this.isSuitablePoint((DirectionalPathPoint[])pathsNY, currentPoint.x, currentPoint.y - 1, currentPoint.z, (DirectionalPathPoint[])pathsPX, currentPoint.x + 1, currentPoint.y, currentPoint.z, pathsNYPX[k6], currentPoint, this.checkObstructions, fitsThroughPoles, is3DPathing)) continue;
                    pathOptions[openedNodeCount++] = pathsNYPX[k6];
                }
            }
            if (allowDiagonalNY && allowDiagonalNZ) {
                DirectionalPathPoint[] pathsNYNZ = this.getSafePoints(currentPoint.x, currentPoint.y - this.entityHeight, currentPoint.z - 1, stepHeight, height, NYNZ, this.checkObstructions);
                foundDiagonal2 = false;
                for (k7 = 0; k7 < pathsNYNZ.length; ++k7) {
                    if (!this.isSuitablePoint((DirectionalPathPoint[])pathsNY, currentPoint.x, currentPoint.y - 1, currentPoint.z, (DirectionalPathPoint[])pathsNZ, currentPoint.x, currentPoint.y, currentPoint.z - 1, pathsNYNZ[k7], currentPoint, this.checkObstructions, fitsThroughPoles, is3DPathing)) continue;
                    pathOptions[openedNodeCount++] = pathsNYNZ[k7];
                    foundDiagonal2 = true;
                }
                if (!(foundDiagonal2 || this.entityHeight == 1 && this.entityDepth == 1)) {
                    pathsNYNZ = this.getSafePoints(currentPoint.x, currentPoint.y - 1, currentPoint.z - this.entityDepth, stepHeight, height, NYNZ, this.checkObstructions);
                    for (k7 = 0; k7 < pathsNYNZ.length; ++k7) {
                        if (!this.isSuitablePoint((DirectionalPathPoint[])pathsNY, currentPoint.x, currentPoint.y - 1, currentPoint.z, (DirectionalPathPoint[])pathsNZ, currentPoint.x, currentPoint.y, currentPoint.z - 1, pathsNYNZ[k7], currentPoint, this.checkObstructions, fitsThroughPoles, is3DPathing)) continue;
                        pathOptions[openedNodeCount++] = pathsNYNZ[k7];
                    }
                }
            }
            if (allowDiagonalNY && allowDiagonalPZ) {
                DirectionalPathPoint[] pathsNYPZ = this.getSafePoints(currentPoint.x, currentPoint.y - 1, currentPoint.z + 1, stepHeight, height, NYPZ, this.checkObstructions);
                for (k6 = 0; k6 < pathsNYPZ.length; ++k6) {
                    if (!this.isSuitablePoint((DirectionalPathPoint[])pathsNY, currentPoint.x, currentPoint.y - 1, currentPoint.z, (DirectionalPathPoint[])pathsPZ, currentPoint.x, currentPoint.y, currentPoint.z + 1, pathsNYPZ[k6], currentPoint, this.checkObstructions, fitsThroughPoles, is3DPathing)) continue;
                    pathOptions[openedNodeCount++] = pathsNYPZ[k6];
                }
            }
            if (allowDiagonalPY && allowDiagonalNX) {
                DirectionalPathPoint[] pathsPYNX = this.getSafePoints(currentPoint.x - 1, currentPoint.y + 1, currentPoint.z, stepHeight, height, NXPY, this.checkObstructions);
                for (k6 = 0; k6 < pathsPYNX.length; ++k6) {
                    if (!this.isSuitablePoint((DirectionalPathPoint[])pathsPY, currentPoint.x, currentPoint.y + 1, currentPoint.z, (DirectionalPathPoint[])pathsNZ, currentPoint.x - 1, currentPoint.y, currentPoint.z, pathsPYNX[k6], currentPoint, this.checkObstructions, fitsThroughPoles, is3DPathing)) continue;
                    pathOptions[openedNodeCount++] = pathsPYNX[k6];
                }
            }
            if (allowDiagonalPY && allowDiagonalPX) {
                DirectionalPathPoint[] pathsPYPX = this.getSafePoints(currentPoint.x + this.entityWidth, currentPoint.y + 1, currentPoint.z, stepHeight, height, PXPY, this.checkObstructions);
                foundDiagonal2 = false;
                for (k7 = 0; k7 < pathsPYPX.length; ++k7) {
                    if (!this.isSuitablePoint((DirectionalPathPoint[])pathsPY, currentPoint.x, currentPoint.y + 1, currentPoint.z, (DirectionalPathPoint[])pathsPX, currentPoint.x + 1, currentPoint.y, currentPoint.z, pathsPYPX[k7], currentPoint, this.checkObstructions, fitsThroughPoles, is3DPathing)) continue;
                    pathOptions[openedNodeCount++] = pathsPYPX[k7];
                    foundDiagonal2 = true;
                }
                if (!(foundDiagonal2 || this.entityWidth == 1 && this.entityHeight == 1)) {
                    pathsPYPX = this.getSafePoints(currentPoint.x + 1, currentPoint.y + this.entityHeight, currentPoint.z, stepHeight, height, PXPY, this.checkObstructions);
                    for (k7 = 0; k7 < pathsPYPX.length; ++k7) {
                        if (!this.isSuitablePoint((DirectionalPathPoint[])pathsPY, currentPoint.x, currentPoint.y + 1, currentPoint.z, (DirectionalPathPoint[])pathsPX, currentPoint.x + 1, currentPoint.y, currentPoint.z, pathsPYPX[k7], currentPoint, this.checkObstructions, fitsThroughPoles, is3DPathing)) continue;
                        pathOptions[openedNodeCount++] = pathsPYPX[k7];
                    }
                }
            }
            if (allowDiagonalPY && allowDiagonalNZ) {
                DirectionalPathPoint[] pathsPYNZ = this.getSafePoints(currentPoint.x, currentPoint.y + 1, currentPoint.z - 1, stepHeight, height, PYNZ, this.checkObstructions);
                for (k6 = 0; k6 < pathsPYNZ.length; ++k6) {
                    if (!this.isSuitablePoint((DirectionalPathPoint[])pathsPY, currentPoint.x, currentPoint.y + 1, currentPoint.z, (DirectionalPathPoint[])pathsNZ, currentPoint.x, currentPoint.y, currentPoint.z - 1, pathsPYNZ[k6], currentPoint, this.checkObstructions, fitsThroughPoles, is3DPathing)) continue;
                    pathOptions[openedNodeCount++] = pathsPYNZ[k6];
                }
            }
            if (allowDiagonalPY && allowDiagonalPZ) {
                DirectionalPathPoint[] pathsPYPZ = this.getSafePoints(currentPoint.x, currentPoint.y + this.entityHeight, currentPoint.z + 1, stepHeight, height, PYPZ, this.checkObstructions);
                foundDiagonal2 = false;
                for (k7 = 0; k7 < pathsPYPZ.length; ++k7) {
                    if (!this.isSuitablePoint((DirectionalPathPoint[])pathsPY, currentPoint.x, currentPoint.y + 1, currentPoint.z, (DirectionalPathPoint[])pathsPZ, currentPoint.x, currentPoint.y, currentPoint.z + 1, pathsPYPZ[k7], currentPoint, this.checkObstructions, fitsThroughPoles, is3DPathing)) continue;
                    pathOptions[openedNodeCount++] = pathsPYPZ[k7];
                    foundDiagonal2 = true;
                }
                if (!(foundDiagonal2 || this.entityHeight == 1 && this.entityDepth == 1)) {
                    pathsPYPZ = this.getSafePoints(currentPoint.x, currentPoint.y + 1, currentPoint.z + this.entityDepth, stepHeight, height, PYPZ, this.checkObstructions);
                    for (k7 = 0; k7 < pathsPYPZ.length; ++k7) {
                        if (!this.isSuitablePoint((DirectionalPathPoint[])pathsPY, currentPoint.x, currentPoint.y + 1, currentPoint.z, (DirectionalPathPoint[])pathsPZ, currentPoint.x, currentPoint.y, currentPoint.z + 1, pathsPYPZ[k7], currentPoint, this.checkObstructions, fitsThroughPoles, is3DPathing)) continue;
                        pathOptions[openedNodeCount++] = pathsPYPZ[k7];
                    }
                }
            }
        }
        return openedNodeCount;
    }

    protected boolean isTraversible(DirectionalPathPoint from, DirectionalPathPoint to) {
        if (this.canFloat() && (from.type == PathType.WATER || from.type == PathType.WATER_BORDER || from.type == PathType.LAVA || to.type == PathType.WATER || to.type == PathType.WATER_BORDER || to.type == PathType.LAVA)) {
            return true;
        }
        boolean dx = to.x - from.x != 0;
        boolean dy = to.y - from.y != 0;
        boolean dz = to.z - from.z != 0;
        boolean isDiagonal = (dx ? 1 : 0) + (dy ? 1 : 0) + (dz ? 1 : 0) > 1;
        Direction[] fromDirections = from.getPathableSides();
        Direction[] toDirections = to.getPathableSides();
        for (int i = 0; i < fromDirections.length; ++i) {
            Direction d1 = fromDirections[i];
            for (int j = 0; j < toDirections.length; ++j) {
                Direction d2 = toDirections[j];
                if (d1 == d2) {
                    return true;
                }
                if (!isDiagonal) continue;
                Direction.Axis a1 = d1.getAxis();
                Direction.Axis a2 = d2.getAxis();
                if (a1 == Direction.Axis.X && a2 == Direction.Axis.Y || a1 == Direction.Axis.Y && a2 == Direction.Axis.X) {
                    return !dz;
                }
                if (a1 == Direction.Axis.X && a2 == Direction.Axis.Z || a1 == Direction.Axis.Z && a2 == Direction.Axis.X) {
                    return !dy;
                }
                if ((a1 != Direction.Axis.Z || a2 != Direction.Axis.Y) && (a1 != Direction.Axis.Y || a2 != Direction.Axis.Z)) continue;
                return !dx;
            }
        }
        return false;
    }

    protected static boolean isSharingDirection(DirectionalPathPoint from, DirectionalPathPoint to) {
        Direction[] fromDirections = from.getPathableSides();
        Direction[] toDirections = to.getPathableSides();
        for (int i = 0; i < fromDirections.length; ++i) {
            Direction d1 = fromDirections[i];
            for (int j = 0; j < toDirections.length; ++j) {
                Direction d2 = toDirections[j];
                if (d1 != d2) continue;
                return true;
            }
        }
        return false;
    }

    protected boolean isSuitablePoint(@Nullable DirectionalPathPoint newPoint, DirectionalPathPoint currentPoint, boolean allowObstructions) {
        return newPoint != null && !newPoint.closed && (allowObstructions || newPoint.costMalus >= 0.0f || currentPoint.costMalus < 0.0f) && this.isTraversible(currentPoint, newPoint);
    }

    protected boolean isSuitablePoint(@Nullable DirectionalPathPoint[] newPoints1, int np1x, int np1y, int np1z, @Nullable DirectionalPathPoint[] newPoints2, int np2x, int np2y, int np2z, @Nullable DirectionalPathPoint newPointDiagonal, DirectionalPathPoint currentPoint, boolean allowObstructions, boolean fitsThroughPoles, boolean is3DPathing) {
        if (!is3DPathing) {
            if (!(newPointDiagonal == null || newPointDiagonal.closed || newPoints2 == null || newPoints2.length <= 0 || newPoints2[0] == null && (newPoints2.length <= 1 || newPoints2[1] == null) || newPoints1 == null || newPoints1.length <= 0 || newPoints1[0] == null && (newPoints1.length <= 1 || newPoints1[1] == null) || newPoints1[0] != null && newPoints1[0].type == PathType.WALKABLE_DOOR || newPoints2[0] != null && newPoints2[0].type == PathType.WALKABLE_DOOR || newPointDiagonal.type == PathType.WALKABLE_DOOR)) {
                boolean canPassPoleDiagonally = newPoints2[0] != null && newPoints2[0].type == PathType.FENCE && newPoints1[0] != null && newPoints1[0].type == PathType.FENCE && fitsThroughPoles;
                return (allowObstructions || newPointDiagonal.costMalus >= 0.0f) && (canPassPoleDiagonally || (newPoints2[0] != null && (allowObstructions || newPoints2[0].costMalus >= 0.0f) || newPoints2.length > 1 && newPoints2[1] != null && (allowObstructions || newPoints2[1].costMalus >= 0.0f)) && (newPoints1[0] != null && (allowObstructions || newPoints1[0].costMalus >= 0.0f) || newPoints1.length > 1 && newPoints1[1] != null && (allowObstructions || newPoints1[1].costMalus >= 0.0f)));
            }
        } else if (newPointDiagonal != null && !newPointDiagonal.closed && this.isTraversible(currentPoint, newPointDiagonal)) {
            long packed2 = this.getDirectionalPathNodeTypeCached(this.mob, np2x, np2y, np2z);
            PathType pathNodeType2 = AdvancedWalkNodeProcessor.unpackNodeType(packed2);
            boolean open2 = pathNodeType2 == PathType.OPEN || pathNodeType2 == PathType.WALKABLE;
            long packed1 = this.getDirectionalPathNodeTypeCached(this.mob, np1x, np1y, np1z);
            PathType pathNodeType1 = AdvancedWalkNodeProcessor.unpackNodeType(packed1);
            boolean open1 = pathNodeType1 == PathType.OPEN || pathNodeType1 == PathType.WALKABLE;
            return open1 != open2 || open1 && open2 && AdvancedWalkNodeProcessor.isSharingDirection(newPointDiagonal, currentPoint);
        }
        return false;
    }

    protected DirectionalPathPoint openPoint(int x, int y, int z, long packed, boolean isDrop) {
        int hash = Node.createHash((int)x, (int)y, (int)z);
        Node point = (Node)this.nodes.computeIfAbsent(hash, key -> new DirectionalPathPoint(x, y, z, packed, isDrop));
        if (!(point instanceof DirectionalPathPoint)) {
            point = new DirectionalPathPoint(point);
            this.nodes.put(hash, (Object)point);
        }
        return (DirectionalPathPoint)point;
    }

    @Nullable
    private DirectionalPathPoint[] getSafePoints(int x, int y, int z, int stepHeight, double height, Vec3i direction, boolean allowBlocked) {
        long initialPacked;
        DirectionalPathPoint directPathPoint = null;
        BlockPos pos = new BlockPos(x, y, z);
        double blockHeight = (double)y - AdvancedWalkNodeProcessor.getFloorLevel((BlockGetter)this.cachedLevel, (BlockPos)new BlockPos(x, y, z));
        if (blockHeight - height > 1.125) {
            return new DirectionalPathPoint[0];
        }
        long packed = initialPacked = this.getDirectionalPathNodeTypeCached(this.mob, x, y, z);
        PathType nodeType = AdvancedWalkNodeProcessor.unpackNodeType(packed);
        float malus = this.advancedPathFindingEntity.getPathingMalus(this.cachedLevel, this.mob, nodeType, pos, direction, dir -> AdvancedWalkNodeProcessor.unpackDirection(dir, initialPacked));
        double halfWidth = (double)this.mob.getBbWidth() / 2.0;
        DirectionalPathPoint[] result = new DirectionalPathPoint[1];
        if (malus >= 0.0f && (allowBlocked || nodeType != PathType.BLOCKED)) {
            directPathPoint = this.openPoint(x, y, z, packed, false);
            directPathPoint.type = nodeType;
            directPathPoint.costMalus = Math.max(directPathPoint.costMalus, malus);
            if (directPathPoint.type == PathType.BLOCKED) {
                result = new DirectionalPathPoint[2];
                result[1] = directPathPoint;
                directPathPoint = null;
            }
        }
        if (nodeType == PathType.WALKABLE) {
            result[0] = directPathPoint;
            return result;
        }
        if (directPathPoint == null && stepHeight > 0 && nodeType != PathType.FENCE && nodeType != PathType.UNPASSABLE_RAIL && nodeType != PathType.TRAPDOOR && direction.getY() == 0 && Math.abs(direction.getX()) + Math.abs(direction.getY()) + Math.abs(direction.getZ()) == 1) {
            double offsetZ;
            double offsetX;
            AABB enclosingAabb;
            DirectionalPathPoint[] pointsAbove = this.getSafePoints(x, y + 1, z, stepHeight - 1, height, direction, false);
            DirectionalPathPoint directionalPathPoint = directPathPoint = pointsAbove.length > 0 ? pointsAbove[0] : null;
            if (directPathPoint != null && (directPathPoint.type == PathType.OPEN || directPathPoint.type == PathType.WALKABLE) && this.mob.getBbWidth() < 1.0f && this.checkAabbCollision(enclosingAabb = new AABB((offsetX = (double)(x - direction.getX()) + 0.5) - halfWidth, AdvancedWalkNodeProcessor.getFloorLevel((BlockGetter)this.cachedLevel, (BlockPos)commonInit.blockPos(offsetX, y + 1, offsetZ = (double)(z - direction.getY()) + 0.5)) + 0.001, offsetZ - halfWidth, offsetX + halfWidth, (double)this.mob.getBbHeight() + AdvancedWalkNodeProcessor.getFloorLevel((BlockGetter)this.cachedLevel, (BlockPos)new BlockPos(directPathPoint.x, directPathPoint.y, directPathPoint.z)) - 0.002, offsetZ + halfWidth))) {
                directPathPoint = null;
            }
        }
        if (nodeType == PathType.OPEN) {
            float bridingMalus;
            directPathPoint = null;
            AABB checkAabb = new AABB((double)x - halfWidth + 0.5, (double)y + 0.001, (double)z - halfWidth + 0.5, (double)x + halfWidth + 0.5, (double)((float)y + this.mob.getBbHeight()), (double)z + halfWidth + 0.5);
            if (this.checkAabbCollision(checkAabb)) {
                result[0] = null;
                return result;
            }
            if (this.mob.getBbWidth() >= 1.0f) {
                for (int i = 0; i < this.pathableFacingsArray.length; ++i) {
                    Direction pathableFacing = this.pathableFacingsArray[i];
                    long packedAtFacing = this.getDirectionalPathNodeTypeCached(this.mob, x + pathableFacing.getStepX() * this.pathingSizeOffsetX, y + (pathableFacing == Direction.DOWN ? -1 : (pathableFacing == Direction.UP ? this.pathingSizeOffsetY : 0)), z + pathableFacing.getStepZ() * this.pathingSizeOffsetZ);
                    PathType nodeTypeAtFacing = AdvancedWalkNodeProcessor.unpackNodeType(packedAtFacing);
                    if (nodeTypeAtFacing != PathType.BLOCKED) continue;
                    directPathPoint = this.openPoint(x, y, z, packedAtFacing, false);
                    directPathPoint.type = PathType.WALKABLE;
                    directPathPoint.costMalus = Math.max(directPathPoint.costMalus, malus);
                    result[0] = directPathPoint;
                    return result;
                }
            }
            boolean cancelFallDown = false;
            DirectionalPathPoint fallPathPoint = null;
            int fallDistance = 0;
            int preFallY = y;
            while (y > this.cachedLevel.getMinY() && nodeType == PathType.OPEN) {
                if (fallDistance++ >= Math.max(1, this.mob.getMaxFallDistance()) || --y == 0) {
                    cancelFallDown = true;
                    break;
                }
                packed = this.getDirectionalPathNodeTypeCached(this.mob, x, y, z);
                nodeType = AdvancedWalkNodeProcessor.unpackNodeType(packed);
                malus = this.mob.getPathfindingMalus(nodeType);
                if ((this.mob.getMaxFallDistance() > 0 && nodeType != PathType.OPEN || nodeType == PathType.WATER || nodeType == PathType.LAVA) && malus >= 0.0f) {
                    fallPathPoint = this.openPoint(x, y, z, packed, true);
                    fallPathPoint.type = nodeType;
                    fallPathPoint.costMalus = Math.max(fallPathPoint.costMalus, malus);
                    break;
                }
                if (!(malus < 0.0f)) continue;
                cancelFallDown = true;
            }
            boolean hasPathUp = false;
            if (this.pathableFacings.size() > 1) {
                packed = this.getDirectionalPathNodeTypeCached(this.mob, x, preFallY, z);
                nodeType = AdvancedWalkNodeProcessor.unpackNodeType(packed);
                malus = this.mob.getPathfindingMalus(nodeType);
                if (nodeType != PathType.OPEN && malus >= 0.0f) {
                    if (fallPathPoint != null) {
                        result = new DirectionalPathPoint[2];
                        result[1] = fallPathPoint;
                    }
                    result[0] = directPathPoint = this.openPoint(x, preFallY, z, packed, false);
                    directPathPoint.type = nodeType;
                    directPathPoint.costMalus = Math.max(directPathPoint.costMalus, malus);
                    hasPathUp = true;
                }
            }
            if (fallPathPoint != null) {
                if (!hasPathUp) {
                    result[0] = directPathPoint = fallPathPoint;
                } else {
                    result = new DirectionalPathPoint[]{directPathPoint, fallPathPoint};
                }
            }
            if (fallPathPoint != null && (bridingMalus = this.advancedPathFindingEntity.getBridgePathingMalus(this.mob, new BlockPos(x, preFallY, z), fallPathPoint)) >= 0.0f) {
                result = new DirectionalPathPoint[2];
                result[0] = directPathPoint;
                DirectionalPathPoint bridgePathPoint = this.openPoint(x, preFallY, z, packed, false);
                bridgePathPoint.type = PathType.WALKABLE;
                bridgePathPoint.costMalus = Math.max(bridgePathPoint.costMalus, bridingMalus);
                result[1] = bridgePathPoint;
            }
            if (cancelFallDown && !hasPathUp) {
                result[0] = null;
                if (result.length == 2) {
                    result[1] = null;
                }
                return result;
            }
        }
        if (nodeType == PathType.FENCE) {
            directPathPoint = this.openPoint(x, y, z, packed, false);
            directPathPoint.closed = true;
            directPathPoint.type = nodeType;
            directPathPoint.costMalus = nodeType.getMalus();
        }
        result[0] = directPathPoint;
        return result;
    }

    protected long getDirectionalPathNodeTypeCached(Mob entitylivingIn, int x, int y, int z) {
        return this.pathNodeTypeCache.computeIfAbsent(BlockPos.asLong((int)x, (int)y, (int)z), key -> this.getDirectionalPathNodeType(this.cachedLevel, x, y, z, entitylivingIn, this.entityWidth, this.entityHeight, this.entityDepth, this.canOpenDoors(), this.canPassDoors()));
    }

    static long packDirection(Direction facing, long packed) {
        return packed | 1L << facing.ordinal();
    }

    static long packDirection(long packed1, long packed2) {
        return packed1 & 0xFFFFFFFF00000000L | packed1 & 0xFFFFFFFFL | packed2 & 0xFFFFFFFFL;
    }

    static boolean unpackDirection(Direction facing, long packed) {
        return (packed & 1L << facing.ordinal()) != 0L;
    }

    static boolean unpackDirection(long packed) {
        return (packed & 0xFFFFFFFFL) != 0L;
    }

    static long packNodeType(PathType type, long packed) {
        return (long)type.ordinal() << 32 | packed & 0xFFFFFFFFL;
    }

    static PathType unpackNodeType(long packed) {
        return PATH_NODE_TYPES[(int)(packed >> 32)];
    }

    protected long getDirectionalPathNodeType(BlockGetter blockaccessIn, int x, int y, int z, Mob entity, int xSize, int ySize, int zSize, boolean canBreakDoorsIn, boolean canEnterDoorsIn) {
        BlockPos pos = commonInit.blockPos(entity.position());
        EnumSet<PathType> applicablePathNodeTypes = EnumSet.noneOf(PathType.class);
        long centerPacked = this.getDirectionalPathNodeType(blockaccessIn, x, y, z, xSize, ySize, zSize, canBreakDoorsIn, canEnterDoorsIn, applicablePathNodeTypes, PathType.BLOCKED, pos);
        PathType centerPathNodeType = AdvancedWalkNodeProcessor.unpackNodeType(centerPacked);
        if (applicablePathNodeTypes.contains(PathType.FENCE)) {
            return AdvancedWalkNodeProcessor.packNodeType(PathType.FENCE, centerPacked);
        }
        if (applicablePathNodeTypes.contains(PathType.UNPASSABLE_RAIL)) {
            return AdvancedWalkNodeProcessor.packNodeType(PathType.UNPASSABLE_RAIL, centerPacked);
        }
        PathType selectedPathNodeType = PathType.BLOCKED;
        for (PathType applicablePathNodeType : applicablePathNodeTypes) {
            float p2;
            if (entity.getPathfindingMalus(applicablePathNodeType) < 0.0f) {
                return AdvancedWalkNodeProcessor.packNodeType(applicablePathNodeType, centerPacked);
            }
            float p1 = entity.getPathfindingMalus(applicablePathNodeType);
            if (!(p1 > (p2 = entity.getPathfindingMalus(selectedPathNodeType))) && (p1 != p2 || selectedPathNodeType == PathType.WALKABLE && applicablePathNodeType == PathType.OPEN) && (p1 != p2 || selectedPathNodeType != PathType.OPEN || applicablePathNodeType != PathType.WALKABLE)) continue;
            selectedPathNodeType = applicablePathNodeType;
        }
        if (centerPathNodeType == PathType.OPEN && entity.getPathfindingMalus(selectedPathNodeType) == 0.0f) {
            return AdvancedWalkNodeProcessor.packNodeType(PathType.OPEN, 0L);
        }
        return AdvancedWalkNodeProcessor.packNodeType(selectedPathNodeType, centerPacked);
    }

    protected long getDirectionalPathNodeType(BlockGetter blockaccessIn, int x, int y, int z, int xSize, int ySize, int zSize, boolean canOpenDoorsIn, boolean canEnterDoorsIn, EnumSet<PathType> nodeTypeEnum, PathType nodeType, BlockPos pos) {
        long packed = 0L;
        for (int ox = 0; ox < xSize; ++ox) {
            for (int oy = 0; oy < ySize; ++oy) {
                for (int oz = 0; oz < zSize; ++oz) {
                    int bx = ox + x;
                    int by = oy + y;
                    int bz = oz + z;
                    long packedAdjusted = this.getDirectionalPathNodeType(blockaccessIn, bx, by, bz);
                    PathType adjustedNodeType = AdvancedWalkNodeProcessor.unpackNodeType(packedAdjusted);
                    if (ox == 0 && oy == 0 && oz == 0) {
                        packed = AdvancedWalkNodeProcessor.packNodeType(adjustedNodeType, packedAdjusted);
                    }
                    nodeTypeEnum.add(adjustedNodeType);
                }
            }
        }
        return packed;
    }

    protected long getDirectionalPathNodeType(BlockGetter blockaccessIn, int x, int y, int z) {
        return this.getDirectionalPathNodeType(this.rawPathNodeTypeCache, blockaccessIn, x, y, z, this.pathingSizeOffsetX, this.pathingSizeOffsetY, this.pathingSizeOffsetZ, this.pathableFacingsArray);
    }

    protected static PathType getRawPathNodeTypeCached(Long2ObjectMap<PathType> cache, BlockGetter blockaccessIn, BlockPos.MutableBlockPos pos) {
        return (PathType)cache.computeIfAbsent(BlockPos.asLong((int)pos.getX(), (int)pos.getY(), (int)pos.getZ()), key -> WalkNodeEvaluator.getPathTypeFromState((BlockGetter)blockaccessIn, (BlockPos)pos));
    }

    protected long getDirectionalPathNodeType(Long2ObjectMap<PathType> rawPathNodeTypeCache, BlockGetter blockaccessIn, int x, int y, int z, int pathingSizeOffsetX, int pathingSizeOffsetY, int pathingSizeOffsetZ, Direction[] pathableFacings) {
        long packed = 0L;
        BlockPos.MutableBlockPos pos = new BlockPos.MutableBlockPos();
        PathType nodeType = AdvancedWalkNodeProcessor.getRawPathNodeTypeCached(rawPathNodeTypeCache, blockaccessIn, pos.set(x, y, z));
        boolean isWalkable = false;
        if (nodeType == PathType.OPEN && y >= blockaccessIn.getMinY() + 1) {
            for (int i = 0; i < pathableFacings.length; ++i) {
                Direction pathableFacing = pathableFacings[i];
                int checkHeight = pathableFacing.getAxis() != Direction.Axis.Y ? Math.min(4, pathingSizeOffsetY - 1) : 0;
                int cx = x + pathableFacing.getStepX() * pathingSizeOffsetX;
                int cy = y + (pathableFacing == Direction.DOWN ? -1 : (pathableFacing == Direction.UP ? pathingSizeOffsetY : 0));
                int cz = z + pathableFacing.getStepZ() * pathingSizeOffsetZ;
                for (int yo = 0; yo <= checkHeight; ++yo) {
                    pos.set(cx, cy + yo, cz);
                    PathType offsetNodeType = AdvancedWalkNodeProcessor.getRawPathNodeTypeCached(rawPathNodeTypeCache, blockaccessIn, pos);
                    PathType pathType = nodeType = offsetNodeType != PathType.WALKABLE && offsetNodeType != PathType.OPEN && offsetNodeType != PathType.WATER && offsetNodeType != PathType.LAVA ? PathType.WALKABLE : PathType.OPEN;
                    if (offsetNodeType == PathType.DAMAGE_FIRE) {
                        nodeType = PathType.DAMAGE_FIRE;
                    }
                    if (offsetNodeType == PathType.DANGER_OTHER) {
                        nodeType = PathType.DANGER_OTHER;
                    }
                    if (offsetNodeType == PathType.DAMAGE_OTHER) {
                        nodeType = PathType.DAMAGE_OTHER;
                    }
                    if (offsetNodeType == PathType.STICKY_HONEY) {
                        nodeType = PathType.STICKY_HONEY;
                    }
                    if (nodeType != PathType.WALKABLE) continue;
                    if (AdvancedWalkNodeProcessor.isColliderNodeType(offsetNodeType)) {
                        packed = AdvancedWalkNodeProcessor.packDirection(pathableFacing, packed);
                    }
                    isWalkable = true;
                }
            }
        }
        if (isWalkable) {
            PathfindingContext pathfindingContext = new PathfindingContext((CollisionGetter)blockaccessIn, this.mob);
            nodeType = WalkNodeEvaluator.checkNeighbourBlocks((PathfindingContext)pathfindingContext, (int)x, (int)y, (int)z, (PathType)PathType.WALKABLE);
        }
        return AdvancedWalkNodeProcessor.packNodeType(nodeType, packed);
    }

    protected static boolean isColliderNodeType(PathType type) {
        return type == PathType.BLOCKED || type == PathType.TRAPDOOR || type == PathType.FENCE || type == PathType.DOOR_WOOD_CLOSED || type == PathType.DOOR_IRON_CLOSED || type == PathType.LEAVES || type == PathType.STICKY_HONEY || type == PathType.COCOA;
    }
}

