/*
 * Decompiled with CFR 0.152.
 */
package win.demistorm.stormiespiders.config;

import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import win.demistorm.stormiespiders.Constants;

public final class ModConfig {
    private static final Path CONFIG_FILE = Paths.get("config", "stormiespiders.json");
    private static boolean preventClimbingInRain = false;

    public static void load() {
        try {
            String generalSection;
            if (Files.notExists(CONFIG_FILE.getParent(), new LinkOption[0])) {
                Files.createDirectories(CONFIG_FILE.getParent(), new FileAttribute[0]);
            }
            if (Files.notExists(CONFIG_FILE, new LinkOption[0])) {
                ModConfig.save();
                return;
            }
            String content = Files.readString(CONFIG_FILE);
            if ((content = content.trim()).isEmpty()) {
                ModConfig.save();
                return;
            }
            if ((content = content.substring(1, content.length() - 1)).contains("\"general\":") && (generalSection = ModConfig.extractSection(content, "general")) != null) {
                preventClimbingInRain = ModConfig.parseBoolean(generalSection, "prevent_climbing_in_rain", false);
            }
        }
        catch (IOException e) {
            Constants.LOG.error("Failed to load config, using defaults", (Throwable)e);
            preventClimbingInRain = false;
        }
    }

    public static void save() {
        try {
            if (Files.notExists(CONFIG_FILE.getParent(), new LinkOption[0])) {
                Files.createDirectories(CONFIG_FILE.getParent(), new FileAttribute[0]);
            }
            String json = String.format("{\n  \"general\": {\n    \"prevent_climbing_in_rain\": %b\n  }\n}", preventClimbingInRain);
            Files.writeString(CONFIG_FILE, (CharSequence)json, new OpenOption[0]);
        }
        catch (IOException e) {
            Constants.LOG.error("Failed to save config", (Throwable)e);
        }
    }

    private static String extractSection(String content, String sectionName) {
        int endIndex;
        String searchPattern = "\"" + sectionName + "\":";
        int startIndex = content.indexOf(searchPattern);
        if (startIndex == -1) {
            return null;
        }
        if ((startIndex = content.indexOf(123, startIndex)) == -1) {
            return null;
        }
        int braceCount = 1;
        for (endIndex = startIndex + 1; endIndex < content.length() && braceCount > 0; ++endIndex) {
            char c = content.charAt(endIndex);
            if (c == '{') {
                ++braceCount;
                continue;
            }
            if (c != '}') continue;
            --braceCount;
        }
        if (braceCount == 0) {
            return content.substring(startIndex + 1, endIndex - 1);
        }
        return null;
    }

    private static boolean parseBoolean(String section, String key, boolean defaultValue) {
        String searchPattern = "\"" + key + "\":";
        int index = section.indexOf(searchPattern);
        if (index == -1) {
            return defaultValue;
        }
        index += searchPattern.length();
        while (index < section.length() && Character.isWhitespace(section.charAt(index))) {
            ++index;
        }
        if (index >= section.length()) {
            return defaultValue;
        }
        if (section.substring(index).startsWith("true")) {
            return true;
        }
        if (section.substring(index).startsWith("false")) {
            return false;
        }
        return defaultValue;
    }

    public static final class Data {
        public static boolean preventClimbingInRain() {
            return preventClimbingInRain;
        }

        public static void setPreventClimbingInRain(boolean value) {
            preventClimbingInRain = value;
            ModConfig.save();
        }
    }
}

