/*
 * Decompiled with CFR 0.152.
 */
package win.demistorm.stormiespiders.mixin;

import net.minecraft.core.BlockPos;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.monster.Spider;
import net.minecraft.world.phys.Vec3;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={Spider.class})
public class ClientSpiderAnimationMixin {
    @Inject(method={"tick()V"}, at={@At(value="HEAD")})
    private void onTick(CallbackInfo ci) {
        boolean isClimbing;
        LivingEntity entity = (LivingEntity)this;
        if (!entity.level().isClientSide) {
            return;
        }
        Vec3 motion = entity.getDeltaMovement();
        float movementSpeed = (float)Math.sqrt(motion.x * motion.x + motion.y * motion.y + motion.z * motion.z);
        BlockPos underPos = BlockPos.containing((double)entity.getX(), (double)(entity.getY() - 0.2), (double)entity.getZ());
        boolean hasAirUnderneath = entity.level().getBlockState(underPos).isAir();
        boolean bl = isClimbing = hasAirUnderneath && movementSpeed > 0.01f;
        if (movementSpeed > 0.01f) {
            float multiplier = isClimbing ? 8.0f : 3.0f;
            float animSpeed = Math.min(movementSpeed * multiplier, 1.0f);
            entity.walkAnimation.update(animSpeed, 0.4f, 1.0f);
        }
    }
}

