/*
 * Decompiled with CFR 0.152.
 */
package win.demistorm.stormiespiders.common.entity.movement;

import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.ai.control.JumpControl;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.Nullable;
import win.demistorm.stormiespiders.common.entity.mob.IClimberEntity;

public class ClimberJumpController<T extends Mob>
extends JumpControl {
    protected final T climber;
    @Nullable
    protected Vec3 dir;

    public ClimberJumpController(T mob) {
        super(mob);
        this.climber = mob;
    }

    public void jump() {
        this.setJumping(null);
    }

    public void setJumping(Vec3 dir) {
        super.jump();
        this.dir = dir;
    }

    public void tick() {
        this.climber.setJumping(this.jump);
        if (this.jump) {
            ((IClimberEntity)this.climber).setJumpDirection(this.dir);
        } else if (this.dir == null) {
            ((IClimberEntity)this.climber).setJumpDirection(null);
        }
        this.climber.setJumping(false);
        this.jump = false;
    }
}

