/*
 * Decompiled with CFR 0.152.
 */
package win.demistorm.stormiespiders.common.entity.movement;

import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.ai.control.JumpControl;
import net.minecraft.world.entity.ai.control.MoveControl;
import net.minecraft.world.entity.ai.navigation.PathNavigation;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.pathfinder.BlockPathTypes;
import net.minecraft.world.level.pathfinder.NodeEvaluator;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.Nullable;
import win.demistorm.stormiespiders.common.entity.mob.IClimberEntity;
import win.demistorm.stormiespiders.common.entity.mob.Orientation;
import win.demistorm.stormiespiders.common.entity.movement.ClimberJumpController;

public class ClimberMoveController<T extends Mob>
extends MoveControl {
    protected final IClimberEntity climber;
    @Nullable
    protected BlockPos block;
    @Nullable
    protected Direction side;

    public ClimberMoveController(T entity) {
        super(entity);
        this.climber = (IClimberEntity)entity;
    }

    public void setWantedPosition(double x, double y, double z, double speedIn) {
        this.setMoveTo(x, y, z, null, null, speedIn);
    }

    public void setMoveTo(double x, double y, double z, BlockPos block, Direction side, double speedIn) {
        super.setWantedPosition(x, y, z, speedIn);
        this.block = block;
        this.side = side;
    }

    public void tick() {
        double speed = (double)this.climber.getMovementSpeed() * this.speedModifier;
        if (this.operation == MoveControl.Operation.STRAFE) {
            this.operation = MoveControl.Operation.WAIT;
            float forward = this.strafeForwards;
            float strafe = this.strafeRight;
            float moveSpeed = Mth.sqrt((float)(forward * forward + strafe * strafe));
            if (moveSpeed < 1.0f) {
                moveSpeed = 1.0f;
            }
            moveSpeed = (float)speed / moveSpeed;
            Orientation orientation = this.climber.getOrientation();
            Vec3 forwardVector = orientation.getGlobal(this.mob.yRot, 0.0f);
            Vec3 strafeVector = orientation.getGlobal(this.mob.yRot + 90.0f, 0.0f);
            if (!this.isWalkableAtOffset(forwardVector.x * (double)(forward *= moveSpeed) + strafeVector.x * (double)(strafe *= moveSpeed), forwardVector.y * (double)forward + strafeVector.y * (double)strafe, forwardVector.z * (double)forward + strafeVector.z * (double)strafe)) {
                this.strafeForwards = 1.0f;
                this.strafeRight = 0.0f;
            }
            this.mob.setSpeed((float)speed);
            this.mob.setZza(this.strafeForwards);
            this.mob.setXxa(this.strafeRight);
        } else if (this.operation == MoveControl.Operation.MOVE_TO) {
            double hdz;
            double hdy;
            double hdx;
            double hdsq;
            this.operation = MoveControl.Operation.WAIT;
            double dx = this.wantedX - this.mob.getX();
            double dy = this.wantedY - this.mob.getY();
            double dz = this.wantedZ - this.mob.getZ();
            if (this.side != null && this.block != null) {
                VoxelShape shape = this.mob.level().getBlockState(this.block).getCollisionShape((BlockGetter)this.mob.level(), this.block);
                AABB aabb = this.mob.getBoundingBox();
                double ox = 0.0;
                double oy = 0.0;
                double oz = 0.0;
                switch (this.side) {
                    case DOWN: {
                        if (!(aabb.minY >= (double)this.block.getY() + shape.max(Direction.Axis.Y) - 0.01)) break;
                        ox -= 0.1;
                        break;
                    }
                    case UP: {
                        if (!(aabb.maxY <= (double)this.block.getY() + shape.min(Direction.Axis.Y) + 0.01)) break;
                        oy += 0.1;
                        break;
                    }
                    case WEST: {
                        if (!(aabb.minX >= (double)this.block.getX() + shape.max(Direction.Axis.X) - 0.01)) break;
                        ox -= 0.1;
                        break;
                    }
                    case EAST: {
                        if (!(aabb.maxX <= (double)this.block.getX() + shape.min(Direction.Axis.X) + 0.01)) break;
                        ox += 0.1;
                        break;
                    }
                    case NORTH: {
                        if (!(aabb.minZ >= (double)this.block.getZ() + shape.max(Direction.Axis.Z) - 0.01)) break;
                        oz -= 0.1;
                        break;
                    }
                    case SOUTH: {
                        if (!(aabb.maxZ <= (double)this.block.getZ() + shape.min(Direction.Axis.Z) + 0.01)) break;
                        oz += 0.1;
                    }
                }
                AABB blockAabb = new AABB(this.block.relative(this.side.getOpposite()));
                if (aabb.intersects(blockAabb)) {
                    Direction.Axis offsetAxis = this.side.getAxis();
                    double allowedOffset = shape.collide(offsetAxis, aabb.move((double)(-this.block.getX()), (double)(-this.block.getY()), (double)(-this.block.getZ())), switch (offsetAxis) {
                        default -> (float)this.side.getStepX() * 0.5f;
                        case Direction.Axis.Y -> (float)this.side.getStepY() * 0.5f;
                        case Direction.Axis.Z -> (float)this.side.getStepZ() * 0.5f;
                    });
                    switch (this.side) {
                        case DOWN: {
                            if (!(aabb.minY + allowedOffset < (double)this.block.getY() + shape.max(Direction.Axis.Y) - 0.01)) break;
                            oy = 0.0;
                            break;
                        }
                        case UP: {
                            if (!(aabb.maxY + allowedOffset > (double)this.block.getY() + shape.min(Direction.Axis.Y) + 0.01)) break;
                            oy = 0.0;
                            break;
                        }
                        case WEST: {
                            if (!(aabb.minX + allowedOffset < (double)this.block.getX() + shape.max(Direction.Axis.X) - 0.01)) break;
                            ox = 0.0;
                            break;
                        }
                        case EAST: {
                            if (!(aabb.maxX + allowedOffset > (double)this.block.getX() + shape.min(Direction.Axis.X) + 0.01)) break;
                            ox = 0.0;
                            break;
                        }
                        case NORTH: {
                            if (!(aabb.minZ + allowedOffset < (double)this.block.getZ() + shape.max(Direction.Axis.Z) - 0.01)) break;
                            oz = 0.0;
                            break;
                        }
                        case SOUTH: {
                            if (!(aabb.maxZ + allowedOffset > (double)this.block.getZ() + shape.min(Direction.Axis.Z) + 0.01)) break;
                            oz = 0.0;
                        }
                    }
                }
                dx += ox;
                dy += oy;
                dz += oz;
            }
            Direction mainOffsetDir = Direction.getNearest((double)dx, (double)dy, (double)dz);
            float reach = switch (mainOffsetDir) {
                case Direction.DOWN -> 0.0f;
                case Direction.UP -> this.mob.getBbHeight();
                default -> this.mob.getBbWidth() * 0.5f;
            };
            double verticalOffset = Math.abs((double)mainOffsetDir.getStepX() * dx) + Math.abs((double)mainOffsetDir.getStepY() * dy) + Math.abs((double)mainOffsetDir.getStepZ() * dz);
            Direction groundDir = (Direction)this.climber.getGroundDirection().getLeft();
            Vec3 jumpDir = null;
            if (this.side != null && verticalOffset > (double)(reach - 0.05f) && groundDir != this.side && groundDir.getAxis() != this.side.getAxis() && (hdsq = (hdx = (double)(1 - Math.abs(mainOffsetDir.getStepX())) * dx) * hdx + (hdy = (double)(1 - Math.abs(mainOffsetDir.getStepY())) * dy) * hdy + (hdz = (double)(1 - Math.abs(mainOffsetDir.getStepZ())) * dz) * hdz) < (double)0.707f) {
                dx -= (double)((float)this.side.getStepX() * 0.2f);
                dy -= (double)((float)this.side.getStepY() * 0.2f);
                dz -= (double)((float)this.side.getStepZ() * 0.2f);
                if (hdsq < (double)0.1f) {
                    jumpDir = new Vec3((double)mainOffsetDir.getStepX(), (double)mainOffsetDir.getStepY(), (double)mainOffsetDir.getStepZ());
                }
            }
            Orientation orientation = this.climber.getOrientation();
            Vec3 up = orientation.getGlobal(this.mob.yRot, -90.0f);
            Vec3 offset = new Vec3(dx, dy, dz);
            Vec3 targetDir = offset.subtract(up.scale(offset.dot(up)));
            double targetDist = targetDir.length();
            targetDir = targetDir.normalize();
            if (targetDist < 1.0E-4) {
                this.mob.setZza(0.0f);
            } else {
                float rx = (float)orientation.localZ.dot(targetDir);
                float ry = (float)orientation.localX.dot(targetDir);
                this.mob.yRot = this.rotlerp(this.mob.yRot, 270.0f - (float)Math.toDegrees(Mth.atan2((double)rx, (double)ry)), 90.0f);
                if (jumpDir == null && this.side != null && targetDist < 0.1 && groundDir == this.side.getOpposite()) {
                    jumpDir = new Vec3((double)this.side.getStepX(), (double)this.side.getStepY(), (double)this.side.getStepZ());
                }
                if (jumpDir == null && this.side != null && Math.abs(((Vec3)this.climber.getGroundDirection().getRight()).y) > 0.5 && (!this.climber.canAttachToSide(this.side) || !this.climber.canAttachToSide(Direction.getNearest((double)dx, (double)dy, (double)dz))) && this.wantedY > this.mob.getY() + (double)0.1f && verticalOffset > (double)0.6f) {
                    jumpDir = new Vec3(0.0, 1.0, 0.0);
                }
                if (jumpDir != null) {
                    this.mob.setSpeed((float)speed * 0.5f);
                    JumpControl jumpController = this.mob.getJumpControl();
                    if (jumpController instanceof ClimberJumpController) {
                        ((ClimberJumpController)jumpController).setJumping(jumpDir);
                    }
                } else {
                    this.mob.setSpeed((float)speed);
                }
            }
        } else if (this.operation == MoveControl.Operation.JUMPING) {
            this.mob.setSpeed((float)speed);
            if (this.mob.onGround()) {
                this.operation = MoveControl.Operation.WAIT;
            }
        } else {
            this.mob.setZza(0.0f);
        }
    }

    private boolean isWalkableAtOffset(double x, double y, double z) {
        NodeEvaluator processor;
        PathNavigation navigator = this.mob.getNavigation();
        return navigator == null || (processor = navigator.getNodeEvaluator()) == null || processor.getBlockPathType((BlockGetter)this.mob.level(), Mth.floor((double)(this.mob.getX() + x)), Mth.floor((double)(this.mob.getY() + (double)(this.mob.getBbHeight() * 0.5f) + y)), Mth.floor((double)(this.mob.getZ() + z))) == BlockPathTypes.WALKABLE;
    }
}

