/*
 * Decompiled with CFR 0.152.
 */
package win.demistorm.stormiespiders.mixin;

import com.llamalad7.mixinextras.injector.wrapoperation.Operation;
import com.llamalad7.mixinextras.injector.wrapoperation.WrapOperation;
import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityDimensions;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.MoverType;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;
import win.demistorm.stormiespiders.common.CommonEventHandlers;
import win.demistorm.stormiespiders.common.entity.mob.IEntityMovementHook;
import win.demistorm.stormiespiders.common.entity.mob.IEntityReadWriteHook;

@Mixin(value={Entity.class})
public abstract class EntityMixin
implements IEntityMovementHook,
IEntityReadWriteHook {
    @Shadow
    private EntityDimensions dimensions;

    @Inject(method={"<init>(Lnet/minecraft/world/entity/EntityType;Lnet/minecraft/world/level/Level;)V"}, at={@At(value="RETURN")})
    private void setDimensions(EntityType entityType, Level level, CallbackInfo ci) {
        Optional<EntityDimensions> entityDimensions = CommonEventHandlers.onEntitySize((Entity)this);
        entityDimensions.ifPresent(value -> {
            this.dimensions = value;
        });
    }

    @Inject(method={"refreshDimensions()V"}, at={@At(value="INVOKE_ASSIGN", target="Lnet/minecraft/world/entity/Entity;getDimensions(Lnet/minecraft/world/entity/Pose;)Lnet/minecraft/world/entity/EntityDimensions;")})
    private void setDimensionsNew(CallbackInfo ci) {
        Optional<EntityDimensions> entityDimensions = CommonEventHandlers.onEntitySize((Entity)this);
        entityDimensions.ifPresent(value -> {
            this.dimensions = value;
        });
    }

    @Inject(method={"move(Lnet/minecraft/world/entity/MoverType;Lnet/minecraft/world/phys/Vec3;)V"}, at={@At(value="HEAD")}, cancellable=true)
    private void onMovePre(MoverType type, Vec3 pos, CallbackInfo ci) {
        if (this.onMove(type, pos, true)) {
            ci.cancel();
        }
    }

    @Inject(method={"move(Lnet/minecraft/world/entity/MoverType;Lnet/minecraft/world/phys/Vec3;)V"}, at={@At(value="RETURN")})
    private void onMovePost(MoverType type, Vec3 pos, CallbackInfo ci) {
        this.onMove(type, pos, false);
    }

    @Override
    public boolean onMove(MoverType type, Vec3 pos, boolean pre) {
        return false;
    }

    @Inject(method={"getOnPos()Lnet/minecraft/core/BlockPos;"}, at={@At(value="RETURN")}, cancellable=true)
    private void onGetOnPosition(CallbackInfoReturnable<BlockPos> ci) {
        BlockPos adjusted = this.getAdjustedOnPosition((BlockPos)ci.getReturnValue());
        if (adjusted != null) {
            ci.setReturnValue((Object)adjusted);
        }
    }

    @Override
    public BlockPos getAdjustedOnPosition(BlockPos onPosition) {
        return null;
    }

    @WrapOperation(method={"move(Lnet/minecraft/world/entity/MoverType;Lnet/minecraft/world/phys/Vec3;)V"}, at={@At(value="INVOKE", target="Lnet/minecraft/world/entity/Entity$MovementEmission;emitsAnything()Z")})
    public boolean bop(Entity.MovementEmission instance, Operation<Boolean> original) {
        return this.getAdjustedCanTriggerWalking(instance.emitsAnything());
    }

    @Override
    public boolean getAdjustedCanTriggerWalking(boolean canTriggerWalking) {
        return canTriggerWalking;
    }

    @Inject(method={"load(Lnet/minecraft/nbt/CompoundTag;)V"}, at={@At(value="INVOKE", target="Lnet/minecraft/world/entity/Entity;readAdditionalSaveData(Lnet/minecraft/nbt/CompoundTag;)V", shift=At.Shift.AFTER)})
    private void onRead(CompoundTag nbt, CallbackInfo ci) {
        this.onRead(nbt);
    }

    @Override
    public void onRead(CompoundTag nbt) {
    }

    @Inject(method={"saveWithoutId(Lnet/minecraft/nbt/CompoundTag;)Lnet/minecraft/nbt/CompoundTag;"}, at={@At(value="INVOKE", target="Lnet/minecraft/world/entity/Entity;addAdditionalSaveData(Lnet/minecraft/nbt/CompoundTag;)V", shift=At.Shift.AFTER)})
    private void onWrite(CompoundTag nbt, CallbackInfoReturnable<CompoundTag> ci) {
        this.onWrite(nbt);
    }

    @Override
    public void onWrite(CompoundTag nbt) {
    }

    @Shadow(prefix="shadow$")
    private void shadow$defineSynchedData() {
    }
}

