/*
 * Decompiled with CFR 0.152.
 */
package win.demistorm.stormiespiders.common.entity.movement;

import java.util.HashSet;
import java.util.Set;
import net.minecraft.class_10;
import net.minecraft.class_11;
import net.minecraft.class_13;
import net.minecraft.class_1308;
import net.minecraft.class_1409;
import net.minecraft.class_1922;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_238;
import net.minecraft.class_243;
import net.minecraft.class_265;
import net.minecraft.class_2680;
import net.minecraft.class_3532;
import net.minecraft.class_3726;
import net.minecraft.class_7;
import net.minecraft.class_8;
import org.jetbrains.annotations.Nullable;
import win.demistorm.stormiespiders.common.entity.movement.AdvancedPathFinder;
import win.demistorm.stormiespiders.common.entity.movement.AdvancedWalkNodeProcessor;
import win.demistorm.stormiespiders.common.entity.movement.IAdvancedPathFindingEntity;
import win.demistorm.stormiespiders.commonInit;

public class AdvancedGroundPathNavigator<T extends class_1308>
extends class_1409 {
    protected AdvancedPathFinder pathFinder;
    protected long lastTimeUpdated;
    protected class_2338 targetPos;
    protected final T advancedPathFindingEntity;
    protected final boolean checkObstructions;
    protected int stuckCheckTicks = 0;
    protected int checkpointRange;

    public AdvancedGroundPathNavigator(T entity, class_1937 worldIn) {
        this(entity, worldIn, true);
    }

    public AdvancedGroundPathNavigator(T entity, class_1937 worldIn, boolean checkObstructions) {
        super(entity, worldIn);
        this.advancedPathFindingEntity = entity;
        this.checkObstructions = checkObstructions;
        if (this.field_6678 instanceof AdvancedWalkNodeProcessor) {
            AdvancedWalkNodeProcessor processor = (AdvancedWalkNodeProcessor)this.field_6678;
            processor.setCheckObstructions(checkObstructions);
        }
    }

    public AdvancedPathFinder getAssignedPathFinder() {
        return this.pathFinder;
    }

    protected final class_13 method_6336(int maxExpansions) {
        this.pathFinder = this.createAdvancedPathFinder(maxExpansions);
        this.field_6678 = this.pathFinder.getNodeProcessor();
        return this.pathFinder;
    }

    protected AdvancedPathFinder createAdvancedPathFinder(int maxExpansions) {
        AdvancedWalkNodeProcessor nodeProcessor = new AdvancedWalkNodeProcessor();
        nodeProcessor.method_15(true);
        return new AdvancedPathFinder((class_8)nodeProcessor, maxExpansions);
    }

    @Nullable
    protected class_11 method_35142(Set<class_2338> waypoints, int padding, boolean startAbove, int checkpointRange) {
        HashSet<class_2338> adjustedWaypoints = new HashSet<class_2338>();
        for (class_2338 pos : waypoints) {
            adjustedWaypoints.add(pos.method_10069(-class_3532.method_15386((float)this.field_6684.method_17681()) + 1, -class_3532.method_15386((float)this.field_6684.method_17682()) + 1, -class_3532.method_15386((float)this.field_6684.method_17681()) + 1));
        }
        class_11 path = super.method_35142(adjustedWaypoints, padding, startAbove, checkpointRange);
        if (path != null && path.method_48() != null) {
            this.checkpointRange = checkpointRange;
        }
        return path;
    }

    public void method_6356() {
        if (this.field_6677.method_8510() - this.lastTimeUpdated > 20L) {
            if (this.targetPos != null) {
                this.field_6681 = null;
                this.field_6681 = this.method_6348(this.targetPos, this.checkpointRange);
                this.lastTimeUpdated = this.field_6677.method_8510();
                this.field_6679 = false;
            }
        } else {
            this.field_6679 = true;
        }
    }

    protected void method_6346(class_243 entityPos) {
        super.method_6346(entityPos);
        if (this.checkObstructions && this.field_6681 != null && !this.field_6681.method_46()) {
            class_243 target = this.field_6681.method_47(this.advancedPathFindingEntity, Math.min(this.field_6681.method_38() - 1, this.field_6681.method_39() + 0));
            class_243 diff = target.method_1020(entityPos);
            int axis = 0;
            double maxDiff = 0.0;
            for (int i = 0; i < 3; ++i) {
                double d = switch (i) {
                    default -> Math.abs(diff.field_1352);
                    case 1 -> Math.abs(diff.field_1351);
                    case 2 -> Math.abs(diff.field_1350);
                };
                if (!(d > maxDiff)) continue;
                axis = i;
                maxDiff = d;
            }
            int height = class_3532.method_15375((float)(this.advancedPathFindingEntity.method_17682() + 1.0f));
            int ceilHalfWidth = class_3532.method_15386((float)(this.advancedPathFindingEntity.method_17681() / 2.0f + 0.05f));
            class_243 facingDiff = (switch (axis) {
                default -> new class_243(entityPos.field_1352 + Math.signum(diff.field_1352) * (double)ceilHalfWidth, entityPos.field_1351, target.field_1350);
                case 1 -> new class_243(entityPos.field_1352, entityPos.field_1351 + (double)(diff.field_1351 > 0.0 ? height + 1 : -1), target.field_1350);
                case 2 -> new class_243(target.field_1352, entityPos.field_1351, entityPos.field_1350 + Math.signum(diff.field_1350) * (double)ceilHalfWidth);
            }).method_1020(entityPos.method_1031(0.0, axis == 1 ? (double)(this.field_6684.method_17682() / 2.0f) : 0.0, 0.0));
            class_2350 facing = class_2350.method_62672((int)class_3532.method_15357((double)facingDiff.field_1352), (int)class_3532.method_15357((double)facingDiff.field_1351), (int)class_3532.method_15357((double)facingDiff.field_1350), (class_2350)class_2350.field_11036);
            boolean blocked = false;
            class_238 checkBox = this.advancedPathFindingEntity.method_5829().method_1012(Math.signum(diff.field_1352) * 0.2, Math.signum(diff.field_1351) * 0.2, Math.signum(diff.field_1350) * 0.2);
            block9: for (int yo = 0; yo < height; ++yo) {
                for (int xzo = -ceilHalfWidth; xzo <= ceilHalfWidth; ++xzo) {
                    class_265 collisionShape;
                    class_7 nodeType;
                    class_2338 pos = commonInit.blockPos(checkPos.field_1352 + (double)(axis != 0 ? xzo : 0), checkPos.field_1351 + (double)(axis != 1 ? yo : 0), checkPos.field_1350 + (double)(axis != 2 ? xzo : 0));
                    class_2680 state = this.advancedPathFindingEntity.method_73183().method_8320(pos);
                    class_7 class_72 = nodeType = state.method_26171(class_10.field_50) ? class_7.field_7 : class_7.field_22;
                    if (nodeType != class_7.field_22 || (collisionShape = state.method_26172((class_1922)this.advancedPathFindingEntity.method_73183(), pos, class_3726.method_16195(this.advancedPathFindingEntity)).method_1096((double)pos.method_10263(), (double)pos.method_10264(), (double)pos.method_10260())) == null || !collisionShape.method_1090().stream().anyMatch(aabb -> aabb.method_994(checkBox))) continue;
                    blocked = true;
                    break block9;
                }
            }
            if (blocked) {
                ++this.stuckCheckTicks;
                if (this.stuckCheckTicks > ((IAdvancedPathFindingEntity)this.advancedPathFindingEntity).getMaxStuckCheckTicks()) {
                    ((IAdvancedPathFindingEntity)this.advancedPathFindingEntity).onPathingObstructed(facing);
                    this.stuckCheckTicks = 0;
                }
            } else {
                this.stuckCheckTicks = Math.max(this.stuckCheckTicks - 2, 0);
            }
        } else {
            this.stuckCheckTicks = Math.max(this.stuckCheckTicks - 4, 0);
        }
    }
}

