/*
 * Decompiled with CFR 0.152.
 */
package win.demistorm.stormiespiders.common.entity.movement;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import net.minecraft.class_11;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_7;
import net.minecraft.class_8;
import net.minecraft.class_9;
import org.jetbrains.annotations.Nullable;
import win.demistorm.stormiespiders.common.entity.movement.CustomPathFinder;
import win.demistorm.stormiespiders.common.entity.movement.DirectionalPathPoint;

public class AdvancedPathFinder
extends CustomPathFinder {
    private static final class_2350[] DOWN = new class_2350[]{class_2350.field_11033};

    public AdvancedPathFinder(class_8 processor, int maxExpansions) {
        super(processor, maxExpansions);
    }

    @Override
    protected class_11 createPath(class_9 _targetPoint, class_2338 target, boolean isTargetReached) {
        ArrayList<class_9> points = new ArrayList<class_9>();
        this.backtrackPath(points, _targetPoint);
        TPONode end = this.retraceSidedPath(points, true);
        if (end == null) {
            return new class_11(Collections.emptyList(), target, isTargetReached);
        }
        points.clear();
        this.backtrackPath(points, end);
        return new class_11(points, target, isTargetReached);
    }

    private void backtrackPath(List<class_9> points, class_9 start) {
        class_9 currentPathPoint = start;
        points.add(start);
        while (currentPathPoint.field_35 != null) {
            currentPathPoint = currentPathPoint.field_35;
            points.add(currentPathPoint);
        }
    }

    private void backtrackPath(List<class_9> points, TPONode start) {
        TPONode currentTPONode = start;
        points.add(start.pathPoint);
        while (currentTPONode.previous != null) {
            currentTPONode = currentTPONode.previous;
            points.add(currentTPONode.pathPoint);
        }
    }

    private static class_2350[] getPathableSidesWithFallback(DirectionalPathPoint point) {
        if (point.getPathableSides().length == 0) {
            return DOWN;
        }
        return point.getPathableSides();
    }

    private static boolean isOmnidirectionalPoint(DirectionalPathPoint point) {
        return point.field_41 == class_7.field_18 || point.field_41 == class_7.field_14;
    }

    private TPONode retraceSidedPath(List<class_9> points, boolean isReversed) {
        if (points.isEmpty()) {
            return null;
        }
        LinkedList<TPONode> queue = new LinkedList<TPONode>();
        DirectionalPathPoint targetPoint = this.ensureDirectional(points.get(0));
        for (class_2350 direction : AdvancedPathFinder.getPathableSidesWithFallback(targetPoint)) {
            queue.add(new TPONode(null, targetPoint.assignPathSide(direction)));
        }
        TPONode end = null;
        int maxExpansions = 200;
        HashSet<TPONode> checkedSet = new HashSet<TPONode>();
        int expansions = 0;
        while (!queue.isEmpty() && expansions++ <= 200) {
            TPONode current = (TPONode)queue.removeFirst();
            if (current.depth == points.size() - 1) {
                end = current;
                break;
            }
            class_2350 currentSide = current.side;
            DirectionalPathPoint next = this.ensureDirectional(points.get(current.depth + 1));
            for (class_2350 nextSide : AdvancedPathFinder.getPathableSidesWithFallback(next)) {
                TPONode nextTPONode = null;
                if (isReversed && current.pathPoint.isDrop() || !isReversed && next.isDrop()) {
                    nextTPONode = new TPONode(current, next.assignPathSide(nextSide));
                } else {
                    int adz;
                    int ady;
                    int dx = (int)Math.signum(next.field_40 - current.pathPoint.field_40);
                    int dy = (int)Math.signum(next.field_39 - current.pathPoint.field_39);
                    int dz = (int)Math.signum(next.field_38 - current.pathPoint.field_38);
                    int adx = Math.abs(dx);
                    int d = adx + (ady = Math.abs(dy)) + (adz = Math.abs(dz));
                    if (d == 1) {
                        if (nextSide == currentSide) {
                            nextTPONode = new TPONode(current, next.assignPathSide(nextSide));
                        } else if (nextSide.method_10166() != currentSide.method_10166()) {
                            TPONode intermediary = Math.abs(currentSide.method_10148()) == adx && Math.abs(currentSide.method_10164()) == ady && Math.abs(currentSide.method_10165()) == adz ? new TPONode(current, current.pathPoint.assignPathSide(nextSide)) : new TPONode(current, next.assignPathSide(currentSide));
                            nextTPONode = new TPONode(intermediary, intermediary.depth, next.assignPathSide(nextSide));
                        }
                    } else if (d == 2) {
                        int currentSidePlaneMatch = (currentSide.method_10148() == -dx ? 1 : 0) + (currentSide.method_10164() == -dy ? 1 : 0) + (currentSide.method_10165() == -dz ? 1 : 0);
                        if (currentSide == nextSide && currentSidePlaneMatch == 0) {
                            nextTPONode = new TPONode(current, next.assignPathSide(nextSide));
                        } else {
                            TPONode intermediary = null;
                            if (currentSidePlaneMatch == 2) {
                                for (class_2350 intermediarySide : AdvancedPathFinder.getPathableSidesWithFallback(current.pathPoint)) {
                                    if (intermediarySide == currentSide || (intermediarySide.method_10148() == dx ? 1 : 0) + (intermediarySide.method_10164() == dy ? 1 : 0) + (intermediarySide.method_10165() == dz ? 1 : 0) != 2) continue;
                                    intermediary = new TPONode(current, current.pathPoint.assignPathSide(intermediarySide));
                                    break;
                                }
                            } else {
                                for (class_2350 intermediarySide : AdvancedPathFinder.getPathableSidesWithFallback(next)) {
                                    if (intermediarySide == nextSide || (intermediarySide.method_10148() == -dx ? 1 : 0) + (intermediarySide.method_10164() == -dy ? 1 : 0) + (intermediarySide.method_10165() == -dz ? 1 : 0) != 2) continue;
                                    intermediary = new TPONode(current, next.assignPathSide(intermediarySide));
                                    break;
                                }
                            }
                            nextTPONode = intermediary != null ? new TPONode(intermediary, intermediary.depth, next.assignPathSide(nextSide)) : new TPONode(current, next.assignPathSide(nextSide));
                        }
                    }
                }
                if (nextTPONode == null || !checkedSet.add(nextTPONode)) continue;
                queue.addLast(nextTPONode);
            }
        }
        return end;
    }

    private DirectionalPathPoint ensureDirectional(class_9 point) {
        if (point instanceof DirectionalPathPoint) {
            return (DirectionalPathPoint)point;
        }
        return new DirectionalPathPoint(point);
    }

    private static class TPONode {
        private final TPONode previous;
        private final DirectionalPathPoint pathPoint;
        private final class_2350 side;
        private final int depth;

        private TPONode(@Nullable TPONode previous, DirectionalPathPoint pathPoint) {
            this.previous = previous;
            this.depth = previous != null ? previous.depth + 1 : 0;
            this.pathPoint = pathPoint;
            this.side = pathPoint.getPathSide();
        }

        private TPONode(TPONode previous, int depth, DirectionalPathPoint pathPoint) {
            this.previous = previous;
            this.depth = depth;
            this.pathPoint = pathPoint;
            this.side = pathPoint.getPathSide();
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this.pathPoint == null ? 0 : this.pathPoint.hashCode());
            result = 31 * result + (this.side == null ? 0 : this.side.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            TPONode other = (TPONode)obj;
            if (this.pathPoint == null ? other.pathPoint != null : !this.pathPoint.equals((Object)other.pathPoint)) {
                return false;
            }
            return this.side == other.side;
        }
    }
}

