/*
 * Decompiled with CFR 0.152.
 */
package win.demistorm.stormiespiders.client.config;

import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.Tooltip;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;
import win.demistorm.stormiespiders.Constants;
import win.demistorm.stormiespiders.config.ModConfig;

public final class ConfigScreen {
    private ConfigScreen() {
    }

    public static class SimpleToggleScreen
    extends Screen {
        private final Screen parent;
        private final Minecraft client = Minecraft.getInstance();
        private boolean preventClimbingInRainValue = ModConfig.Data.preventClimbingInRain();

        protected SimpleToggleScreen(Screen parent) {
            super((Component)Component.literal((String)"Stormie's Spiders Configuration"));
            this.parent = parent;
        }

        public static SimpleToggleScreen create(Screen parent) {
            return new SimpleToggleScreen(parent);
        }

        protected void init() {
            this.addRenderableWidget((GuiEventListener)Button.builder((Component)Component.literal((String)("Prevent Climbing in Rain: " + (this.preventClimbingInRainValue ? "ON" : "OFF"))), btn -> {
                this.preventClimbingInRainValue = !this.preventClimbingInRainValue;
                btn.setMessage((Component)Component.literal((String)("Prevent Climbing in Rain: " + (this.preventClimbingInRainValue ? "ON" : "OFF"))));
            }).bounds(this.width / 2 - 80, this.height / 4 + 24, 160, 20).tooltip(Tooltip.create((Component)Component.literal((String)"EXPERIMENTAL: When enabled, spiders will not climb on surfaces during rain"))).build());
            this.addRenderableWidget((GuiEventListener)Button.builder((Component)Component.literal((String)"Done"), btn -> {
                ModConfig.Data.setPreventClimbingInRain(this.preventClimbingInRainValue);
                Constants.LOG.info("Config saved: preventClimbingInRain = {}", (Object)this.preventClimbingInRainValue);
                this.client.setScreen(this.parent);
            }).bounds(this.width / 2 - 100, this.height - 27, 200, 20).build());
        }

        public void render(GuiGraphics context, int mouseX, int mouseY, float delta) {
            this.renderBackground(context, mouseX, mouseY, delta);
            super.render(context, mouseX, mouseY, delta);
            context.drawCenteredString(this.font, this.title, this.width / 2, 20, 0xFFFFFF);
        }
    }
}

