/*
 * Decompiled with CFR 0.152.
 */
package win.demistorm.stormiespiders.common.entity.movement;

import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.pathfinder.Path;
import win.demistorm.stormiespiders.common.entity.movement.AdvancedClimberPathNavigator;
import win.demistorm.stormiespiders.commonInit;

public class BetterSpiderPathNavigator<T extends Mob>
extends AdvancedClimberPathNavigator<T> {
    private boolean useVanillaBehaviour;
    private BlockPos targetPosition;

    public BetterSpiderPathNavigator(T entity, Level worldIn, boolean useVanillaBehaviour) {
        super(entity, worldIn, false, true, true);
        this.useVanillaBehaviour = useVanillaBehaviour;
    }

    @Override
    public Path createPath(BlockPos pos, int p_179680_2_) {
        this.targetPosition = pos;
        return super.createPath(pos, p_179680_2_);
    }

    @Override
    public Path createPath(Entity entityIn, int p_75494_2_) {
        this.targetPosition = entityIn.blockPosition();
        return super.createPath(entityIn, p_75494_2_);
    }

    public boolean moveTo(Entity entityIn, double speedIn) {
        Path path = this.createPath(entityIn, 0);
        if (path != null) {
            return this.moveTo(path, speedIn);
        }
        this.targetPosition = entityIn.blockPosition();
        this.speedModifier = speedIn;
        return true;
    }

    @Override
    public void tick() {
        if (!this.isDone()) {
            super.tick();
        } else if (this.targetPosition != null && this.useVanillaBehaviour) {
            if (!(this.targetPosition.closerThan((Vec3i)this.mob.blockPosition(), Math.max((double)this.mob.getBbWidth(), 1.0)) || this.mob.getY() > (double)this.targetPosition.getY() && commonInit.blockPos(this.targetPosition.getX(), this.mob.getY(), this.targetPosition.getZ()).closerThan((Vec3i)this.mob.blockPosition(), Math.max((double)this.mob.getBbWidth(), 1.0)))) {
                this.mob.getMoveControl().setWantedPosition((double)this.targetPosition.getX(), (double)this.targetPosition.getY(), (double)this.targetPosition.getZ(), this.speedModifier);
            } else {
                this.targetPosition = null;
            }
        }
    }
}

