/*
 * Decompiled with CFR 0.152.
 */
package win.demistorm.stormiespiders.common.entity.movement;

import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import net.minecraft.core.BlockPos;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.level.PathNavigationRegion;
import net.minecraft.world.level.pathfinder.BinaryHeap;
import net.minecraft.world.level.pathfinder.Node;
import net.minecraft.world.level.pathfinder.NodeEvaluator;
import net.minecraft.world.level.pathfinder.Path;
import net.minecraft.world.level.pathfinder.PathFinder;
import net.minecraft.world.level.pathfinder.Target;
import org.jetbrains.annotations.Nullable;

public class CustomPathFinder
extends PathFinder {
    private final BinaryHeap path = new BinaryHeap();
    private final Node[] pathOptions = new Node[32];
    private final NodeEvaluator nodeProcessor;
    private int maxExpansions = 200;
    public static final Heuristic DEFAULT_HEURISTIC = (start, end, isTargetHeuristic) -> start.distanceManhattan(end);
    private Heuristic heuristic = DEFAULT_HEURISTIC;

    public CustomPathFinder(NodeEvaluator processor, int maxExpansions) {
        super(processor, maxExpansions);
        this.nodeProcessor = processor;
        this.maxExpansions = maxExpansions;
    }

    public NodeEvaluator getNodeProcessor() {
        return this.nodeProcessor;
    }

    public CustomPathFinder setMaxExpansions(int expansions) {
        this.maxExpansions = expansions;
        return this;
    }

    public CustomPathFinder setHeuristic(Heuristic heuristic) {
        this.heuristic = heuristic;
        return this;
    }

    @Nullable
    public Path findPath(PathNavigationRegion region, Mob entity, Set<BlockPos> checkpoints, float maxDistance, int checkpointRange, float maxExpansionsMultiplier) {
        this.path.clear();
        this.nodeProcessor.prepare(region, entity);
        Node pathpoint = this.nodeProcessor.getStart();
        Map<Target, BlockPos> checkpointsMap = checkpoints.stream().collect(Collectors.toMap(pos -> this.nodeProcessor.getTarget((double)pos.getX(), (double)pos.getY(), (double)pos.getZ()), Function.identity()));
        Path path = this.findPath(pathpoint, checkpointsMap, maxDistance, checkpointRange, maxExpansionsMultiplier);
        this.nodeProcessor.done();
        return path;
    }

    @Nullable
    private Path findPath(Node start, Map<Target, BlockPos> checkpointsMap, float maxDistance, int checkpointRange, float maxExpansionsMultiplier) {
        Set<Target> checkpoints = checkpointsMap.keySet();
        start.g = 0.0f;
        start.f = start.h = this.computeHeuristic(start, checkpoints);
        this.path.clear();
        this.path.insert(start);
        HashSet reachedCheckpoints = Sets.newHashSetWithExpectedSize((int)checkpoints.size());
        int expansions = 0;
        int maxExpansions = (int)((float)this.maxExpansions * maxExpansionsMultiplier);
        while (!this.path.isEmpty() && ++expansions < maxExpansions) {
            Node openPathPoint = this.path.pop();
            openPathPoint.closed = true;
            for (Target checkpoint2 : checkpoints) {
                if (!(openPathPoint.distanceManhattan((Node)checkpoint2) <= (float)checkpointRange)) continue;
                checkpoint2.setReached();
                reachedCheckpoints.add(checkpoint2);
            }
            if (!reachedCheckpoints.isEmpty()) break;
            if (!(openPathPoint.distanceTo(start) < maxDistance)) continue;
            int numOptions = this.nodeProcessor.getNeighbors(this.pathOptions, openPathPoint);
            for (int i = 0; i < numOptions; ++i) {
                Node successorPathPoint = this.pathOptions[i];
                float costHeuristic = openPathPoint.distanceTo(successorPathPoint);
                successorPathPoint.walkedDistance = openPathPoint.walkedDistance + costHeuristic;
                float totalSuccessorPathCost = openPathPoint.g + costHeuristic + successorPathPoint.costMalus;
                if (!(successorPathPoint.walkedDistance < maxDistance) || successorPathPoint.inOpenSet() && !(totalSuccessorPathCost < successorPathPoint.g)) continue;
                successorPathPoint.cameFrom = openPathPoint;
                successorPathPoint.g = totalSuccessorPathCost;
                successorPathPoint.h = this.computeHeuristic(successorPathPoint, checkpoints) * 1.0f;
                if (successorPathPoint.inOpenSet()) {
                    this.path.changeCost(successorPathPoint, successorPathPoint.g + successorPathPoint.h);
                    continue;
                }
                successorPathPoint.f = successorPathPoint.g + successorPathPoint.h;
                this.path.insert(successorPathPoint);
            }
        }
        Optional<Path> path = !reachedCheckpoints.isEmpty() ? reachedCheckpoints.stream().map(checkpoint -> this.createPath(checkpoint.getBestNode(), (BlockPos)checkpointsMap.get(checkpoint), true)).min(Comparator.comparingInt(Path::getNodeCount)) : checkpoints.stream().map(checkpoint -> this.createPath(checkpoint.getBestNode(), (BlockPos)checkpointsMap.get(checkpoint), false)).min(Comparator.comparingDouble(Path::getDistToTarget).thenComparingInt(Path::getNodeCount));
        return !path.isPresent() ? null : path.get();
    }

    private float computeHeuristic(Node pathPoint, Set<Target> checkpoints) {
        float minDst = Float.MAX_VALUE;
        for (Target checkpoint : checkpoints) {
            float dst = pathPoint.distanceTo((Node)checkpoint);
            checkpoint.updateBest(dst, pathPoint);
            minDst = Math.min(dst, minDst);
        }
        return minDst;
    }

    protected Path createPath(Node start, BlockPos target, boolean isTargetReached) {
        ArrayList points = Lists.newArrayList();
        Node currentPathPoint = start;
        points.add(0, start);
        while (currentPathPoint.cameFrom != null) {
            currentPathPoint = currentPathPoint.cameFrom;
            points.add(0, currentPathPoint);
        }
        return new Path((List)points, target, isTargetReached);
    }

    public static interface Heuristic {
        public float compute(Node var1, Node var2, boolean var3);
    }
}

