/*
 * Decompiled with CFR 0.152.
 */
package win.demistorm.stormiespiders.mixin;

import java.lang.invoke.MethodHandles;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import net.minecraft.commands.arguments.EntityAnchorArgument;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Rotations;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ChunkMap;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.tags.BlockTags;
import net.minecraft.util.Mth;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MoverType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.attributes.AttributeInstance;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.navigation.PathNavigation;
import net.minecraft.world.entity.monster.Spider;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.CollisionGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.FenceGateBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.border.WorldBorder;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.pathfinder.Node;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.apache.commons.lang3.tuple.Pair;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.Redirect;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;
import win.demistorm.stormiespiders.common.CollisionSmoothingUtil;
import win.demistorm.stormiespiders.common.Matrix4f;
import win.demistorm.stormiespiders.common.entity.mob.IClimberEntity;
import win.demistorm.stormiespiders.common.entity.mob.IEntityMovementHook;
import win.demistorm.stormiespiders.common.entity.mob.IEntityReadWriteHook;
import win.demistorm.stormiespiders.common.entity.mob.ILivingEntityDataManagerHook;
import win.demistorm.stormiespiders.common.entity.mob.ILivingEntityJumpHook;
import win.demistorm.stormiespiders.common.entity.mob.ILivingEntityLookAtHook;
import win.demistorm.stormiespiders.common.entity.mob.ILivingEntityRotationHook;
import win.demistorm.stormiespiders.common.entity.mob.ILivingEntityTravelHook;
import win.demistorm.stormiespiders.common.entity.mob.IMobEntityLivingTickHook;
import win.demistorm.stormiespiders.common.entity.mob.IMobEntityTickHook;
import win.demistorm.stormiespiders.common.entity.mob.Orientation;
import win.demistorm.stormiespiders.common.entity.movement.BetterSpiderPathNavigator;
import win.demistorm.stormiespiders.common.entity.movement.ClimberJumpController;
import win.demistorm.stormiespiders.common.entity.movement.ClimberLookController;
import win.demistorm.stormiespiders.common.entity.movement.ClimberMoveController;
import win.demistorm.stormiespiders.config.Config;

@Mixin(value={Spider.class})
public abstract class ClimberEntityMixin
extends PathfinderMob
implements IClimberEntity,
IMobEntityLivingTickHook,
ILivingEntityLookAtHook,
IMobEntityTickHook,
ILivingEntityRotationHook,
ILivingEntityDataManagerHook,
ILivingEntityTravelHook,
IEntityMovementHook,
IEntityReadWriteHook,
ILivingEntityJumpHook {
    private static final UUID SLOW_FALLING_ID = UUID.fromString("A5B6CF2A-2F7C-31EF-9022-7C3E7D5E6ABA");
    private static final AttributeModifier SLOW_FALLING = new AttributeModifier(ResourceLocation.fromNamespaceAndPath((String)"stormiespiders", (String)"slow_falling"), -0.07, AttributeModifier.Operation.ADD_VALUE);
    private static final EntityDataAccessor<Rotations> ROTATION_BODY;
    private static final EntityDataAccessor<Rotations> ROTATION_HEAD;
    private double prevAttachmentOffsetX;
    private double prevAttachmentOffsetY;
    private double prevAttachmentOffsetZ;
    private double attachmentOffsetX;
    private double attachmentOffsetY;
    private double attachmentOffsetZ;
    private Vec3 attachmentNormal = new Vec3(0.0, 1.0, 0.0);
    private Vec3 prevAttachmentNormal = new Vec3(0.0, 1.0, 0.0);
    private float prevOrientationYawDelta;
    private float orientationYawDelta;
    private double lastAttachmentOffsetX;
    private double lastAttachmentOffsetY;
    private double lastAttachmentOffsetZ;
    private Vec3 lastAttachmentOrientationNormal = new Vec3(0.0, 1.0, 0.0);
    private int attachedTicks = 5;
    private Vec3 attachedSides = new Vec3(0.0, 0.0, 0.0);
    private Vec3 prevAttachedSides = new Vec3(0.0, 0.0, 0.0);
    private boolean canClimbInWater = false;
    private boolean canClimbInLava = false;
    private boolean isTravelingInFluid = false;
    private float collisionsInclusionRange = 2.0f;
    private float collisionsSmoothingRange = 1.25f;
    private Orientation orientation;
    private Pair<Direction, Vec3> groundDirection = Pair.of((Object)Direction.DOWN, (Object)new Vec3(0.0, -1.0, 0.0));
    private Orientation renderOrientation;
    private float nextStepDistance;
    private float nextFlap;
    private Vec3 preWalkingPosition;
    private double preMoveY;
    private Vec3 jumpDir;
    private boolean isJumping = false;

    private ClimberEntityMixin(EntityType<? extends PathfinderMob> type, Level worldIn) {
        super(type, worldIn);
    }

    @Inject(method={"<init>*"}, at={@At(value="RETURN")})
    private void onConstructed(CallbackInfo ci) {
        this.orientation = this.calculateOrientation(1.0f);
        this.groundDirection = this.getGroundDirection();
        this.moveControl = new ClimberMoveController<ClimberEntityMixin>(this);
        this.lookControl = new ClimberLookController<ClimberEntityMixin>(this);
        this.jumpControl = new ClimberJumpController<ClimberEntityMixin>(this);
    }

    @Inject(method={"createNavigation(Lnet/minecraft/world/level/Level;)Lnet/minecraft/world/entity/ai/navigation/PathNavigation;"}, at={@At(value="HEAD")}, cancellable=true)
    private void onCreateNavigator(Level world, CallbackInfoReturnable<PathNavigation> ci) {
        BetterSpiderPathNavigator<ClimberEntityMixin> navigate = new BetterSpiderPathNavigator<ClimberEntityMixin>(this, world, false);
        navigate.setCanFloat(true);
        ci.setReturnValue(navigate);
    }

    @Redirect(method={"defineSynchedData(Lnet/minecraft/network/syncher/SynchedEntityData$Builder;)V"}, at=@At(value="INVOKE", target="Lnet/minecraft/network/syncher/SynchedEntityData$Builder;define(Lnet/minecraft/network/syncher/EntityDataAccessor;Ljava/lang/Object;)Lnet/minecraft/network/syncher/SynchedEntityData$Builder;", ordinal=0))
    public <T> SynchedEntityData.Builder onDefineData(SynchedEntityData.Builder builder, EntityDataAccessor<T> accessor, T value) {
        SynchedEntityData.Builder result = builder.define(accessor, value);
        builder.define(ROTATION_BODY, (Object)new Rotations(0.0f, 0.0f, 0.0f));
        builder.define(ROTATION_HEAD, (Object)new Rotations(0.0f, 0.0f, 0.0f));
        return result;
    }

    @Override
    public void onWrite(CompoundTag nbt) {
        nbt.putDouble("stormiespiders.AttachmentNormalX", this.attachmentNormal.x);
        nbt.putDouble("stormiespiders.AttachmentNormalY", this.attachmentNormal.y);
        nbt.putDouble("stormiespiders.AttachmentNormalZ", this.attachmentNormal.z);
        nbt.putInt("stormiespiders.AttachedTicks", this.attachedTicks);
    }

    @Override
    public void onRead(CompoundTag nbt) {
        this.prevAttachmentNormal = this.attachmentNormal = new Vec3(nbt.getDouble("stormiespiders.AttachmentNormalX"), nbt.getDouble("stormiespiders.AttachmentNormalY"), nbt.getDouble("stormiespiders.AttachmentNormalZ"));
        this.attachedTicks = nbt.getInt("stormiespiders.AttachedTicks");
        this.orientation = this.calculateOrientation(1.0f);
    }

    @Override
    public boolean canClimbInWater() {
        return this.canClimbInWater;
    }

    @Override
    public void setCanClimbInWater(boolean value) {
        this.canClimbInWater = value;
    }

    @Override
    public boolean canClimbInLava() {
        return this.canClimbInLava;
    }

    @Override
    public void setCanClimbInLava(boolean value) {
        this.canClimbInLava = value;
    }

    @Override
    public float getCollisionsInclusionRange() {
        return this.collisionsInclusionRange;
    }

    @Override
    public void setCollisionsInclusionRange(float range) {
        this.collisionsInclusionRange = range;
    }

    @Override
    public float getCollisionsSmoothingRange() {
        return this.collisionsSmoothingRange;
    }

    @Override
    public void setCollisionsSmoothingRange(float range) {
        this.collisionsSmoothingRange = range;
    }

    @Override
    public float getBridgePathingMalus(Mob entity, BlockPos pos, Node fallPathPoint) {
        return -1.0f;
    }

    @Override
    public void onPathingObstructed(Direction facing) {
    }

    public int getMaxFallDistance() {
        return 0;
    }

    @Override
    public float getMovementSpeed() {
        AttributeInstance attribute = this.getAttribute(Attributes.MOVEMENT_SPEED);
        return attribute != null ? (float)attribute.getValue() : 1.0f;
    }

    private static double calculateXOffset(AABB aabb, AABB other, double offsetX) {
        if (other.maxY > aabb.minY && other.minY < aabb.maxY && other.maxZ > aabb.minZ && other.minZ < aabb.maxZ) {
            double dx;
            if (offsetX > 0.0 && other.maxX <= aabb.minX) {
                double dx2 = aabb.minX - other.maxX;
                if (dx2 < offsetX) {
                    offsetX = dx2;
                }
            } else if (offsetX < 0.0 && other.minX >= aabb.maxX && (dx = aabb.maxX - other.minX) > offsetX) {
                offsetX = dx;
            }
            return offsetX;
        }
        return offsetX;
    }

    private static double calculateYOffset(AABB aabb, AABB other, double offsetY) {
        if (other.maxX > aabb.minX && other.minX < aabb.maxX && other.maxZ > aabb.minZ && other.minZ < aabb.maxZ) {
            double dy;
            if (offsetY > 0.0 && other.maxY <= aabb.minY) {
                double dy2 = aabb.minY - other.maxY;
                if (dy2 < offsetY) {
                    offsetY = dy2;
                }
            } else if (offsetY < 0.0 && other.minY >= aabb.maxY && (dy = aabb.maxY - other.minY) > offsetY) {
                offsetY = dy;
            }
            return offsetY;
        }
        return offsetY;
    }

    private static double calculateZOffset(AABB aabb, AABB other, double offsetZ) {
        if (other.maxX > aabb.minX && other.minX < aabb.maxX && other.maxY > aabb.minY && other.minY < aabb.maxY) {
            double dz;
            if (offsetZ > 0.0 && other.maxZ <= aabb.minZ) {
                double dz2 = aabb.minZ - other.maxZ;
                if (dz2 < offsetZ) {
                    offsetZ = dz2;
                }
            } else if (offsetZ < 0.0 && other.minZ >= aabb.maxZ && (dz = aabb.maxZ - other.minZ) > offsetZ) {
                offsetZ = dz;
            }
            return offsetZ;
        }
        return offsetZ;
    }

    private void updateWalkingSide() {
        Object avoidPathingFacing = null;
        AABB entityBox = this.getBoundingBox();
        double closestFacingDst = Double.MAX_VALUE;
        Direction closestFacing = null;
        Vec3 weighting = new Vec3(0.0, 0.0, 0.0);
        float stickingDistance = this.zza != 0.0f ? 1.5f : 0.1f;
        for (Direction facing : Direction.values()) {
            if (avoidPathingFacing == facing) continue;
            List<AABB> collisionBoxes = this.getCollisionBoxes(entityBox.inflate((double)0.2f).expandTowards((double)((float)facing.getStepX() * stickingDistance), (double)((float)facing.getStepY() * stickingDistance), (double)((float)facing.getStepZ() * stickingDistance)));
            double closestDst = Double.MAX_VALUE;
            for (AABB collisionBox : collisionBoxes) {
                switch (facing) {
                    case EAST: 
                    case WEST: {
                        closestDst = Math.min(closestDst, Math.abs(ClimberEntityMixin.calculateXOffset(entityBox, collisionBox, (float)(-facing.getStepX()) * stickingDistance)));
                        break;
                    }
                    case UP: 
                    case DOWN: {
                        closestDst = Math.min(closestDst, Math.abs(ClimberEntityMixin.calculateYOffset(entityBox, collisionBox, (float)(-facing.getStepY()) * stickingDistance)));
                        break;
                    }
                    case NORTH: 
                    case SOUTH: {
                        closestDst = Math.min(closestDst, Math.abs(ClimberEntityMixin.calculateZOffset(entityBox, collisionBox, (float)(-facing.getStepZ()) * stickingDistance)));
                    }
                }
            }
            if (closestDst < closestFacingDst) {
                closestFacingDst = closestDst;
                closestFacing = facing;
            }
            if (!(closestDst < Double.MAX_VALUE)) continue;
            weighting = weighting.add(new Vec3((double)facing.getStepX(), (double)facing.getStepY(), (double)facing.getStepZ()).scale(1.0 - Math.min(closestDst, (double)stickingDistance) / (double)stickingDistance));
        }
        this.groundDirection = closestFacing == null ? Pair.of((Object)Direction.DOWN, (Object)new Vec3(0.0, -1.0, 0.0)) : Pair.of(closestFacing, (Object)weighting.normalize().add(0.0, (double)-0.001f, 0.0).normalize());
    }

    @Override
    public Pair<Direction, Vec3> getGroundDirection() {
        return this.groundDirection;
    }

    @Override
    public Direction getGroundSide() {
        return (Direction)this.groundDirection.getKey();
    }

    @Override
    public Orientation getOrientation() {
        return this.orientation;
    }

    @Override
    public void setRenderOrientation(Orientation orientation) {
        this.renderOrientation = orientation;
    }

    @Override
    public Orientation getRenderOrientation() {
        return this.renderOrientation;
    }

    @Override
    public float getAttachmentOffset(Direction.Axis axis, float partialTicks) {
        switch (axis) {
            default: {
                return (float)(this.prevAttachmentOffsetX + (this.attachmentOffsetX - this.prevAttachmentOffsetX) * (double)partialTicks);
            }
            case Y: {
                return (float)(this.prevAttachmentOffsetY + (this.attachmentOffsetY - this.prevAttachmentOffsetY) * (double)partialTicks);
            }
            case Z: 
        }
        return (float)(this.prevAttachmentOffsetZ + (this.attachmentOffsetZ - this.prevAttachmentOffsetZ) * (double)partialTicks);
    }

    @Override
    public Vec3 onLookAt(EntityAnchorArgument.Anchor anchor, Vec3 vec) {
        Vec3 dir = vec.subtract(this.position());
        dir = this.getOrientation().getLocal(dir);
        return dir;
    }

    @Override
    public void onTick() {
        ChunkMap.TrackedEntity entityTracker;
        if (!this.level().isClientSide && this.level() instanceof ServerLevel && (entityTracker = (ChunkMap.TrackedEntity)((ServerLevel)this.level()).getChunkSource().chunkMap.entityMap.get(this.getId())) != null && entityTracker.serverEntity.tickCount % entityTracker.serverEntity.updateInterval == 0) {
            Orientation orientation = this.getOrientation();
            Vec3 look = orientation.getGlobal(this.getYRot(), this.getXRot());
            this.entityData.set(ROTATION_BODY, (Object)new Rotations((float)look.x, (float)look.y, (float)look.z));
            look = orientation.getGlobal(this.yHeadRot, 0.0f);
            this.entityData.set(ROTATION_HEAD, (Object)new Rotations((float)look.x, (float)look.y, (float)look.z));
        }
    }

    @Override
    public void onLivingTick() {
        this.updateWalkingSide();
    }

    public boolean onClimbable() {
        return true;
    }

    @Override
    public float getVerticalOffset(float partialTicks) {
        return 0.075f;
    }

    private void forEachCollisonBox(AABB aabb, Shapes.DoubleLineConsumer action) {
        int minChunkX = Mth.floor((double)(aabb.minX - 1.0E-7)) - 1 >> 4;
        int maxChunkX = Mth.floor((double)(aabb.maxX + 1.0E-7)) + 1 >> 4;
        int minChunkZ = Mth.floor((double)(aabb.minZ - 1.0E-7)) - 1 >> 4;
        int maxChunkZ = Mth.floor((double)(aabb.maxZ + 1.0E-7)) + 1 >> 4;
        int width = maxChunkX - minChunkX + 1;
        int depth = maxChunkZ - minChunkZ + 1;
        BlockGetter[] blockReaderCache = new BlockGetter[width * depth];
        Level collisionReader = this.level();
        for (int cx = minChunkX; cx <= maxChunkX; ++cx) {
            for (int cz = minChunkZ; cz <= maxChunkZ; ++cz) {
                blockReaderCache[cx - minChunkX + (cz - minChunkZ) * width] = collisionReader.getChunkForCollisions(cx, cz);
            }
        }
        CollisionGetter cachedCollisionReader = new CollisionGetter(){
            final /* synthetic */ CollisionGetter val$collisionReader;
            final /* synthetic */ BlockGetter[] val$blockReaderCache;
            final /* synthetic */ int val$minChunkX;
            final /* synthetic */ int val$minChunkZ;
            final /* synthetic */ int val$width;
            {
                this.val$collisionReader = collisionGetter;
                this.val$blockReaderCache = blockGetterArray;
                this.val$minChunkX = n;
                this.val$minChunkZ = n2;
                this.val$width = n3;
            }

            public int getHeight() {
                return ClimberEntityMixin.this.level().getHeight();
            }

            public int getMinY() {
                return ClimberEntityMixin.this.level().getMinY();
            }

            public BlockEntity getBlockEntity(BlockPos pos) {
                return this.val$collisionReader.getBlockEntity(pos);
            }

            public BlockState getBlockState(BlockPos pos) {
                return this.val$collisionReader.getBlockState(pos);
            }

            public FluidState getFluidState(BlockPos pos) {
                return this.val$collisionReader.getFluidState(pos);
            }

            public WorldBorder getWorldBorder() {
                return this.val$collisionReader.getWorldBorder();
            }

            public List<VoxelShape> getEntityCollisions(Entity entity, AABB aabb) {
                return this.val$collisionReader.getEntityCollisions(entity, aabb);
            }

            public BlockGetter getChunkForCollisions(int chunkX, int chunkZ) {
                return this.val$blockReaderCache[chunkX - this.val$minChunkX + (chunkZ - this.val$minChunkZ) * this.val$width];
            }
        };
        Iterable shapes = cachedCollisionReader.getBlockCollisions((Entity)this, aabb);
        shapes.forEach(shape -> shape.forAllBoxes(action));
    }

    private List<AABB> getCollisionBoxes(AABB aabb) {
        ArrayList<AABB> boxes = new ArrayList<AABB>();
        this.forEachCollisonBox(aabb, (minX, minY, minZ, maxX, maxY, maxZ) -> boxes.add(new AABB(minX, minY, minZ, maxX, maxY, maxZ)));
        return boxes;
    }

    @Override
    public boolean canClimbOnBlock(BlockState state, BlockPos pos) {
        return !Config.COMMON.preventClimbingInRain() || !this.level().isRaining() || !this.level().isRainingAt(pos);
    }

    @Override
    public boolean canAttachToSide(Direction side) {
        return this.isJumping || !Config.COMMON.preventClimbingInRain() || side.getAxis() == Direction.Axis.Y || !this.level().isRainingAt(new BlockPos((int)this.getX(), (int)(this.getY() + (double)(this.getBbHeight() * 0.5f)), (int)this.getZ()));
    }

    @Override
    public float getBlockSlipperiness(BlockPos pos) {
        BlockState offsetState = this.level().getBlockState(pos);
        return offsetState.getBlock().getFriction() * 0.91f;
    }

    private void updateOffsetsAndOrientation() {
        Vec3 direction = this.getOrientation().getGlobal(this.getYRot(), this.getXRot());
        boolean isAttached = false;
        double baseStickingOffsetX = 0.0;
        double baseStickingOffsetY = this.getVerticalOffset(1.0f);
        double baseStickingOffsetZ = 0.0;
        Vec3 baseOrientationNormal = new Vec3(0.0, 1.0, 0.0);
        if (Config.COMMON.preventClimbingInRain() && this.level().isRaining() && this.level().isRainingAt(new BlockPos((int)this.getX(), (int)(this.getY() + (double)(this.getBbHeight() * 0.5f)), (int)this.getZ()))) {
            isAttached = false;
        } else if (!this.isTravelingInFluid && this.onGround() && this.getVehicle() == null) {
            Vec3 p = this.position();
            Vec3 s = p.add(0.0, (double)(this.getBbHeight() * 0.5f), 0.0);
            AABB inclusionBox = new AABB(s.x, s.y, s.z, s.x, s.y, s.z).inflate((double)this.collisionsInclusionRange);
            Pair<Vec3, Vec3> attachmentPoint = CollisionSmoothingUtil.findClosestPoint(consumer -> this.forEachCollisonBox(inclusionBox, (Shapes.DoubleLineConsumer)consumer), s, this.attachmentNormal.scale(-1.0), this.collisionsSmoothingRange, 1.0f, 0.001f, 20, 0.05f, s);
            AABB entityBox = this.getBoundingBox();
            if (attachmentPoint != null) {
                double dz;
                double dy;
                Vec3 attachmentPos = (Vec3)attachmentPoint.getLeft();
                double dx = Math.max(entityBox.minX - attachmentPos.x, attachmentPos.x - entityBox.maxX);
                if (Math.max(dx, Math.max(dy = Math.max(entityBox.minY - attachmentPos.y, attachmentPos.y - entityBox.maxY), dz = Math.max(entityBox.minZ - attachmentPos.z, attachmentPos.z - entityBox.maxZ))) < 0.5) {
                    isAttached = true;
                    this.lastAttachmentOffsetX = Mth.clamp((double)(attachmentPos.x - p.x), (double)(-this.getBbWidth() / 2.0f), (double)(this.getBbWidth() / 2.0f));
                    this.lastAttachmentOffsetY = Mth.clamp((double)(attachmentPos.y - p.y), (double)0.0, (double)this.getBbHeight());
                    this.lastAttachmentOffsetZ = Mth.clamp((double)(attachmentPos.z - p.z), (double)(-this.getBbWidth() / 2.0f), (double)(this.getBbWidth() / 2.0f));
                    this.lastAttachmentOrientationNormal = (Vec3)attachmentPoint.getRight();
                }
            }
        }
        this.prevAttachmentOffsetX = this.attachmentOffsetX;
        this.prevAttachmentOffsetY = this.attachmentOffsetY;
        this.prevAttachmentOffsetZ = this.attachmentOffsetZ;
        this.prevAttachmentNormal = this.attachmentNormal;
        float attachmentBlend = (float)this.attachedTicks * 0.2f;
        this.attachmentOffsetX = baseStickingOffsetX + (this.lastAttachmentOffsetX - baseStickingOffsetX) * (double)attachmentBlend;
        this.attachmentOffsetY = baseStickingOffsetY + (this.lastAttachmentOffsetY - baseStickingOffsetY) * (double)attachmentBlend;
        this.attachmentOffsetZ = baseStickingOffsetZ + (this.lastAttachmentOffsetZ - baseStickingOffsetZ) * (double)attachmentBlend;
        this.attachmentNormal = baseOrientationNormal.add(this.lastAttachmentOrientationNormal.subtract(baseOrientationNormal).scale((double)attachmentBlend)).normalize();
        this.attachedTicks = !isAttached ? Math.max(0, this.attachedTicks - 1) : Math.min(5, this.attachedTicks + 1);
        this.orientation = this.calculateOrientation(1.0f);
        Pair<Float, Float> newRotations = this.getOrientation().getLocalRotation(direction);
        float yawDelta = ((Float)newRotations.getLeft()).floatValue() - this.getYRot();
        float pitchDelta = ((Float)newRotations.getRight()).floatValue() - this.getXRot();
        this.prevOrientationYawDelta = this.orientationYawDelta;
        this.orientationYawDelta = yawDelta;
        this.yRot = Mth.wrapDegrees((float)(this.yRot + yawDelta));
        this.yRotO = this.wrapAngleInRange(this.yRotO, this.yRot);
        this.lerpYRot = Mth.wrapDegrees((double)(this.lerpYRot + (double)yawDelta));
        this.yBodyRot = Mth.wrapDegrees((float)(this.yBodyRot + yawDelta));
        this.yBodyRotO = this.wrapAngleInRange(this.yBodyRotO, this.yBodyRot);
        this.yHeadRot = Mth.wrapDegrees((float)(this.yHeadRot + yawDelta));
        this.yHeadRotO = this.wrapAngleInRange(this.yHeadRotO, this.yHeadRot);
        this.lerpYHeadRot = Mth.wrapDegrees((double)(this.lerpYHeadRot + (double)yawDelta));
        this.xRot = Mth.wrapDegrees((float)(this.xRot + pitchDelta));
        this.xRotO = this.wrapAngleInRange(this.xRotO, this.xRot);
        this.lerpXRot = Mth.wrapDegrees((double)(this.lerpXRot + (double)pitchDelta));
    }

    private float wrapAngleInRange(float angle, float target) {
        while (target - angle < -180.0f) {
            angle -= 360.0f;
        }
        while (target - angle >= 180.0f) {
            angle += 360.0f;
        }
        return angle;
    }

    @Override
    public Orientation calculateOrientation(float partialTicks) {
        Vec3 attachmentNormal = this.prevAttachmentNormal.add(this.attachmentNormal.subtract(this.prevAttachmentNormal).scale((double)partialTicks));
        Vec3 localZ = new Vec3(0.0, 0.0, 1.0);
        Vec3 localY = new Vec3(0.0, 1.0, 0.0);
        Vec3 localX = new Vec3(1.0, 0.0, 0.0);
        float componentZ = (float)localZ.dot(attachmentNormal);
        float componentX = (float)localX.dot(attachmentNormal);
        float yaw = (float)Math.toDegrees(Mth.atan2((double)componentX, (double)componentZ));
        localZ = new Vec3(Math.sin(Math.toRadians(yaw)), 0.0, Math.cos(Math.toRadians(yaw)));
        localY = new Vec3(0.0, 1.0, 0.0);
        localX = new Vec3(Math.sin(Math.toRadians(yaw - 90.0f)), 0.0, Math.cos(Math.toRadians(yaw - 90.0f)));
        componentZ = (float)localZ.dot(attachmentNormal);
        float componentY = (float)localY.dot(attachmentNormal);
        componentX = (float)localX.dot(attachmentNormal);
        float pitch = (float)Math.toDegrees(Mth.atan2((double)Mth.sqrt((float)(componentX * componentX + componentZ * componentZ)), (double)componentY));
        Matrix4f m = new Matrix4f();
        m.multiply(new Matrix4f((float)Math.toRadians(yaw), 0.0f, 1.0f, 0.0f));
        m.multiply(new Matrix4f((float)Math.toRadians(pitch), 1.0f, 0.0f, 0.0f));
        m.multiply(new Matrix4f((float)Math.toRadians(Math.signum(0.5f - componentY - componentZ - componentX) * yaw), 0.0f, 1.0f, 0.0f));
        localZ = m.multiply(new Vec3(0.0, 0.0, -1.0));
        localY = m.multiply(new Vec3(0.0, 1.0, 0.0));
        localX = m.multiply(new Vec3(1.0, 0.0, 0.0));
        return new Orientation(attachmentNormal, localZ, localY, localX, componentZ, componentY, componentX, yaw, pitch);
    }

    @Override
    public float getTargetYaw(double x, double y, double z, float yaw, float pitch, int posRotationIncrements) {
        return (float)this.lerpYRot;
    }

    @Override
    public float getTargetPitch(double x, double y, double z, float yaw, float pitch, int posRotationIncrements) {
        return (float)this.lerpXRot;
    }

    @Override
    public float getTargetHeadYaw(float yaw, int rotationIncrements) {
        return (float)this.lerpYHeadRot;
    }

    @Override
    public void onNotifyDataManagerChange(EntityDataAccessor<?> key) {
        if (ROTATION_BODY.equals(key)) {
            Rotations rotation = (Rotations)this.entityData.get(ROTATION_BODY);
            Vec3 look = new Vec3((double)rotation.getX(), (double)rotation.getY(), (double)rotation.getZ());
            Pair<Float, Float> rotations = this.getOrientation().getLocalRotation(look);
            this.lerpYRot = ((Float)rotations.getLeft()).floatValue();
            this.lerpXRot = ((Float)rotations.getRight()).floatValue();
        } else if (ROTATION_HEAD.equals(key)) {
            Rotations rotation = (Rotations)this.entityData.get(ROTATION_HEAD);
            Vec3 look = new Vec3((double)rotation.getX(), (double)rotation.getY(), (double)rotation.getZ());
            Pair<Float, Float> rotations = this.getOrientation().getLocalRotation(look);
            this.lerpYHeadRot = ((Float)rotations.getLeft()).floatValue();
            this.lerpHeadSteps = 3;
        }
    }

    private double getClimberGravity() {
        boolean isFalling;
        if (this.isNoGravity()) {
            return 0.0;
        }
        double gravity = 0.08;
        boolean bl = isFalling = this.getDeltaMovement().y <= 0.0;
        if (isFalling && this.hasEffect(MobEffects.SLOW_FALLING)) {
            gravity = 0.1;
        }
        return gravity;
    }

    private Vec3 getStickingForce(Pair<Direction, Vec3> walkingSide) {
        double uprightness = Math.max(this.attachmentNormal.y, 0.0);
        double gravity = this.getClimberGravity();
        double stickingForce = gravity * uprightness + 0.08 * (1.0 - uprightness);
        return ((Vec3)walkingSide.getRight()).scale(stickingForce);
    }

    @Override
    public void setJumpDirection(Vec3 dir) {
        this.jumpDir = dir != null ? dir.normalize() : null;
    }

    @Override
    public void setJumping(boolean jumping) {
        this.isJumping = jumping;
    }

    @Override
    public boolean onJump() {
        this.isJumping = true;
        if (this.jumpDir != null) {
            float jumpStrength = this.getJumpPower();
            if (this.hasEffect(MobEffects.JUMP)) {
                jumpStrength += 0.1f * (float)(this.getEffect(MobEffects.JUMP).getAmplifier() + 1);
            }
            Vec3 motion = this.getDeltaMovement();
            Vec3 orthogonalMotion = this.jumpDir.scale(this.jumpDir.dot(motion));
            Vec3 tangentialMotion = motion.subtract(orthogonalMotion);
            this.setDeltaMovement(tangentialMotion.x + this.jumpDir.x * (double)jumpStrength, tangentialMotion.y + this.jumpDir.y * (double)jumpStrength, tangentialMotion.z + this.jumpDir.z * (double)jumpStrength);
            if (this.isSprinting()) {
                Vec3 boost = this.getOrientation().getGlobal(this.yRot, 0.0f).scale((double)0.2f);
                this.setDeltaMovement(this.getDeltaMovement().add(boost));
            }
            this.hasImpulse = true;
            return true;
        }
        return false;
    }

    @Override
    public boolean onTravel(Vec3 relative, boolean pre) {
        if (pre) {
            boolean canTravel = this.isEffectiveAi() || this.isControlledByLocalInstance();
            this.isTravelingInFluid = false;
            FluidState fluidState = this.level().getFluidState(this.blockPosition());
            if (!this.canClimbInWater && this.isInWater() && this.isAffectedByFluids() && !this.canStandOnFluid(fluidState)) {
                this.isTravelingInFluid = true;
                if (canTravel) {
                    return false;
                }
            } else if (!this.canClimbInLava && this.isInLava() && this.isAffectedByFluids() && !this.canStandOnFluid(fluidState)) {
                this.isTravelingInFluid = true;
                if (canTravel) {
                    return false;
                }
            } else if (canTravel) {
                this.travelOnGround(relative);
            }
            if (!canTravel) {
                this.calculateEntityAnimation(true);
            }
            this.updateOffsetsAndOrientation();
            return true;
        }
        this.updateOffsetsAndOrientation();
        return false;
    }

    private float getRelevantMoveFactor(float slipperiness) {
        return this.onGround() ? this.getSpeed() * (0.16277136f / (slipperiness * slipperiness * slipperiness)) : this.getFlyingSpeed();
    }

    private void travelOnGround(Vec3 relative) {
        boolean detachedZ;
        boolean isFalling;
        Orientation orientation = this.getOrientation();
        Vec3 forwardVector = orientation.getGlobal(this.yRot, 0.0f);
        Vec3 strafeVector = orientation.getGlobal(this.yRot + 90.0f, 0.0f);
        Vec3 upVector = orientation.getGlobal(this.yRot, -90.0f);
        Pair<Direction, Vec3> groundDirection = this.getGroundDirection();
        Vec3 stickingForce = this.getStickingForce(groundDirection);
        boolean bl = isFalling = this.getDeltaMovement().y <= 0.0;
        if (isFalling && this.hasEffect(MobEffects.SLOW_FALLING)) {
            this.fallDistance = 0.0f;
        }
        float forward = (float)relative.z;
        float strafe = (float)relative.x;
        if (forward != 0.0f || strafe != 0.0f) {
            float f;
            float slipperiness = 0.91f;
            if (this.onGround()) {
                BlockPos offsetPos = new BlockPos((Vec3i)this.blockPosition()).relative((Direction)groundDirection.getLeft());
                slipperiness = this.getBlockSlipperiness(offsetPos);
            }
            if ((f = forward * forward + strafe * strafe) >= 1.0E-4f) {
                boolean isInnerCorner;
                f = Math.max(Mth.sqrt((float)f), 1.0f);
                f = this.getRelevantMoveFactor(slipperiness) / f;
                Vec3 movementOffset = new Vec3(forwardVector.x * (double)(forward *= f) + strafeVector.x * (double)(strafe *= f), forwardVector.y * (double)forward + strafeVector.y * (double)strafe, forwardVector.z * (double)forward + strafeVector.z * (double)strafe);
                double px = this.getX();
                double py = this.getY();
                double pz = this.getZ();
                Vec3 motion = this.getDeltaMovement();
                AABB aabb = this.getBoundingBox();
                this.move(MoverType.SELF, movementOffset);
                Vec3 movementDir = new Vec3(this.getX() - px, this.getY() - py, this.getZ() - pz).normalize();
                this.setBoundingBox(aabb);
                this.setLocationFromBoundingbox();
                this.setDeltaMovement(motion);
                Vec3 probeVector = new Vec3(Math.abs(movementDir.x) < 0.001 ? -Math.signum(upVector.x) : 0.0, Math.abs(movementDir.y) < 0.001 ? -Math.signum(upVector.y) : 0.0, Math.abs(movementDir.z) < 0.001 ? -Math.signum(upVector.z) : 0.0).normalize().scale(1.0E-4);
                this.move(MoverType.SELF, probeVector);
                Vec3 collisionNormal = new Vec3(Math.abs(this.getX() - px - probeVector.x) > 1.0E-6 ? Math.signum(-probeVector.x) : 0.0, Math.abs(this.getY() - py - probeVector.y) > 1.0E-6 ? Math.signum(-probeVector.y) : 0.0, Math.abs(this.getZ() - pz - probeVector.z) > 1.0E-6 ? Math.signum(-probeVector.z) : 0.0).normalize();
                this.setBoundingBox(aabb);
                this.setLocationFromBoundingbox();
                this.setDeltaMovement(motion);
                Vec3 surfaceMovementDir = movementDir.subtract(collisionNormal.scale(collisionNormal.dot(movementDir))).normalize();
                boolean bl2 = isInnerCorner = Math.abs(collisionNormal.x) + Math.abs(collisionNormal.y) + Math.abs(collisionNormal.z) > (double)1.0001f;
                if (!isInnerCorner) {
                    movementDir = surfaceMovementDir;
                }
                stickingForce = stickingForce.subtract(surfaceMovementDir.scale(surfaceMovementDir.normalize().dot(stickingForce)));
                float moveSpeed = Mth.sqrt((float)(forward * forward + strafe * strafe));
                this.setDeltaMovement(this.getDeltaMovement().add(movementDir.scale((double)moveSpeed)));
            }
        }
        this.setDeltaMovement(this.getDeltaMovement().add(stickingForce));
        double px = this.getX();
        double py = this.getY();
        double pz = this.getZ();
        Vec3 motion = this.getDeltaMovement();
        this.move(MoverType.SELF, motion);
        this.prevAttachedSides = this.attachedSides;
        this.attachedSides = new Vec3(Math.abs(this.getX() - px - motion.x) > 0.001 ? -Math.signum(motion.x) : 0.0, Math.abs(this.getY() - py - motion.y) > 0.001 ? -Math.signum(motion.y) : 0.0, Math.abs(this.getZ() - pz - motion.z) > 0.001 ? -Math.signum(motion.z) : 0.0);
        float slipperiness = 0.91f;
        if (this.onGround()) {
            this.fallDistance = 0.0f;
            BlockPos offsetPos = new BlockPos((Vec3i)this.blockPosition()).relative((Direction)groundDirection.getLeft());
            slipperiness = this.getBlockSlipperiness(offsetPos);
        }
        motion = this.getDeltaMovement();
        Vec3 orthogonalMotion = upVector.scale(upVector.dot(motion));
        Vec3 tangentialMotion = motion.subtract(orthogonalMotion);
        this.setDeltaMovement(tangentialMotion.x * (double)slipperiness + orthogonalMotion.x * (double)0.98f, tangentialMotion.y * (double)slipperiness + orthogonalMotion.y * (double)0.98f, tangentialMotion.z * (double)slipperiness + orthogonalMotion.z * (double)0.98f);
        boolean detachedX = this.attachedSides.x != this.prevAttachedSides.x && Math.abs(this.attachedSides.x) < 0.001;
        boolean detachedY = this.attachedSides.y != this.prevAttachedSides.y && Math.abs(this.attachedSides.y) < 0.001;
        boolean bl3 = detachedZ = this.attachedSides.z != this.prevAttachedSides.z && Math.abs(this.attachedSides.z) < 0.001;
        if (detachedX || detachedY || detachedZ) {
            float stepHeight = this.maxUpStep();
            boolean prevOnGround = this.onGround();
            boolean prevCollidedHorizontally = this.horizontalCollision;
            boolean prevCollidedVertically = this.verticalCollision;
            this.move(MoverType.SELF, new Vec3(detachedX ? -this.prevAttachedSides.x * 0.25 : 0.0, detachedY ? -this.prevAttachedSides.y * 0.25 : 0.0, detachedZ ? -this.prevAttachedSides.z * 0.25 : 0.0));
            Vec3 axis = this.prevAttachedSides.normalize();
            Vec3 attachVector = upVector.scale(-1.0);
            attachVector = attachVector.subtract(axis.scale(axis.dot(attachVector)));
            attachVector = Math.abs(attachVector.x) > Math.abs(attachVector.y) && Math.abs(attachVector.x) > Math.abs(attachVector.z) ? new Vec3(Math.signum(attachVector.x), 0.0, 0.0) : (Math.abs(attachVector.y) > Math.abs(attachVector.z) ? new Vec3(0.0, Math.signum(attachVector.y), 0.0) : new Vec3(0.0, 0.0, Math.signum(attachVector.z)));
            double attachDst = motion.length() + (double)0.1f;
            AABB aabb = this.getBoundingBox();
            motion = this.getDeltaMovement();
            for (int i = 0; i < 2 && !this.onGround(); ++i) {
                this.move(MoverType.SELF, attachVector.scale(attachDst));
            }
            if (!this.onGround()) {
                this.setBoundingBox(aabb);
                this.setLocationFromBoundingbox();
                this.setDeltaMovement(motion);
                this.setOnGround(prevOnGround);
                this.horizontalCollision = prevCollidedHorizontally;
                this.verticalCollision = prevCollidedVertically;
            } else {
                this.setDeltaMovement(Vec3.ZERO);
            }
        }
        this.calculateEntityAnimation(true);
    }

    @Override
    public boolean onMove(MoverType type, Vec3 pos, boolean pre) {
        if (pre) {
            this.preWalkingPosition = this.position();
            this.preMoveY = this.getY();
        } else {
            if (Math.abs(this.getY() - this.preMoveY - pos.y) > 1.0E-6) {
                this.setDeltaMovement(this.getDeltaMovement().multiply(1.0, 0.0, 1.0));
            }
            this.setOnGround(this.horizontalCollision || this.verticalCollision);
        }
        return false;
    }

    @Override
    public BlockPos getAdjustedOnPosition(BlockPos onPosition) {
        float verticalOffset = this.getVerticalOffset(1.0f);
        int x = Mth.floor((double)(this.getX() + this.attachmentOffsetX - (double)((float)this.attachmentNormal.x * (verticalOffset + 0.2f))));
        int y = Mth.floor((double)(this.getY() + this.attachmentOffsetY - (double)((float)this.attachmentNormal.y * (verticalOffset + 0.2f))));
        int z = Mth.floor((double)(this.getZ() + this.attachmentOffsetZ - (double)((float)this.attachmentNormal.z * (verticalOffset + 0.2f))));
        BlockPos pos = new BlockPos(x, y, z);
        if (this.level().isEmptyBlock(pos) && this.attachmentNormal.y < 0.0) {
            BlockPos posDown = pos.below();
            BlockState stateDown = this.level().getBlockState(posDown);
            if (stateDown.is(BlockTags.FENCES) || stateDown.is(BlockTags.WALLS) || stateDown.getBlock() instanceof FenceGateBlock) {
                return posDown;
            }
        }
        return pos;
    }

    @Override
    public boolean getAdjustedCanTriggerWalking(boolean canTriggerWalking) {
        if (this.preWalkingPosition != null && this.canClimberTriggerWalking() && !this.isPassenger()) {
            Vec3 moved = this.position().subtract(this.preWalkingPosition);
            this.preWalkingPosition = null;
            BlockPos pos = this.getOnPos();
            BlockState state = this.level().getBlockState(pos);
            double dx = moved.x;
            double dy = moved.y;
            double dz = moved.z;
            Vec3 tangentialMovement = moved.subtract(this.attachmentNormal.scale(this.attachmentNormal.dot(moved)));
            this.moveDist = (float)((double)this.moveDist + Math.sqrt(dx * dx + dy * dy + dz * dz) * 0.6);
            if (this.moveDist > this.nextStepDistance && !state.isAir()) {
                this.nextStepDistance = this.nextStep();
                if (this.isInWater()) {
                    ClimberEntityMixin controller = this.isVehicle() && this.getControllingPassenger() != null ? this.getControllingPassenger() : this;
                    float multiplier = controller == this ? 0.35f : 0.4f;
                    Vec3 motion = controller.getDeltaMovement();
                    float swimStrength = (float)Math.sqrt(motion.x * motion.x * (double)0.2f + motion.y * motion.y + motion.z * motion.z * (double)0.2f) * multiplier;
                    if (swimStrength > 1.0f) {
                        swimStrength = 1.0f;
                    }
                    this.playSwimSound(swimStrength);
                } else {
                    this.playStepSound(pos, state);
                }
            } else if (state.isAir()) {
                this.processFlappingMovement();
            }
        }
        return false;
    }

    @Override
    public boolean canClimberTriggerWalking() {
        return true;
    }

    public void setLocationFromBoundingbox() {
        AABB axisalignedbb = this.getBoundingBox();
        this.setPosRaw((axisalignedbb.minX + axisalignedbb.maxX) / 2.0, axisalignedbb.minY, (axisalignedbb.minZ + axisalignedbb.maxZ) / 2.0);
    }

    static {
        Class<?> cls = MethodHandles.lookup().lookupClass();
        ROTATION_BODY = SynchedEntityData.defineId(cls, (EntityDataSerializer)EntityDataSerializers.ROTATIONS);
        ROTATION_HEAD = SynchedEntityData.defineId(cls, (EntityDataSerializer)EntityDataSerializers.ROTATIONS);
    }
}

