/*
 * Decompiled with CFR 0.152.
 */
package com.gly091020.GLYCan;

import com.gly091020.GLYCan.GLYCanMod;
import com.gly091020.GLYCan.block.entity.CanBlockEntity;
import com.gly091020.GLYCan.util.CanItemContainer;
import java.util.List;
import java.util.SequencedCollection;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.core.component.DataComponents;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.gametest.framework.GameTest;
import net.minecraft.gametest.framework.GameTestAssertException;
import net.minecraft.gametest.framework.GameTestHelper;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.alchemy.PotionContents;
import net.minecraft.world.item.alchemy.Potions;
import net.minecraft.world.level.GameType;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.phys.Vec3;
import net.neoforged.neoforge.gametest.GameTestHolder;
import net.neoforged.neoforge.gametest.PrefixGameTestTemplate;

@GameTestHolder(value="gly_can")
public class TestCan {
    private static final BlockPos CAN_POS = new BlockPos(2, 2, 2);

    @GameTest(template="test_can")
    @PrefixGameTestTemplate(value=false)
    public static void test_base(GameTestHelper helper) {
        Player p = helper.makeMockPlayer(GameType.SURVIVAL);
        p.setItemInHand(InteractionHand.MAIN_HAND, new ItemStack((ItemLike)Items.GOLDEN_APPLE));
        helper.useBlock(CAN_POS, p);
        helper.assertBlockEntityData(CAN_POS, entity -> {
            if (entity instanceof CanBlockEntity) {
                CanBlockEntity entity1 = (CanBlockEntity)entity;
                return !entity1.isEmpty();
            }
            return false;
        }, () -> "\u7269\u54c1\u653e\u7f6e\u5931\u8d25");
        helper.succeed();
    }

    @GameTest(template="test_can")
    @PrefixGameTestTemplate(value=false)
    public static void test_input(GameTestHelper helper) {
        Player p = helper.makeMockPlayer(GameType.SURVIVAL);
        List<Item> l = List.of(Items.GOLDEN_APPLE, Items.HONEY_BOTTLE, Items.MILK_BUCKET, Items.APPLE, Items.POTION, Items.TNT);
        for (Item i : l) {
            p.setItemInHand(InteractionHand.MAIN_HAND, new ItemStack((ItemLike)i));
            if (i == Items.POTION) {
                ItemStack s = new ItemStack((ItemLike)i);
                s.set(DataComponents.POTION_CONTENTS, (Object)new PotionContents(Potions.INVISIBILITY));
                p.setItemInHand(InteractionHand.MAIN_HAND, s);
            }
            helper.useBlock(CAN_POS, p);
            if (i == Items.TNT) continue;
            helper.assertTrue(!p.getInventory().contains(new ItemStack((ItemLike)i, 1)), "\u7269\u54c1\u653e\u7f6e\u5931\u8d25");
        }
        helper.assertBlock(new BlockPos(2, 2, 1), block -> block == Blocks.TNT, "\u653e\u5165\u4e86\u4e0d\u80fd\u653e\u7684\u7269\u54c1");
        helper.succeed();
    }

    @GameTest(template="test_can")
    @PrefixGameTestTemplate(value=false)
    public static void test_shift_eat(GameTestHelper helper) {
        Player p = helper.makeMockPlayer(GameType.SURVIVAL);
        SequencedCollection l = List.of(Items.GOLDEN_APPLE, Items.HONEY_BOTTLE, Items.MILK_BUCKET, Items.APPLE, Items.POTION).reversed();
        for (Item i : l) {
            p.setItemInHand(InteractionHand.MAIN_HAND, new ItemStack((ItemLike)i));
            if (i == Items.POTION) {
                ItemStack s = new ItemStack((ItemLike)i);
                s.set(DataComponents.POTION_CONTENTS, (Object)new PotionContents(Potions.INVISIBILITY));
                p.setItemInHand(InteractionHand.MAIN_HAND, s);
            }
            helper.useBlock(CAN_POS, p);
        }
        p.setShiftKeyDown(true);
        p.setItemInHand(InteractionHand.MAIN_HAND, ItemStack.EMPTY);
        for (int i = 0; i < 10; ++i) {
            helper.useBlock(CAN_POS, p);
        }
        helper.assertLivingEntityHasMobEffect((LivingEntity)p, MobEffects.INVISIBILITY, 0);
        helper.assertTrue(!p.hasEffect(MobEffects.FIRE_RESISTANCE), "\u725b\u5976\u4f7f\u7528\u5931\u8d25");
        helper.assertBlockEntityData(CAN_POS, entity -> {
            if (entity instanceof CanBlockEntity) {
                CanBlockEntity entity1 = (CanBlockEntity)entity;
                return entity1.isEmpty();
            }
            return false;
        }, () -> "\u4e1c\u897f\u6ca1\u5403\u5b8c");
        helper.assertTrue(p.getInventory().contains(new ItemStack((ItemLike)Items.GLASS_BOTTLE, 2)), "\u73bb\u7483\u74f6\u6570\u91cf\u9519\u8bef");
        helper.assertTrue(p.getInventory().contains(new ItemStack((ItemLike)Items.BUCKET, 1)), "\u672a\u8fd4\u8fd8\u6876");
        helper.succeed();
    }

    @GameTest(template="test_can")
    @PrefixGameTestTemplate(value=false)
    public static void test_eat(GameTestHelper helper) {
        Player p = helper.makeMockPlayer(GameType.SURVIVAL);
        SequencedCollection l = List.of(Items.GOLDEN_APPLE, Items.HONEY_BOTTLE, Items.APPLE, Items.POTION).reversed();
        ItemStack c = new ItemStack(GLYCanMod.CAN, 1);
        CanItemContainer cc = new CanItemContainer(c);
        for (Item i : l) {
            ItemStack s = new ItemStack((ItemLike)i);
            if (i == Items.POTION) {
                s.set(DataComponents.POTION_CONTENTS, (Object)new PotionContents(Potions.INVISIBILITY));
            }
            cc.addItems(s);
        }
        c.finishUsingItem((Level)helper.getLevel(), (LivingEntity)p);
        helper.assertLivingEntityHasMobEffect((LivingEntity)p, MobEffects.INVISIBILITY, 0);
        helper.assertTrue(!p.hasEffect(MobEffects.FIRE_RESISTANCE), "\u725b\u5976\u4f7f\u7528\u5931\u8d25");
        helper.assertBlockEntityData(CAN_POS, entity -> {
            if (entity instanceof CanBlockEntity) {
                CanBlockEntity entity1 = (CanBlockEntity)entity;
                return entity1.isEmpty();
            }
            return false;
        }, () -> "\u4e1c\u897f\u6ca1\u5403\u5b8c");
        helper.succeed();
    }

    @GameTest(template="test_can")
    @PrefixGameTestTemplate(value=false)
    public static void test_color(GameTestHelper helper) {
        Player p = helper.makeMockPlayer(GameType.SURVIVAL);
        List<Item> l = List.of(Items.LIGHT_BLUE_DYE, Items.RED_DYE, Items.PINK_DYE, Items.LIME_DYE, Items.ORANGE_DYE);
        for (Item item : l) {
            p.setItemInHand(InteractionHand.MAIN_HAND, new ItemStack((ItemLike)item, 1));
            helper.useBlock(CAN_POS, p);
        }
        helper.assertBlockEntityData(CAN_POS, entity -> {
            if (entity instanceof CanBlockEntity) {
                CanBlockEntity entity1 = (CanBlockEntity)entity;
                return entity1.color != 0xD3D3D3;
            }
            return false;
        }, () -> "\u65e0\u6cd5\u67d3\u8272");
        p.setItemInHand(InteractionHand.MAIN_HAND, new ItemStack((ItemLike)Items.SPONGE, 1));
        helper.useBlock(CAN_POS, p);
        helper.assertBlockEntityData(CAN_POS, entity -> {
            if (entity instanceof CanBlockEntity) {
                CanBlockEntity entity1 = (CanBlockEntity)entity;
                return entity1.color == 0xD3D3D3;
            }
            return false;
        }, () -> "\u65e0\u6cd5\u53bb\u8272");
        helper.succeed();
    }

    @GameTest(template="test_can")
    @PrefixGameTestTemplate(value=false)
    public static void test_teto(GameTestHelper helper) {
        Player p = helper.makeMockPlayer(GameType.SURVIVAL);
        Item tomato = (Item)BuiltInRegistries.ITEM.get(ResourceLocation.parse((String)"farmersdelight:tomato"));
        BlockEntity e = helper.getBlockEntity(CAN_POS);
        if (!(e instanceof CanBlockEntity)) {
            throw new GameTestAssertException("\u65b9\u5757\u5b9e\u4f53\u9519\u8bef");
        }
        CanBlockEntity entity = (CanBlockEntity)e;
        for (int i = 0; i < 10; ++i) {
            entity.addItems(new ItemStack((ItemLike)tomato, 1));
        }
        ItemStack c = new ItemStack(GLYCanMod.CAN, 1);
        CanItemContainer cc = new CanItemContainer(c);
        for (int i = 0; i < 10; ++i) {
            cc.addItems(new ItemStack((ItemLike)tomato, 1));
        }
        p.setItemInHand(InteractionHand.MAIN_HAND, c);
        p.setPos(Vec3.atCenterOf((Vec3i)CAN_POS.above()));
        p.setShiftKeyDown(true);
        p.sendSystemMessage((Component)Component.literal((String)"\u304b\u3055\u306d \u304c\u3055\u306d \u307f\u308b\u7269\u89e6\u308c\u308b~"));
        helper.succeed();
    }
}

