/*
 * Decompiled with CFR 0.152.
 */
package com.gly091020.GLYCan.client;

import com.gly091020.GLYCan.GLYCanMod;
import com.gly091020.GLYCan.block.entity.CanBlockEntity;
import com.gly091020.GLYCan.client.CanBlockEntityRenderer;
import com.gly091020.GLYCan.client.CanItemExtensions;
import com.gly091020.GLYCan.util.CanComponent;
import com.gly091020.GLYCan.util.CanItemContainer;
import com.mojang.datafixers.util.Either;
import java.util.List;
import net.minecraft.client.renderer.ItemBlockRenderTypes;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderers;
import net.minecraft.core.Holder;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.Style;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.fml.event.lifecycle.FMLClientSetupEvent;
import net.neoforged.neoforge.client.event.RegisterColorHandlersEvent;
import net.neoforged.neoforge.client.event.RenderTooltipEvent;
import net.neoforged.neoforge.client.extensions.common.IClientItemExtensions;
import net.neoforged.neoforge.client.extensions.common.RegisterClientExtensionsEvent;

@EventBusSubscriber
class EventHandler {
    private static final CanItemExtensions extension = new CanItemExtensions();

    EventHandler() {
    }

    @SubscribeEvent
    public static void onClientSetup(FMLClientSetupEvent event) {
        event.enqueueWork(() -> ItemBlockRenderTypes.setRenderLayer((Block)((Block)GLYCanMod.CAN_BLOCK.get()), (RenderType)RenderType.cutout()));
        BlockEntityRenderers.register(GLYCanMod.CAN_BLOCK_ENTITY.get(), context -> new CanBlockEntityRenderer());
    }

    @SubscribeEvent
    public static void registerClientExtensions(RegisterClientExtensionsEvent event) {
        event.registerItem((IClientItemExtensions)extension, new Holder[]{GLYCanMod.CAN});
    }

    @SubscribeEvent
    public static void registerBlockColorHandlers(RegisterColorHandlersEvent.Block event) {
        event.register((state, level, pos, tintIndex) -> {
            BlockEntity b;
            if (level != null && pos != null && (b = level.getBlockEntity(pos)) instanceof CanBlockEntity) {
                CanBlockEntity entity = (CanBlockEntity)b;
                return entity.color;
            }
            return 0xD3D3D3;
        }, new Block[]{(Block)GLYCanMod.CAN_BLOCK.get()});
    }

    @SubscribeEvent
    public static void registerItemColorHandlers(RegisterColorHandlersEvent.Item event) {
        event.register((itemStack, tintIndex) -> {
            if (itemStack.is(GLYCanMod.CAN)) {
                CanComponent p = (CanComponent)itemStack.getOrDefault(GLYCanMod.CAN_COMPONENTS, (Object)new CanComponent(false, 0xD3D3D3));
                if (p.isTeto()) {
                    return 0xD3D3D3;
                }
                return p.color();
            }
            return 0xD3D3D3;
        }, new ItemLike[]{(ItemLike)GLYCanMod.CAN.get()});
    }

    @SubscribeEvent
    public static void registryTooltip(RenderTooltipEvent.GatherComponents event) {
        CanComponent c;
        if (event.getItemStack().is(GLYCanMod.CAN) && (c = (CanComponent)event.getItemStack().get(GLYCanMod.CAN_COMPONENTS)) != null) {
            List<ItemStack> l;
            if (c.color() != 0xD3D3D3) {
                if (c.isTeto()) {
                    event.getTooltipElements().add(Either.left((Object)FormattedText.composite((FormattedText[])new FormattedText[]{FormattedText.of((String)Component.translatable((String)"tip.gly_can.can.1", (Object[])new Object[]{Component.translatable((String)"tip.gly_can.can.teto")}).getString())})));
                } else {
                    event.getTooltipElements().add(Either.left((Object)FormattedText.composite((FormattedText[])new FormattedText[]{FormattedText.of((String)Component.translatable((String)"tip.gly_can.can.1", (Object[])new Object[]{String.format("#%x", c.color()).toUpperCase()}).getString()), FormattedText.of((String)"\u25a0", (Style)Style.EMPTY.withColor(c.color()))})));
                }
            }
            if (!(l = new CanItemContainer(event.getItemStack()).getMaxItems()).isEmpty()) {
                event.getTooltipElements().add(Either.left((Object)FormattedText.of((String)Component.translatable((String)"tip.gly_can.can.2").getString())));
                for (ItemStack stack : l) {
                    if (stack.isEmpty()) continue;
                    event.getTooltipElements().add(Either.left((Object)FormattedText.composite((FormattedText[])new FormattedText[]{FormattedText.of((String)("- " + stack.getHoverName().getString())), FormattedText.of((String)String.format(" x%d", stack.getCount()))})));
                }
            }
        }
    }
}

