/*
 * Decompiled with CFR 0.152.
 */
package com.gly091020.GLYCan.util;

import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import net.minecraft.core.NonNullList;
import net.minecraft.core.component.DataComponents;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.ItemTags;
import net.minecraft.world.Container;
import net.minecraft.world.ContainerHelper;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import org.jetbrains.annotations.NotNull;

public interface CanContainer
extends Container {
    default public int getContainerSize() {
        return 10;
    }

    default public boolean isEmpty() {
        return this.getItems().stream().allMatch(ItemStack::isEmpty);
    }

    default public ItemStack getItem(int i) {
        return (ItemStack)this.getItems().get(i);
    }

    default public ItemStack removeItem(int i, int i1) {
        ItemStack stack = ContainerHelper.removeItem(this.getItems(), (int)i, (int)i1);
        this.setChanged();
        return stack;
    }

    default public ItemStack removeItemNoUpdate(int i) {
        ItemStack stack = ContainerHelper.takeItem(this.getItems(), (int)i);
        this.setChanged();
        return stack;
    }

    default public void setItem(int i, ItemStack itemStack) {
        itemStack.limitSize(this.getMaxStackSize(itemStack));
        this.getItems().set(i, (Object)itemStack);
        this.setChanged();
    }

    default public boolean stillValid(Player player) {
        return true;
    }

    default public void clearContent() {
        this.getItems().clear();
        this.setChanged();
    }

    default public void setItems(NonNullList<ItemStack> stacks) {
        this.getItems().clear();
        if (stacks.size() > 10) {
            throw new RuntimeException("\u592a\u5927\u4e86");
        }
        for (int i = 0; i < stacks.size(); ++i) {
            this.setItem(i, (ItemStack)stacks.get(i));
        }
    }

    default public boolean addItems(ItemStack stack) {
        for (int i = 0; i < this.getItems().size(); ++i) {
            if (!((ItemStack)this.getItems().get(i)).isEmpty()) continue;
            this.setItem(i, stack);
            return true;
        }
        return false;
    }

    @NotNull
    public NonNullList<ItemStack> getItems();

    default public List<ItemStack> getMaxItems() {
        ArrayList<ItemStack> l = new ArrayList<ItemStack>();
        HashMap<ItemStack, Integer> map = new HashMap<ItemStack, Integer>();
        for (ItemStack stack2 : this.getItems()) {
            if ((stack2 = stack2.copy()).isEmpty()) continue;
            int i = CanContainer.getItemIndexInMap(map, stack2);
            if (i >= 0) {
                ItemStack k = (ItemStack)map.keySet().stream().toList().get(i);
                map.put(k, map.get(k) + 1);
                continue;
            }
            map.put(stack2, 1);
            l.add(stack2);
        }
        l.sort(Comparator.comparingInt(map::get));
        l.forEach(stack -> stack.setCount(map.getOrDefault(stack, 1).intValue()));
        return l.reversed();
    }

    default public boolean isTomatoCan() {
        return this.getItems().stream().allMatch(stack -> stack.is(ItemTags.create((ResourceLocation)ResourceLocation.parse((String)"c:crops/tomato"))));
    }

    private static int getItemIndexInMap(HashMap<ItemStack, Integer> map, ItemStack stack) {
        int i = -1;
        for (int j = 0; j < map.size(); ++j) {
            ItemStack stack1 = (ItemStack)map.keySet().stream().toList().get(j);
            if (!ItemStack.isSameItemSameComponents((ItemStack)stack, (ItemStack)stack1)) continue;
            i = j;
        }
        return i;
    }

    default public boolean canPlaceItem(int slot, ItemStack stack) {
        return stack.has(DataComponents.FOOD) || stack.has(DataComponents.POTION_CONTENTS) || stack.has(DataComponents.SUSPICIOUS_STEW_EFFECTS);
    }

    default public int getMaxStackSize() {
        return 1;
    }
}

