/*
 * Decompiled with CFR 0.152.
 */
package com.gly091020.GLYCan.block;

import com.gly091020.GLYCan.GLYCanMod;
import com.gly091020.GLYCan.block.entity.CanBlockEntity;
import com.gly091020.GLYCan.util.CanComponent;
import com.gly091020.GLYCan.util.CanItemContainer;
import com.mojang.serialization.MapCodec;
import java.util.Objects;
import net.minecraft.advancements.AdvancementHolder;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.NonNullList;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.core.component.DataComponents;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.ServerAdvancementManager;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.tags.ItemTags;
import net.minecraft.world.Containers;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.ItemInteractionResult;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.food.FoodProperties;
import net.minecraft.world.item.DyeItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.component.ItemContainerContents;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.EntityBlock;
import net.minecraft.world.level.block.HorizontalDirectionalBlock;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.Nullable;

public class CanBlock
extends HorizontalDirectionalBlock
implements EntityBlock {
    private static final VoxelShape COLLISION_SHAPE = Shapes.box((double)0.25, (double)0.0, (double)0.25, (double)0.75, (double)0.8125, (double)0.75);
    public static final BooleanProperty IS_TETO = BooleanProperty.create((String)"is_teto");
    public static final int NORMAL_COLOR = 0xD3D3D3;

    public CanBlock(BlockBehaviour.Properties properties) {
        super(properties);
        this.registerDefaultState((BlockState)((BlockState)((BlockState)this.stateDefinition.any()).setValue((Property)FACING, (Comparable)Direction.NORTH)).setValue((Property)IS_TETO, (Comparable)Boolean.valueOf(false)));
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        builder.add(new Property[]{FACING});
        builder.add(new Property[]{IS_TETO});
    }

    protected MapCodec<? extends HorizontalDirectionalBlock> codec() {
        return CanBlock.simpleCodec(CanBlock::new);
    }

    @Nullable
    public BlockEntity newBlockEntity(BlockPos blockPos, BlockState blockState) {
        return new CanBlockEntity(blockPos, blockState);
    }

    protected VoxelShape getShape(BlockState state, BlockGetter level, BlockPos pos, CollisionContext context) {
        return COLLISION_SHAPE;
    }

    protected VoxelShape getCollisionShape(BlockState state, BlockGetter level, BlockPos pos, CollisionContext context) {
        return COLLISION_SHAPE;
    }

    protected void onRemove(BlockState state, Level level, BlockPos pos, BlockState state1, boolean b) {
        if (state.is(state1.getBlock())) {
            super.onRemove(state, level, pos, state1, b);
            return;
        }
        ItemStack stack = new ItemStack(GLYCanMod.CAN);
        CanItemContainer container = new CanItemContainer(stack);
        BlockEntity blockEntity = level.getBlockEntity(pos);
        if (!(blockEntity instanceof CanBlockEntity)) {
            super.onRemove(state, level, pos, state1, b);
            return;
        }
        CanBlockEntity entity = (CanBlockEntity)blockEntity;
        container.setItems(entity.getItems());
        stack.set((DataComponentType)GLYCanMod.CAN_COMPONENTS.get(), (Object)new CanComponent((Boolean)state.getValue((Property)IS_TETO), entity.color));
        Containers.dropItemStack((Level)level, (double)pos.getX(), (double)pos.getY(), (double)pos.getZ(), (ItemStack)stack);
        super.onRemove(state, level, pos, state1, b);
    }

    protected ItemInteractionResult useItemOn(ItemStack itemStack, BlockState state, Level level, BlockPos pos, Player player, InteractionHand interactionHand, BlockHitResult result) {
        if (itemStack.is(GLYCanMod.CAN)) {
            return ItemInteractionResult.PASS_TO_DEFAULT_BLOCK_INTERACTION;
        }
        BlockEntity blockEntity = level.getBlockEntity(pos);
        if (!(blockEntity instanceof CanBlockEntity)) {
            return ItemInteractionResult.PASS_TO_DEFAULT_BLOCK_INTERACTION;
        }
        CanBlockEntity entity = (CanBlockEntity)blockEntity;
        if (itemStack.is(Items.SPONGE)) {
            if (entity.color == 0xD3D3D3) {
                return ItemInteractionResult.SKIP_DEFAULT_BLOCK_INTERACTION;
            }
            entity.color = 0xD3D3D3;
            entity.setChanged();
            level.sendBlockUpdated(pos, state, state, 3);
            level.playLocalSound(pos, SoundEvents.SPONGE_ABSORB, SoundSource.PLAYERS, 1.0f, 1.0f, true);
            return ItemInteractionResult.SUCCESS;
        }
        Item item = itemStack.getItem();
        if (item instanceof DyeItem) {
            DyeItem item2 = (DyeItem)item;
            if (entity.color == item2.getDyeColor().getTextureDiffuseColor()) {
                return ItemInteractionResult.PASS_TO_DEFAULT_BLOCK_INTERACTION;
            }
            entity.color = entity.color == 0xD3D3D3 ? item2.getDyeColor().getTextureDiffuseColor() : CanBlock.blendColors(entity.color, item2.getDyeColor().getTextureDiffuseColor(), 0.8f, 0.2f);
            entity.setChanged();
            level.sendBlockUpdated(pos, state, state, 3);
            level.playLocalSound(pos, SoundEvents.DYE_USE, SoundSource.PLAYERS, 1.0f, 1.0f, true);
            itemStack.consume(1, (LivingEntity)player);
            return ItemInteractionResult.SUCCESS;
        }
        FoodProperties f = itemStack.getFoodProperties((LivingEntity)player);
        if (!(itemStack.is(ItemTags.create((ResourceLocation)ResourceLocation.parse((String)"c:foods"))) || itemStack.is(ItemTags.create((ResourceLocation)ResourceLocation.parse((String)"c:drinks"))) || itemStack.has(DataComponents.FOOD) || itemStack.has(DataComponents.POTION_CONTENTS) || itemStack.has(DataComponents.SUSPICIOUS_STEW_EFFECTS))) {
            return ItemInteractionResult.PASS_TO_DEFAULT_BLOCK_INTERACTION;
        }
        ItemStack i1 = itemStack.copy();
        i1.setCount(1);
        if (!entity.addItems(i1)) {
            return ItemInteractionResult.PASS_TO_DEFAULT_BLOCK_INTERACTION;
        }
        itemStack.consume(1, (LivingEntity)player);
        return ItemInteractionResult.SUCCESS;
    }

    public void setPlacedBy(Level level, BlockPos pos, BlockState state, @Nullable LivingEntity placer, ItemStack stack) {
        super.setPlacedBy(level, pos, state, placer, stack);
        BlockEntity blockEntity = level.getBlockEntity(pos);
        if (blockEntity instanceof CanBlockEntity) {
            CanBlockEntity entity = (CanBlockEntity)blockEntity;
            NonNullList l = NonNullList.withSize((int)10, (Object)ItemStack.EMPTY);
            ((ItemContainerContents)stack.getOrDefault(DataComponents.CONTAINER, (Object)ItemContainerContents.EMPTY)).copyInto(l);
            entity.setItems(l);
        }
        this.setTeto(level, pos, state, placer, stack);
    }

    public void setTeto(Level level, BlockPos pos, BlockState state, @Nullable LivingEntity placer, ItemStack stack) {
        BlockEntity blockEntity = level.getBlockEntity(pos);
        if (blockEntity instanceof CanBlockEntity) {
            CanBlockEntity entity = (CanBlockEntity)blockEntity;
            blockEntity = level.getBlockEntity(pos.below());
            if (blockEntity instanceof CanBlockEntity) {
                CanBlockEntity entity1 = (CanBlockEntity)blockEntity;
                if (entity.isTomatoCan() && entity1.isTomatoCan()) {
                    level.setBlock(pos, (BlockState)state.setValue((Property)IS_TETO, (Comparable)Boolean.valueOf(true)), 3);
                    level.playLocalSound(pos, (SoundEvent)GLYCanMod.TETO_CAN_SOUND.get(), SoundSource.BLOCKS, 1.0f, 1.0f, true);
                    if (placer instanceof ServerPlayer) {
                        ServerPlayer player = (ServerPlayer)placer;
                        this.grantAdvancement(player, ResourceLocation.parse((String)"gly_can:teto_can"), "teto");
                    }
                }
            }
        }
    }

    private static int blendColors(int color1, int color2, float weight1, float weight2) {
        if (Math.abs(weight1 + weight2 - 1.0f) > 1.0E-4f) {
            throw new IllegalArgumentException("Weights must sum to 1.0");
        }
        int a1 = color1 >> 24 & 0xFF;
        int r1 = color1 >> 16 & 0xFF;
        int g1 = color1 >> 8 & 0xFF;
        int b1 = color1 & 0xFF;
        int a2 = color2 >> 24 & 0xFF;
        int r2 = color2 >> 16 & 0xFF;
        int g2 = color2 >> 8 & 0xFF;
        int b2 = color2 & 0xFF;
        int a = (int)((float)a1 * weight1 + (float)a2 * weight2);
        int r = (int)((float)r1 * weight1 + (float)r2 * weight2);
        int g = (int)((float)g1 * weight1 + (float)g2 * weight2);
        int b = (int)((float)b1 * weight1 + (float)b2 * weight2);
        a = Math.max(0, Math.min(255, a));
        r = Math.max(0, Math.min(255, r));
        g = Math.max(0, Math.min(255, g));
        b = Math.max(0, Math.min(255, b));
        return a << 24 | r << 16 | g << 8 | b;
    }

    public RenderShape getRenderShape(BlockState state) {
        return RenderShape.MODEL;
    }

    protected InteractionResult useWithoutItem(BlockState state, Level level, BlockPos pos, Player player, BlockHitResult hitResult) {
        CanBlockEntity entity;
        BlockEntity blockEntity;
        if (player.isShiftKeyDown() && (blockEntity = level.getBlockEntity(pos)) instanceof CanBlockEntity && !(entity = (CanBlockEntity)blockEntity).isEmpty()) {
            for (int i = entity.getItems().size() - 1; i >= 0; --i) {
                ItemStack stack = (ItemStack)entity.getItems().get(i);
                if (stack.isEmpty()) continue;
                ItemStack s = stack.finishUsingItem(level, (LivingEntity)player);
                if (!player.hasInfiniteMaterials()) {
                    player.addItem(s);
                }
                entity.removeItem(i, 1);
                if (!player.level().isClientSide && !Objects.equals(player.getGameProfile().getName(), "test-mock-player")) {
                    this.grantAdvancement((ServerPlayer)player, ResourceLocation.parse((String)"gly_can:eat_can_block"), "eat_block");
                }
                return InteractionResult.SUCCESS;
            }
        }
        return super.useWithoutItem(state, level, pos, player, hitResult);
    }

    @Nullable
    public BlockState getStateForPlacement(BlockPlaceContext context) {
        return (BlockState)this.defaultBlockState().setValue((Property)FACING, (Comparable)context.getHorizontalDirection().getOpposite());
    }

    public void grantAdvancement(ServerPlayer player, ResourceLocation advancementId, String key) {
        ServerAdvancementManager manager = player.server.getAdvancements();
        AdvancementHolder advancement = manager.get(advancementId);
        if (advancement != null) {
            player.getAdvancements().award(advancement, key);
        }
    }
}

