/*
 * Decompiled with CFR 0.152.
 */
package com.gly091020.GLYCan.block.entity;

import com.gly091020.GLYCan.GLYCanMod;
import com.gly091020.GLYCan.util.CanContainer;
import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.NonNullList;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.Connection;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.world.ContainerHelper;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import org.jetbrains.annotations.NotNull;

public class CanBlockEntity
extends BlockEntity
implements CanContainer {
    public NonNullList<ItemStack> stacks = NonNullList.withSize((int)10, (Object)ItemStack.EMPTY);
    public int color = 0xD3D3D3;

    public CanBlockEntity(BlockPos pos, BlockState blockState) {
        super(GLYCanMod.CAN_BLOCK_ENTITY.get(), pos, blockState);
    }

    protected void saveAdditional(CompoundTag tag, HolderLookup.Provider provider) {
        super.saveAdditional(tag, provider);
        ContainerHelper.saveAllItems((CompoundTag)tag, this.stacks, (HolderLookup.Provider)provider);
        tag.putInt("color", this.color);
    }

    protected void loadAdditional(CompoundTag tag, HolderLookup.Provider provider) {
        super.loadAdditional(tag, provider);
        ContainerHelper.loadAllItems((CompoundTag)tag, this.stacks, (HolderLookup.Provider)provider);
        this.color = tag.getInt("color");
    }

    public void handleUpdateTag(CompoundTag tag, HolderLookup.Provider lookupProvider) {
        super.handleUpdateTag(tag, lookupProvider);
        ContainerHelper.loadAllItems((CompoundTag)tag, this.stacks, (HolderLookup.Provider)lookupProvider);
        this.color = tag.getInt("color");
    }

    public void onDataPacket(Connection net, ClientboundBlockEntityDataPacket pkt, HolderLookup.Provider lookupProvider) {
        super.onDataPacket(net, pkt, lookupProvider);
        CompoundTag tag = pkt.getTag();
        ContainerHelper.loadAllItems((CompoundTag)tag, this.stacks, (HolderLookup.Provider)lookupProvider);
        this.color = tag.getInt("color");
    }

    public CompoundTag getUpdateTag(HolderLookup.Provider registries) {
        CompoundTag t = super.getUpdateTag(registries);
        ContainerHelper.saveAllItems((CompoundTag)t, this.stacks, (HolderLookup.Provider)registries);
        t.putInt("color", this.color);
        return t;
    }

    @Override
    @NotNull
    public NonNullList<ItemStack> getItems() {
        return this.stacks;
    }
}

