/*
 * Decompiled with CFR 0.152.
 */
package com.gly091020.GLYCan.item;

import com.gly091020.GLYCan.GLYCanMod;
import com.gly091020.GLYCan.block.CanBlock;
import com.gly091020.GLYCan.block.entity.CanBlockEntity;
import com.gly091020.GLYCan.util.CanComponent;
import com.gly091020.GLYCan.util.CanItemContainer;
import java.util.List;
import java.util.Optional;
import net.minecraft.core.component.DataComponents;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.ItemTags;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.SlotAccess;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.food.FoodProperties;
import net.minecraft.world.inventory.ClickAction;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.PotionItem;
import net.minecraft.world.item.alchemy.PotionContents;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import org.jetbrains.annotations.Nullable;

public class CanItem
extends BlockItem {
    public CanItem(Block block, Item.Properties properties) {
        super(block, properties);
    }

    protected boolean placeBlock(BlockPlaceContext context, BlockState state) {
        if (context.getPlayer() != null && context.getPlayer().isShiftKeyDown()) {
            CanComponent d = (CanComponent)context.getItemInHand().getOrDefault(GLYCanMod.CAN_COMPONENTS, (Object)new CanComponent(false, 0xD3D3D3));
            boolean r = super.placeBlock(context, (BlockState)state.setValue((Property)CanBlock.IS_TETO, (Comparable)Boolean.valueOf(d.isTeto())));
            BlockEntity blockEntity = context.getLevel().getBlockEntity(context.getClickedPos());
            if (blockEntity instanceof CanBlockEntity) {
                CanBlockEntity entity = (CanBlockEntity)blockEntity;
                entity.color = d.color();
            }
            return r;
        }
        return false;
    }

    @Nullable
    public FoodProperties getFoodProperties(ItemStack stack, @Nullable LivingEntity entity) {
        CanItemContainer c = new CanItemContainer(stack);
        if (c.isEmpty()) {
            return null;
        }
        float eatSeconds = 0.0f;
        for (ItemStack food : c.getItems()) {
            Optional p;
            FoodProperties f = (FoodProperties)food.get(DataComponents.FOOD);
            if (f != null) {
                eatSeconds += f.eatSeconds();
            }
            if (!(food.getItem() instanceof PotionItem) || !(p = ((PotionContents)food.getOrDefault(DataComponents.POTION_CONTENTS, (Object)PotionContents.EMPTY)).potion()).isPresent()) continue;
            eatSeconds += 1.6f;
        }
        return new FoodProperties(0, 0.0f, true, eatSeconds * 0.5f, Optional.empty(), List.of());
    }

    public ItemStack finishUsingItem(ItemStack stack, Level level, LivingEntity livingEntity) {
        CanItemContainer c = new CanItemContainer(stack);
        for (ItemStack food : c.getItems()) {
            food.finishUsingItem(level, livingEntity);
        }
        c.clearContent();
        return stack;
    }

    public Component getName(ItemStack stack) {
        CanItemContainer c = new CanItemContainer(stack);
        if (((CanComponent)stack.getOrDefault(GLYCanMod.CAN_COMPONENTS, (Object)new CanComponent(false, 0xD3D3D3))).isTeto()) {
            return Component.translatable((String)"item.gly_can.can", (Object[])new Object[]{Component.translatable((String)"item.gly_can.can.teto")});
        }
        List<ItemStack> l = c.getMaxItems();
        if (l.size() >= 2) {
            return Component.translatable((String)"item.gly_can.can2", (Object[])new Object[]{l.get(0).getHoverName(), l.get(1).getHoverName()});
        }
        if (l.size() == 1) {
            return Component.translatable((String)"item.gly_can.can", (Object[])new Object[]{l.getFirst().getHoverName()});
        }
        return Component.translatable((String)"item.gly_can.can", (Object[])new Object[]{""});
    }

    public boolean overrideOtherStackedOnMe(ItemStack stack, ItemStack other, Slot slot, ClickAction action, Player player, SlotAccess access) {
        if (action == ClickAction.PRIMARY) {
            if (!(other.is(ItemTags.create((ResourceLocation)ResourceLocation.parse((String)"c:foods"))) || other.is(ItemTags.create((ResourceLocation)ResourceLocation.parse((String)"c:drinks"))) || other.has(DataComponents.FOOD) || other.has(DataComponents.POTION_CONTENTS) || other.has(DataComponents.SUSPICIOUS_STEW_EFFECTS))) {
                return false;
            }
            CanItemContainer c = new CanItemContainer(stack);
            ItemStack input = other.copy();
            input.setCount(1);
            if (c.addItems(input)) {
                other.shrink(1);
                return true;
            }
        } else {
            CanItemContainer c = new CanItemContainer(stack);
            if (access.get().isEmpty() && !c.isEmpty()) {
                for (int i = c.getItems().size() - 1; i >= 0; --i) {
                    ItemStack stack1 = (ItemStack)c.getItems().get(i);
                    if (stack1.isEmpty()) continue;
                    access.set(c.removeItem(i, 1));
                    return true;
                }
            }
        }
        return false;
    }
}

