/*
 * Decompiled with CFR 0.152.
 */
package com.gly091020.GLYCan.item;

import com.gly091020.GLYCan.GLYCanMod;
import com.gly091020.GLYCan.block.CanBlock;
import com.gly091020.GLYCan.block.entity.CanBlockEntity;
import com.gly091020.GLYCan.util.CanComponent;
import com.gly091020.GLYCan.util.CanItemContainer;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import net.minecraft.core.Holder;
import net.minecraft.core.component.DataComponents;
import net.minecraft.network.chat.Component;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.food.FoodConstants;
import net.minecraft.world.food.FoodProperties;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.PotionItem;
import net.minecraft.world.item.SuspiciousStewItem;
import net.minecraft.world.item.alchemy.Potion;
import net.minecraft.world.item.alchemy.PotionContents;
import net.minecraft.world.item.component.SuspiciousStewEffects;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import org.jetbrains.annotations.Nullable;

public class CanItem
extends BlockItem {
    public CanItem(Block block, Item.Properties properties) {
        super(block, properties);
    }

    protected boolean placeBlock(BlockPlaceContext context, BlockState state) {
        if (context.getPlayer() != null && context.getPlayer().isShiftKeyDown()) {
            CanComponent d = (CanComponent)context.getItemInHand().getOrDefault(GLYCanMod.CAN_COMPONENTS, (Object)new CanComponent(false, 0xD3D3D3));
            boolean r = super.placeBlock(context, (BlockState)state.setValue((Property)CanBlock.IS_TETO, (Comparable)Boolean.valueOf(d.isTeto())));
            BlockEntity blockEntity = context.getLevel().getBlockEntity(context.getClickedPos());
            if (blockEntity instanceof CanBlockEntity) {
                CanBlockEntity entity = (CanBlockEntity)blockEntity;
                entity.color = d.color();
            }
            return r;
        }
        return false;
    }

    @Nullable
    public FoodProperties getFoodProperties(ItemStack stack, @Nullable LivingEntity entity) {
        CanItemContainer c = new CanItemContainer(stack);
        if (c.isEmpty()) {
            return null;
        }
        int nutrition = 0;
        float saturation = 0.0f;
        float eatSeconds = 0.0f;
        ArrayList<FoodProperties.PossibleEffect> effect = new ArrayList<FoodProperties.PossibleEffect>(List.of());
        for (ItemStack food : c.getItems()) {
            SuspiciousStewEffects s;
            Optional p;
            FoodProperties f = (FoodProperties)food.get(DataComponents.FOOD);
            if (f != null) {
                nutrition += f.nutrition();
                saturation += f.saturation();
                eatSeconds += f.eatSeconds();
                effect.addAll(f.effects());
            }
            if (food.getItem() instanceof PotionItem && (p = ((PotionContents)food.getOrDefault(DataComponents.POTION_CONTENTS, (Object)PotionContents.EMPTY)).potion()).isPresent()) {
                for (MobEffectInstance effect1 : ((Potion)((Holder)p.get()).value()).getEffects()) {
                    effect.add(new FoodProperties.PossibleEffect(() -> effect1, 1.0f));
                    eatSeconds += 1.6f;
                }
            }
            if (!(food.getItem() instanceof SuspiciousStewItem) || (s = (SuspiciousStewEffects)food.get(DataComponents.SUSPICIOUS_STEW_EFFECTS)) == null) continue;
            for (SuspiciousStewEffects.Entry e : s.effects()) {
                effect.add(new FoodProperties.PossibleEffect(() -> ((SuspiciousStewEffects.Entry)e).createEffectInstance(), 1.0f));
            }
        }
        float f = FoodConstants.saturationByModifier((int)nutrition, (float)saturation);
        ItemStack c1 = new ItemStack(GLYCanMod.CAN, 1);
        c1.set(GLYCanMod.CAN_COMPONENTS, (Object)((CanComponent)stack.getOrDefault(GLYCanMod.CAN_COMPONENTS, (Object)new CanComponent(false, 0xD3D3D3))));
        return new FoodProperties(nutrition, f, true, eatSeconds * 0.5f, Optional.of(c1), effect);
    }

    public Component getName(ItemStack stack) {
        CanItemContainer c = new CanItemContainer(stack);
        if (((CanComponent)stack.getOrDefault(GLYCanMod.CAN_COMPONENTS, (Object)new CanComponent(false, 0xD3D3D3))).isTeto()) {
            return Component.translatable((String)"item.gly_can.can", (Object[])new Object[]{Component.translatable((String)"item.gly_can.can.teto")});
        }
        List<ItemStack> l = c.getMaxItems();
        if (l.size() >= 2) {
            return Component.translatable((String)"item.gly_can.can2", (Object[])new Object[]{l.get(0).getHoverName(), l.get(1).getHoverName()});
        }
        if (l.size() == 1) {
            return Component.translatable((String)"item.gly_can.can", (Object[])new Object[]{l.getFirst().getHoverName()});
        }
        return Component.translatable((String)"item.gly_can.can", (Object[])new Object[]{""});
    }
}

