/*
 * Decompiled with CFR 0.152.
 */
package com.sakuraryoko.morecolors.impl.nodes;

import com.sakuraryoko.morecolors.api.MoreColorsEvents;
import com.sakuraryoko.morecolors.impl.MoreColor;
import com.sakuraryoko.morecolors.impl.config.ConfigWrap;
import com.sakuraryoko.morecolors.impl.nodes.MoreColorNode;
import eu.pb4.placeholders.api.node.TextNode;
import eu.pb4.placeholders.api.node.parent.ColorNode;
import eu.pb4.placeholders.api.parsers.TextParserV1;
import eu.pb4.placeholders.impl.textparser.TextParserImpl;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicBoolean;
import net.minecraft.class_5251;
import org.jetbrains.annotations.ApiStatus;

@ApiStatus.Internal
public class NodeManager {
    private static final List<MoreColorNode> REMOVE = new ArrayList<MoreColorNode>();

    @ApiStatus.Internal
    private static void registerColors(boolean cleanup) {
        Iterator<MoreColorNode> iterator = ConfigWrap.colors().iterator();
        REMOVE.clear();
        while (iterator.hasNext()) {
            MoreColorNode iColorNode = iterator.next();
            NodeManager.registerColor(iColorNode);
        }
        if (!REMOVE.isEmpty() && cleanup) {
            REMOVE.forEach(iNode -> {
                MoreColor.LOGGER.warn("Removing Node \"{}\" from config, because it was detected as being in use.", (Object)iNode.getName());
                ConfigWrap.colors().remove(iNode);
            });
            REMOVE.clear();
        }
    }

    @ApiStatus.Internal
    public static void registerColor(MoreColorNode iColorNode) {
        MoreColor.debugLog("registerColors(): register ColorNode: {} // {}", iColorNode.getName(), iColorNode.getHexCode());
        class_5251 finalIColorNode = iColorNode.getColor();
        if (NodeManager.checkIfRegistered(iColorNode)) {
            MoreColor.debugLog("registerColors(): A tag named \"{}\" is already registered.", iColorNode.getName());
            REMOVE.add(iColorNode);
            return;
        }
        if (iColorNode.getAliases() != null) {
            TextParserV1.registerDefault((TextParserV1.TextTag)TextParserV1.TextTag.of((String)iColorNode.getName(), iColorNode.getAliases(), (String)"color", (boolean)true, (TextParserV1.TagNodeBuilder)NodeManager.wrap((nodes, arg) -> new ColorNode(nodes, finalIColorNode))));
            ((MoreColorsEvents.RegisterColorEvent)MoreColorsEvents.REGISTER_COLOR_NODE.invoker()).onRegisterMoreColorNode(iColorNode.getName(), iColorNode.getHexCode(), iColorNode.getAliases());
        } else {
            TextParserV1.registerDefault((TextParserV1.TextTag)TextParserV1.TextTag.of((String)iColorNode.getName(), List.of(""), (String)"color", (boolean)true, (TextParserV1.TagNodeBuilder)NodeManager.wrap((nodes, arg) -> new ColorNode(nodes, finalIColorNode))));
            ((MoreColorsEvents.RegisterColorEvent)MoreColorsEvents.REGISTER_COLOR_NODE.invoker()).onRegisterMoreColorNode(iColorNode.getName(), iColorNode.getHexCode(), null);
        }
    }

    @ApiStatus.Internal
    public static boolean isMoreColorNode(String node) {
        AtomicBoolean atomic = new AtomicBoolean(false);
        ConfigWrap.colors().forEach(iNode -> {
            if (node.equals(iNode.getName()) || iNode.getAliases() != null && iNode.getAliases().contains(node)) {
                atomic.set(true);
            }
        });
        return atomic.get();
    }

    @ApiStatus.Internal
    public static void registerNodes(boolean fromInit) {
        NodeManager.registerColors(fromInit);
    }

    @ApiStatus.Internal
    public static boolean checkIfRegistered(MoreColorNode colorNode) {
        String node = colorNode.getName();
        AtomicBoolean exists = new AtomicBoolean(false);
        TextParserV1.DEFAULT.getTags().forEach(tag -> {
            if (tag.name().equals(node)) {
                exists.set(true);
            }
        });
        return exists.get();
    }

    @ApiStatus.Internal
    public static List<String> getAllColorNodes() {
        ArrayList<String> nodes = new ArrayList<String>();
        TextParserV1.DEFAULT.getTags().forEach(tag -> {
            if (tag.type().equals("color") && !Objects.equals(tag.name(), "reset") && !Objects.equals(tag.name(), "color")) {
                nodes.add(tag.name());
            }
        });
        return nodes;
    }

    @ApiStatus.Internal
    private static TextParserV1.TagNodeBuilder wrap(Wrapper wrapper) {
        return (tag, data, input, handlers, endAt) -> {
            TextParserV1.NodeList out = TextParserImpl.recursiveParsing((String)input, (TextParserV1.TagParserGetter)handlers, (String)endAt);
            return new TextParserV1.TagNodeValue(wrapper.wrap(out.nodes(), data), out.length());
        };
    }

    @ApiStatus.Internal
    static interface Wrapper {
        public TextNode wrap(TextNode[] var1, String var2);
    }
}

