/*
 * Decompiled with CFR 0.152.
 */
package com.sakuraryoko.morecolors.api;

import com.sakuraryoko.morecolors.impl.MoreColor;
import com.sakuraryoko.morecolors.impl.config.ConfigWrap;
import com.sakuraryoko.morecolors.impl.nodes.MoreColorNode;
import com.sakuraryoko.morecolors.impl.nodes.NodeManager;
import com.sakuraryoko.morecolors.impl.text.FormattingExample;
import com.sakuraryoko.morecolors.impl.text.TextUtils;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.class_2561;

public interface MoreColorsAPI {
    public static boolean isMoreColorNode(@Nonnull String node) {
        return NodeManager.isMoreColorNode(node);
    }

    public static class_2561 addColorNode(@Nonnull String name, @Nonnull String hexCode, @Nullable List<String> aliases) {
        MoreColorNode newNode;
        if (name.isEmpty()) {
            return class_2561.method_43473();
        }
        if (((String)hexCode).isEmpty()) {
            return class_2561.method_43473();
        }
        if (NodeManager.isMoreColorNode(name)) {
            return class_2561.method_43473();
        }
        if (((String)hexCode).charAt(0) != '#') {
            hexCode = "#" + ((String)hexCode).toUpperCase(Locale.ROOT);
        }
        if ((newNode = aliases == null || aliases.isEmpty() ? new MoreColorNode(name, (String)hexCode) : new MoreColorNode(name, (String)hexCode, aliases)).getColor() != null) {
            MoreColor.debugLog("New Node Debug: [{}]", newNode.toString());
            ConfigWrap.colors().add(newNode);
            NodeManager.registerColor(newNode);
            return TextUtils.getInstance().formatText("More Color Node added successfully\nTest (Click to copy): <r><copy:'<" + newNode.getName() + ">'><" + newNode.getName() + ">" + newNode.getName() + "<r>");
        }
        return class_2561.method_43473();
    }

    public static class_2561 formatTextSafe(@Nonnull String str) {
        return TextUtils.getInstance().formatTextSafe(str);
    }

    public static class_2561 formatText(@Nonnull String str) {
        return TextUtils.getInstance().formatText(str);
    }

    public static class_2561 of(@Nonnull String str) {
        return TextUtils.getInstance().of(str);
    }

    public static class_2561 getBuiltInFormattingTest() {
        return FormattingExample.runBuiltInTest();
    }

    public static class_2561 getPlaceholderAPIFormattingTest() {
        return FormattingExample.runPlaceholderAPITest();
    }

    public static class_2561 getMoreColorsFormattingTest() {
        return FormattingExample.runMoreColorsTest();
    }

    public static class_2561 getEndFormattingTest() {
        return FormattingExample.getClipboardMessage();
    }

    public static List<class_2561> getAllFormattingTests() {
        ArrayList<class_2561> list = new ArrayList<class_2561>();
        list.add(FormattingExample.runBuiltInTest());
        list.add(FormattingExample.runPlaceholderAPITest());
        list.add(FormattingExample.runMoreColorsTest());
        list.add(FormattingExample.getClipboardMessage());
        return list;
    }
}

