/*
 * Decompiled with CFR 0.152.
 */
package com.sakuraryoko.morecolors.impl.nodes;

import com.sakuraryoko.morecolors.impl.MoreColor;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.class_5251;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Nullable;

@ApiStatus.Internal
public class MoreColorNode {
    private final String name;
    private final String hexCode;
    private List<String> aliases = new ArrayList<String>();
    private final class_5251 color;

    public MoreColorNode(String name, String hexCode) {
        this.color = class_5251.method_27719((String)hexCode);
        if (this.color != null) {
            this.name = name;
            this.hexCode = hexCode;
        } else {
            MoreColor.LOGGER.warn("MoreColor({}) unhandled error (color is null)", (Object)name);
            this.name = "";
            this.hexCode = "";
        }
    }

    public MoreColorNode(String name, String hexCode, @Nullable List<String> aliases) {
        this.color = class_5251.method_27719((String)hexCode);
        if (this.color != null) {
            this.name = name;
            this.hexCode = hexCode;
            this.aliases = aliases;
        } else {
            MoreColor.LOGGER.warn("MoreColor({}) unhandled error (color is null)", (Object)name);
            this.name = "";
            this.hexCode = "";
        }
    }

    public String getName() {
        return this.name;
    }

    public String getHexCode() {
        return this.hexCode;
    }

    @Nullable
    public List<String> getAliases() {
        return this.aliases;
    }

    public class_5251 getColor() {
        return this.color;
    }

    public String toString() {
        StringBuilder result = new StringBuilder("MoreColorNode{name={");
        result.append(this.name).append("}, hexCode={").append(this.hexCode).append("}");
        if (this.color != null) {
            result.append(", color={").append(this.color).append("}");
        }
        if (!this.aliases.isEmpty()) {
            StringBuilder result2 = new StringBuilder("[");
            int i = 0;
            result.append(", aliases=");
            for (String entry : this.aliases) {
                if (i > 0) {
                    result2.append(",");
                }
                result2.append("{").append(entry).append("}");
                ++i;
            }
            result2.append("]");
            result.append((CharSequence)result2);
        }
        result.append("}");
        return result.toString();
    }
}

