package us.potatoboy.nostrip.client;

import net.fabricmc.api.ClientModInitializer;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.fabricmc.fabric.api.client.event.lifecycle.v1.ClientLifecycleEvents;
import net.fabricmc.fabric.api.client.event.lifecycle.v1.ClientTickEvents;
import net.fabricmc.fabric.api.client.keybinding.v1.KeyBindingHelper;
import net.fabricmc.fabric.api.event.player.UseBlockCallback;
import net.fabricmc.loader.api.FabricLoader;
import net.minecraft.class_1269;
import net.minecraft.class_1657;
import net.minecraft.class_1743;
import net.minecraft.class_1799;
import net.minecraft.class_1821;
import net.minecraft.class_2338;
import net.minecraft.class_2561;
import net.minecraft.class_2680;
import net.minecraft.class_2960;
import net.minecraft.class_304;
import net.minecraft.class_310;
import net.minecraft.class_3675;
import net.minecraft.class_5953;
import net.minecraft.class_5955;
import net.minecraft.class_9334;
import net.minecraft.item.*;
import org.lwjgl.glfw.GLFW;

import java.io.File;

@Environment(EnvType.CLIENT)
public class NostripClient implements ClientModInitializer {
    private static class_304 keyBinding;
    private boolean doStrip = false;
    private final class_2561 on = class_2561.method_43471("text.nostrip.on");
    private final class_2561 off = class_2561.method_43471("text.nostrip.off");
    private static long lastMessage = 0;
    private static final int MESSAGE_REPEAT_TIME = 1000;
    private static NoStripConfig config;

    @Override
    public void onInitializeClient() {

        // Create config object from JSON
        config = NoStripConfig.loadConfig(new File(FabricLoader.getInstance().getConfigDir() + "/nostrip_config.json"));
        doStrip = config.isStripping();

        UseBlockCallback.EVENT.register(((playerEntity, world, hand, blockHitResult) -> {
            if (!world.method_8608()) return class_1269.field_5811;
            if (doStrip) return class_1269.field_5811;

            class_1799 stack = playerEntity.method_5998(hand);
            class_2338 blockPos = blockHitResult.method_17777();
            class_2680 blockState = world.method_8320(blockPos);

            if (stack.method_57353().method_57832(class_9334.field_50077)) {
                if (class_1743.field_7898.containsKey(blockState.method_26204())
                        || class_5955.field_29565.get().containsKey(blockState.method_26204())
                        || class_5953.field_29561.get().containsKey(blockState.method_26204())
                ) {
                    informPlayer(playerEntity);
                    return class_1269.field_5814;
                }
            }

            if (stack.method_7909() instanceof class_1821) {
                if (class_1821.field_8912.containsKey(blockState.method_26204())) {
                    informPlayer(playerEntity);
                    return class_1269.field_5814;
                }
            }
            return class_1269.field_5811;
        }));
        ClientLifecycleEvents.CLIENT_STOPPING.register((class_310 client) -> {
            config.saveConfig(new File(FabricLoader.getInstance().getConfigDir() + "/nostrip_config.json"));
        });

        var catagory = class_304.class_11900.method_74698(class_2960.method_60655("nostrip", "keys"));

        keyBinding = KeyBindingHelper.registerKeyBinding(new class_304(
                "key.nostrip.togglestrip",
                class_3675.class_307.field_1668,
                GLFW.GLFW_KEY_Y,
                catagory
        ));

        ClientTickEvents.END_CLIENT_TICK.register(client -> {
            while (keyBinding.method_1436()) {
                doStrip = !doStrip;
                client.field_1724.method_7353(class_2561.method_43469("text.nostrip.toggle", doStrip ? on : off), true);
            }
        });
    }

    private void informPlayer(class_1657 player) {
        if (!config.isFeedback() || System.currentTimeMillis() < lastMessage + MESSAGE_REPEAT_TIME) {
            return;
        }
        lastMessage = System.currentTimeMillis();
        class_2561 message;
        if (KeyBindingHelper.getBoundKeyOf(keyBinding).method_1444() == GLFW.GLFW_KEY_UNKNOWN) {
            message = class_2561.method_43471("text.nostrip.prevented");
        } else {
            message = class_2561.method_43469("text.nostrip.enableby", KeyBindingHelper.getBoundKeyOf(keyBinding).method_27445());
        }
        player.method_7353(message, true);
    }
}
