/*
 * Decompiled with CFR 0.152.
 */
package com.torikun9971.itemprotectionenchantments.enchantments;

import com.torikun9971.itemprotectionenchantments.config.ModConfiguration;
import java.util.function.Predicate;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.EnchantmentCategory;
import net.minecraft.world.level.block.ShulkerBoxBlock;

public abstract class BaseProtectionEnchantment
extends Enchantment {
    public static final int MIN_COST = 30;
    public static final int MAX_COST = 50;
    public static final Enchantment.Rarity RARITY = Enchantment.Rarity.VERY_RARE;
    public static final EnchantmentCategories CATEGORY = EnchantmentCategories.ITEMS_AND_COMPATIBLE_BLOCKS;

    public BaseProtectionEnchantment() {
        super(RARITY, CATEGORY.getEnchantmentCategory(), EquipmentSlot.values());
    }

    public int m_6183_(int enchantmentLevel) {
        return this.getConfig().getMinimumCost();
    }

    public int m_6175_(int enchantmentLevel) {
        return 50;
    }

    public Enchantment.Rarity m_44699_() {
        return this.getConfig().getRarity();
    }

    public boolean m_6081_(ItemStack stack) {
        return this.getConfig().getEnchantableItems().getPredicate().test(stack.m_41720_());
    }

    public boolean m_6591_() {
        return this.getConfig().isTreasure();
    }

    public boolean m_6594_() {
        return this.getConfig().isTradeable();
    }

    public boolean canApplyAtEnchantingTable(ItemStack stack) {
        return this.m_6081_(stack);
    }

    protected abstract ModConfiguration.IBaseProtectionConfig getConfig();

    public static enum EnchantmentCategories {
        ALL_ITEMS("all_items", item -> true),
        ITEMS_AND_COMPATIBLE_BLOCKS("items_and_compatible_blocks", item -> {
            BlockItem blockItem;
            if (!(item instanceof BlockItem)) {
                return true;
            }
            return item instanceof BlockItem && (blockItem = (BlockItem)item).m_40614_() instanceof ShulkerBoxBlock;
        }),
        ITEMS_ONLY("items_only", item -> !(item instanceof BlockItem));

        private final Predicate<Item> predicate;
        private final EnchantmentCategory category;

        private EnchantmentCategories(String name, Predicate<Item> predicate) {
            this.predicate = predicate;
            this.category = EnchantmentCategory.create((String)name, predicate);
        }

        public Predicate<Item> getPredicate() {
            return this.predicate;
        }

        public EnchantmentCategory getEnchantmentCategory() {
            return this.category;
        }
    }
}

