/*
 * Decompiled with CFR 0.152.
 */
package com.torikun9971.itemprotectionenchantments;

import com.mojang.logging.LogUtils;
import com.torikun9971.itemprotectionenchantments.config.ModConfiguration;
import com.torikun9971.itemprotectionenchantments.event.ModEvents;
import com.torikun9971.itemprotectionenchantments.init.ModEnchantments;
import me.shedaniel.autoconfig.AutoConfig;
import me.shedaniel.autoconfig.serializer.JanksonConfigSerializer;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.Enchantment;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import net.neoforged.bus.api.IEventBus;
import net.neoforged.fml.ModLoadingContext;
import net.neoforged.fml.common.Mod;
import net.neoforged.fml.event.lifecycle.FMLClientSetupEvent;
import net.neoforged.fml.event.lifecycle.FMLCommonSetupEvent;
import net.neoforged.fml.loading.FMLEnvironment;
import net.neoforged.neoforge.client.gui.IConfigScreenFactory;
import net.neoforged.neoforge.common.NeoForge;
import org.slf4j.Logger;

@Mod(value="protection_enchantments")
public class ItemProtectionEnchantments {
    public static final String MOD_ID = "protection_enchantments";
    public static final Logger LOGGER = LogUtils.getLogger();

    public ItemProtectionEnchantments(IEventBus eventBus) {
        ModEnchantments.ENCHANTMENTS.register(eventBus);
        eventBus.addListener(this::setup);
        if (FMLEnvironment.dist.isClient()) {
            eventBus.addListener(this::setupClient);
        }
    }

    private void setup(FMLCommonSetupEvent event) {
        IEventBus modEventBus = NeoForge.EVENT_BUS;
        modEventBus.register((Object)new ModEvents());
        AutoConfig.register(ModConfiguration.class, JanksonConfigSerializer::new);
    }

    @OnlyIn(value=Dist.CLIENT)
    private void setupClient(FMLClientSetupEvent event) {
        ModLoadingContext.get().registerExtensionPoint(IConfigScreenFactory.class, () -> (client, parent) -> (Screen)AutoConfig.getConfigScreen(ModConfiguration.class, (Screen)parent).get());
    }

    public static boolean hasEnchantment(ItemStack itemStack, boolean mustHaveAll, Enchantment ... enchantments) {
        for (Enchantment enchantment : enchantments) {
            int lvl = itemStack.getEnchantmentLevel(enchantment);
            if (mustHaveAll && lvl < 1) {
                return false;
            }
            if (mustHaveAll || lvl <= 0) continue;
            return true;
        }
        return mustHaveAll;
    }
}

