/*
 * Decompiled with CFR 0.152.
 */
package com.torikun9971.itemprotectionenchantments.enchantments;

import com.torikun9971.itemprotectionenchantments.config.ModConfiguration;
import java.util.function.Predicate;
import net.minecraft.tags.ItemTags;
import net.minecraft.tags.TagKey;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.level.block.ShulkerBoxBlock;

public abstract class BaseProtectionEnchantment
extends Enchantment {
    public static final EnchantmentPredicates PREDICATE = EnchantmentPredicates.ITEMS_AND_COMPATIBLE_BLOCKS;
    public static final int MIN_LEVEL = 30;
    public static final int MAX_LEVEL = 50;
    public static final int ANVIL_COST = 4;
    public static final int WEIGHT = 1;

    public BaseProtectionEnchantment() {
        super(Enchantment.definition((TagKey)ItemTags.AXES, (int)1, (int)1, (Enchantment.Cost)Enchantment.constantCost((int)30), (Enchantment.Cost)Enchantment.constantCost((int)50), (int)4, (EquipmentSlot[])EquipmentSlot.values()));
    }

    public int getMinCost(int enchantmentLevel) {
        return this.getConfig().getMinimumCost();
    }

    public int getMaxCost(int enchantmentLevel) {
        return 50;
    }

    public int getAnvilCost() {
        return this.getConfig().getAnvilCost();
    }

    public int getWeight() {
        return this.getConfig().getWeight();
    }

    public boolean canEnchant(ItemStack stack) {
        return this.getConfig().getEnchantableItems().getPredicate().test(stack.getItem());
    }

    public boolean isTreasureOnly() {
        return this.getConfig().isTreasure();
    }

    public boolean isTradeable() {
        return this.getConfig().isTradeable();
    }

    public boolean canApplyAtEnchantingTable(ItemStack stack) {
        return this.canEnchant(stack);
    }

    protected abstract ModConfiguration.IBaseProtectionConfig getConfig();

    public static enum EnchantmentPredicates {
        ALL_ITEMS(item -> true),
        ITEMS_AND_COMPATIBLE_BLOCKS(item -> {
            BlockItem blockItem;
            if (!(item instanceof BlockItem)) {
                return true;
            }
            return item instanceof BlockItem && (blockItem = (BlockItem)item).getBlock() instanceof ShulkerBoxBlock;
        }),
        ITEMS_ONLY(item -> !(item instanceof BlockItem));

        private final Predicate<Item> predicate;

        private EnchantmentPredicates(Predicate<Item> predicate) {
            this.predicate = predicate;
        }

        public Predicate<Item> getPredicate() {
            return this.predicate;
        }
    }
}

