/*
 * Decompiled with CFR 0.152.
 */
package com.torikun9971.itemprotectionenchantments.mixins;

import com.torikun9971.itemprotectionenchantments.ItemProtectionEnchantments;
import com.torikun9971.itemprotectionenchantments.config.ModConfiguration;
import com.torikun9971.itemprotectionenchantments.init.ModEnchantments;
import java.util.List;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Redirect;

@Mixin(value={Player.class})
public abstract class PlayerMixin {
    @Redirect(method={"dropEquipment"}, at=@At(value="INVOKE", target="Lnet/minecraft/world/entity/player/Player;destroyVanishingCursedItems()V", ordinal=0))
    private void protection_enchantments$destroyVanishingCursedItems(Player player) {
        for (int i = 0; i < player.inventory.getContainerSize(); ++i) {
            ItemStack itemstack = player.inventory.getItem(i);
            if (itemstack.isEmpty() || !EnchantmentHelper.hasVanishingCurse((ItemStack)itemstack) || ItemProtectionEnchantments.hasEnchantment(itemstack, true, (Enchantment)ModEnchantments.INVENTORY_HOLDING.get()) && ModConfiguration.getConfig().inventoryHolding.isVanishingCurseDisabled) continue;
            player.inventory.removeItemNoUpdate(i);
        }
    }

    @Redirect(method={"dropEquipment"}, at=@At(value="INVOKE", target="Lnet/minecraft/world/entity/player/Inventory;dropAll()V", ordinal=0))
    private void protection_enchantments$dropAll(Inventory inventory) {
        for (List list : inventory.compartments) {
            for (int i = 0; i < list.size(); ++i) {
                ItemStack itemstack = (ItemStack)list.get(i);
                if (itemstack.isEmpty()) continue;
                if (ItemProtectionEnchantments.hasEnchantment(itemstack, true, (Enchantment)ModEnchantments.INVENTORY_HOLDING.get())) continue;
                inventory.player.drop(itemstack, true, false);
                list.set(i, ItemStack.EMPTY);
            }
        }
    }
}

