/*
 * Decompiled with CFR 0.152.
 */
package com.benbenlaw.colors.data;

import com.benbenlaw.colors.block.ColorsBlocks;
import com.benbenlaw.colors.block.sets.PlankLikeBlocksList;
import com.benbenlaw.colors.block.sets.StoneLikeBlocksList;
import com.benbenlaw.core.block.brightable.BrightCraftingTable;
import com.benbenlaw.core.util.ColorList;
import net.minecraft.data.PackOutput;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.ButtonBlock;
import net.minecraft.world.level.block.CeilingHangingSignBlock;
import net.minecraft.world.level.block.DoorBlock;
import net.minecraft.world.level.block.FenceBlock;
import net.minecraft.world.level.block.FenceGateBlock;
import net.minecraft.world.level.block.PressurePlateBlock;
import net.minecraft.world.level.block.RotatedPillarBlock;
import net.minecraft.world.level.block.SlabBlock;
import net.minecraft.world.level.block.SnowyDirtBlock;
import net.minecraft.world.level.block.StairBlock;
import net.minecraft.world.level.block.StandingSignBlock;
import net.minecraft.world.level.block.TrapDoorBlock;
import net.minecraft.world.level.block.WallBlock;
import net.minecraft.world.level.block.WallHangingSignBlock;
import net.minecraft.world.level.block.WallSignBlock;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.DoubleBlockHalf;
import net.minecraft.world.level.block.state.properties.Property;
import net.neoforged.neoforge.client.model.generators.BlockModelBuilder;
import net.neoforged.neoforge.client.model.generators.BlockStateProvider;
import net.neoforged.neoforge.client.model.generators.ConfiguredModel;
import net.neoforged.neoforge.client.model.generators.ItemModelBuilder;
import net.neoforged.neoforge.client.model.generators.ModelBuilder;
import net.neoforged.neoforge.client.model.generators.ModelFile;
import net.neoforged.neoforge.common.data.ExistingFileHelper;
import net.neoforged.neoforge.registries.DeferredBlock;

public class ColorsBlockStatesProvider
extends BlockStateProvider {
    public ColorsBlockStatesProvider(PackOutput output, ExistingFileHelper existingFileHelper) {
        super(output, "colors", existingFileHelper);
    }

    protected void registerStatesAndModels() {
        for (String color : ColorList.COLORS) {
            String keyPrefix;
            String singularType;
            this.simpleBlock((Block)ColorsBlocks.SAPLINGS.get(color + "_sapling").get(), (ModelFile)((BlockModelBuilder)((BlockModelBuilder)this.models().cross(color + "_sapling", this.modLoc("block/" + color + "_sapling"))).texture("cross", this.modLoc("block/" + color + "_sapling"))).renderType("cutout"));
            this.logBlock((RotatedPillarBlock)ColorsBlocks.LOGS.get(color + "_log").get());
            this.logBlock((RotatedPillarBlock)ColorsBlocks.LOGS.get(color + "_stripped_log").get());
            this.axisBlock((RotatedPillarBlock)ColorsBlocks.WOOD.get(color + "_wood").get(), this.blockTexture((Block)ColorsBlocks.LOGS.get(color + "_log").get()), this.blockTexture((Block)ColorsBlocks.LOGS.get(color + "_log").get()));
            this.axisBlock((RotatedPillarBlock)ColorsBlocks.WOOD.get(color + "_stripped_wood").get(), this.blockTexture((Block)ColorsBlocks.LOGS.get(color + "_stripped_log").get()), this.blockTexture((Block)ColorsBlocks.LOGS.get(color + "_stripped_log").get()));
            this.itemModels().withExistingParent(color + "_log", this.modLoc("block/" + color + "_log"));
            this.itemModels().withExistingParent(color + "_stripped_log", this.modLoc("block/" + color + "_stripped_log"));
            this.itemModels().withExistingParent(color + "_wood", this.modLoc("block/" + color + "_wood"));
            this.itemModels().withExistingParent(color + "_stripped_wood", this.modLoc("block/" + color + "_stripped_wood"));
            this.logBlock((RotatedPillarBlock)ColorsBlocks.BAMBOO.get(color + "_bamboo").get());
            this.logBlock((RotatedPillarBlock)ColorsBlocks.BAMBOO.get(color + "_stripped_bamboo").get());
            this.itemModels().withExistingParent(color + "_bamboo", this.modLoc("block/" + color + "_bamboo"));
            this.itemModels().withExistingParent(color + "_stripped_bamboo", this.modLoc("block/" + color + "_stripped_bamboo"));
            this.blockWithItem(ColorsBlocks.LEAVES.get(color + "_leaves"));
            this.simpleBlock((Block)ColorsBlocks.SHORT_GRASS.get(color + "_short_grass").get(), (ModelFile)((BlockModelBuilder)this.models().cross(color + "_short_grass", this.modLoc("block/" + color + "_short_grass"))).renderType("cutout"));
            ((ItemModelBuilder)this.itemModels().singleTexture(color + "_short_grass", this.mcLoc("item/generated"), "layer0", this.modLoc("block/" + color + "_short_grass"))).renderType("cutout");
            this.getVariantBuilder((Block)ColorsBlocks.TALL_GRASS.get(color + "_tall_grass").get()).forAllStates(state -> {
                DoubleBlockHalf half = (DoubleBlockHalf)state.getValue((Property)BlockStateProperties.DOUBLE_BLOCK_HALF);
                ModelBuilder model = ((BlockModelBuilder)this.models().cross(color + "_tall_grass_" + (half == DoubleBlockHalf.LOWER ? "bottom" : "top"), this.modLoc("block/" + color + "_tall_grass_" + (half == DoubleBlockHalf.LOWER ? "bottom" : "top")))).renderType("cutout");
                return ConfiguredModel.builder().modelFile((ModelFile)model).build();
            });
            ((ItemModelBuilder)this.itemModels().singleTexture(color + "_tall_grass", this.mcLoc("item/generated"), "layer0", this.modLoc("block/" + color + "_tall_grass_top"))).renderType("cutout");
            this.simpleBlock((Block)ColorsBlocks.POPPY.get(color + "_poppy").get(), (ModelFile)((BlockModelBuilder)this.models().cross(color + "_poppy", this.modLoc("block/" + color + "_poppy"))).renderType("cutout"));
            this.simpleBlock((Block)ColorsBlocks.POTTED_POPPY.get(color + "_potted_poppy").get(), (ModelFile)((BlockModelBuilder)this.models().singleTexture("potted_poppy", ResourceLocation.fromNamespaceAndPath((String)"colors", (String)"tintable_flower_pot_cross"), "plant", ResourceLocation.parse((String)"colors:block/poppy"))).renderType("cutout"));
            this.simpleBlock((Block)ColorsBlocks.DANDELION.get(color + "_dandelion").get(), (ModelFile)((BlockModelBuilder)this.models().cross(color + "_dandelion", this.modLoc("block/" + color + "_dandelion"))).renderType("cutout"));
            this.simpleBlock((Block)ColorsBlocks.POTTED_DANDELION.get(color + "_potted_dandelion").get(), (ModelFile)((BlockModelBuilder)this.models().singleTexture("potted_dandelion", ResourceLocation.fromNamespaceAndPath((String)"colors", (String)"tintable_flower_pot_cross"), "plant", ResourceLocation.parse((String)"colors:block/dandelion"))).renderType("cutout"));
            this.blockWithItem(ColorsBlocks.DIRT.get(color + "_dirt"));
            this.getVariantBuilder((Block)ColorsBlocks.GRASS_BLOCK.get(color + "_grass_block").get()).forAllStates(state -> {
                boolean snowy = (Boolean)state.getValue((Property)SnowyDirtBlock.SNOWY);
                String blockName = color + "_grass_block";
                ResourceLocation side = this.modLoc("block/" + blockName + "_side" + (snowy ? "_snow" : ""));
                ResourceLocation bottom = this.modLoc("block/" + color + "_dirt");
                ResourceLocation top = this.modLoc("block/" + blockName + "_top");
                ModelBuilder model = this.models().cubeBottomTop(blockName + (snowy ? "_snow" : ""), side, bottom, top);
                return ConfiguredModel.builder().modelFile((ModelFile)model).build();
            });
            this.itemModels().withExistingParent(color + "_grass_block", this.modLoc("block/" + color + "_grass_block"));
            this.simpleBlock((Block)((BrightCraftingTable)ColorsBlocks.CRAFTING_TABLE.get(color + "_crafting_table").get()), (ModelFile)this.models().cube(color + "_crafting_table", this.modLoc("block/" + color + "_planks"), this.modLoc("block/" + color + "_crafting_table_top"), this.modLoc("block/" + color + "_crafting_table"), this.modLoc("block/" + color + "_crafting_table_side"), this.modLoc("block/" + color + "_crafting_table_side"), this.modLoc("block/" + color + "_crafting_table")));
            this.itemModels().withExistingParent(color + "_crafting_table", this.modLoc("block/" + color + "_crafting_table"));
            for (String type : StoneLikeBlocksList.STONE_BLOCKS) {
                singularType = type.endsWith("s") ? type.substring(0, type.length() - 1) : type;
                keyPrefix = color + "_" + singularType;
                this.blockWithItem(ColorsBlocks.STONE_BLOCKS.get(color + "_" + type));
                this.slabBlock((SlabBlock)ColorsBlocks.STONE_BLOCKS.get(keyPrefix + "_slab").get(), this.blockTexture((Block)ColorsBlocks.STONE_BLOCKS.get(color + "_" + type).get()), this.blockTexture((Block)ColorsBlocks.STONE_BLOCKS.get(color + "_" + type).get()));
                this.stairsBlock((StairBlock)ColorsBlocks.STONE_BLOCKS.get(keyPrefix + "_stairs").get(), this.blockTexture((Block)ColorsBlocks.STONE_BLOCKS.get(color + "_" + type).get()));
                this.wallBlock((WallBlock)ColorsBlocks.STONE_BLOCKS.get(keyPrefix + "_wall").get(), this.blockTexture((Block)ColorsBlocks.STONE_BLOCKS.get(color + "_" + type).get()));
                this.pressurePlateBlock((PressurePlateBlock)ColorsBlocks.STONE_BLOCKS.get(keyPrefix + "_pressure_plate").get(), this.blockTexture((Block)ColorsBlocks.STONE_BLOCKS.get(color + "_" + type).get()));
                this.buttonBlock((ButtonBlock)ColorsBlocks.STONE_BLOCKS.get(keyPrefix + "_button").get(), this.blockTexture((Block)ColorsBlocks.STONE_BLOCKS.get(color + "_" + type).get()));
                this.itemModels().withExistingParent(keyPrefix + "_slab", this.modLoc("block/" + keyPrefix + "_slab"));
                this.itemModels().withExistingParent(keyPrefix + "_stairs", this.modLoc("block/" + keyPrefix + "_stairs"));
                ((ItemModelBuilder)this.itemModels().withExistingParent(keyPrefix + "_wall", this.mcLoc("block/wall_inventory"))).texture("wall", this.blockTexture((Block)ColorsBlocks.STONE_BLOCKS.get(color + "_" + type).get()));
                this.itemModels().withExistingParent(keyPrefix + "_pressure_plate", this.modLoc("block/" + keyPrefix + "_pressure_plate"));
                ((ItemModelBuilder)this.itemModels().withExistingParent(keyPrefix + "_button", this.mcLoc("block/button_inventory"))).texture("texture", this.blockTexture((Block)ColorsBlocks.STONE_BLOCKS.get(color + "_" + type).get()));
            }
            for (String type : PlankLikeBlocksList.PLANKS) {
                singularType = type.endsWith("s") ? type.substring(0, type.length() - 1) : type;
                keyPrefix = color + "_" + singularType;
                this.blockWithItem(ColorsBlocks.PLANKS.get(color + "_" + type));
                this.slabBlock((SlabBlock)ColorsBlocks.PLANKS.get(keyPrefix + "_slab").get(), this.blockTexture((Block)ColorsBlocks.PLANKS.get(color + "_" + type).get()), this.blockTexture((Block)ColorsBlocks.PLANKS.get(color + "_" + type).get()));
                this.stairsBlock((StairBlock)ColorsBlocks.PLANKS.get(keyPrefix + "_stairs").get(), this.blockTexture((Block)ColorsBlocks.PLANKS.get(color + "_" + type).get()));
                this.pressurePlateBlock((PressurePlateBlock)ColorsBlocks.PLANKS.get(keyPrefix + "_pressure_plate").get(), this.blockTexture((Block)ColorsBlocks.PLANKS.get(color + "_" + type).get()));
                this.buttonBlock((ButtonBlock)ColorsBlocks.PLANKS.get(keyPrefix + "_button").get(), this.blockTexture((Block)ColorsBlocks.PLANKS.get(color + "_" + type).get()));
                this.fenceBlock((FenceBlock)ColorsBlocks.PLANKS.get(keyPrefix + "_fence").get(), this.blockTexture((Block)ColorsBlocks.PLANKS.get(color + "_" + type).get()));
                this.fenceGateBlock((FenceGateBlock)ColorsBlocks.PLANKS.get(keyPrefix + "_fence_gate").get(), this.blockTexture((Block)ColorsBlocks.PLANKS.get(color + "_" + type).get()));
                this.doorBlockWithRenderType((DoorBlock)ColorsBlocks.PLANKS.get(keyPrefix + "_door").get(), ResourceLocation.parse((String)("colors:block/" + color + "_" + singularType + "_door_bottom")), ResourceLocation.parse((String)("colors:block/" + color + "_" + singularType + "_door_top")), "cutout");
                this.trapdoorBlockWithRenderType((TrapDoorBlock)ColorsBlocks.PLANKS.get(keyPrefix + "_trapdoor").get(), this.blockTexture((Block)ColorsBlocks.PLANKS.get(keyPrefix + "_trapdoor").get()), true, "cutout");
                this.signBlock((StandingSignBlock)ColorsBlocks.PLANKS.get(keyPrefix + "_sign").get(), (WallSignBlock)ColorsBlocks.PLANKS.get(keyPrefix + "_wall_sign").get(), this.blockTexture((Block)ColorsBlocks.PLANKS.get(color + "_" + type).get()));
                this.hangingSignBlock((CeilingHangingSignBlock)ColorsBlocks.PLANKS.get(keyPrefix + "_hanging_sign").get(), (WallHangingSignBlock)ColorsBlocks.PLANKS.get(keyPrefix + "_wall_hanging_sign").get(), this.blockTexture((Block)ColorsBlocks.PLANKS.get(color + "_" + type).get()));
                this.itemModels().withExistingParent(keyPrefix + "_slab", this.modLoc("block/" + keyPrefix + "_slab"));
                this.itemModels().withExistingParent(keyPrefix + "_stairs", this.modLoc("block/" + keyPrefix + "_stairs"));
                this.itemModels().withExistingParent(keyPrefix + "_pressure_plate", this.modLoc("block/" + keyPrefix + "_pressure_plate"));
                ((ItemModelBuilder)this.itemModels().withExistingParent(keyPrefix + "_button", this.mcLoc("block/button_inventory"))).texture("texture", this.blockTexture((Block)ColorsBlocks.PLANKS.get(color + "_" + type).get()));
                ((ItemModelBuilder)this.itemModels().withExistingParent(keyPrefix + "_fence", this.mcLoc("block/fence_inventory"))).texture("texture", this.blockTexture((Block)ColorsBlocks.PLANKS.get(color + "_" + type).get()));
                this.itemModels().withExistingParent(keyPrefix + "_fence_gate", this.modLoc("block/" + keyPrefix + "_fence_gate"));
                this.itemModels().basicItem(((Block)ColorsBlocks.PLANKS.get(keyPrefix + "_door").get()).asItem());
                this.itemModels().withExistingParent(keyPrefix + "_trapdoor", this.modLoc("block/" + keyPrefix + "_trapdoor_bottom"));
                this.itemModels().basicItem(((Block)ColorsBlocks.PLANKS.get(keyPrefix + "_sign").get()).asItem());
                this.itemModels().basicItem(((Block)ColorsBlocks.PLANKS.get(keyPrefix + "_hanging_sign").get()).asItem());
            }
        }
    }

    private void blockWithItem(DeferredBlock<Block> deferredBlock) {
        this.simpleBlockWithItem((Block)deferredBlock.get(), this.cubeAll((Block)deferredBlock.get()));
    }

    public String getName() {
        return "colors Block States";
    }
}

