/*
 * Decompiled with CFR 0.152.
 */
package com.benbenlaw.colors.worldgen;

import com.benbenlaw.colors.block.ColorsBlocks;
import com.benbenlaw.core.block.brightable.BrightBlock;
import com.benbenlaw.core.block.brightable.BrightLeaves;
import com.benbenlaw.core.block.brightable.BrightLog;
import com.benbenlaw.core.util.ColorList;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.core.registries.Registries;
import net.minecraft.data.worldgen.BootstrapContext;
import net.minecraft.data.worldgen.features.FeatureUtils;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.BlockTags;
import net.minecraft.util.random.SimpleWeightedRandomList;
import net.minecraft.util.valueproviders.ConstantInt;
import net.minecraft.util.valueproviders.IntProvider;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.levelgen.feature.ConfiguredFeature;
import net.minecraft.world.level.levelgen.feature.Feature;
import net.minecraft.world.level.levelgen.feature.configurations.FeatureConfiguration;
import net.minecraft.world.level.levelgen.feature.configurations.OreConfiguration;
import net.minecraft.world.level.levelgen.feature.configurations.SimpleBlockConfiguration;
import net.minecraft.world.level.levelgen.feature.configurations.TreeConfiguration;
import net.minecraft.world.level.levelgen.feature.featuresize.FeatureSize;
import net.minecraft.world.level.levelgen.feature.featuresize.TwoLayersFeatureSize;
import net.minecraft.world.level.levelgen.feature.foliageplacers.AcaciaFoliagePlacer;
import net.minecraft.world.level.levelgen.feature.foliageplacers.BlobFoliagePlacer;
import net.minecraft.world.level.levelgen.feature.foliageplacers.FoliagePlacer;
import net.minecraft.world.level.levelgen.feature.foliageplacers.SpruceFoliagePlacer;
import net.minecraft.world.level.levelgen.feature.stateproviders.BlockStateProvider;
import net.minecraft.world.level.levelgen.feature.stateproviders.WeightedStateProvider;
import net.minecraft.world.level.levelgen.feature.trunkplacers.ForkingTrunkPlacer;
import net.minecraft.world.level.levelgen.feature.trunkplacers.StraightTrunkPlacer;
import net.minecraft.world.level.levelgen.feature.trunkplacers.TrunkPlacer;
import net.minecraft.world.level.levelgen.structure.templatesystem.RuleTest;
import net.minecraft.world.level.levelgen.structure.templatesystem.TagMatchTest;

public class ColorsConfiguredFeatures {
    public static final Map<String, ResourceKey<ConfiguredFeature<?, ?>>> GRASS_BONEMEAL_KEY = new HashMap();
    public static final Map<String, ResourceKey<ConfiguredFeature<?, ?>>> TREES_KEY = new HashMap();
    public static final Map<String, ResourceKey<ConfiguredFeature<?, ?>>> STONE_KEY = new HashMap();

    public static void bootstrap(BootstrapContext<ConfiguredFeature<?, ?>> context) {
        for (String color : ColorList.COLORS) {
            FeatureUtils.register(context, GRASS_BONEMEAL_KEY.get(color), (Feature)Feature.SIMPLE_BLOCK, (FeatureConfiguration)new SimpleBlockConfiguration((BlockStateProvider)new WeightedStateProvider(new SimpleWeightedRandomList.Builder().add((Object)((Block)ColorsBlocks.DANDELION.get(color + "_dandelion").get()).defaultBlockState(), 10).add((Object)((Block)ColorsBlocks.POPPY.get(color + "_poppy").get()).defaultBlockState(), 10).add((Object)((Block)ColorsBlocks.SHORT_GRASS.get(color + "_short_grass").get()).defaultBlockState(), 40).add((Object)((Block)ColorsBlocks.TALL_GRASS.get(color + "_tall_grass").get()).defaultBlockState(), 5))));
        }
        FeatureUtils.register(context, TREES_KEY.get("black"), (Feature)Feature.TREE, (FeatureConfiguration)new TreeConfiguration.TreeConfigurationBuilder((BlockStateProvider)BlockStateProvider.simple((BlockState)((BlockState)((Block)ColorsBlocks.LOGS.get("black_log").get()).defaultBlockState().setValue((Property)BrightLog.LIT, (Comparable)Boolean.valueOf(false)))), (TrunkPlacer)new StraightTrunkPlacer(4, 2, 0), (BlockStateProvider)BlockStateProvider.simple((BlockState)((BlockState)((Block)ColorsBlocks.LEAVES.get("black_leaves").get()).defaultBlockState().setValue((Property)BrightLeaves.LIT, (Comparable)Boolean.valueOf(false)))), (FoliagePlacer)new BlobFoliagePlacer((IntProvider)ConstantInt.of((int)2), (IntProvider)ConstantInt.of((int)0), 3), (FeatureSize)new TwoLayersFeatureSize(1, 0, 1)).dirt((BlockStateProvider)BlockStateProvider.simple((BlockState)((BlockState)((Block)ColorsBlocks.DIRT.get("black_dirt").get()).defaultBlockState().setValue((Property)BrightBlock.LIT, (Comparable)Boolean.valueOf(false))))).build());
        FeatureUtils.register(context, TREES_KEY.get("red"), (Feature)Feature.TREE, (FeatureConfiguration)new TreeConfiguration.TreeConfigurationBuilder((BlockStateProvider)BlockStateProvider.simple((BlockState)((BlockState)((Block)ColorsBlocks.LOGS.get("red_log").get()).defaultBlockState().setValue((Property)BrightLog.LIT, (Comparable)Boolean.valueOf(false)))), (TrunkPlacer)new StraightTrunkPlacer(7, 5, 7), (BlockStateProvider)BlockStateProvider.simple((BlockState)((BlockState)((Block)ColorsBlocks.LEAVES.get("red_leaves").get()).defaultBlockState().setValue((Property)BrightLeaves.LIT, (Comparable)Boolean.valueOf(false)))), (FoliagePlacer)new SpruceFoliagePlacer((IntProvider)ConstantInt.of((int)4), (IntProvider)ConstantInt.of((int)0), (IntProvider)ConstantInt.of((int)4)), (FeatureSize)new TwoLayersFeatureSize(1, 0, 1)).dirt((BlockStateProvider)BlockStateProvider.simple((BlockState)((BlockState)((Block)ColorsBlocks.DIRT.get("red_dirt").get()).defaultBlockState().setValue((Property)BrightBlock.LIT, (Comparable)Boolean.valueOf(false))))).build());
        FeatureUtils.register(context, TREES_KEY.get("blue"), (Feature)Feature.TREE, (FeatureConfiguration)new TreeConfiguration.TreeConfigurationBuilder((BlockStateProvider)BlockStateProvider.simple((BlockState)((BlockState)((Block)ColorsBlocks.LOGS.get("blue_log").get()).defaultBlockState().setValue((Property)BrightLog.LIT, (Comparable)Boolean.valueOf(false)))), (TrunkPlacer)new StraightTrunkPlacer(7, 5, 7), (BlockStateProvider)BlockStateProvider.simple((BlockState)((BlockState)((Block)ColorsBlocks.LEAVES.get("blue_leaves").get()).defaultBlockState().setValue((Property)BrightLeaves.LIT, (Comparable)Boolean.valueOf(false)))), (FoliagePlacer)new SpruceFoliagePlacer((IntProvider)ConstantInt.of((int)4), (IntProvider)ConstantInt.of((int)0), (IntProvider)ConstantInt.of((int)4)), (FeatureSize)new TwoLayersFeatureSize(1, 0, 1)).dirt((BlockStateProvider)BlockStateProvider.simple((BlockState)((BlockState)((Block)ColorsBlocks.DIRT.get("blue_dirt").get()).defaultBlockState().setValue((Property)BrightBlock.LIT, (Comparable)Boolean.valueOf(false))))).build());
        FeatureUtils.register(context, TREES_KEY.get("light_blue"), (Feature)Feature.TREE, (FeatureConfiguration)new TreeConfiguration.TreeConfigurationBuilder((BlockStateProvider)BlockStateProvider.simple((BlockState)((BlockState)((Block)ColorsBlocks.LOGS.get("light_blue_log").get()).defaultBlockState().setValue((Property)BrightLog.LIT, (Comparable)Boolean.valueOf(false)))), (TrunkPlacer)new StraightTrunkPlacer(7, 5, 7), (BlockStateProvider)BlockStateProvider.simple((BlockState)((BlockState)((Block)ColorsBlocks.LEAVES.get("light_blue_leaves").get()).defaultBlockState().setValue((Property)BrightLeaves.LIT, (Comparable)Boolean.valueOf(false)))), (FoliagePlacer)new SpruceFoliagePlacer((IntProvider)ConstantInt.of((int)4), (IntProvider)ConstantInt.of((int)0), (IntProvider)ConstantInt.of((int)4)), (FeatureSize)new TwoLayersFeatureSize(1, 0, 1)).dirt((BlockStateProvider)BlockStateProvider.simple((BlockState)((BlockState)((Block)ColorsBlocks.DIRT.get("light_blue_dirt").get()).defaultBlockState().setValue((Property)BrightBlock.LIT, (Comparable)Boolean.valueOf(false))))).build());
        FeatureUtils.register(context, TREES_KEY.get("cyan"), (Feature)Feature.TREE, (FeatureConfiguration)new TreeConfiguration.TreeConfigurationBuilder((BlockStateProvider)BlockStateProvider.simple((BlockState)((BlockState)((Block)ColorsBlocks.LOGS.get("cyan_log").get()).defaultBlockState().setValue((Property)BrightLog.LIT, (Comparable)Boolean.valueOf(false)))), (TrunkPlacer)new StraightTrunkPlacer(7, 5, 7), (BlockStateProvider)BlockStateProvider.simple((BlockState)((BlockState)((Block)ColorsBlocks.LEAVES.get("cyan_leaves").get()).defaultBlockState().setValue((Property)BrightLeaves.LIT, (Comparable)Boolean.valueOf(false)))), (FoliagePlacer)new SpruceFoliagePlacer((IntProvider)ConstantInt.of((int)4), (IntProvider)ConstantInt.of((int)0), (IntProvider)ConstantInt.of((int)4)), (FeatureSize)new TwoLayersFeatureSize(1, 0, 1)).dirt((BlockStateProvider)BlockStateProvider.simple((BlockState)((BlockState)((Block)ColorsBlocks.DIRT.get("cyan_dirt").get()).defaultBlockState().setValue((Property)BrightBlock.LIT, (Comparable)Boolean.valueOf(false))))).build());
        FeatureUtils.register(context, TREES_KEY.get("green"), (Feature)Feature.TREE, (FeatureConfiguration)new TreeConfiguration.TreeConfigurationBuilder((BlockStateProvider)BlockStateProvider.simple((BlockState)((BlockState)((Block)ColorsBlocks.LOGS.get("green_log").get()).defaultBlockState().setValue((Property)BrightLog.LIT, (Comparable)Boolean.valueOf(false)))), (TrunkPlacer)new StraightTrunkPlacer(7, 5, 0), (BlockStateProvider)BlockStateProvider.simple((BlockState)((BlockState)((Block)ColorsBlocks.LEAVES.get("green_leaves").get()).defaultBlockState().setValue((Property)BrightLeaves.LIT, (Comparable)Boolean.valueOf(false)))), (FoliagePlacer)new BlobFoliagePlacer((IntProvider)ConstantInt.of((int)3), (IntProvider)ConstantInt.of((int)0), 3), (FeatureSize)new TwoLayersFeatureSize(1, 0, 1)).dirt((BlockStateProvider)BlockStateProvider.simple((BlockState)((BlockState)((Block)ColorsBlocks.DIRT.get("green_dirt").get()).defaultBlockState().setValue((Property)BrightBlock.LIT, (Comparable)Boolean.valueOf(false))))).build());
        FeatureUtils.register(context, TREES_KEY.get("yellow"), (Feature)Feature.TREE, (FeatureConfiguration)new TreeConfiguration.TreeConfigurationBuilder((BlockStateProvider)BlockStateProvider.simple((BlockState)((BlockState)((Block)ColorsBlocks.LOGS.get("yellow_log").get()).defaultBlockState().setValue((Property)BrightLog.LIT, (Comparable)Boolean.valueOf(false)))), (TrunkPlacer)new ForkingTrunkPlacer(7, 3, 3), (BlockStateProvider)BlockStateProvider.simple((BlockState)((BlockState)((Block)ColorsBlocks.LEAVES.get("yellow_leaves").get()).defaultBlockState().setValue((Property)BrightLeaves.LIT, (Comparable)Boolean.valueOf(false)))), (FoliagePlacer)new AcaciaFoliagePlacer((IntProvider)ConstantInt.of((int)2), (IntProvider)ConstantInt.of((int)0)), (FeatureSize)new TwoLayersFeatureSize(1, 0, 1)).dirt((BlockStateProvider)BlockStateProvider.simple((BlockState)((BlockState)((Block)ColorsBlocks.DIRT.get("yellow_dirt").get()).defaultBlockState().setValue((Property)BrightBlock.LIT, (Comparable)Boolean.valueOf(false))))).build());
        FeatureUtils.register(context, TREES_KEY.get("orange"), (Feature)Feature.TREE, (FeatureConfiguration)new TreeConfiguration.TreeConfigurationBuilder((BlockStateProvider)BlockStateProvider.simple((BlockState)((BlockState)((Block)ColorsBlocks.LOGS.get("orange_log").get()).defaultBlockState().setValue((Property)BrightLog.LIT, (Comparable)Boolean.valueOf(false)))), (TrunkPlacer)new StraightTrunkPlacer(4, 2, 0), (BlockStateProvider)BlockStateProvider.simple((BlockState)((BlockState)((Block)ColorsBlocks.LEAVES.get("orange_leaves").get()).defaultBlockState().setValue((Property)BrightLeaves.LIT, (Comparable)Boolean.valueOf(false)))), (FoliagePlacer)new BlobFoliagePlacer((IntProvider)ConstantInt.of((int)2), (IntProvider)ConstantInt.of((int)0), 3), (FeatureSize)new TwoLayersFeatureSize(1, 0, 1)).dirt((BlockStateProvider)BlockStateProvider.simple((BlockState)((BlockState)((Block)ColorsBlocks.DIRT.get("orange_dirt").get()).defaultBlockState().setValue((Property)BrightBlock.LIT, (Comparable)Boolean.valueOf(false))))).build());
        FeatureUtils.register(context, TREES_KEY.get("purple"), (Feature)Feature.TREE, (FeatureConfiguration)new TreeConfiguration.TreeConfigurationBuilder((BlockStateProvider)BlockStateProvider.simple((BlockState)((BlockState)((Block)ColorsBlocks.LOGS.get("purple_log").get()).defaultBlockState().setValue((Property)BrightLog.LIT, (Comparable)Boolean.valueOf(false)))), (TrunkPlacer)new StraightTrunkPlacer(8, 4, 0), (BlockStateProvider)BlockStateProvider.simple((BlockState)((BlockState)((Block)ColorsBlocks.LEAVES.get("purple_leaves").get()).defaultBlockState().setValue((Property)BrightLeaves.LIT, (Comparable)Boolean.valueOf(false)))), (FoliagePlacer)new BlobFoliagePlacer((IntProvider)ConstantInt.of((int)2), (IntProvider)ConstantInt.of((int)0), 3), (FeatureSize)new TwoLayersFeatureSize(1, 0, 1)).dirt((BlockStateProvider)BlockStateProvider.simple((BlockState)((BlockState)((Block)ColorsBlocks.DIRT.get("purple_dirt").get()).defaultBlockState().setValue((Property)BrightBlock.LIT, (Comparable)Boolean.valueOf(false))))).build());
        FeatureUtils.register(context, TREES_KEY.get("pink"), (Feature)Feature.TREE, (FeatureConfiguration)new TreeConfiguration.TreeConfigurationBuilder((BlockStateProvider)BlockStateProvider.simple((BlockState)((BlockState)((Block)ColorsBlocks.LOGS.get("pink_log").get()).defaultBlockState().setValue((Property)BrightLog.LIT, (Comparable)Boolean.valueOf(false)))), (TrunkPlacer)new ForkingTrunkPlacer(7, 3, 3), (BlockStateProvider)BlockStateProvider.simple((BlockState)((BlockState)((Block)ColorsBlocks.LEAVES.get("pink_leaves").get()).defaultBlockState().setValue((Property)BrightLeaves.LIT, (Comparable)Boolean.valueOf(false)))), (FoliagePlacer)new AcaciaFoliagePlacer((IntProvider)ConstantInt.of((int)2), (IntProvider)ConstantInt.of((int)0)), (FeatureSize)new TwoLayersFeatureSize(1, 0, 1)).dirt((BlockStateProvider)BlockStateProvider.simple((BlockState)((BlockState)((Block)ColorsBlocks.DIRT.get("pink_dirt").get()).defaultBlockState().setValue((Property)BrightBlock.LIT, (Comparable)Boolean.valueOf(false))))).build());
        FeatureUtils.register(context, TREES_KEY.get("lime"), (Feature)Feature.TREE, (FeatureConfiguration)new TreeConfiguration.TreeConfigurationBuilder((BlockStateProvider)BlockStateProvider.simple((BlockState)((BlockState)((Block)ColorsBlocks.LOGS.get("lime_log").get()).defaultBlockState().setValue((Property)BrightLog.LIT, (Comparable)Boolean.valueOf(false)))), (TrunkPlacer)new StraightTrunkPlacer(4, 2, 0), (BlockStateProvider)BlockStateProvider.simple((BlockState)((BlockState)((Block)ColorsBlocks.LEAVES.get("lime_leaves").get()).defaultBlockState().setValue((Property)BrightLeaves.LIT, (Comparable)Boolean.valueOf(false)))), (FoliagePlacer)new BlobFoliagePlacer((IntProvider)ConstantInt.of((int)2), (IntProvider)ConstantInt.of((int)0), 3), (FeatureSize)new TwoLayersFeatureSize(1, 0, 1)).dirt((BlockStateProvider)BlockStateProvider.simple((BlockState)((BlockState)((Block)ColorsBlocks.DIRT.get("lime_dirt").get()).defaultBlockState().setValue((Property)BrightBlock.LIT, (Comparable)Boolean.valueOf(false))))).build());
        FeatureUtils.register(context, TREES_KEY.get("magenta"), (Feature)Feature.TREE, (FeatureConfiguration)new TreeConfiguration.TreeConfigurationBuilder((BlockStateProvider)BlockStateProvider.simple((BlockState)((BlockState)((Block)ColorsBlocks.LOGS.get("magenta_log").get()).defaultBlockState().setValue((Property)BrightLog.LIT, (Comparable)Boolean.valueOf(false)))), (TrunkPlacer)new StraightTrunkPlacer(4, 2, 0), (BlockStateProvider)BlockStateProvider.simple((BlockState)((BlockState)((Block)ColorsBlocks.LEAVES.get("magenta_leaves").get()).defaultBlockState().setValue((Property)BrightLeaves.LIT, (Comparable)Boolean.valueOf(false)))), (FoliagePlacer)new BlobFoliagePlacer((IntProvider)ConstantInt.of((int)2), (IntProvider)ConstantInt.of((int)0), 3), (FeatureSize)new TwoLayersFeatureSize(1, 0, 1)).dirt((BlockStateProvider)BlockStateProvider.simple((BlockState)((BlockState)((Block)ColorsBlocks.DIRT.get("magenta_dirt").get()).defaultBlockState().setValue((Property)BrightBlock.LIT, (Comparable)Boolean.valueOf(false))))).build());
        FeatureUtils.register(context, TREES_KEY.get("light_gray"), (Feature)Feature.TREE, (FeatureConfiguration)new TreeConfiguration.TreeConfigurationBuilder((BlockStateProvider)BlockStateProvider.simple((BlockState)((BlockState)((Block)ColorsBlocks.LOGS.get("light_gray_log").get()).defaultBlockState().setValue((Property)BrightLog.LIT, (Comparable)Boolean.valueOf(false)))), (TrunkPlacer)new StraightTrunkPlacer(4, 2, 0), (BlockStateProvider)BlockStateProvider.simple((BlockState)((BlockState)((Block)ColorsBlocks.LEAVES.get("light_gray_leaves").get()).defaultBlockState().setValue((Property)BrightLeaves.LIT, (Comparable)Boolean.valueOf(false)))), (FoliagePlacer)new BlobFoliagePlacer((IntProvider)ConstantInt.of((int)2), (IntProvider)ConstantInt.of((int)0), 3), (FeatureSize)new TwoLayersFeatureSize(1, 0, 1)).dirt((BlockStateProvider)BlockStateProvider.simple((BlockState)((BlockState)((Block)ColorsBlocks.DIRT.get("light_gray_dirt").get()).defaultBlockState().setValue((Property)BrightBlock.LIT, (Comparable)Boolean.valueOf(false))))).build());
        FeatureUtils.register(context, TREES_KEY.get("gray"), (Feature)Feature.TREE, (FeatureConfiguration)new TreeConfiguration.TreeConfigurationBuilder((BlockStateProvider)BlockStateProvider.simple((BlockState)((BlockState)((Block)ColorsBlocks.LOGS.get("gray_log").get()).defaultBlockState().setValue((Property)BrightLog.LIT, (Comparable)Boolean.valueOf(false)))), (TrunkPlacer)new StraightTrunkPlacer(4, 2, 0), (BlockStateProvider)BlockStateProvider.simple((BlockState)((BlockState)((Block)ColorsBlocks.LEAVES.get("gray_leaves").get()).defaultBlockState().setValue((Property)BrightLeaves.LIT, (Comparable)Boolean.valueOf(false)))), (FoliagePlacer)new BlobFoliagePlacer((IntProvider)ConstantInt.of((int)2), (IntProvider)ConstantInt.of((int)0), 3), (FeatureSize)new TwoLayersFeatureSize(1, 0, 1)).dirt((BlockStateProvider)BlockStateProvider.simple((BlockState)((BlockState)((Block)ColorsBlocks.DIRT.get("gray_dirt").get()).defaultBlockState().setValue((Property)BrightBlock.LIT, (Comparable)Boolean.valueOf(false))))).build());
        FeatureUtils.register(context, TREES_KEY.get("white"), (Feature)Feature.TREE, (FeatureConfiguration)new TreeConfiguration.TreeConfigurationBuilder((BlockStateProvider)BlockStateProvider.simple((BlockState)((BlockState)((Block)ColorsBlocks.LOGS.get("white_log").get()).defaultBlockState().setValue((Property)BrightLog.LIT, (Comparable)Boolean.valueOf(false)))), (TrunkPlacer)new StraightTrunkPlacer(4, 2, 0), (BlockStateProvider)BlockStateProvider.simple((BlockState)((BlockState)((Block)ColorsBlocks.LEAVES.get("white_leaves").get()).defaultBlockState().setValue((Property)BrightLeaves.LIT, (Comparable)Boolean.valueOf(false)))), (FoliagePlacer)new BlobFoliagePlacer((IntProvider)ConstantInt.of((int)2), (IntProvider)ConstantInt.of((int)0), 3), (FeatureSize)new TwoLayersFeatureSize(1, 0, 1)).dirt((BlockStateProvider)BlockStateProvider.simple((BlockState)((BlockState)((Block)ColorsBlocks.DIRT.get("white_dirt").get()).defaultBlockState().setValue((Property)BrightBlock.LIT, (Comparable)Boolean.valueOf(false))))).build());
        FeatureUtils.register(context, TREES_KEY.get("brown"), (Feature)Feature.TREE, (FeatureConfiguration)new TreeConfiguration.TreeConfigurationBuilder((BlockStateProvider)BlockStateProvider.simple((BlockState)((BlockState)((Block)ColorsBlocks.LOGS.get("brown_log").get()).defaultBlockState().setValue((Property)BrightLog.LIT, (Comparable)Boolean.valueOf(false)))), (TrunkPlacer)new StraightTrunkPlacer(4, 2, 0), (BlockStateProvider)BlockStateProvider.simple((BlockState)((BlockState)((Block)ColorsBlocks.LEAVES.get("brown_leaves").get()).defaultBlockState().setValue((Property)BrightLeaves.LIT, (Comparable)Boolean.valueOf(false)))), (FoliagePlacer)new BlobFoliagePlacer((IntProvider)ConstantInt.of((int)2), (IntProvider)ConstantInt.of((int)0), 3), (FeatureSize)new TwoLayersFeatureSize(1, 0, 1)).dirt((BlockStateProvider)BlockStateProvider.simple((BlockState)((BlockState)((Block)ColorsBlocks.DIRT.get("brown_dirt").get()).defaultBlockState().setValue((Property)BrightBlock.LIT, (Comparable)Boolean.valueOf(false))))).build());
        TagMatchTest stoneReplaceables = new TagMatchTest(BlockTags.STONE_ORE_REPLACEABLES);
        TagMatchTest deepslateReplaceables = new TagMatchTest(BlockTags.DEEPSLATE_ORE_REPLACEABLES);
        ColorsConfiguredFeatures.register(context, STONE_KEY.get("black"), Feature.ORE, new OreConfiguration((RuleTest)deepslateReplaceables, ((Block)ColorsBlocks.STONE_BLOCKS.get("black_stone").get()).defaultBlockState(), 48));
        ColorsConfiguredFeatures.register(context, STONE_KEY.get("red"), Feature.ORE, new OreConfiguration((RuleTest)stoneReplaceables, ((Block)ColorsBlocks.STONE_BLOCKS.get("red_stone").get()).defaultBlockState(), 48));
        ColorsConfiguredFeatures.register(context, STONE_KEY.get("green"), Feature.ORE, new OreConfiguration((RuleTest)stoneReplaceables, ((Block)ColorsBlocks.STONE_BLOCKS.get("green_stone").get()).defaultBlockState(), 48));
        ColorsConfiguredFeatures.register(context, STONE_KEY.get("blue"), Feature.ORE, new OreConfiguration((RuleTest)stoneReplaceables, ((Block)ColorsBlocks.STONE_BLOCKS.get("blue_stone").get()).defaultBlockState(), 48));
        ColorsConfiguredFeatures.register(context, STONE_KEY.get("yellow"), Feature.ORE, new OreConfiguration((RuleTest)stoneReplaceables, ((Block)ColorsBlocks.STONE_BLOCKS.get("yellow_stone").get()).defaultBlockState(), 48));
        ColorsConfiguredFeatures.register(context, STONE_KEY.get("orange"), Feature.ORE, new OreConfiguration((RuleTest)stoneReplaceables, ((Block)ColorsBlocks.STONE_BLOCKS.get("orange_stone").get()).defaultBlockState(), 48));
        ColorsConfiguredFeatures.register(context, STONE_KEY.get("purple"), Feature.ORE, new OreConfiguration((RuleTest)stoneReplaceables, ((Block)ColorsBlocks.STONE_BLOCKS.get("purple_stone").get()).defaultBlockState(), 48));
        ColorsConfiguredFeatures.register(context, STONE_KEY.get("pink"), Feature.ORE, new OreConfiguration((RuleTest)stoneReplaceables, ((Block)ColorsBlocks.STONE_BLOCKS.get("pink_stone").get()).defaultBlockState(), 48));
        ColorsConfiguredFeatures.register(context, STONE_KEY.get("cyan"), Feature.ORE, new OreConfiguration((RuleTest)stoneReplaceables, ((Block)ColorsBlocks.STONE_BLOCKS.get("cyan_stone").get()).defaultBlockState(), 48));
        ColorsConfiguredFeatures.register(context, STONE_KEY.get("white"), Feature.ORE, new OreConfiguration((RuleTest)stoneReplaceables, ((Block)ColorsBlocks.STONE_BLOCKS.get("white_stone").get()).defaultBlockState(), 48));
        ColorsConfiguredFeatures.register(context, STONE_KEY.get("brown"), Feature.ORE, new OreConfiguration((RuleTest)deepslateReplaceables, ((Block)ColorsBlocks.STONE_BLOCKS.get("brown_stone").get()).defaultBlockState(), 48));
        ColorsConfiguredFeatures.register(context, STONE_KEY.get("gray"), Feature.ORE, new OreConfiguration((RuleTest)deepslateReplaceables, ((Block)ColorsBlocks.STONE_BLOCKS.get("gray_stone").get()).defaultBlockState(), 48));
        ColorsConfiguredFeatures.register(context, STONE_KEY.get("light_blue"), Feature.ORE, new OreConfiguration((RuleTest)stoneReplaceables, ((Block)ColorsBlocks.STONE_BLOCKS.get("light_blue_stone").get()).defaultBlockState(), 48));
        ColorsConfiguredFeatures.register(context, STONE_KEY.get("lime"), Feature.ORE, new OreConfiguration((RuleTest)stoneReplaceables, ((Block)ColorsBlocks.STONE_BLOCKS.get("lime_stone").get()).defaultBlockState(), 48));
        ColorsConfiguredFeatures.register(context, STONE_KEY.get("magenta"), Feature.ORE, new OreConfiguration((RuleTest)stoneReplaceables, ((Block)ColorsBlocks.STONE_BLOCKS.get("magenta_stone").get()).defaultBlockState(), 48));
        ColorsConfiguredFeatures.register(context, STONE_KEY.get("light_gray"), Feature.ORE, new OreConfiguration((RuleTest)deepslateReplaceables, ((Block)ColorsBlocks.STONE_BLOCKS.get("light_gray_stone").get()).defaultBlockState(), 48));
    }

    public static ResourceKey<ConfiguredFeature<?, ?>> registerKey(String name) {
        return ResourceKey.create((ResourceKey)Registries.CONFIGURED_FEATURE, (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"colors", (String)name));
    }

    private static <FC extends FeatureConfiguration, F extends Feature<FC>> void register(BootstrapContext<ConfiguredFeature<?, ?>> context, ResourceKey<ConfiguredFeature<?, ?>> key, F feature, FC configuration) {
        context.register(key, (Object)new ConfiguredFeature(feature, configuration));
    }

    static {
        for (String color : ColorList.COLORS) {
            GRASS_BONEMEAL_KEY.put(color, ColorsConfiguredFeatures.registerKey("bonemeal_" + color + "_grass_key"));
            TREES_KEY.put(color, ColorsConfiguredFeatures.registerKey(color + "_tree"));
            STONE_KEY.put(color, ColorsConfiguredFeatures.registerKey(color + "_stone"));
        }
    }
}

