/*
 * Decompiled with CFR 0.152.
 */
package com.benbenlaw.colors.worldgen;

import com.benbenlaw.colors.block.ColorsBlocks;
import com.benbenlaw.colors.worldgen.ColorsConfiguredFeatures;
import com.benbenlaw.colors.worldgen.PlacementStones;
import com.benbenlaw.colors.worldgen.PlacementTrees;
import com.benbenlaw.core.util.ColorList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderGetter;
import net.minecraft.core.registries.Registries;
import net.minecraft.data.worldgen.BootstrapContext;
import net.minecraft.data.worldgen.placement.PlacementUtils;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.levelgen.VerticalAnchor;
import net.minecraft.world.level.levelgen.feature.ConfiguredFeature;
import net.minecraft.world.level.levelgen.placement.BiomeFilter;
import net.minecraft.world.level.levelgen.placement.CountPlacement;
import net.minecraft.world.level.levelgen.placement.HeightRangePlacement;
import net.minecraft.world.level.levelgen.placement.InSquarePlacement;
import net.minecraft.world.level.levelgen.placement.PlacedFeature;
import net.minecraft.world.level.levelgen.placement.PlacementModifier;
import net.minecraft.world.level.levelgen.placement.RarityFilter;
import net.minecraft.world.level.levelgen.placement.SurfaceWaterDepthFilter;

public class ColorsPlacedFeatures {
    public static final Map<String, ResourceKey<PlacedFeature>> GRASS_BONEMEAL = new HashMap<String, ResourceKey<PlacedFeature>>();
    public static final Map<String, ResourceKey<PlacedFeature>> TREE_PLACED = new HashMap<String, ResourceKey<PlacedFeature>>();
    public static final Map<String, ResourceKey<PlacedFeature>> STONE_PLACED = new HashMap<String, ResourceKey<PlacedFeature>>();

    public static void bootstrap(BootstrapContext<PlacedFeature> context) {
        HolderGetter configuredFeatures = context.lookup(Registries.CONFIGURED_FEATURE);
        for (String color : ColorList.COLORS) {
            PlacementUtils.register(context, GRASS_BONEMEAL.get(color), (Holder)configuredFeatures.getOrThrow(ColorsConfiguredFeatures.GRASS_BONEMEAL_KEY.get(color)), (PlacementModifier[])new PlacementModifier[]{RarityFilter.onAverageOnceEvery((int)32), InSquarePlacement.spread(), PlacementUtils.HEIGHTMAP});
        }
        ColorsPlacedFeatures.register(context, TREE_PLACED.get("black"), configuredFeatures.getOrThrow(ColorsConfiguredFeatures.TREES_KEY.get("black")), List.of(PlacementUtils.HEIGHTMAP_OCEAN_FLOOR, RarityFilter.onAverageOnceEvery((int)10), CountPlacement.of((int)1), BiomeFilter.biome(), SurfaceWaterDepthFilter.forMaxDepth((int)0), InSquarePlacement.spread(), PlacementTrees.create(), PlacementUtils.filteredByBlockSurvival((Block)((Block)ColorsBlocks.SAPLINGS.get("black_sapling").get()))));
        ColorsPlacedFeatures.register(context, TREE_PLACED.get("red"), configuredFeatures.getOrThrow(ColorsConfiguredFeatures.TREES_KEY.get("red")), List.of(PlacementUtils.HEIGHTMAP_OCEAN_FLOOR, RarityFilter.onAverageOnceEvery((int)20), CountPlacement.of((int)1), BiomeFilter.biome(), SurfaceWaterDepthFilter.forMaxDepth((int)0), InSquarePlacement.spread(), PlacementTrees.create(), PlacementUtils.filteredByBlockSurvival((Block)((Block)ColorsBlocks.SAPLINGS.get("red_sapling").get()))));
        ColorsPlacedFeatures.register(context, TREE_PLACED.get("blue"), configuredFeatures.getOrThrow(ColorsConfiguredFeatures.TREES_KEY.get("blue")), List.of(PlacementUtils.HEIGHTMAP_OCEAN_FLOOR, RarityFilter.onAverageOnceEvery((int)16), CountPlacement.of((int)1), BiomeFilter.biome(), SurfaceWaterDepthFilter.forMaxDepth((int)0), InSquarePlacement.spread(), PlacementTrees.create(), PlacementUtils.filteredByBlockSurvival((Block)((Block)ColorsBlocks.SAPLINGS.get("blue_sapling").get()))));
        ColorsPlacedFeatures.register(context, TREE_PLACED.get("green"), configuredFeatures.getOrThrow(ColorsConfiguredFeatures.TREES_KEY.get("green")), List.of(PlacementUtils.HEIGHTMAP_OCEAN_FLOOR, RarityFilter.onAverageOnceEvery((int)10), CountPlacement.of((int)1), BiomeFilter.biome(), SurfaceWaterDepthFilter.forMaxDepth((int)0), InSquarePlacement.spread(), PlacementTrees.create(), PlacementUtils.filteredByBlockSurvival((Block)((Block)ColorsBlocks.SAPLINGS.get("green_sapling").get()))));
        ColorsPlacedFeatures.register(context, TREE_PLACED.get("yellow"), configuredFeatures.getOrThrow(ColorsConfiguredFeatures.TREES_KEY.get("yellow")), List.of(PlacementUtils.HEIGHTMAP_OCEAN_FLOOR, RarityFilter.onAverageOnceEvery((int)20), CountPlacement.of((int)1), BiomeFilter.biome(), SurfaceWaterDepthFilter.forMaxDepth((int)0), InSquarePlacement.spread(), PlacementTrees.create(), PlacementUtils.filteredByBlockSurvival((Block)Blocks.CACTUS)));
        ColorsPlacedFeatures.register(context, TREE_PLACED.get("purple"), configuredFeatures.getOrThrow(ColorsConfiguredFeatures.TREES_KEY.get("purple")), List.of(PlacementUtils.HEIGHTMAP_OCEAN_FLOOR, RarityFilter.onAverageOnceEvery((int)12), CountPlacement.of((int)1), BiomeFilter.biome(), SurfaceWaterDepthFilter.forMaxDepth((int)0), InSquarePlacement.spread(), PlacementTrees.create(), PlacementUtils.filteredByBlockSurvival((Block)((Block)ColorsBlocks.SAPLINGS.get("purple_sapling").get()))));
        ColorsPlacedFeatures.register(context, TREE_PLACED.get("orange"), configuredFeatures.getOrThrow(ColorsConfiguredFeatures.TREES_KEY.get("orange")), List.of(PlacementUtils.HEIGHTMAP_OCEAN_FLOOR, RarityFilter.onAverageOnceEvery((int)12), CountPlacement.of((int)1), BiomeFilter.biome(), SurfaceWaterDepthFilter.forMaxDepth((int)0), InSquarePlacement.spread(), PlacementTrees.create(), PlacementUtils.filteredByBlockSurvival((Block)Blocks.DEAD_BUSH)));
        ColorsPlacedFeatures.register(context, TREE_PLACED.get("white"), configuredFeatures.getOrThrow(ColorsConfiguredFeatures.TREES_KEY.get("white")), List.of(PlacementUtils.HEIGHTMAP_OCEAN_FLOOR, RarityFilter.onAverageOnceEvery((int)16), CountPlacement.of((int)1), BiomeFilter.biome(), SurfaceWaterDepthFilter.forMaxDepth((int)0), InSquarePlacement.spread(), PlacementTrees.create(), PlacementUtils.filteredByBlockSurvival((Block)((Block)ColorsBlocks.SAPLINGS.get("white_sapling").get()))));
        ColorsPlacedFeatures.register(context, TREE_PLACED.get("brown"), configuredFeatures.getOrThrow(ColorsConfiguredFeatures.TREES_KEY.get("brown")), List.of(PlacementUtils.HEIGHTMAP_OCEAN_FLOOR, RarityFilter.onAverageOnceEvery((int)10), CountPlacement.of((int)1), BiomeFilter.biome(), SurfaceWaterDepthFilter.forMaxDepth((int)0), InSquarePlacement.spread(), PlacementTrees.create(), PlacementUtils.filteredByBlockSurvival((Block)((Block)ColorsBlocks.SAPLINGS.get("brown_sapling").get()))));
        ColorsPlacedFeatures.register(context, TREE_PLACED.get("pink"), configuredFeatures.getOrThrow(ColorsConfiguredFeatures.TREES_KEY.get("pink")), List.of(PlacementUtils.HEIGHTMAP_OCEAN_FLOOR, RarityFilter.onAverageOnceEvery((int)12), CountPlacement.of((int)1), BiomeFilter.biome(), SurfaceWaterDepthFilter.forMaxDepth((int)0), InSquarePlacement.spread(), PlacementTrees.create(), PlacementUtils.filteredByBlockSurvival((Block)((Block)ColorsBlocks.SAPLINGS.get("pink_sapling").get()))));
        ColorsPlacedFeatures.register(context, TREE_PLACED.get("cyan"), configuredFeatures.getOrThrow(ColorsConfiguredFeatures.TREES_KEY.get("cyan")), List.of(PlacementUtils.HEIGHTMAP_OCEAN_FLOOR, RarityFilter.onAverageOnceEvery((int)10), CountPlacement.of((int)1), BiomeFilter.biome(), SurfaceWaterDepthFilter.forMaxDepth((int)0), InSquarePlacement.spread(), PlacementTrees.create(), PlacementUtils.filteredByBlockSurvival((Block)((Block)ColorsBlocks.SAPLINGS.get("cyan_sapling").get()))));
        ColorsPlacedFeatures.register(context, TREE_PLACED.get("light_gray"), configuredFeatures.getOrThrow(ColorsConfiguredFeatures.TREES_KEY.get("light_gray")), List.of(PlacementUtils.HEIGHTMAP_OCEAN_FLOOR, RarityFilter.onAverageOnceEvery((int)12), CountPlacement.of((int)1), BiomeFilter.biome(), SurfaceWaterDepthFilter.forMaxDepth((int)0), InSquarePlacement.spread(), PlacementTrees.create(), PlacementUtils.filteredByBlockSurvival((Block)((Block)ColorsBlocks.SAPLINGS.get("light_gray_sapling").get()))));
        ColorsPlacedFeatures.register(context, TREE_PLACED.get("lime"), configuredFeatures.getOrThrow(ColorsConfiguredFeatures.TREES_KEY.get("lime")), List.of(PlacementUtils.HEIGHTMAP_OCEAN_FLOOR, RarityFilter.onAverageOnceEvery((int)12), CountPlacement.of((int)1), BiomeFilter.biome(), SurfaceWaterDepthFilter.forMaxDepth((int)0), InSquarePlacement.spread(), PlacementTrees.create(), PlacementUtils.filteredByBlockSurvival((Block)((Block)ColorsBlocks.SAPLINGS.get("lime_sapling").get()))));
        ColorsPlacedFeatures.register(context, TREE_PLACED.get("magenta"), configuredFeatures.getOrThrow(ColorsConfiguredFeatures.TREES_KEY.get("magenta")), List.of(PlacementUtils.HEIGHTMAP_OCEAN_FLOOR, RarityFilter.onAverageOnceEvery((int)12), CountPlacement.of((int)1), BiomeFilter.biome(), SurfaceWaterDepthFilter.forMaxDepth((int)0), InSquarePlacement.spread(), PlacementTrees.create(), PlacementUtils.filteredByBlockSurvival((Block)((Block)ColorsBlocks.SAPLINGS.get("magenta_sapling").get()))));
        ColorsPlacedFeatures.register(context, TREE_PLACED.get("gray"), configuredFeatures.getOrThrow(ColorsConfiguredFeatures.TREES_KEY.get("gray")), List.of(PlacementUtils.HEIGHTMAP_OCEAN_FLOOR, RarityFilter.onAverageOnceEvery((int)10), CountPlacement.of((int)1), BiomeFilter.biome(), SurfaceWaterDepthFilter.forMaxDepth((int)0), InSquarePlacement.spread(), PlacementTrees.create(), PlacementUtils.filteredByBlockSurvival((Block)((Block)ColorsBlocks.SAPLINGS.get("gray_sapling").get()))));
        ColorsPlacedFeatures.register(context, TREE_PLACED.get("light_blue"), configuredFeatures.getOrThrow(ColorsConfiguredFeatures.TREES_KEY.get("light_blue")), List.of(PlacementUtils.HEIGHTMAP_OCEAN_FLOOR, RarityFilter.onAverageOnceEvery((int)16), CountPlacement.of((int)1), BiomeFilter.biome(), SurfaceWaterDepthFilter.forMaxDepth((int)0), InSquarePlacement.spread(), PlacementTrees.create(), PlacementUtils.filteredByBlockSurvival((Block)((Block)ColorsBlocks.SAPLINGS.get("light_blue_sapling").get()))));
        ColorsPlacedFeatures.register(context, STONE_PLACED.get("black"), configuredFeatures.getOrThrow(ColorsConfiguredFeatures.STONE_KEY.get("black")), List.of(CountPlacement.of((int)1), InSquarePlacement.spread(), PlacementStones.create(), HeightRangePlacement.uniform((VerticalAnchor)VerticalAnchor.aboveBottom((int)-64), (VerticalAnchor)VerticalAnchor.absolute((int)10)), BiomeFilter.biome()));
        ColorsPlacedFeatures.register(context, STONE_PLACED.get("red"), configuredFeatures.getOrThrow(ColorsConfiguredFeatures.STONE_KEY.get("red")), List.of(CountPlacement.of((int)1), InSquarePlacement.spread(), PlacementStones.create(), HeightRangePlacement.uniform((VerticalAnchor)VerticalAnchor.aboveBottom((int)-64), (VerticalAnchor)VerticalAnchor.absolute((int)10)), BiomeFilter.biome()));
        ColorsPlacedFeatures.register(context, STONE_PLACED.get("blue"), configuredFeatures.getOrThrow(ColorsConfiguredFeatures.STONE_KEY.get("blue")), List.of(CountPlacement.of((int)1), InSquarePlacement.spread(), PlacementStones.create(), HeightRangePlacement.uniform((VerticalAnchor)VerticalAnchor.aboveBottom((int)10), (VerticalAnchor)VerticalAnchor.absolute((int)150)), BiomeFilter.biome()));
        ColorsPlacedFeatures.register(context, STONE_PLACED.get("green"), configuredFeatures.getOrThrow(ColorsConfiguredFeatures.STONE_KEY.get("green")), List.of(CountPlacement.of((int)1), InSquarePlacement.spread(), PlacementStones.create(), HeightRangePlacement.uniform((VerticalAnchor)VerticalAnchor.aboveBottom((int)10), (VerticalAnchor)VerticalAnchor.absolute((int)150)), BiomeFilter.biome()));
        ColorsPlacedFeatures.register(context, STONE_PLACED.get("yellow"), configuredFeatures.getOrThrow(ColorsConfiguredFeatures.STONE_KEY.get("yellow")), List.of(CountPlacement.of((int)1), InSquarePlacement.spread(), PlacementStones.create(), HeightRangePlacement.uniform((VerticalAnchor)VerticalAnchor.aboveBottom((int)10), (VerticalAnchor)VerticalAnchor.absolute((int)150)), BiomeFilter.biome()));
        ColorsPlacedFeatures.register(context, STONE_PLACED.get("purple"), configuredFeatures.getOrThrow(ColorsConfiguredFeatures.STONE_KEY.get("purple")), List.of(CountPlacement.of((int)1), InSquarePlacement.spread(), PlacementStones.create(), HeightRangePlacement.uniform((VerticalAnchor)VerticalAnchor.aboveBottom((int)10), (VerticalAnchor)VerticalAnchor.absolute((int)150)), BiomeFilter.biome()));
        ColorsPlacedFeatures.register(context, STONE_PLACED.get("orange"), configuredFeatures.getOrThrow(ColorsConfiguredFeatures.STONE_KEY.get("orange")), List.of(CountPlacement.of((int)1), InSquarePlacement.spread(), PlacementStones.create(), HeightRangePlacement.uniform((VerticalAnchor)VerticalAnchor.aboveBottom((int)10), (VerticalAnchor)VerticalAnchor.absolute((int)150)), BiomeFilter.biome()));
        ColorsPlacedFeatures.register(context, STONE_PLACED.get("white"), configuredFeatures.getOrThrow(ColorsConfiguredFeatures.STONE_KEY.get("white")), List.of(CountPlacement.of((int)1), InSquarePlacement.spread(), PlacementStones.create(), HeightRangePlacement.uniform((VerticalAnchor)VerticalAnchor.aboveBottom((int)10), (VerticalAnchor)VerticalAnchor.absolute((int)150)), BiomeFilter.biome()));
        ColorsPlacedFeatures.register(context, STONE_PLACED.get("brown"), configuredFeatures.getOrThrow(ColorsConfiguredFeatures.STONE_KEY.get("brown")), List.of(CountPlacement.of((int)1), InSquarePlacement.spread(), PlacementStones.create(), HeightRangePlacement.uniform((VerticalAnchor)VerticalAnchor.aboveBottom((int)-64), (VerticalAnchor)VerticalAnchor.absolute((int)10)), BiomeFilter.biome()));
        ColorsPlacedFeatures.register(context, STONE_PLACED.get("pink"), configuredFeatures.getOrThrow(ColorsConfiguredFeatures.STONE_KEY.get("pink")), List.of(CountPlacement.of((int)1), InSquarePlacement.spread(), PlacementStones.create(), HeightRangePlacement.uniform((VerticalAnchor)VerticalAnchor.aboveBottom((int)10), (VerticalAnchor)VerticalAnchor.absolute((int)150)), BiomeFilter.biome()));
        ColorsPlacedFeatures.register(context, STONE_PLACED.get("cyan"), configuredFeatures.getOrThrow(ColorsConfiguredFeatures.STONE_KEY.get("cyan")), List.of(CountPlacement.of((int)1), InSquarePlacement.spread(), PlacementStones.create(), HeightRangePlacement.uniform((VerticalAnchor)VerticalAnchor.aboveBottom((int)10), (VerticalAnchor)VerticalAnchor.absolute((int)150)), BiomeFilter.biome()));
        ColorsPlacedFeatures.register(context, STONE_PLACED.get("light_gray"), configuredFeatures.getOrThrow(ColorsConfiguredFeatures.STONE_KEY.get("light_gray")), List.of(CountPlacement.of((int)1), InSquarePlacement.spread(), PlacementStones.create(), HeightRangePlacement.uniform((VerticalAnchor)VerticalAnchor.aboveBottom((int)-64), (VerticalAnchor)VerticalAnchor.absolute((int)10)), BiomeFilter.biome()));
        ColorsPlacedFeatures.register(context, STONE_PLACED.get("lime"), configuredFeatures.getOrThrow(ColorsConfiguredFeatures.STONE_KEY.get("lime")), List.of(CountPlacement.of((int)1), InSquarePlacement.spread(), PlacementStones.create(), HeightRangePlacement.uniform((VerticalAnchor)VerticalAnchor.aboveBottom((int)10), (VerticalAnchor)VerticalAnchor.absolute((int)150)), BiomeFilter.biome()));
        ColorsPlacedFeatures.register(context, STONE_PLACED.get("magenta"), configuredFeatures.getOrThrow(ColorsConfiguredFeatures.STONE_KEY.get("magenta")), List.of(CountPlacement.of((int)1), InSquarePlacement.spread(), PlacementStones.create(), HeightRangePlacement.uniform((VerticalAnchor)VerticalAnchor.aboveBottom((int)10), (VerticalAnchor)VerticalAnchor.absolute((int)150)), BiomeFilter.biome()));
        ColorsPlacedFeatures.register(context, STONE_PLACED.get("gray"), configuredFeatures.getOrThrow(ColorsConfiguredFeatures.STONE_KEY.get("gray")), List.of(CountPlacement.of((int)1), InSquarePlacement.spread(), PlacementStones.create(), HeightRangePlacement.uniform((VerticalAnchor)VerticalAnchor.aboveBottom((int)-64), (VerticalAnchor)VerticalAnchor.absolute((int)10)), BiomeFilter.biome()));
        ColorsPlacedFeatures.register(context, STONE_PLACED.get("light_blue"), configuredFeatures.getOrThrow(ColorsConfiguredFeatures.STONE_KEY.get("light_blue")), List.of(CountPlacement.of((int)1), InSquarePlacement.spread(), PlacementStones.create(), HeightRangePlacement.uniform((VerticalAnchor)VerticalAnchor.aboveBottom((int)-64), (VerticalAnchor)VerticalAnchor.absolute((int)10)), BiomeFilter.biome()));
    }

    private static ResourceKey<PlacedFeature> registerKey(String name) {
        return ResourceKey.create((ResourceKey)Registries.PLACED_FEATURE, (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"colors", (String)name));
    }

    private static void register(BootstrapContext<PlacedFeature> context, ResourceKey<PlacedFeature> key, Holder<ConfiguredFeature<?, ?>> configuration, List<PlacementModifier> modifiers) {
        context.register(key, (Object)new PlacedFeature(configuration, List.copyOf(modifiers)));
    }

    static {
        for (String color : ColorList.COLORS) {
            GRASS_BONEMEAL.put(color, ColorsPlacedFeatures.registerKey(color + "_grass_bonemeal"));
            TREE_PLACED.put(color, ColorsPlacedFeatures.registerKey(color + "_tree_placed"));
            STONE_PLACED.put(color, ColorsPlacedFeatures.registerKey(color + "_stone_placed"));
        }
    }
}

