/*
 * Decompiled with CFR 0.152.
 */
package com.benbenlaw.colors.worldgen;

import com.benbenlaw.colors.config.WorldGenConfig;
import com.benbenlaw.colors.worldgen.ColorsWorldGen;
import com.mojang.serialization.MapCodec;
import java.util.stream.Stream;
import net.minecraft.core.BlockPos;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.levelgen.WorldgenRandom;
import net.minecraft.world.level.levelgen.placement.PlacementContext;
import net.minecraft.world.level.levelgen.placement.PlacementModifier;
import net.minecraft.world.level.levelgen.placement.PlacementModifierType;

public class PlacementTrees
extends PlacementModifier {
    private static final PlacementTrees INSTANCE = new PlacementTrees();
    public static final MapCodec<PlacementModifier> CODEC = MapCodec.unit(() -> INSTANCE);

    public Stream<BlockPos> getPositions(PlacementContext placementContext, RandomSource random, BlockPos pos) {
        WorldGenLevel level = placementContext.getLevel();
        int chunkX = pos.getX() >> 8;
        int chunkZ = pos.getZ() >> 8;
        ((WorldgenRandom)random).setDecorationSeed(level.getSeed(), chunkX, chunkZ);
        if (((Boolean)WorldGenConfig.shouldColoredTreesSpawn.get()).booleanValue()) {
            return Stream.of(pos);
        }
        return Stream.empty();
    }

    public static PlacementTrees create() {
        return INSTANCE;
    }

    public PlacementModifierType<?> type() {
        return ColorsWorldGen.TREES_PLACEMENT.get();
    }
}

