/*
 * Decompiled with CFR 0.152.
 */
package magicstone.entity;

import java.util.EnumSet;
import javax.annotation.Nullable;
import magicstone.entity.ApprenticeOfTheSorcererEntity;
import magicstone.entity.DreamlandGuardiansEntity;
import magicstone.entity.FifthOrderBlastingShellsEntity;
import magicstone.entity.MasterOfMagicEntity;
import magicstone.entity.MengLiEntity;
import magicstone.entity.SlaveEntity;
import magicstone.init.MagicStoneModItems;
import magicstone.procedures.ChaosCreatureSpawnActionProcedure;
import magicstone.procedures.InfectedChiEActionProcedure;
import magicstone.procedures.InfectedChiEDropsActionProcedure;
import magicstone.procedures.InfectedChiEHurtActionProcedure;
import net.minecraft.core.BlockPos;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerBossEvent;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.util.RandomSource;
import net.minecraft.world.BossEvent;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.damagesource.DamageTypes;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityDimensions;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.control.FlyingMoveControl;
import net.minecraft.world.entity.ai.goal.AvoidEntityGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.MeleeAttackGoal;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;
import net.minecraft.world.entity.ai.goal.RandomStrollGoal;
import net.minecraft.world.entity.ai.goal.RangedAttackGoal;
import net.minecraft.world.entity.ai.goal.target.HurtByTargetGoal;
import net.minecraft.world.entity.ai.goal.target.NearestAttackableTargetGoal;
import net.minecraft.world.entity.ai.navigation.FlyingPathNavigation;
import net.minecraft.world.entity.ai.navigation.PathNavigation;
import net.minecraft.world.entity.animal.AbstractGolem;
import net.minecraft.world.entity.animal.Animal;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.entity.monster.RangedAttackMob;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Explosion;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec3;
import net.neoforged.neoforge.event.entity.RegisterSpawnPlacementsEvent;

public class InfectedChiEEntity
extends Monster
implements RangedAttackMob {
    private final ServerBossEvent bossInfo = new ServerBossEvent(this.getDisplayName(), BossEvent.BossBarColor.PINK, BossEvent.BossBarOverlay.PROGRESS);

    public InfectedChiEEntity(EntityType<InfectedChiEEntity> type, Level world) {
        super(type, world);
        this.xpReward = 500;
        this.setNoAi(false);
        this.setPersistenceRequired();
        this.setItemSlot(EquipmentSlot.HEAD, new ItemStack((ItemLike)MagicStoneModItems.BROKEN_WREATH.get()));
        this.moveControl = new FlyingMoveControl((Mob)this, 10, true);
        this.refreshDimensions();
    }

    protected PathNavigation createNavigation(Level world) {
        return new FlyingPathNavigation((Mob)this, world);
    }

    protected void registerGoals() {
        super.registerGoals();
        this.goalSelector.addGoal(1, (Goal)new AvoidEntityGoal((PathfinderMob)this, MengLiEntity.class, 15.0f, 1.0, 1.2));
        this.targetSelector.addGoal(2, (Goal)new HurtByTargetGoal((PathfinderMob)this, new Class[0]));
        this.goalSelector.addGoal(3, new Goal(){
            {
                this.setFlags(EnumSet.of(Goal.Flag.MOVE));
            }

            public boolean canUse() {
                return InfectedChiEEntity.this.getTarget() != null && !InfectedChiEEntity.this.getMoveControl().hasWanted();
            }

            public boolean canContinueToUse() {
                return InfectedChiEEntity.this.getMoveControl().hasWanted() && InfectedChiEEntity.this.getTarget() != null && InfectedChiEEntity.this.getTarget().isAlive();
            }

            public void start() {
                LivingEntity livingentity = InfectedChiEEntity.this.getTarget();
                Vec3 vec3d = livingentity.getEyePosition(1.0f);
                InfectedChiEEntity.this.moveControl.setWantedPosition(vec3d.x, vec3d.y, vec3d.z, 2.0);
            }

            public void tick() {
                LivingEntity livingentity = InfectedChiEEntity.this.getTarget();
                if (InfectedChiEEntity.this.getBoundingBox().intersects(livingentity.getBoundingBox())) {
                    InfectedChiEEntity.this.doHurtTarget((Entity)livingentity);
                } else {
                    double d0 = InfectedChiEEntity.this.distanceToSqr((Entity)livingentity);
                    if (d0 < 3.0) {
                        Vec3 vec3d = livingentity.getEyePosition(1.0f);
                        InfectedChiEEntity.this.moveControl.setWantedPosition(vec3d.x, vec3d.y, vec3d.z, 2.0);
                    }
                }
            }
        });
        this.goalSelector.addGoal(4, (Goal)new MeleeAttackGoal(this, (PathfinderMob)this, 2.0, true){

            protected boolean canPerformAttack(LivingEntity entity) {
                return this.isTimeToAttack() && this.mob.distanceToSqr((Entity)entity) < (double)(this.mob.getBbWidth() * this.mob.getBbWidth() + entity.getBbWidth()) && this.mob.getSensing().hasLineOfSight((Entity)entity);
            }
        });
        this.targetSelector.addGoal(5, (Goal)new NearestAttackableTargetGoal((Mob)this, Player.class, false, true));
        this.targetSelector.addGoal(6, (Goal)new NearestAttackableTargetGoal((Mob)this, Animal.class, false, true));
        this.targetSelector.addGoal(7, (Goal)new NearestAttackableTargetGoal((Mob)this, AbstractGolem.class, false, true));
        this.targetSelector.addGoal(8, (Goal)new NearestAttackableTargetGoal((Mob)this, DreamlandGuardiansEntity.class, false, true));
        this.targetSelector.addGoal(9, (Goal)new NearestAttackableTargetGoal((Mob)this, SlaveEntity.class, false, true));
        this.targetSelector.addGoal(10, (Goal)new NearestAttackableTargetGoal((Mob)this, ApprenticeOfTheSorcererEntity.class, false, true));
        this.targetSelector.addGoal(11, (Goal)new NearestAttackableTargetGoal((Mob)this, MasterOfMagicEntity.class, false, true));
        this.goalSelector.addGoal(12, (Goal)new RandomStrollGoal((PathfinderMob)this, 1.0, 20){

            protected Vec3 getPosition() {
                RandomSource random = InfectedChiEEntity.this.getRandom();
                double dir_x = InfectedChiEEntity.this.getX() + (double)((random.nextFloat() * 2.0f - 1.0f) * 16.0f);
                double dir_y = InfectedChiEEntity.this.getY() + (double)((random.nextFloat() * 2.0f - 1.0f) * 16.0f);
                double dir_z = InfectedChiEEntity.this.getZ() + (double)((random.nextFloat() * 2.0f - 1.0f) * 16.0f);
                return new Vec3(dir_x, dir_y, dir_z);
            }
        });
        this.goalSelector.addGoal(14, (Goal)new RandomLookAroundGoal((Mob)this));
        this.goalSelector.addGoal(1, (Goal)new RangedAttackGoal(this, this, 1.25, 60, 16.0f){

            public boolean canContinueToUse() {
                return this.canUse();
            }
        });
    }

    public boolean removeWhenFarAway(double distanceToClosestPlayer) {
        return false;
    }

    public SoundEvent getHurtSound(DamageSource ds) {
        return (SoundEvent)BuiltInRegistries.SOUND_EVENT.get(ResourceLocation.parse((String)"entity.generic.hurt"));
    }

    public SoundEvent getDeathSound() {
        return (SoundEvent)BuiltInRegistries.SOUND_EVENT.get(ResourceLocation.parse((String)"entity.generic.death"));
    }

    public boolean causeFallDamage(float l, float d, DamageSource source) {
        return false;
    }

    public boolean hurt(DamageSource damagesource, float amount) {
        double x = this.getX();
        double y = this.getY();
        double z = this.getZ();
        Level world = this.level();
        InfectedChiEEntity entity = this;
        Entity sourceentity = damagesource.getEntity();
        Entity immediatesourceentity = damagesource.getDirectEntity();
        InfectedChiEHurtActionProcedure.execute((LevelAccessor)world, x, y, z, (Entity)entity);
        if (damagesource.is(DamageTypes.IN_FIRE)) {
            return false;
        }
        if (damagesource.is(DamageTypes.FALL)) {
            return false;
        }
        if (damagesource.is(DamageTypes.CACTUS)) {
            return false;
        }
        if (damagesource.is(DamageTypes.DROWN)) {
            return false;
        }
        if (damagesource.is(DamageTypes.EXPLOSION) || damagesource.is(DamageTypes.PLAYER_EXPLOSION)) {
            return false;
        }
        if (damagesource.is(DamageTypes.FALLING_ANVIL)) {
            return false;
        }
        return super.hurt(damagesource, amount);
    }

    public boolean ignoreExplosion(Explosion explosion) {
        return true;
    }

    public boolean fireImmune() {
        return true;
    }

    public void die(DamageSource source) {
        super.die(source);
        InfectedChiEDropsActionProcedure.execute((LevelAccessor)this.level(), this.getX(), this.getY(), this.getZ());
    }

    public SpawnGroupData finalizeSpawn(ServerLevelAccessor world, DifficultyInstance difficulty, MobSpawnType reason, @Nullable SpawnGroupData livingdata) {
        SpawnGroupData retval = super.finalizeSpawn(world, difficulty, reason, livingdata);
        ChaosCreatureSpawnActionProcedure.execute((LevelAccessor)world, this.getX(), this.getY(), this.getZ(), (Entity)this);
        return retval;
    }

    public void baseTick() {
        super.baseTick();
        InfectedChiEActionProcedure.execute((LevelAccessor)this.level(), this.getX(), this.getY(), this.getZ(), (Entity)this);
    }

    public void performRangedAttack(LivingEntity target, float flval) {
        FifthOrderBlastingShellsEntity.shoot((LivingEntity)this, target);
    }

    public boolean isPushedByFluid() {
        double x = this.getX();
        double y = this.getY();
        double z = this.getZ();
        Level world = this.level();
        InfectedChiEEntity entity = this;
        return false;
    }

    public void startSeenByPlayer(ServerPlayer player) {
        super.startSeenByPlayer(player);
        this.bossInfo.addPlayer(player);
    }

    public void stopSeenByPlayer(ServerPlayer player) {
        super.stopSeenByPlayer(player);
        this.bossInfo.removePlayer(player);
    }

    public void customServerAiStep() {
        super.customServerAiStep();
        this.bossInfo.setProgress(this.getHealth() / this.getMaxHealth());
    }

    public EntityDimensions getDefaultDimensions(Pose pose) {
        return super.getDefaultDimensions(pose).scale(0.8f);
    }

    protected void checkFallDamage(double y, boolean onGroundIn, BlockState state, BlockPos pos) {
    }

    public void setNoGravity(boolean ignored) {
        super.setNoGravity(true);
    }

    public void aiStep() {
        super.aiStep();
        this.setNoGravity(true);
    }

    public static void init(RegisterSpawnPlacementsEvent event) {
    }

    public static AttributeSupplier.Builder createAttributes() {
        AttributeSupplier.Builder builder = Mob.createMobAttributes();
        builder = builder.add(Attributes.MOVEMENT_SPEED, 0.5);
        builder = builder.add(Attributes.MAX_HEALTH, 1000.0);
        builder = builder.add(Attributes.ARMOR, 20.0);
        builder = builder.add(Attributes.ATTACK_DAMAGE, 100.0);
        builder = builder.add(Attributes.FOLLOW_RANGE, 48.0);
        builder = builder.add(Attributes.STEP_HEIGHT, 1.0);
        builder = builder.add(Attributes.KNOCKBACK_RESISTANCE, 10.0);
        builder = builder.add(Attributes.ATTACK_KNOCKBACK, 10.0);
        builder = builder.add(Attributes.FLYING_SPEED, 0.5);
        return builder;
    }
}

