/*
 * Decompiled with CFR 0.152.
 */
package magicstone.item;

import magicstone.procedures.AbyssalEnergySpearActionProcedure;
import magicstone.procedures.AbyssalEnergySpearSoundActionProcedure;
import magicstone.procedures.TabooMagicStoneParticleProcedure;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlotGroup;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Rarity;
import net.minecraft.world.item.UseAnim;
import net.minecraft.world.item.component.ItemAttributeModifiers;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;

public class AbyssalEnergySpearItem
extends Item {
    public AbyssalEnergySpearItem() {
        super(new Item.Properties().durability(1000).fireResistant().rarity(Rarity.EPIC).attributes(ItemAttributeModifiers.builder().add(Attributes.ATTACK_DAMAGE, new AttributeModifier(BASE_ATTACK_DAMAGE_ID, 665.0, AttributeModifier.Operation.ADD_VALUE), EquipmentSlotGroup.MAINHAND).add(Attributes.ATTACK_SPEED, new AttributeModifier(BASE_ATTACK_SPEED_ID, -2.4, AttributeModifier.Operation.ADD_VALUE), EquipmentSlotGroup.MAINHAND).build()));
    }

    public UseAnim getUseAnimation(ItemStack itemstack) {
        return UseAnim.SPEAR;
    }

    public int getUseDuration(ItemStack itemstack, LivingEntity livingEntity) {
        return 40;
    }

    public InteractionResultHolder<ItemStack> use(Level world, Player entity, InteractionHand hand) {
        InteractionResultHolder ar = super.use(world, entity, hand);
        entity.startUsingItem(hand);
        return ar;
    }

    public ItemStack finishUsingItem(ItemStack itemstack, Level world, LivingEntity entity) {
        ItemStack retval = super.finishUsingItem(itemstack, world, entity);
        double x = entity.getX();
        double y = entity.getY();
        double z = entity.getZ();
        AbyssalEnergySpearActionProcedure.execute((Entity)entity);
        return retval;
    }

    public boolean hurtEnemy(ItemStack itemstack, LivingEntity entity, LivingEntity sourceentity) {
        itemstack.hurtAndBreak(1, entity, LivingEntity.getSlotForHand((InteractionHand)entity.getUsedItemHand()));
        AbyssalEnergySpearSoundActionProcedure.execute((LevelAccessor)entity.level(), entity.getX(), entity.getY(), entity.getZ(), (Entity)sourceentity);
        return true;
    }

    public void inventoryTick(ItemStack itemstack, Level world, Entity entity, int slot, boolean selected) {
        super.inventoryTick(itemstack, world, entity, slot, selected);
        if (selected) {
            TabooMagicStoneParticleProcedure.execute((LevelAccessor)world, entity.getX(), entity.getY(), entity.getZ());
        }
    }
}

