/*
 * Decompiled with CFR 0.152.
 */
package magic_stone.block;

import com.mojang.serialization.MapCodec;
import magic_stone.procedures.MoonDustDropActionProcedure;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.FallingBlock;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.FluidState;
import net.neoforged.neoforge.common.util.TriState;

public class MoonSandBlock
extends FallingBlock {
    public static final MapCodec<MoonSandBlock> CODEC = MoonSandBlock.simpleCodec(properties -> new MoonSandBlock());

    public MapCodec<MoonSandBlock> codec() {
        return CODEC;
    }

    public MoonSandBlock() {
        super(BlockBehaviour.Properties.of().sound(SoundType.SAND).strength(35.0f, 80.0f).friction(0.3f).speedFactor(1.1f).jumpFactor(1.1f));
    }

    public int getLightBlock(BlockState state, BlockGetter worldIn, BlockPos pos) {
        return 15;
    }

    public float getEnchantPowerBonus(BlockState state, LevelReader world, BlockPos pos) {
        return 0.2f;
    }

    public TriState canSustainPlant(BlockState state, BlockGetter world, BlockPos pos, Direction direction, BlockState plant) {
        return TriState.TRUE;
    }

    public boolean onDestroyedByPlayer(BlockState blockstate, Level world, BlockPos pos, Player entity, boolean willHarvest, FluidState fluid) {
        boolean retval = super.onDestroyedByPlayer(blockstate, world, pos, entity, willHarvest, fluid);
        MoonDustDropActionProcedure.execute((LevelAccessor)world, pos.getX(), pos.getY(), pos.getZ(), (Entity)entity);
        return retval;
    }
}

