/*
 * Decompiled with CFR 0.152.
 */
package magic_stone.fluid;

import magic_stone.init.MagicStoneModBlocks;
import magic_stone.init.MagicStoneModFluidTypes;
import magic_stone.init.MagicStoneModFluids;
import magic_stone.init.MagicStoneModItems;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.block.LiquidBlock;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidState;
import net.neoforged.neoforge.fluids.BaseFlowingFluid;
import net.neoforged.neoforge.fluids.FluidType;

public abstract class AbyssalEnergyLiquidFluid
extends BaseFlowingFluid {
    public static final BaseFlowingFluid.Properties PROPERTIES = new BaseFlowingFluid.Properties(() -> (FluidType)MagicStoneModFluidTypes.ABYSSAL_ENERGY_LIQUID_TYPE.get(), () -> (Fluid)MagicStoneModFluids.ABYSSAL_ENERGY_LIQUID.get(), () -> (Fluid)MagicStoneModFluids.FLOWING_ABYSSAL_ENERGY_LIQUID.get()).explosionResistance(100.0f).tickRate(20).levelDecreasePerBlock(2).bucket(() -> (Item)MagicStoneModItems.ABYSSAL_ENERGY_LIQUID_BUCKET.get()).block(() -> (LiquidBlock)MagicStoneModBlocks.ABYSSAL_ENERGY_LIQUID.get());

    private AbyssalEnergyLiquidFluid() {
        super(PROPERTIES);
    }

    public ParticleOptions getDripParticle() {
        return ParticleTypes.DRAGON_BREATH;
    }

    public static class Flowing
    extends AbyssalEnergyLiquidFluid {
        protected void createFluidStateDefinition(StateDefinition.Builder<Fluid, FluidState> builder) {
            super.createFluidStateDefinition(builder);
            builder.add(new Property[]{LEVEL});
        }

        public int getAmount(FluidState state) {
            return (Integer)state.getValue((Property)LEVEL);
        }

        public boolean isSource(FluidState state) {
            return false;
        }
    }

    public static class Source
    extends AbyssalEnergyLiquidFluid {
        public int getAmount(FluidState state) {
            return 8;
        }

        public boolean isSource(FluidState state) {
            return true;
        }
    }
}

