/*
 * Decompiled with CFR 0.152.
 */
package magic_stone.world.features.treedecorators;

import com.mojang.serialization.MapCodec;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import magic_stone.init.MagicStoneModBlocks;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.levelgen.feature.treedecorators.CocoaDecorator;
import net.minecraft.world.level.levelgen.feature.treedecorators.TreeDecorator;
import net.minecraft.world.level.levelgen.feature.treedecorators.TreeDecoratorType;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.registries.RegisterEvent;

@EventBusSubscriber(bus=EventBusSubscriber.Bus.MOD)
public class CollapseAreaFruitDecorator
extends CocoaDecorator {
    public static MapCodec<CollapseAreaFruitDecorator> CODEC = MapCodec.unit(CollapseAreaFruitDecorator::new);
    public static TreeDecoratorType<?> DECORATOR_TYPE = new TreeDecoratorType(CODEC);

    @SubscribeEvent
    public static void registerTreeDecorator(RegisterEvent event) {
        event.register(Registries.TREE_DECORATOR_TYPE, ResourceLocation.parse((String)"magic_stone:collapse_area_tree_fruit_decorator"), () -> DECORATOR_TYPE);
    }

    public CollapseAreaFruitDecorator() {
        super(0.2f);
    }

    protected TreeDecoratorType<?> type() {
        return DECORATOR_TYPE;
    }

    public void place(TreeDecorator.Context context) {
        RandomSource randomsource = context.random();
        if (!(randomsource.nextFloat() >= 0.2f)) {
            ObjectArrayList list = context.logs();
            int i = ((BlockPos)list.get(0)).getY();
            list.stream().filter(p_69980_ -> p_69980_.getY() - i <= 2).forEach(p_226026_ -> {
                for (Direction direction : Direction.Plane.HORIZONTAL) {
                    Direction direction1;
                    BlockPos blockpos;
                    if (!(randomsource.nextFloat() <= 0.25f) || !context.isAir(blockpos = p_226026_.offset((direction1 = direction.getOpposite()).getStepX(), 0, direction1.getStepZ()))) continue;
                    context.setBlock(blockpos, CollapseAreaFruitDecorator.oriented(((Block)MagicStoneModBlocks.ABYSSAL_ENERGY_GRASS.get()).defaultBlockState(), direction1));
                }
            });
        }
    }

    private static BlockState oriented(BlockState blockstate, Direction direction) {
        return switch (direction) {
            case Direction.SOUTH -> blockstate.rotate(Rotation.CLOCKWISE_180);
            case Direction.EAST -> blockstate.rotate(Rotation.CLOCKWISE_90);
            case Direction.WEST -> blockstate.rotate(Rotation.COUNTERCLOCKWISE_90);
            default -> blockstate;
        };
    }
}

