/*
 * Decompiled with CFR 0.152.
 */
package magic_stone.block;

import com.mojang.serialization.MapCodec;
import magic_stone.procedures.MoonDustDropActionProcedure;
import net.minecraft.core.BlockPos;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.FallingBlock;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.FluidState;

public class MoonSandBlock
extends FallingBlock {
    public static final MapCodec<MoonSandBlock> CODEC = MoonSandBlock.simpleCodec(properties -> new MoonSandBlock());

    public MapCodec<MoonSandBlock> codec() {
        return CODEC;
    }

    public MoonSandBlock() {
        super(BlockBehaviour.Properties.of().sound(SoundType.SAND).strength(1.2f, 50.0f).lightLevel(s -> 2).friction(0.3f).hasPostProcess((bs, br, bp) -> true).emissiveRendering((bs, br, bp) -> true));
    }

    public int getLightBlock(BlockState state, BlockGetter worldIn, BlockPos pos) {
        return 15;
    }

    public boolean onDestroyedByPlayer(BlockState blockstate, Level world, BlockPos pos, Player entity, boolean willHarvest, FluidState fluid) {
        boolean retval = super.onDestroyedByPlayer(blockstate, world, pos, entity, willHarvest, fluid);
        MoonDustDropActionProcedure.execute((LevelAccessor)world, pos.getX(), pos.getY(), pos.getZ());
        return retval;
    }
}

