/*
 * Decompiled with CFR 0.152.
 */
package magic_stone.procedures;

import magic_stone.entity.TheMulingMeteorEntity;
import magic_stone.init.MagicStoneModEntities;
import magic_stone.init.MagicStoneModMobEffects;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.projectile.AbstractArrow;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.enchantment.Enchantments;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;

public class DisasterQuellingActionProcedure {
    public static void execute(LevelAccessor world, double x, double y, double z, Entity entity) {
        LivingEntity _livEnt0;
        if (entity == null) {
            return;
        }
        if (entity instanceof LivingEntity && (_livEnt0 = (LivingEntity)entity).hasEffect(MagicStoneModMobEffects.DISASTER_QUELLING_CIRCULATION)) {
            Entity _shootFrom;
            Level projectileLevel;
            if (world instanceof Level) {
                Level _level = (Level)world;
                if (!_level.isClientSide()) {
                    _level.playSound(null, BlockPos.containing((double)x, (double)y, (double)z), (SoundEvent)BuiltInRegistries.SOUND_EVENT.get(ResourceLocation.parse((String)"magic_stone:cast_magic_spell")), SoundSource.VOICE, 1.0f, 1.0f);
                } else {
                    _level.playLocalSound(x, y, z, (SoundEvent)BuiltInRegistries.SOUND_EVENT.get(ResourceLocation.parse((String)"magic_stone:cast_magic_spell")), SoundSource.VOICE, 1.0f, 1.0f, false);
                }
            }
            if (!(projectileLevel = (_shootFrom = entity).level()).isClientSide()) {
                AbstractArrow _entityToSpawn = DisasterQuellingActionProcedure.initArrowProjectile(new TheMulingMeteorEntity((EntityType<? extends TheMulingMeteorEntity>)((EntityType)MagicStoneModEntities.THE_MULING_METEOR.get()), 0.0, 0.0, 0.0, projectileLevel, DisasterQuellingActionProcedure.createArrowWeaponItemStack(projectileLevel, 0, (byte)100)), entity, 1.0f, true, false, false, AbstractArrow.Pickup.DISALLOWED);
                _entityToSpawn.setPos(_shootFrom.getX(), _shootFrom.getEyeY() - 0.1, _shootFrom.getZ());
                _entityToSpawn.shoot(_shootFrom.getLookAngle().x, _shootFrom.getLookAngle().y, _shootFrom.getLookAngle().z, 3.0f, 0.0f);
                projectileLevel.addFreshEntity((Entity)_entityToSpawn);
            }
        }
    }

    private static AbstractArrow initArrowProjectile(AbstractArrow entityToSpawn, Entity shooter, float damage, boolean silent, boolean fire, boolean particles, AbstractArrow.Pickup pickup) {
        entityToSpawn.setOwner(shooter);
        entityToSpawn.setBaseDamage((double)damage);
        if (silent) {
            entityToSpawn.setSilent(true);
        }
        if (fire) {
            entityToSpawn.igniteForSeconds(100.0f);
        }
        if (particles) {
            entityToSpawn.setCritArrow(true);
        }
        entityToSpawn.pickup = pickup;
        return entityToSpawn;
    }

    private static ItemStack createArrowWeaponItemStack(Level level, int knockback, byte piercing) {
        ItemStack weapon = new ItemStack((ItemLike)Items.ARROW);
        if (knockback > 0) {
            weapon.enchant((Holder)level.registryAccess().lookupOrThrow(Registries.ENCHANTMENT).getOrThrow(Enchantments.KNOCKBACK), knockback);
        }
        if (piercing > 0) {
            weapon.enchant((Holder)level.registryAccess().lookupOrThrow(Registries.ENCHANTMENT).getOrThrow(Enchantments.PIERCING), (int)piercing);
        }
        return weapon;
    }
}

