/*
 * Decompiled with CFR 0.152.
 */
package magicstone.entity;

import javax.annotation.Nullable;
import magicstone.init.MagicStoneModEntities;
import magicstone.init.MagicStoneModItems;
import magicstone.procedures.DreamlandPollenDustActionProcedure;
import magicstone.procedures.DreamlandPollenDustHitActionProcedure;
import magicstone.procedures.DreamlandPollenDustHitBlockActionProcedure;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientGamePacketListener;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.projectile.AbstractArrow;
import net.minecraft.world.entity.projectile.ItemSupplier;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.network.NetworkHooks;
import net.minecraftforge.network.PlayMessages;

@OnlyIn(value=Dist.CLIENT, _interface=ItemSupplier.class)
public class DreamlandPollenDustEntity
extends AbstractArrow
implements ItemSupplier {
    public static final ItemStack PROJECTILE_ITEM = new ItemStack((ItemLike)MagicStoneModItems.DREAMLAND_DUST.get());

    public DreamlandPollenDustEntity(PlayMessages.SpawnEntity packet, Level world) {
        super((EntityType)MagicStoneModEntities.DREAMLAND_POLLEN_DUST.get(), world);
    }

    public DreamlandPollenDustEntity(EntityType<? extends DreamlandPollenDustEntity> type, Level world) {
        super(type, world);
    }

    public DreamlandPollenDustEntity(EntityType<? extends DreamlandPollenDustEntity> type, double x, double y, double z, Level world) {
        super(type, x, y, z, world);
    }

    public DreamlandPollenDustEntity(EntityType<? extends DreamlandPollenDustEntity> type, LivingEntity entity, Level world) {
        super(type, entity, world);
    }

    public Packet<ClientGamePacketListener> m_5654_() {
        return NetworkHooks.getEntitySpawningPacket((Entity)this);
    }

    @OnlyIn(value=Dist.CLIENT)
    public ItemStack m_7846_() {
        return PROJECTILE_ITEM;
    }

    protected ItemStack m_7941_() {
        return PROJECTILE_ITEM;
    }

    protected void m_7761_(LivingEntity entity) {
        super.m_7761_(entity);
        entity.m_21317_(entity.m_21234_() - 1);
    }

    @Nullable
    protected EntityHitResult m_6351_(Vec3 projectilePosition, Vec3 deltaPosition) {
        double d0 = Double.MAX_VALUE;
        Entity entity = null;
        AABB lookupBox = this.m_20191_();
        for (Entity entity1 : this.m_9236_().m_6249_((Entity)this, lookupBox, x$0 -> this.m_5603_((Entity)x$0))) {
            double d1;
            AABB aabb;
            if (entity1 == this.m_19749_() || !(aabb = entity1.m_20191_()).m_82381_(lookupBox) || !((d1 = projectilePosition.m_82557_(projectilePosition)) < d0)) continue;
            entity = entity1;
            d0 = d1;
        }
        return entity == null ? null : new EntityHitResult(entity);
    }

    private Direction determineHitDirection(AABB entityBox, AABB blockBox) {
        double dx = entityBox.m_82399_().f_82479_ - blockBox.m_82399_().f_82479_;
        double dy = entityBox.m_82399_().f_82480_ - blockBox.m_82399_().f_82480_;
        double dz = entityBox.m_82399_().f_82481_ - blockBox.m_82399_().f_82481_;
        double absDx = Math.abs(dx);
        double absDy = Math.abs(dy);
        double absDz = Math.abs(dz);
        if (absDy > absDx && absDy > absDz) {
            return dy > 0.0 ? Direction.DOWN : Direction.UP;
        }
        if (absDx > absDz) {
            return dx > 0.0 ? Direction.WEST : Direction.EAST;
        }
        return dz > 0.0 ? Direction.NORTH : Direction.SOUTH;
    }

    public void m_5790_(EntityHitResult entityHitResult) {
        super.m_5790_(entityHitResult);
        DreamlandPollenDustHitActionProcedure.execute((LevelAccessor)this.m_9236_(), this.m_20185_(), this.m_20186_(), this.m_20189_());
    }

    public void m_8060_(BlockHitResult blockHitResult) {
        super.m_8060_(blockHitResult);
        DreamlandPollenDustHitBlockActionProcedure.execute((LevelAccessor)this.m_9236_(), blockHitResult.m_82425_().m_123341_(), blockHitResult.m_82425_().m_123342_(), blockHitResult.m_82425_().m_123343_());
    }

    public void m_8119_() {
        super.m_8119_();
        if (!this.m_36797_()) {
            for (VoxelShape collision : this.m_9236_().m_186434_((Entity)this, this.m_20191_())) {
                for (AABB blockAABB : collision.m_83299_()) {
                    if (!this.m_20191_().m_82381_(blockAABB)) continue;
                    BlockPos blockPos = new BlockPos((int)blockAABB.f_82288_, (int)blockAABB.f_82289_, (int)blockAABB.f_82290_);
                    Vec3 intersectionPoint = new Vec3((blockAABB.f_82288_ + blockAABB.f_82291_) / 2.0, (blockAABB.f_82289_ + blockAABB.f_82292_) / 2.0, (blockAABB.f_82290_ + blockAABB.f_82293_) / 2.0);
                    Direction hitDirection = this.determineHitDirection(this.m_20191_(), blockAABB);
                    this.m_6532_((HitResult)new BlockHitResult(intersectionPoint, hitDirection, blockPos, false));
                }
            }
        }
        DreamlandPollenDustActionProcedure.execute((LevelAccessor)this.m_9236_(), this.m_20185_(), this.m_20186_(), this.m_20189_());
        if (this.f_36703_) {
            this.m_146870_();
        }
    }

    public static DreamlandPollenDustEntity shoot(Level world, LivingEntity entity, RandomSource source) {
        return DreamlandPollenDustEntity.shoot(world, entity, source, 1.0f, 0.0, 0);
    }

    public static DreamlandPollenDustEntity shoot(Level world, LivingEntity entity, RandomSource source, float pullingPower) {
        return DreamlandPollenDustEntity.shoot(world, entity, source, pullingPower * 1.0f, 0.0, 0);
    }

    public static DreamlandPollenDustEntity shoot(Level world, LivingEntity entity, RandomSource random, float power, double damage, int knockback) {
        DreamlandPollenDustEntity entityarrow = new DreamlandPollenDustEntity((EntityType<? extends DreamlandPollenDustEntity>)((EntityType)MagicStoneModEntities.DREAMLAND_POLLEN_DUST.get()), entity, world);
        entityarrow.m_6686_(entity.m_20252_((float)1.0f).f_82479_, entity.m_20252_((float)1.0f).f_82480_, entity.m_20252_((float)1.0f).f_82481_, power * 2.0f, 0.0f);
        entityarrow.m_20225_(true);
        entityarrow.m_36762_(false);
        entityarrow.m_36781_(damage);
        entityarrow.m_36735_(knockback);
        world.m_7967_((Entity)entityarrow);
        return entityarrow;
    }

    public static DreamlandPollenDustEntity shoot(LivingEntity entity, LivingEntity target) {
        DreamlandPollenDustEntity entityarrow = new DreamlandPollenDustEntity((EntityType<? extends DreamlandPollenDustEntity>)((EntityType)MagicStoneModEntities.DREAMLAND_POLLEN_DUST.get()), entity, entity.m_9236_());
        double dx = target.m_20185_() - entity.m_20185_();
        double dy = target.m_20186_() + (double)target.m_20192_() - 1.1;
        double dz = target.m_20189_() - entity.m_20189_();
        entityarrow.m_6686_(dx, dy - entityarrow.m_20186_() + Math.hypot(dx, dz) * (double)0.2f, dz, 2.0f, 12.0f);
        entityarrow.m_20225_(true);
        entityarrow.m_36781_(0.0);
        entityarrow.m_36735_(0);
        entityarrow.m_36762_(false);
        entity.m_9236_().m_7967_((Entity)entityarrow);
        return entityarrow;
    }
}

