/*
 * Decompiled with CFR 0.152.
 */
package magicstone.network;

import java.util.function.Supplier;
import magicstone.MagicStoneMod;
import magicstone.procedures.ClearShellsActionProcedure;
import magicstone.procedures.ErrorFixingFlightActionProcedure;
import magicstone.procedures.GUIGamemodeAdventureProcedure;
import magicstone.procedures.GUIGamemodeCreativeProcedure;
import magicstone.procedures.GUIGamemodeSpectatorProcedure;
import magicstone.procedures.GUIGamemodeSurvivalProcedure;
import magicstone.procedures.GUIGameruleDaylightCycleProcedure;
import magicstone.procedures.GUIGameruleMobGriefingProcedure;
import magicstone.procedures.GUIGameruleMobLootProcedure;
import magicstone.procedures.GUIGameruleTileDropsProcedure;
import magicstone.procedures.GuiTpProcedure;
import magicstone.procedures.GuiWeatherClearProcedure;
import magicstone.procedures.GuiWeatherRainProcedure;
import net.minecraft.core.BlockPos;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.network.NetworkEvent;

@Mod.EventBusSubscriber(bus=Mod.EventBusSubscriber.Bus.MOD)
public class MagicStoneDebugMenuGuiButtonMessage {
    private final int buttonID;
    private final int x;
    private final int y;
    private final int z;

    public MagicStoneDebugMenuGuiButtonMessage(FriendlyByteBuf buffer) {
        this.buttonID = buffer.readInt();
        this.x = buffer.readInt();
        this.y = buffer.readInt();
        this.z = buffer.readInt();
    }

    public MagicStoneDebugMenuGuiButtonMessage(int buttonID, int x, int y, int z) {
        this.buttonID = buttonID;
        this.x = x;
        this.y = y;
        this.z = z;
    }

    public static void buffer(MagicStoneDebugMenuGuiButtonMessage message, FriendlyByteBuf buffer) {
        buffer.writeInt(message.buttonID);
        buffer.writeInt(message.x);
        buffer.writeInt(message.y);
        buffer.writeInt(message.z);
    }

    public static void handler(MagicStoneDebugMenuGuiButtonMessage message, Supplier<NetworkEvent.Context> contextSupplier) {
        NetworkEvent.Context context = contextSupplier.get();
        context.enqueueWork(() -> {
            ServerPlayer entity = context.getSender();
            int buttonID = message.buttonID;
            int x = message.x;
            int y = message.y;
            int z = message.z;
            MagicStoneDebugMenuGuiButtonMessage.handleButtonAction((Player)entity, buttonID, x, y, z);
        });
        context.setPacketHandled(true);
    }

    public static void handleButtonAction(Player entity, int buttonID, int x, int y, int z) {
        Level world = entity.m_9236_();
        if (!world.m_46805_(new BlockPos(x, y, z))) {
            return;
        }
        if (buttonID == 0) {
            ErrorFixingFlightActionProcedure.execute((LevelAccessor)world, x, y, z, (Entity)entity);
        }
        if (buttonID == 1) {
            ClearShellsActionProcedure.execute((LevelAccessor)world, x, y, z, (Entity)entity);
        }
        if (buttonID == 2) {
            GUIGamemodeCreativeProcedure.execute((Entity)entity);
        }
        if (buttonID == 3) {
            GUIGamemodeSurvivalProcedure.execute((Entity)entity);
        }
        if (buttonID == 4) {
            GUIGamemodeSpectatorProcedure.execute((Entity)entity);
        }
        if (buttonID == 5) {
            GUIGamemodeAdventureProcedure.execute((Entity)entity);
        }
        if (buttonID == 6) {
            GuiWeatherClearProcedure.execute((LevelAccessor)world, x, y, z, (Entity)entity);
        }
        if (buttonID == 7) {
            GuiWeatherRainProcedure.execute((LevelAccessor)world, x, y, z, (Entity)entity);
        }
        if (buttonID == 8) {
            GUIGameruleMobGriefingProcedure.execute((LevelAccessor)world, x, y, z, (Entity)entity);
        }
        if (buttonID == 9) {
            GUIGameruleMobLootProcedure.execute((LevelAccessor)world, x, y, z, (Entity)entity);
        }
        if (buttonID == 10) {
            GUIGameruleTileDropsProcedure.execute((LevelAccessor)world, x, y, z, (Entity)entity);
        }
        if (buttonID == 11) {
            GUIGameruleDaylightCycleProcedure.execute((LevelAccessor)world, x, y, z, (Entity)entity);
        }
        if (buttonID == 12) {
            GuiTpProcedure.execute((Entity)entity);
        }
    }

    @SubscribeEvent
    public static void registerMessage(FMLCommonSetupEvent event) {
        MagicStoneMod.addNetworkMessage(MagicStoneDebugMenuGuiButtonMessage.class, MagicStoneDebugMenuGuiButtonMessage::buffer, MagicStoneDebugMenuGuiButtonMessage::new, MagicStoneDebugMenuGuiButtonMessage::handler);
    }
}

