/*
 * Decompiled with CFR 0.152.
 */
package magic_stone.init;

import magic_stone.network.MagicGhostSpellMessage;
import magic_stone.network.MagicGhostSubsidiarySkillMessage;
import net.minecraft.client.KeyMapping;
import net.minecraft.client.Minecraft;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.world.entity.player.Player;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.client.event.ClientTickEvent;
import net.neoforged.neoforge.client.event.RegisterKeyMappingsEvent;
import net.neoforged.neoforge.network.PacketDistributor;

@EventBusSubscriber(bus=EventBusSubscriber.Bus.MOD, value={Dist.CLIENT})
public class MagicStoneModKeyMappings {
    public static final KeyMapping MAGIC_GHOST_SPELL = new KeyMapping("key.magic_stone.magic_ghost_spell", 88, "key.categories.movement"){
        private boolean isDownOld = false;

        public void setDown(boolean isDown) {
            super.setDown(isDown);
            if (this.isDownOld != isDown && isDown) {
                MAGIC_GHOST_SPELL_LASTPRESS = System.currentTimeMillis();
            } else if (this.isDownOld != isDown && !isDown) {
                int dt = (int)(System.currentTimeMillis() - MAGIC_GHOST_SPELL_LASTPRESS);
                PacketDistributor.sendToServer((CustomPacketPayload)new MagicGhostSpellMessage(1, dt), (CustomPacketPayload[])new CustomPacketPayload[0]);
                MagicGhostSpellMessage.pressAction((Player)Minecraft.getInstance().player, 1, dt);
            }
            this.isDownOld = isDown;
        }
    };
    public static final KeyMapping MAGIC_GHOST_SUBSIDIARY_SKILL = new KeyMapping("key.magic_stone.magic_ghost_subsidiary_skill", 90, "key.categories.movement"){
        private boolean isDownOld = false;

        public void setDown(boolean isDown) {
            super.setDown(isDown);
            if (this.isDownOld != isDown && isDown) {
                MAGIC_GHOST_SUBSIDIARY_SKILL_LASTPRESS = System.currentTimeMillis();
            } else if (this.isDownOld != isDown && !isDown) {
                int dt = (int)(System.currentTimeMillis() - MAGIC_GHOST_SUBSIDIARY_SKILL_LASTPRESS);
                PacketDistributor.sendToServer((CustomPacketPayload)new MagicGhostSubsidiarySkillMessage(1, dt), (CustomPacketPayload[])new CustomPacketPayload[0]);
                MagicGhostSubsidiarySkillMessage.pressAction((Player)Minecraft.getInstance().player, 1, dt);
            }
            this.isDownOld = isDown;
        }
    };
    private static long MAGIC_GHOST_SPELL_LASTPRESS = 0L;
    private static long MAGIC_GHOST_SUBSIDIARY_SKILL_LASTPRESS = 0L;

    @SubscribeEvent
    public static void registerKeyMappings(RegisterKeyMappingsEvent event) {
        event.register(MAGIC_GHOST_SPELL);
        event.register(MAGIC_GHOST_SUBSIDIARY_SKILL);
    }

    @EventBusSubscriber(value={Dist.CLIENT})
    public static class KeyEventListener {
        @SubscribeEvent
        public static void onClientTick(ClientTickEvent.Post event) {
            if (Minecraft.getInstance().screen == null) {
                MAGIC_GHOST_SPELL.consumeClick();
                MAGIC_GHOST_SUBSIDIARY_SKILL.consumeClick();
            }
        }
    }
}

