/*
 * Decompiled with CFR 0.152.
 */
package magic_stone.item;

import magic_stone.procedures.RegenerationLeftActionProcedure;
import magic_stone.procedures.RegenerationRightActionProcedure;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Rarity;
import net.minecraft.world.item.UseAnim;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;

public class AdvancedSecondOrderRegenerationCurseStoneItem
extends Item {
    public AdvancedSecondOrderRegenerationCurseStoneItem() {
        super(new Item.Properties().durability(10).fireResistant().rarity(Rarity.UNCOMMON));
    }

    public UseAnim getUseAnimation(ItemStack itemstack) {
        return UseAnim.BOW;
    }

    public int getEnchantmentValue() {
        return 10;
    }

    public int getUseDuration(ItemStack itemstack, LivingEntity livingEntity) {
        return 10;
    }

    public InteractionResultHolder<ItemStack> use(Level world, Player entity, InteractionHand hand) {
        InteractionResultHolder ar = super.use(world, entity, hand);
        entity.startUsingItem(hand);
        return ar;
    }

    public ItemStack finishUsingItem(ItemStack itemstack, Level world, LivingEntity entity) {
        ItemStack retval = super.finishUsingItem(itemstack, world, entity);
        double x = entity.getX();
        double y = entity.getY();
        double z = entity.getZ();
        RegenerationRightActionProcedure.execute((LevelAccessor)world, x, y, z, (Entity)entity, itemstack);
        return retval;
    }

    public boolean onEntitySwing(ItemStack itemstack, LivingEntity entity, InteractionHand hand) {
        boolean retval = super.onEntitySwing(itemstack, entity, hand);
        RegenerationLeftActionProcedure.execute((LevelAccessor)entity.level(), entity.getX(), entity.getY(), entity.getZ(), (Entity)entity, itemstack);
        return retval;
    }
}

