/*
 * Decompiled with CFR 0.152.
 */
package magicstone.entity;

import java.util.EnumSet;
import javax.annotation.Nullable;
import magicstone.entity.ApprenticeOfTheSorcererEntity;
import magicstone.entity.ChaosFiendRioterEntity;
import magicstone.entity.DreamlandGuardiansEntity;
import magicstone.entity.InfectedMengLiEntity;
import magicstone.entity.MagicalConstructGiantEntity;
import magicstone.entity.MasterOfMagicEntity;
import magicstone.entity.MengLiEntity;
import magicstone.entity.MildChaosErodedRemnantEntity;
import magicstone.entity.SlaveEntity;
import magicstone.entity.StrangeCreatureEntity;
import magicstone.entity.TheSpearOfAbyssEntity;
import magicstone.procedures.AbyssofMadnessActionProcedure;
import magicstone.procedures.AbyssofMadnessTimerActionProcedure;
import net.minecraft.core.BlockPos;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.util.RandomSource;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.damagesource.DamageTypes;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.control.FlyingMoveControl;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;
import net.minecraft.world.entity.ai.goal.RandomStrollGoal;
import net.minecraft.world.entity.ai.goal.RangedAttackGoal;
import net.minecraft.world.entity.ai.goal.target.HurtByTargetGoal;
import net.minecraft.world.entity.ai.goal.target.NearestAttackableTargetGoal;
import net.minecraft.world.entity.ai.navigation.FlyingPathNavigation;
import net.minecraft.world.entity.ai.navigation.PathNavigation;
import net.minecraft.world.entity.animal.Animal;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.entity.monster.RangedAttackMob;
import net.minecraft.world.entity.npc.Villager;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Explosion;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec3;
import net.neoforged.neoforge.event.entity.RegisterSpawnPlacementsEvent;

public class EnemyAbyssofMadnessEntity
extends Monster
implements RangedAttackMob {
    public EnemyAbyssofMadnessEntity(EntityType<EnemyAbyssofMadnessEntity> type, Level world) {
        super(type, world);
        this.xpReward = 0;
        this.setNoAi(false);
        this.moveControl = new FlyingMoveControl((Mob)this, 10, true);
    }

    protected PathNavigation createNavigation(Level world) {
        return new FlyingPathNavigation((Mob)this, world);
    }

    protected void registerGoals() {
        super.registerGoals();
        this.targetSelector.addGoal(1, (Goal)new NearestAttackableTargetGoal((Mob)this, Player.class, false, false));
        this.targetSelector.addGoal(2, (Goal)new NearestAttackableTargetGoal((Mob)this, StrangeCreatureEntity.class, false, true));
        this.targetSelector.addGoal(3, (Goal)new NearestAttackableTargetGoal((Mob)this, SlaveEntity.class, false, false));
        this.targetSelector.addGoal(4, (Goal)new NearestAttackableTargetGoal((Mob)this, ApprenticeOfTheSorcererEntity.class, false, false));
        this.targetSelector.addGoal(5, (Goal)new NearestAttackableTargetGoal((Mob)this, MasterOfMagicEntity.class, false, false));
        this.targetSelector.addGoal(6, (Goal)new NearestAttackableTargetGoal((Mob)this, Villager.class, false, false));
        this.targetSelector.addGoal(7, (Goal)new NearestAttackableTargetGoal((Mob)this, MagicalConstructGiantEntity.class, false, false));
        this.targetSelector.addGoal(8, (Goal)new NearestAttackableTargetGoal((Mob)this, DreamlandGuardiansEntity.class, false, false));
        this.targetSelector.addGoal(9, (Goal)new NearestAttackableTargetGoal((Mob)this, MengLiEntity.class, false, false));
        this.targetSelector.addGoal(10, (Goal)new NearestAttackableTargetGoal((Mob)this, InfectedMengLiEntity.class, false, false));
        this.targetSelector.addGoal(11, (Goal)new NearestAttackableTargetGoal((Mob)this, MildChaosErodedRemnantEntity.class, false, false));
        this.targetSelector.addGoal(12, (Goal)new NearestAttackableTargetGoal((Mob)this, ChaosFiendRioterEntity.class, false, false));
        this.targetSelector.addGoal(13, (Goal)new NearestAttackableTargetGoal((Mob)this, Animal.class, false, false));
        this.goalSelector.addGoal(14, new Goal(){
            {
                this.setFlags(EnumSet.of(Goal.Flag.MOVE));
            }

            public boolean canUse() {
                return EnemyAbyssofMadnessEntity.this.getTarget() != null && !EnemyAbyssofMadnessEntity.this.getMoveControl().hasWanted();
            }

            public boolean canContinueToUse() {
                return EnemyAbyssofMadnessEntity.this.getMoveControl().hasWanted() && EnemyAbyssofMadnessEntity.this.getTarget() != null && EnemyAbyssofMadnessEntity.this.getTarget().isAlive();
            }

            public void start() {
                LivingEntity livingentity = EnemyAbyssofMadnessEntity.this.getTarget();
                Vec3 vec3d = livingentity.getEyePosition(1.0f);
                EnemyAbyssofMadnessEntity.this.moveControl.setWantedPosition(vec3d.x, vec3d.y, vec3d.z, 1.5);
            }

            public void tick() {
                LivingEntity livingentity = EnemyAbyssofMadnessEntity.this.getTarget();
                if (EnemyAbyssofMadnessEntity.this.getBoundingBox().intersects(livingentity.getBoundingBox())) {
                    EnemyAbyssofMadnessEntity.this.doHurtTarget((Entity)livingentity);
                } else {
                    double d0 = EnemyAbyssofMadnessEntity.this.distanceToSqr((Entity)livingentity);
                    if (d0 < 16.0) {
                        Vec3 vec3d = livingentity.getEyePosition(1.0f);
                        EnemyAbyssofMadnessEntity.this.moveControl.setWantedPosition(vec3d.x, vec3d.y, vec3d.z, 1.5);
                    }
                }
            }
        });
        this.targetSelector.addGoal(15, (Goal)new HurtByTargetGoal((PathfinderMob)this, new Class[0]).setAlertOthers(new Class[0]));
        this.goalSelector.addGoal(16, (Goal)new RandomStrollGoal((PathfinderMob)this, 1.2, 20){

            protected Vec3 getPosition() {
                RandomSource random = EnemyAbyssofMadnessEntity.this.getRandom();
                double dir_x = EnemyAbyssofMadnessEntity.this.getX() + (double)((random.nextFloat() * 2.0f - 1.0f) * 16.0f);
                double dir_y = EnemyAbyssofMadnessEntity.this.getY() + (double)((random.nextFloat() * 2.0f - 1.0f) * 16.0f);
                double dir_z = EnemyAbyssofMadnessEntity.this.getZ() + (double)((random.nextFloat() * 2.0f - 1.0f) * 16.0f);
                return new Vec3(dir_x, dir_y, dir_z);
            }
        });
        this.goalSelector.addGoal(17, (Goal)new RandomLookAroundGoal((Mob)this));
        this.goalSelector.addGoal(1, (Goal)new RangedAttackGoal(this, this, 1.25, 30, 30.0f){

            public boolean canContinueToUse() {
                return this.canUse();
            }
        });
    }

    public SoundEvent getHurtSound(DamageSource ds) {
        return (SoundEvent)BuiltInRegistries.SOUND_EVENT.get(ResourceLocation.parse((String)"magic_stone:cast_magic_spell"));
    }

    public SoundEvent getDeathSound() {
        return (SoundEvent)BuiltInRegistries.SOUND_EVENT.get(ResourceLocation.parse((String)"magic_stone:cast_magic_spell"));
    }

    public boolean causeFallDamage(float l, float d, DamageSource source) {
        return false;
    }

    public boolean hurt(DamageSource damagesource, float amount) {
        if (damagesource.is(DamageTypes.FALL)) {
            return false;
        }
        if (damagesource.is(DamageTypes.CACTUS)) {
            return false;
        }
        if (damagesource.is(DamageTypes.DROWN)) {
            return false;
        }
        if (damagesource.is(DamageTypes.EXPLOSION) || damagesource.is(DamageTypes.PLAYER_EXPLOSION)) {
            return false;
        }
        if (damagesource.is(DamageTypes.FALLING_ANVIL)) {
            return false;
        }
        if (damagesource.is(DamageTypes.DRAGON_BREATH)) {
            return false;
        }
        if (damagesource.is(DamageTypes.WITHER) || damagesource.is(DamageTypes.WITHER_SKULL)) {
            return false;
        }
        return super.hurt(damagesource, amount);
    }

    public boolean ignoreExplosion(Explosion explosion) {
        return true;
    }

    public SpawnGroupData finalizeSpawn(ServerLevelAccessor world, DifficultyInstance difficulty, MobSpawnType reason, @Nullable SpawnGroupData livingdata) {
        SpawnGroupData retval = super.finalizeSpawn(world, difficulty, reason, livingdata);
        AbyssofMadnessTimerActionProcedure.execute((Entity)this);
        return retval;
    }

    public void baseTick() {
        super.baseTick();
        AbyssofMadnessActionProcedure.execute((LevelAccessor)this.level(), this.getX(), this.getY(), this.getZ());
    }

    public void performRangedAttack(LivingEntity target, float flval) {
        TheSpearOfAbyssEntity.shoot((LivingEntity)this, target);
    }

    public boolean isPushedByFluid() {
        double x = this.getX();
        double y = this.getY();
        double z = this.getZ();
        Level world = this.level();
        EnemyAbyssofMadnessEntity entity = this;
        return false;
    }

    protected void checkFallDamage(double y, boolean onGroundIn, BlockState state, BlockPos pos) {
    }

    public void setNoGravity(boolean ignored) {
        super.setNoGravity(true);
    }

    public void aiStep() {
        super.aiStep();
        this.setNoGravity(true);
    }

    public static void init(RegisterSpawnPlacementsEvent event) {
    }

    public static AttributeSupplier.Builder createAttributes() {
        AttributeSupplier.Builder builder = Mob.createMobAttributes();
        builder = builder.add(Attributes.MOVEMENT_SPEED, 0.35);
        builder = builder.add(Attributes.MAX_HEALTH, 666.0);
        builder = builder.add(Attributes.ARMOR, 20.0);
        builder = builder.add(Attributes.ATTACK_DAMAGE, 1.0);
        builder = builder.add(Attributes.FOLLOW_RANGE, 32.0);
        builder = builder.add(Attributes.STEP_HEIGHT, 0.5);
        builder = builder.add(Attributes.KNOCKBACK_RESISTANCE, 10.0);
        builder = builder.add(Attributes.ATTACK_KNOCKBACK, 2.0);
        builder = builder.add(Attributes.FLYING_SPEED, 0.35);
        return builder;
    }
}

