/*
 * Decompiled with CFR 0.152.
 */
package magicstone.network;

import magicstone.MagicStoneMod;
import magicstone.procedures.ClearShellsActionProcedure;
import magicstone.procedures.ErrorFixingFlightActionProcedure;
import magicstone.procedures.GUIGamemodeAdventureProcedure;
import magicstone.procedures.GUIGamemodeCreativeProcedure;
import magicstone.procedures.GUIGamemodeSpectatorProcedure;
import magicstone.procedures.GUIGamemodeSurvivalProcedure;
import magicstone.procedures.GUIGameruleDaylightCycleProcedure;
import magicstone.procedures.GUIGameruleMobGriefingProcedure;
import magicstone.procedures.GUIGameruleMobLootProcedure;
import magicstone.procedures.GUIGameruleTileDropsProcedure;
import magicstone.procedures.GuiTpProcedure;
import magicstone.procedures.GuiWeatherClearProcedure;
import magicstone.procedures.GuiWeatherRainProcedure;
import net.minecraft.core.BlockPos;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.PacketFlow;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.fml.event.lifecycle.FMLCommonSetupEvent;
import net.neoforged.neoforge.network.handling.IPayloadContext;

@EventBusSubscriber(bus=EventBusSubscriber.Bus.MOD)
public record MagicStoneDebugMenuGuiButtonMessage(int buttonID, int x, int y, int z) implements CustomPacketPayload
{
    public static final CustomPacketPayload.Type<MagicStoneDebugMenuGuiButtonMessage> TYPE = new CustomPacketPayload.Type(ResourceLocation.fromNamespaceAndPath((String)"magic_stone", (String)"magic_stone_debug_menu_gui_buttons"));
    public static final StreamCodec<RegistryFriendlyByteBuf, MagicStoneDebugMenuGuiButtonMessage> STREAM_CODEC = StreamCodec.of((buffer, message) -> {
        buffer.writeInt(message.buttonID);
        buffer.writeInt(message.x);
        buffer.writeInt(message.y);
        buffer.writeInt(message.z);
    }, buffer -> new MagicStoneDebugMenuGuiButtonMessage(buffer.readInt(), buffer.readInt(), buffer.readInt(), buffer.readInt()));

    public CustomPacketPayload.Type<MagicStoneDebugMenuGuiButtonMessage> type() {
        return TYPE;
    }

    public static void handleData(MagicStoneDebugMenuGuiButtonMessage message, IPayloadContext context) {
        if (context.flow() == PacketFlow.SERVERBOUND) {
            context.enqueueWork(() -> MagicStoneDebugMenuGuiButtonMessage.handleButtonAction(context.player(), message.buttonID, message.x, message.y, message.z)).exceptionally(e -> {
                context.connection().disconnect((Component)Component.literal((String)e.getMessage()));
                return null;
            });
        }
    }

    public static void handleButtonAction(Player entity, int buttonID, int x, int y, int z) {
        Level world = entity.level();
        if (!world.hasChunkAt(new BlockPos(x, y, z))) {
            return;
        }
        if (buttonID == 0) {
            ErrorFixingFlightActionProcedure.execute((LevelAccessor)world, x, y, z, (Entity)entity);
        }
        if (buttonID == 1) {
            ClearShellsActionProcedure.execute((LevelAccessor)world, x, y, z, (Entity)entity);
        }
        if (buttonID == 2) {
            GUIGamemodeCreativeProcedure.execute((Entity)entity);
        }
        if (buttonID == 3) {
            GUIGamemodeSurvivalProcedure.execute((Entity)entity);
        }
        if (buttonID == 4) {
            GUIGamemodeSpectatorProcedure.execute((Entity)entity);
        }
        if (buttonID == 5) {
            GUIGamemodeAdventureProcedure.execute((Entity)entity);
        }
        if (buttonID == 6) {
            GuiWeatherClearProcedure.execute((LevelAccessor)world, x, y, z, (Entity)entity);
        }
        if (buttonID == 7) {
            GuiWeatherRainProcedure.execute((LevelAccessor)world, x, y, z, (Entity)entity);
        }
        if (buttonID == 8) {
            GUIGameruleMobGriefingProcedure.execute((LevelAccessor)world, x, y, z, (Entity)entity);
        }
        if (buttonID == 9) {
            GUIGameruleMobLootProcedure.execute((LevelAccessor)world, x, y, z, (Entity)entity);
        }
        if (buttonID == 10) {
            GUIGameruleTileDropsProcedure.execute((LevelAccessor)world, x, y, z, (Entity)entity);
        }
        if (buttonID == 11) {
            GUIGameruleDaylightCycleProcedure.execute((LevelAccessor)world, x, y, z, (Entity)entity);
        }
        if (buttonID == 12) {
            GuiTpProcedure.execute((Entity)entity);
        }
    }

    @SubscribeEvent
    public static void registerMessage(FMLCommonSetupEvent event) {
        MagicStoneMod.addNetworkMessage(TYPE, STREAM_CODEC, MagicStoneDebugMenuGuiButtonMessage::handleData);
    }
}

