/*
 * Decompiled with CFR 0.152.
 */
package magicstone.entity;

import javax.annotation.Nullable;
import magicstone.entity.AbyssalRemnantWarriorEntity;
import magicstone.entity.BaneMageEntity;
import magicstone.entity.ChaosFiendRioterEntity;
import magicstone.entity.EnemySlaveEntity;
import magicstone.entity.FifthOrderFerociousGhostEntity;
import magicstone.entity.FifthOrderSorcererEntity;
import magicstone.entity.FirstOrderFerociousGhostEntity;
import magicstone.entity.FirstOrderSorcererEntity;
import magicstone.entity.FourthOrderFerociousGhostEntity;
import magicstone.entity.FourthOrderSorcererEntity;
import magicstone.entity.InfectedMengLiEntity;
import magicstone.entity.MildChaosErodedRemnantEntity;
import magicstone.entity.ReplicaAbyssalRemnantWarriorEntity;
import magicstone.entity.ReplicaWickedDiscipleUnleashedEntity;
import magicstone.entity.SecondOrderFerociousGhostEntity;
import magicstone.entity.SecondOrderSorcererEntity;
import magicstone.entity.StrangeCreatureEntity;
import magicstone.entity.ThirdOrderFerociousGhostEntity;
import magicstone.entity.ThirdOrderSorcererEntity;
import magicstone.entity.WickedDiscipleEntity;
import magicstone.entity.WickedDiscipleUnleashedEntity;
import magicstone.init.MagicStoneModEntities;
import magicstone.init.MagicStoneModItems;
import magicstone.procedures.ConstructGiantSpecialActionProcedure;
import magicstone.procedures.GiantSlaveActionProcedure;
import magicstone.procedures.GiantSlaveTimerActionProcedure;
import magicstone.procedures.MagicalConstructGiantAutoRideActionProcedure;
import net.minecraft.core.BlockPos;
import net.minecraft.core.component.DataComponents;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.damagesource.DamageTypes;
import net.minecraft.world.entity.AgeableMob;
import net.minecraft.world.entity.AreaEffectCloud;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityDimensions;
import net.minecraft.world.entity.EntitySpawnReason;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.TamableAnimal;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.FloatGoal;
import net.minecraft.world.entity.ai.goal.FollowOwnerGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.MeleeAttackGoal;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;
import net.minecraft.world.entity.ai.goal.RandomStrollGoal;
import net.minecraft.world.entity.ai.goal.target.HurtByTargetGoal;
import net.minecraft.world.entity.ai.goal.target.NearestAttackableTargetGoal;
import net.minecraft.world.entity.ai.goal.target.OwnerHurtByTargetGoal;
import net.minecraft.world.entity.ai.goal.target.OwnerHurtTargetGoal;
import net.minecraft.world.entity.animal.Animal;
import net.minecraft.world.entity.boss.enderdragon.EnderDragon;
import net.minecraft.world.entity.boss.wither.WitherBoss;
import net.minecraft.world.entity.monster.Blaze;
import net.minecraft.world.entity.monster.CaveSpider;
import net.minecraft.world.entity.monster.Creeper;
import net.minecraft.world.entity.monster.Drowned;
import net.minecraft.world.entity.monster.Endermite;
import net.minecraft.world.entity.monster.Evoker;
import net.minecraft.world.entity.monster.Ghast;
import net.minecraft.world.entity.monster.Guardian;
import net.minecraft.world.entity.monster.Husk;
import net.minecraft.world.entity.monster.MagmaCube;
import net.minecraft.world.entity.monster.Phantom;
import net.minecraft.world.entity.monster.Pillager;
import net.minecraft.world.entity.monster.Ravager;
import net.minecraft.world.entity.monster.Silverfish;
import net.minecraft.world.entity.monster.Skeleton;
import net.minecraft.world.entity.monster.Slime;
import net.minecraft.world.entity.monster.Spider;
import net.minecraft.world.entity.monster.Stray;
import net.minecraft.world.entity.monster.Vex;
import net.minecraft.world.entity.monster.Vindicator;
import net.minecraft.world.entity.monster.Witch;
import net.minecraft.world.entity.monster.WitherSkeleton;
import net.minecraft.world.entity.monster.Zombie;
import net.minecraft.world.entity.monster.ZombieVillager;
import net.minecraft.world.entity.monster.ZombifiedPiglin;
import net.minecraft.world.entity.monster.piglin.Piglin;
import net.minecraft.world.entity.monster.piglin.PiglinBrute;
import net.minecraft.world.entity.monster.warden.Warden;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.AbstractArrow;
import net.minecraft.world.entity.projectile.ThrownPotion;
import net.minecraft.world.food.FoodProperties;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.SpawnEggItem;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.Explosion;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec3;
import net.neoforged.neoforge.common.NeoForgeMod;
import net.neoforged.neoforge.event.EventHooks;
import net.neoforged.neoforge.event.entity.RegisterSpawnPlacementsEvent;

public class MagicalConstructGiantEntity
extends TamableAnimal {
    public MagicalConstructGiantEntity(EntityType<MagicalConstructGiantEntity> type, Level world) {
        super(type, world);
        this.xpReward = 0;
        this.setNoAi(false);
        this.refreshDimensions();
    }

    protected void registerGoals() {
        super.registerGoals();
        this.goalSelector.addGoal(1, (Goal)new MeleeAttackGoal(this, (PathfinderMob)this, 0.7, true){

            protected boolean canPerformAttack(LivingEntity entity) {
                return this.isTimeToAttack() && this.mob.distanceToSqr((Entity)entity) < (double)(this.mob.getBbWidth() * this.mob.getBbWidth() + entity.getBbWidth()) && this.mob.getSensing().hasLineOfSight((Entity)entity);
            }
        });
        this.targetSelector.addGoal(2, (Goal)new OwnerHurtTargetGoal((TamableAnimal)this));
        this.goalSelector.addGoal(3, (Goal)new OwnerHurtByTargetGoal((TamableAnimal)this));
        this.targetSelector.addGoal(4, (Goal)new HurtByTargetGoal((PathfinderMob)this, new Class[0]).setAlertOthers(new Class[0]));
        this.targetSelector.addGoal(5, (Goal)new NearestAttackableTargetGoal((Mob)this, FirstOrderSorcererEntity.class, true, true));
        this.targetSelector.addGoal(6, (Goal)new NearestAttackableTargetGoal((Mob)this, SecondOrderSorcererEntity.class, true, true));
        this.targetSelector.addGoal(7, (Goal)new NearestAttackableTargetGoal((Mob)this, ThirdOrderSorcererEntity.class, true, true));
        this.targetSelector.addGoal(8, (Goal)new NearestAttackableTargetGoal((Mob)this, FourthOrderSorcererEntity.class, true, true));
        this.targetSelector.addGoal(9, (Goal)new NearestAttackableTargetGoal((Mob)this, FifthOrderSorcererEntity.class, true, true));
        this.targetSelector.addGoal(10, (Goal)new NearestAttackableTargetGoal((Mob)this, StrangeCreatureEntity.class, true, true));
        this.targetSelector.addGoal(11, (Goal)new NearestAttackableTargetGoal((Mob)this, Zombie.class, true, true));
        this.targetSelector.addGoal(12, (Goal)new NearestAttackableTargetGoal((Mob)this, ZombieVillager.class, true, true));
        this.targetSelector.addGoal(13, (Goal)new NearestAttackableTargetGoal((Mob)this, ZombifiedPiglin.class, true, true));
        this.targetSelector.addGoal(14, (Goal)new NearestAttackableTargetGoal((Mob)this, Husk.class, true, true));
        this.targetSelector.addGoal(15, (Goal)new NearestAttackableTargetGoal((Mob)this, Witch.class, true, true));
        this.targetSelector.addGoal(16, (Goal)new NearestAttackableTargetGoal((Mob)this, Skeleton.class, true, true));
        this.targetSelector.addGoal(17, (Goal)new NearestAttackableTargetGoal((Mob)this, Warden.class, true, true));
        this.targetSelector.addGoal(18, (Goal)new NearestAttackableTargetGoal((Mob)this, EnderDragon.class, true, true));
        this.targetSelector.addGoal(19, (Goal)new NearestAttackableTargetGoal((Mob)this, Blaze.class, true, true));
        this.targetSelector.addGoal(20, (Goal)new NearestAttackableTargetGoal((Mob)this, CaveSpider.class, true, true));
        this.targetSelector.addGoal(21, (Goal)new NearestAttackableTargetGoal((Mob)this, Spider.class, true, true));
        this.targetSelector.addGoal(22, (Goal)new NearestAttackableTargetGoal((Mob)this, Drowned.class, true, true));
        this.targetSelector.addGoal(23, (Goal)new NearestAttackableTargetGoal((Mob)this, Creeper.class, true, true));
        this.targetSelector.addGoal(24, (Goal)new NearestAttackableTargetGoal((Mob)this, Endermite.class, true, true));
        this.targetSelector.addGoal(25, (Goal)new NearestAttackableTargetGoal((Mob)this, WitherBoss.class, true, true));
        this.targetSelector.addGoal(26, (Goal)new NearestAttackableTargetGoal((Mob)this, WitherSkeleton.class, true, true));
        this.targetSelector.addGoal(27, (Goal)new NearestAttackableTargetGoal((Mob)this, WitherSkeleton.class, true, true));
        this.targetSelector.addGoal(28, (Goal)new NearestAttackableTargetGoal((Mob)this, Ghast.class, true, true));
        this.targetSelector.addGoal(29, (Goal)new NearestAttackableTargetGoal((Mob)this, Slime.class, true, true));
        this.targetSelector.addGoal(30, (Goal)new NearestAttackableTargetGoal((Mob)this, Guardian.class, true, true));
        this.targetSelector.addGoal(31, (Goal)new NearestAttackableTargetGoal((Mob)this, Stray.class, true, true));
        this.targetSelector.addGoal(32, (Goal)new NearestAttackableTargetGoal((Mob)this, Phantom.class, true, true));
        this.targetSelector.addGoal(33, (Goal)new NearestAttackableTargetGoal((Mob)this, Vindicator.class, true, true));
        this.targetSelector.addGoal(34, (Goal)new NearestAttackableTargetGoal((Mob)this, Pillager.class, true, true));
        this.targetSelector.addGoal(35, (Goal)new NearestAttackableTargetGoal((Mob)this, Ravager.class, true, true));
        this.targetSelector.addGoal(36, (Goal)new NearestAttackableTargetGoal((Mob)this, Evoker.class, true, true));
        this.targetSelector.addGoal(37, (Goal)new NearestAttackableTargetGoal((Mob)this, Piglin.class, true, true));
        this.targetSelector.addGoal(38, (Goal)new NearestAttackableTargetGoal((Mob)this, PiglinBrute.class, true, true));
        this.targetSelector.addGoal(39, (Goal)new NearestAttackableTargetGoal((Mob)this, Vex.class, true, true));
        this.targetSelector.addGoal(40, (Goal)new NearestAttackableTargetGoal((Mob)this, MagmaCube.class, true, true));
        this.targetSelector.addGoal(41, (Goal)new NearestAttackableTargetGoal((Mob)this, Silverfish.class, true, true));
        this.targetSelector.addGoal(42, (Goal)new NearestAttackableTargetGoal((Mob)this, FirstOrderFerociousGhostEntity.class, true, true));
        this.targetSelector.addGoal(43, (Goal)new NearestAttackableTargetGoal((Mob)this, SecondOrderFerociousGhostEntity.class, true, true));
        this.targetSelector.addGoal(44, (Goal)new NearestAttackableTargetGoal((Mob)this, ThirdOrderFerociousGhostEntity.class, true, true));
        this.targetSelector.addGoal(45, (Goal)new NearestAttackableTargetGoal((Mob)this, FourthOrderFerociousGhostEntity.class, true, true));
        this.targetSelector.addGoal(46, (Goal)new NearestAttackableTargetGoal((Mob)this, FifthOrderFerociousGhostEntity.class, true, true));
        this.targetSelector.addGoal(47, (Goal)new NearestAttackableTargetGoal((Mob)this, WickedDiscipleEntity.class, true, true));
        this.targetSelector.addGoal(48, (Goal)new NearestAttackableTargetGoal((Mob)this, BaneMageEntity.class, true, true));
        this.targetSelector.addGoal(49, (Goal)new NearestAttackableTargetGoal((Mob)this, EnemySlaveEntity.class, true, true));
        this.targetSelector.addGoal(50, (Goal)new NearestAttackableTargetGoal((Mob)this, Warden.class, true, true));
        this.targetSelector.addGoal(51, (Goal)new NearestAttackableTargetGoal((Mob)this, InfectedMengLiEntity.class, true, true));
        this.targetSelector.addGoal(52, (Goal)new NearestAttackableTargetGoal((Mob)this, AbyssalRemnantWarriorEntity.class, true, true));
        this.targetSelector.addGoal(53, (Goal)new NearestAttackableTargetGoal((Mob)this, ReplicaAbyssalRemnantWarriorEntity.class, true, true));
        this.targetSelector.addGoal(54, (Goal)new NearestAttackableTargetGoal((Mob)this, WickedDiscipleUnleashedEntity.class, true, true));
        this.targetSelector.addGoal(55, (Goal)new NearestAttackableTargetGoal((Mob)this, ReplicaWickedDiscipleUnleashedEntity.class, true, true));
        this.targetSelector.addGoal(56, (Goal)new NearestAttackableTargetGoal((Mob)this, MildChaosErodedRemnantEntity.class, true, true));
        this.targetSelector.addGoal(57, (Goal)new NearestAttackableTargetGoal((Mob)this, ChaosFiendRioterEntity.class, true, true));
        this.goalSelector.addGoal(58, (Goal)new FollowOwnerGoal((TamableAnimal)this, 0.8, 10.0f, 2.0f));
        this.goalSelector.addGoal(59, (Goal)new RandomStrollGoal((PathfinderMob)this, 0.5));
        this.goalSelector.addGoal(60, (Goal)new RandomLookAroundGoal((Mob)this));
        this.goalSelector.addGoal(61, (Goal)new FloatGoal((Mob)this));
    }

    public Vec3 getPassengerRidingPosition(Entity entity) {
        return super.getPassengerRidingPosition(entity).add(0.0, (double)-0.35f, 0.0);
    }

    protected Vec3 getPassengerAttachmentPoint(Entity entity, EntityDimensions dimensions, float f) {
        return super.getPassengerAttachmentPoint(entity, dimensions, f).add(0.0, 1.0, 0.0);
    }

    public void playStepSound(BlockPos pos, BlockState blockIn) {
        this.playSound((SoundEvent)BuiltInRegistries.SOUND_EVENT.getValue(ResourceLocation.parse((String)"magic_stone:giant_step")), 0.15f, 1.0f);
    }

    public SoundEvent getHurtSound(DamageSource ds) {
        return (SoundEvent)BuiltInRegistries.SOUND_EVENT.getValue(ResourceLocation.parse((String)"magic_stone:magic_shield_hit"));
    }

    public SoundEvent getDeathSound() {
        return (SoundEvent)BuiltInRegistries.SOUND_EVENT.getValue(ResourceLocation.parse((String)"magic_stone:giant_dead"));
    }

    public boolean hurtServer(ServerLevel level, DamageSource damagesource, float amount) {
        double x = this.getX();
        double y = this.getY();
        double z = this.getZ();
        Level world = this.level();
        MagicalConstructGiantEntity entity = this;
        Entity sourceentity = damagesource.getEntity();
        Entity immediatesourceentity = damagesource.getDirectEntity();
        ConstructGiantSpecialActionProcedure.execute((LevelAccessor)world, (Entity)entity, sourceentity);
        if (damagesource.is(DamageTypes.IN_FIRE)) {
            return false;
        }
        if (damagesource.getDirectEntity() instanceof AbstractArrow) {
            return false;
        }
        if (damagesource.getDirectEntity() instanceof Player) {
            return false;
        }
        if (damagesource.getDirectEntity() instanceof ThrownPotion || damagesource.getDirectEntity() instanceof AreaEffectCloud || damagesource.typeHolder().is(NeoForgeMod.POISON_DAMAGE)) {
            return false;
        }
        if (damagesource.is(DamageTypes.FALL)) {
            return false;
        }
        if (damagesource.is(DamageTypes.CACTUS)) {
            return false;
        }
        if (damagesource.is(DamageTypes.DROWN)) {
            return false;
        }
        if (damagesource.is(DamageTypes.LIGHTNING_BOLT)) {
            return false;
        }
        if (damagesource.is(DamageTypes.EXPLOSION) || damagesource.is(DamageTypes.PLAYER_EXPLOSION)) {
            return false;
        }
        if (damagesource.is(DamageTypes.TRIDENT)) {
            return false;
        }
        if (damagesource.is(DamageTypes.FALLING_ANVIL)) {
            return false;
        }
        if (damagesource.is(DamageTypes.DRAGON_BREATH)) {
            return false;
        }
        if (damagesource.is(DamageTypes.WITHER) || damagesource.is(DamageTypes.WITHER_SKULL)) {
            return false;
        }
        return super.hurtServer(level, damagesource, amount);
    }

    public boolean ignoreExplosion(Explosion explosion) {
        return true;
    }

    public boolean fireImmune() {
        return true;
    }

    public SpawnGroupData finalizeSpawn(ServerLevelAccessor world, DifficultyInstance difficulty, EntitySpawnReason reason, @Nullable SpawnGroupData livingdata) {
        SpawnGroupData retval = super.finalizeSpawn(world, difficulty, reason, livingdata);
        GiantSlaveTimerActionProcedure.execute((Entity)this);
        return retval;
    }

    public InteractionResult mobInteract(Player sourceentity, InteractionHand hand) {
        ItemStack itemstack = sourceentity.getItemInHand(hand);
        InteractionResult.Success retval = InteractionResult.SUCCESS;
        Item item = itemstack.getItem();
        if (itemstack.getItem() instanceof SpawnEggItem) {
            retval = super.mobInteract(sourceentity, hand);
        } else if (this.level().isClientSide()) {
            retval = this.isTame() && this.isOwnedBy((LivingEntity)sourceentity) || this.isFood(itemstack) ? InteractionResult.SUCCESS : InteractionResult.PASS;
        } else if (this.isTame()) {
            if (this.isOwnedBy((LivingEntity)sourceentity)) {
                if (this.isFood(itemstack) && this.getHealth() < this.getMaxHealth()) {
                    this.usePlayerItem(sourceentity, hand, itemstack);
                    FoodProperties foodproperties = (FoodProperties)itemstack.get(DataComponents.FOOD);
                    float nutrition = foodproperties != null ? (float)foodproperties.nutrition() : 1.0f;
                    this.heal(nutrition);
                    retval = InteractionResult.SUCCESS;
                } else if (this.isFood(itemstack) && this.getHealth() < this.getMaxHealth()) {
                    this.usePlayerItem(sourceentity, hand, itemstack);
                    this.heal(4.0f);
                    retval = InteractionResult.SUCCESS;
                } else {
                    retval = super.mobInteract(sourceentity, hand);
                }
            }
        } else if (this.isFood(itemstack)) {
            this.usePlayerItem(sourceentity, hand, itemstack);
            if (this.random.nextInt(3) == 0 && !EventHooks.onAnimalTame((Animal)this, (Player)sourceentity)) {
                this.tame(sourceentity);
                this.level().broadcastEntityEvent((Entity)this, (byte)7);
            } else {
                this.level().broadcastEntityEvent((Entity)this, (byte)6);
            }
            this.setPersistenceRequired();
            retval = InteractionResult.SUCCESS;
        } else {
            retval = super.mobInteract(sourceentity, hand);
            if (retval == InteractionResult.SUCCESS || retval == InteractionResult.CONSUME) {
                this.setPersistenceRequired();
            }
        }
        sourceentity.startRiding((Entity)this);
        double x = this.getX();
        double y = this.getY();
        double z = this.getZ();
        MagicalConstructGiantEntity entity = this;
        Level world = this.level();
        GiantSlaveActionProcedure.execute((LevelAccessor)world, x, y, z, (Entity)entity, (Entity)sourceentity);
        return retval;
    }

    public void playerTouch(Player sourceentity) {
        super.playerTouch(sourceentity);
        MagicalConstructGiantAutoRideActionProcedure.execute((LevelAccessor)this.level(), this.getX(), this.getY(), this.getZ(), (Entity)this);
    }

    public AgeableMob getBreedOffspring(ServerLevel serverWorld, AgeableMob ageable) {
        MagicalConstructGiantEntity retval = (MagicalConstructGiantEntity)((EntityType)MagicStoneModEntities.MAGICAL_CONSTRUCT_GIANT.get()).create((Level)serverWorld, EntitySpawnReason.BREEDING);
        retval.finalizeSpawn((ServerLevelAccessor)serverWorld, serverWorld.getCurrentDifficultyAt(retval.blockPosition()), EntitySpawnReason.BREEDING, null);
        return retval;
    }

    public boolean isFood(ItemStack stack) {
        return Ingredient.of((ItemLike)((ItemLike)MagicStoneModItems.THEME.get())).test(stack);
    }

    public boolean isPushedByFluid() {
        double x = this.getX();
        double y = this.getY();
        double z = this.getZ();
        Level world = this.level();
        MagicalConstructGiantEntity entity = this;
        return false;
    }

    public void travel(Vec3 dir) {
        Entity entity;
        Entity entity2 = entity = this.getPassengers().isEmpty() ? null : (Entity)this.getPassengers().get(0);
        if (this.isVehicle()) {
            double d0;
            double d1;
            float f1;
            this.setYRot(entity.getYRot());
            this.yRotO = this.getYRot();
            this.setXRot(entity.getXRot() * 0.5f);
            this.setRot(this.getYRot(), this.getXRot());
            this.yBodyRot = entity.getYRot();
            this.yHeadRot = entity.getYRot();
            if (entity instanceof ServerPlayer) {
                float forward;
                ServerPlayer passenger = (ServerPlayer)entity;
                this.setSpeed((float)this.getAttributeValue(Attributes.MOVEMENT_SPEED));
                float f = passenger.getLastClientInput().forward() == passenger.getLastClientInput().backward() ? 0.0f : (forward = (float)(passenger.getLastClientInput().forward() ? 1 : -1));
                float strafe = passenger.getLastClientInput().left() == passenger.getLastClientInput().right() ? 0.0f : (float)(passenger.getLastClientInput().left() ? 1 : -1);
                super.travel(new Vec3((double)strafe, 0.0, (double)forward));
            }
            if ((f1 = (float)Math.sqrt((d1 = this.getX() - this.xo) * d1 + (d0 = this.getZ() - this.zo) * d0) * 4.0f) > 1.0f) {
                f1 = 1.0f;
            }
            this.walkAnimation.setSpeed(this.walkAnimation.speed() + (f1 - this.walkAnimation.speed()) * 0.4f);
            this.walkAnimation.position(this.walkAnimation.position() + this.walkAnimation.speed());
            this.calculateEntityAnimation(true);
            return;
        }
        super.travel(dir);
    }

    public EntityDimensions getDefaultDimensions(Pose pose) {
        return super.getDefaultDimensions(pose).scale(3.6f);
    }

    public static void init(RegisterSpawnPlacementsEvent event) {
    }

    public static AttributeSupplier.Builder createAttributes() {
        AttributeSupplier.Builder builder = Mob.createMobAttributes();
        builder = builder.add(Attributes.MOVEMENT_SPEED, 0.25);
        builder = builder.add(Attributes.MAX_HEALTH, 1000.0);
        builder = builder.add(Attributes.ARMOR, 20.0);
        builder = builder.add(Attributes.ATTACK_DAMAGE, 300.0);
        builder = builder.add(Attributes.FOLLOW_RANGE, 32.0);
        builder = builder.add(Attributes.STEP_HEIGHT, 4.0);
        builder = builder.add(Attributes.KNOCKBACK_RESISTANCE, 10.0);
        builder = builder.add(Attributes.ATTACK_KNOCKBACK, 12.0);
        return builder;
    }
}

